/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Database;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.Table_Memory;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.ComboStringListWrapper;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.Math.Grid3D;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Polygon;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class InterpolateValuesDialog
extends JDialog
implements GenericObjectListener.Listener,
ActionListener {
    protected RefractionStaticsProject m_project;
    protected JButton m_btnCancel = new JButton("Close");
    protected JButton m_btnInterpolate = new JButton("Interpolate");
    protected JCheckBox m_shotCheck = new JCheckBox("Modify the shot table");
    protected JCheckBox m_recCheck = new JCheckBox("Modify the receiver table");
    protected JCheckBox m_useShotCheck = new JCheckBox("Use the shot table to compute interpolated values");
    protected JCheckBox m_useRecCheck = new JCheckBox("Use the receiver table to compute interpolated values");
    protected JCheckBox m_isqCheck = new JCheckBox("Use inverse-square interpolation (slower!)");
    protected ComboStringListWrapper m_combo = new ComboStringListWrapper();
    protected JRadioButton m_radValues = new JRadioButton("Use values to determine which rows will be interpolated");
    protected JRadioButton m_radInsidePolygon = new JRadioButton("Interpolate data inside polygon");
    protected ButtonGroup m_group = new ButtonGroup();
    protected LinearLayoutWidget m_valuesLinearLayoutWidget;
    protected JLabel m_valueLabel = new JLabel(" ");
    protected JTextField m_minText = new JTextField("-1000000");
    protected JTextField m_maxText = new JTextField("1000000");
    protected JLabel m_label = new JLabel("ll");
    protected double m_sumTop = 0.0;
    protected double m_sumBottom = 0.0;

    public InterpolateValuesDialog() {
        try {
            this.m_project = RefractionStaticsProject.singleton();
            Java2D_Polygon poly = this.m_project.polygon();
            this.getContentPane().setLayout(new BorderLayout());
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            LinearLayoutWidget sub = main.createLinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, "Use which tables", 0);
            sub.addComponent(this.m_useShotCheck, 0);
            sub.addComponent(this.m_useRecCheck, 0);
            this.m_useShotCheck.addActionListener(this);
            this.m_useShotCheck.setSelected(true);
            this.m_useRecCheck.addActionListener(this);
            this.m_useRecCheck.setSelected(true);
            sub = main.createLinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, "Modify which column", 0);
            sub.addComponent(this.m_combo, 0);
            sub.addComponent(this.m_label, 0);
            this.m_combo.listener().addListener(this);
            this.m_combo.setPreferredSelected("Elevation");
            sub = main.createLinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, "Data selection method", 0);
            sub.addComponent(this.m_radValues, 0);
            sub.addComponent(this.m_radInsidePolygon, 0);
            this.m_radInsidePolygon.addActionListener(this);
            this.m_radValues.addActionListener(this);
            this.m_group.add(this.m_radValues);
            this.m_group.add(this.m_radInsidePolygon);
            this.m_radValues.setSelected(true);
            this.m_radInsidePolygon.setEnabled(this.m_project.polygon().valid());
            this.m_valuesLinearLayoutWidget = main.createLinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, "Valid values", 0);
            String s = "<HTML>Values OUTSIDE of the following minimum and maximum will be interpolated</HTML>";
            this.m_valuesLinearLayoutWidget.addComponent(new JLabel(s), 0);
            this.m_valuesLinearLayoutWidget.addComponent(this.m_valueLabel, 0);
            GridLayoutWidget grid = this.m_valuesLinearLayoutWidget.createGridLayoutWidget(3, 0);
            grid.addSimple(0, new JLabel("Minimum"), this.m_minText);
            grid.addSimple(1, new JLabel("Maximum"), this.m_maxText);
            sub = main.createLinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, "Modify which tables", 0);
            sub.addComponent(this.m_shotCheck, 0);
            sub.addComponent(this.m_recCheck, 0);
            this.m_shotCheck.addActionListener(this);
            this.m_shotCheck.setSelected(true);
            this.m_recCheck.addActionListener(this);
            this.m_recCheck.setSelected(true);
            main.addComponent(this.m_isqCheck, 0);
            LinearLayoutWidget bottom = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null);
            bottom.addStretch(10);
            bottom.addComponent(this.m_btnInterpolate, 0);
            bottom.addComponent(this.m_btnCancel, 0);
            bottom.addStretch(10);
            this.m_btnInterpolate.addActionListener(this);
            this.m_btnCancel.addActionListener(this);
            this.getContentPane().add((Component)main, "Center");
            this.getContentPane().add((Component)bottom, "South");
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.setDefaultCloseOperation(2);
            this.pack();
            this.reloadColumns();
            this.setTitle("Interpolate bad values");
            this.setLocationRelativeTo(null);
            this.setVisible(true);
            this.requestFocus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void reloadColumns() {
        try {
            boolean rec = this.m_useRecCheck.isSelected() || this.m_recCheck.isSelected();
            boolean shot = this.m_useShotCheck.isSelected() || this.m_shotCheck.isSelected();
            ArrayList<String> colList = null;
            if (shot && !rec) {
                colList = this.database().listOfColumnNames("Shot");
            }
            if (!shot && rec) {
                colList = this.database().listOfColumnNames("Receiver");
            }
            if (shot && rec) {
                colList = this.database().listOfColumnNames("Receiver", "Shot");
            }
            this.m_combo.setEnabled(colList != null);
            if (colList != null) {
                this.m_combo.setStringArray(colList);
            }
            this.checkSelected();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void modifyValuesUsingGrid() {
        try {
            double max;
            if (!this.checkSelected()) {
                return;
            }
            String col = this.m_combo.getSelectedString();
            double min = Tools_Widget.extractDouble(this.m_minText, 0.0, -1.0E30, 1.0E30);
            if (min >= (max = Tools_Widget.extractDouble(this.m_maxText, 0.0, -1.0E30, 1.0E30))) {
                this.m_label.setText("Minimum >= Maximum???");
                this.m_label.setForeground(Color.red);
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            Grid3D grid = this.m_project.getSmootherGrid();
            grid.interp_Prep();
            grid.interp_ZeroArrays();
            int num = 0;
            if (this.m_useRecCheck.isSelected()) {
                num += this.addToGrid(this.m_project.receiverTable(), grid);
            }
            if (this.m_useShotCheck.isSelected()) {
                num += this.addToGrid(this.m_project.shotTable(), grid);
            }
            if (num < 1) {
                this.m_label.setText("No valid data inside range");
                this.m_label.setForeground(Color.red);
                this.setCursor(Cursor.getPredefinedCursor(0));
                return;
            }
            grid.interp_Finish(5);
            if (this.m_recCheck.isSelected()) {
                this.getFromGrid(this.m_project.receiverTable(), grid);
                this.database().writeColumnContentsToDatabase(this.m_project.receiverTable(), col);
            }
            if (this.m_shotCheck.isSelected()) {
                this.getFromGrid(this.m_project.shotTable(), grid);
                this.database().writeColumnContentsToDatabase(this.m_project.shotTable(), col);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void modifyInsidePolygonUsingGrid() {
        try {
            if (!this.checkSelected()) {
                return;
            }
            String col = this.m_combo.getSelectedString();
            this.setCursor(Cursor.getPredefinedCursor(3));
            Grid3D grid = this.m_project.getSmootherGrid();
            grid.interp_Prep();
            grid.interp_ZeroArrays();
            int num = 0;
            if (this.m_useRecCheck.isSelected()) {
                num += this.addToGrid_Polygon(this.m_project.receiverTable(), grid);
            }
            if (this.m_useShotCheck.isSelected()) {
                num += this.addToGrid_Polygon(this.m_project.shotTable(), grid);
            }
            if (num < 1) {
                this.m_label.setText("No valid data outside polygon");
                this.m_label.setForeground(Color.red);
                return;
            }
            grid.interp_Finish(1);
            if (this.m_recCheck.isSelected()) {
                this.getFromGrid_Polygon(this.m_project.receiverTable(), grid);
                this.database().writeColumnContentsToDatabase(this.m_project.receiverTable(), col);
            }
            if (this.m_shotCheck.isSelected()) {
                this.getFromGrid_Polygon(this.m_project.shotTable(), grid);
                this.database().writeColumnContentsToDatabase(this.m_project.shotTable(), col);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void modify() {
        try {
            if (!this.checkSelected()) {
                return;
            }
            if (this.m_radInsidePolygon.isSelected()) {
                if (!this.m_isqCheck.isSelected()) {
                    this.modifyInsidePolygonUsingGrid();
                } else {
                    this.modifyInsidePolygonUsingISQ();
                }
                return;
            }
            if (this.m_radValues.isSelected()) {
                if (!this.m_isqCheck.isSelected()) {
                    this.modifyValuesUsingGrid();
                } else {
                    this.modifyValuesUsingISQ();
                }
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void getFromValues_ISQ(Table_Abstract table) {
        try {
            Java2D_Polygon poly = this.m_project.polygon();
            String col = this.m_combo.getSelectedString();
            double min = Tools_Widget.extractDouble(this.m_minText, 0.0, -1.0E30, 1.0E30);
            double max = Tools_Widget.extractDouble(this.m_maxText, 0.0, -1.0E30, 1.0E30);
            int indexX = table.column_indexOfColumn("Easting");
            int indexY = table.column_indexOfColumn("Northing");
            int index = table.column_indexOfColumn(col);
            for (int row = 0; row < table.row_count(); ++row) {
                double v = table.getDouble(row, index);
                double x = table.getDouble(row, indexX);
                double y = table.getDouble(row, indexY);
                if (!(v < min) && !(v > max)) continue;
                this.m_sumTop = 0.0;
                this.m_sumBottom = 1.0E-40;
                if (this.m_useRecCheck.isSelected()) {
                    this.updateInverseSquareSums(this.m_project.receiverTable(), x, y);
                }
                if (this.m_useShotCheck.isSelected()) {
                    this.updateInverseSquareSums(this.m_project.shotTable(), x, y);
                }
                double v1 = this.m_sumTop / this.m_sumBottom;
                table.putDouble(row, index, v1);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void getFromValues_ISQ_Polygon(Table_Abstract table) {
        try {
            Java2D_Polygon poly = this.m_project.polygon();
            String col = this.m_combo.getSelectedString();
            double min = Tools_Widget.extractDouble(this.m_minText, 0.0, -1.0E30, 1.0E30);
            double max = Tools_Widget.extractDouble(this.m_maxText, 0.0, -1.0E30, 1.0E30);
            int indexX = table.column_indexOfColumn("Easting");
            int indexY = table.column_indexOfColumn("Northing");
            int index = table.column_indexOfColumn(col);
            for (int row = 0; row < table.row_count(); ++row) {
                double y;
                double v = table.getDouble(row, index);
                double x = table.getDouble(row, indexX);
                if (!poly.contains(x, y = table.getDouble(row, indexY))) continue;
                this.m_sumTop = 0.0;
                this.m_sumBottom = 1.0E-40;
                if (this.m_useRecCheck.isSelected()) {
                    this.updateInverseSquareSums_Polygon(this.m_project.receiverTable(), x, y);
                }
                if (this.m_useShotCheck.isSelected()) {
                    this.updateInverseSquareSums_Polygon(this.m_project.shotTable(), x, y);
                }
                double v1 = this.m_sumTop / this.m_sumBottom;
                table.putDouble(row, index, v1);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void modifyInsidePolygonUsingISQ() {
        try {
            if (!this.checkSelected()) {
                return;
            }
            String col = this.m_combo.getSelectedString();
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (this.m_recCheck.isSelected()) {
                this.getFromValues_ISQ_Polygon(this.m_project.receiverTable());
                this.database().writeColumnContentsToDatabase(this.m_project.receiverTable(), col);
            }
            if (this.m_shotCheck.isSelected()) {
                this.getFromValues_ISQ_Polygon(this.m_project.shotTable());
                this.database().writeColumnContentsToDatabase(this.m_project.shotTable(), col);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void modifyValuesUsingISQ() {
        try {
            double max;
            if (!this.checkSelected()) {
                return;
            }
            String col = this.m_combo.getSelectedString();
            double min = Tools_Widget.extractDouble(this.m_minText, 0.0, -1.0E30, 1.0E30);
            if (min >= (max = Tools_Widget.extractDouble(this.m_maxText, 0.0, -1.0E30, 1.0E30))) {
                this.m_label.setText("Minimum >= Maximum???");
                this.m_label.setForeground(Color.red);
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (this.m_recCheck.isSelected()) {
                this.getFromValues_ISQ(this.m_project.receiverTable());
                this.database().writeColumnContentsToDatabase(this.m_project.receiverTable(), col);
            }
            if (this.m_shotCheck.isSelected()) {
                this.getFromValues_ISQ(this.m_project.shotTable());
                this.database().writeColumnContentsToDatabase(this.m_project.shotTable(), col);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void updateInverseSquareSums_Polygon(Table_Abstract table, double px, double py) {
        try {
            String col = this.m_combo.getSelectedString();
            Java2D_Polygon poly = this.m_project.polygon();
            int indexX = table.column_indexOfColumn("Easting");
            int indexY = table.column_indexOfColumn("Northing");
            int indexKilled = table.column_indexOfColumn("Killed");
            int index = table.column_indexOfColumn(col);
            for (int row = 0; row < table.row_count(); ++row) {
                double y;
                double v = table.getDouble(row, index);
                double x = table.getDouble(row, indexX);
                if (poly.contains(x, y = table.getDouble(row, indexY)) || table.getBool(row, indexKilled)) continue;
                double dx = px - x;
                double dy = py - y;
                double w = 10.0 / (10.0 + dx * dx + dy * dy);
                this.m_sumTop += w * v;
                this.m_sumBottom += w;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void updateInverseSquareSums(Table_Abstract table, double px, double py) {
        try {
            String col = this.m_combo.getSelectedString();
            double min = Tools_Widget.extractDouble(this.m_minText, 0.0, -1.0E30, 1.0E30);
            double max = Tools_Widget.extractDouble(this.m_maxText, 0.0, -1.0E30, 1.0E30);
            int indexX = table.column_indexOfColumn("Easting");
            int indexY = table.column_indexOfColumn("Northing");
            int indexKilled = table.column_indexOfColumn("Killed");
            int index = table.column_indexOfColumn(col);
            for (int row = 0; row < table.row_count(); ++row) {
                double v = table.getDouble(row, index);
                if (!(v >= min) || !(v <= max) || table.getBool(row, indexKilled)) continue;
                double dx = px - table.getDouble(row, indexX);
                double dy = py - table.getDouble(row, indexY);
                double w = 10.0 / (10.0 + dx * dx + dy * dy);
                this.m_sumTop += w * v;
                this.m_sumBottom += w;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void getFromGrid(Table_Abstract table, Grid3D grid) {
        try {
            String col = this.m_combo.getSelectedString();
            double min = Tools_Widget.extractDouble(this.m_minText, 0.0, -1.0E30, 1.0E30);
            double max = Tools_Widget.extractDouble(this.m_maxText, 0.0, -1.0E30, 1.0E30);
            int indexX = table.column_indexOfColumn("Easting");
            int indexY = table.column_indexOfColumn("Northing");
            int index = table.column_indexOfColumn(col);
            for (int row = 0; row < table.row_count(); ++row) {
                double v = table.getDouble(row, index);
                if (!(v < min) && !(v > max)) continue;
                double x = table.getDouble(row, indexX);
                double y = table.getDouble(row, indexY);
                float v1 = grid.getNearestValue(x, y);
                table.putDouble(row, index, v1);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void getFromGrid_Polygon(Table_Abstract table, Grid3D grid) {
        try {
            Java2D_Polygon poly = this.m_project.polygon();
            String col = this.m_combo.getSelectedString();
            String tableName = table.name();
            Table_Memory editTable = new Table_Memory();
            ((Table_Abstract)editTable).setName(tableName);
            int indexEditFFID = -9999;
            int indexEditLine = ((Table_Abstract)editTable).column_append("LineNumber", DataType.Int);
            int indexEditPoint = ((Table_Abstract)editTable).column_append("PointNumber", DataType.Int);
            int indexEditValueNew = ((Table_Abstract)editTable).column_append(col, DataType.Double);
            int indexEditValueOld = ((Table_Abstract)editTable).column_append(col + "_old", DataType.Double);
            int indexEditChange = ((Table_Abstract)editTable).column_append("Change", DataType.Double);
            int indexEditX = ((Table_Abstract)editTable).column_append("Easting", DataType.Double);
            int indexEditY = ((Table_Abstract)editTable).column_append("Northing", DataType.Double);
            int indexFFID = -9999;
            if (table.column_exists("FFID")) {
                indexFFID = table.column_indexOfColumn("FFID");
                indexEditFFID = ((Table_Abstract)editTable).column_append("FFID", DataType.Int);
            }
            int indexLine = table.column_indexOfColumn("LineNumber");
            int indexPoint = table.column_indexOfColumn("PointNumber");
            int indexX = table.column_indexOfColumn("Easting");
            int indexY = table.column_indexOfColumn("Northing");
            int index = table.column_indexOfColumn(col);
            for (int row = 0; row < table.row_count(); ++row) {
                double y;
                double v = table.getDouble(row, index);
                double x = table.getDouble(row, indexX);
                if (!poly.contains(x, y = table.getDouble(row, indexY))) continue;
                float v1 = grid.getNearestValue(x, y);
                table.putDouble(row, index, v1);
                int line = table.getInt(row, indexLine);
                int point = table.getInt(row, indexPoint);
                int r = ((Table_Abstract)editTable).row_increment();
                ((Table_Abstract)editTable).putInt(r, indexEditLine, line);
                ((Table_Abstract)editTable).putInt(r, indexEditPoint, point);
                ((Table_Abstract)editTable).putDouble(r, indexEditX, x);
                ((Table_Abstract)editTable).putDouble(r, indexEditY, y);
                ((Table_Abstract)editTable).putDouble(r, indexEditValueNew, v1);
                ((Table_Abstract)editTable).putDouble(r, indexEditValueOld, v);
                ((Table_Abstract)editTable).putDouble(r, indexEditChange, (double)v1 - v);
                if (indexEditFFID < 0) continue;
                ((Table_Abstract)editTable).putInt(r, indexEditFFID, table.getInt(row, indexFFID));
            }
            String fileName = this.m_project.projectPath() + "/" + tableName + "_edits.txt";
            editTable.exportColumn(fileName);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected int addToGrid_Polygon(Table_Abstract table, Grid3D grid) {
        try {
            int num = 0;
            Java2D_Polygon poly = this.m_project.polygon();
            String col = this.m_combo.getSelectedString();
            int indexX = table.column_indexOfColumn("Easting");
            int indexY = table.column_indexOfColumn("Northing");
            int index = table.column_indexOfColumn(col);
            for (int row = 0; row < table.row_count(); ++row) {
                double x = table.getDouble(row, indexX);
                double y = table.getDouble(row, indexY);
                double v = table.getDouble(row, index);
                if (poly.contains(x, y)) continue;
                grid.interp_Add(x, y, (float)v, 1.0f);
                ++num;
            }
            return num;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return 0;
        }
    }

    protected int addToGrid(Table_Abstract table, Grid3D grid) {
        try {
            int num = 0;
            Java2D_Polygon poly = this.m_project.polygon();
            boolean usePoly = this.m_radInsidePolygon.isSelected() && poly.valid();
            String col = this.m_combo.getSelectedString();
            double min = Tools_Widget.extractDouble(this.m_minText, 0.0, -1.0E30, 1.0E30);
            double max = Tools_Widget.extractDouble(this.m_maxText, 0.0, -1.0E30, 1.0E30);
            int indexX = table.column_indexOfColumn("Easting");
            int indexY = table.column_indexOfColumn("Northing");
            int indexKilled = table.column_indexOfColumn("Killed");
            int index = table.column_indexOfColumn(col);
            for (int row = 0; row < table.row_count(); ++row) {
                double v = table.getDouble(row, index);
                if (!(v >= min) || !(v <= max) || table.getBool(row, indexKilled)) continue;
                double x = table.getDouble(row, indexX);
                double y = table.getDouble(row, indexY);
                grid.interp_Add(x, y, (float)v, 1.0f);
                ++num;
            }
            return num;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return 0;
        }
    }

    protected boolean checkSelected() {
        try {
            boolean required;
            boolean useOkay = this.m_useRecCheck.isSelected() || this.m_useShotCheck.isSelected();
            boolean modOkay = this.m_recCheck.isSelected() || this.m_shotCheck.isSelected();
            this.m_btnInterpolate.setEnabled(false);
            if (!modOkay) {
                this.m_label.setText("Must modify at least one table");
                this.m_label.setForeground(Color.red);
                return false;
            }
            if (!useOkay) {
                this.m_label.setText("Must use at least one table");
                this.m_label.setForeground(Color.red);
                return false;
            }
            if (!this.m_combo.isEnabled()) {
                this.m_label.setText("Cannot modify column - no table selected?");
                this.m_label.setForeground(Color.red);
                return false;
            }
            String col = this.m_combo.getSelectedString();
            boolean bl = required = col.equalsIgnoreCase("Easting") || col.equalsIgnoreCase("Northing") || col.equalsIgnoreCase("LineNumber") || col.equalsIgnoreCase("PointNumber") || col.equalsIgnoreCase("PointIndex") || col.equalsIgnoreCase("ShotID") || col.equalsIgnoreCase("ReceiverID");
            if (required) {
                this.m_label.setText("Cannot modify required column");
                this.m_label.setForeground(Color.red);
                return false;
            }
            this.m_label.setText("Okay to modify this columns");
            this.m_label.setForeground(Color.blue);
            this.m_btnInterpolate.setEnabled(true);
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    protected IDatabaseConnection database() {
        try {
            return RefractionStaticsProject.singleton().geometryDatabase();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            this.checkSelected();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.m_minText.setEnabled(this.m_radValues.isSelected());
            this.m_maxText.setEnabled(this.m_radValues.isSelected());
            if (this.m_radValues.isSelected()) {
                this.m_valueLabel.setText("  ");
            } else {
                this.m_valueLabel.setText("Range options not used for polygon edits");
                this.m_valueLabel.setForeground(Color.red);
            }
            if (e.getSource() == this.m_radValues) {
                this.m_valueLabel.setText("  ");
                return;
            }
            if (e.getSource() == this.m_useRecCheck || e.getSource() == this.m_recCheck || e.getSource() == this.m_useShotCheck || e.getSource() == this.m_shotCheck) {
                this.reloadColumns();
                return;
            }
            if (e.getSource() == this.m_btnInterpolate) {
                this.modify();
                return;
            }
            if (e.getSource() == this.m_btnCancel) {
                this.dispose();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

