/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Database;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Tools_RefractionStaticsProject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;

public class DropColumnsDialog
extends JDialog
implements ActionListener,
ItemListener {
    protected ArrayList<String> m_columns;
    protected JList m_list = new JList();
    protected JButton m_dropShotButton;
    protected JButton m_dropRecButton;
    protected JButton m_dropBothButton;
    protected JButton m_btnCancel;
    public boolean Dropped = false;

    public DropColumnsDialog(Frame parent) {
        super(parent, "Drop nonrequired database columns", true);
        try {
            LinearLayoutWidget temp = LinearLayoutWidget.horz(0, null);
            LinearLayoutWidget sub = temp.createVertical(0, null, 0);
            sub.addComponent(new JLabel("Select columns to drop"), 0);
            sub.addComponent(new JScrollPane(this.m_list), 10);
            sub = temp.createVertical(0, null, 0);
            this.m_dropShotButton = sub.createButton("Drop from shot table", this, 0);
            this.m_dropRecButton = sub.createButton("Drop from receiver table", this, 0);
            this.m_dropBothButton = sub.createButton("Drop from both tables", this, 0);
            sub.addStretch(10);
            this.m_btnCancel = sub.createButton("Close", this, 0);
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)temp, "Center");
            this.reloadColumns();
            this.setDefaultCloseOperation(2);
            this.pack();
            this.setLocationRelativeTo(null);
            this.setVisible(true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void reloadColumns() {
        try {
            RefractionStaticsProject.singleton().reloadAllData();
            ArrayList<String> all = Tools_RefractionStaticsProject.getColumnList_Union();
            this.m_columns = new ArrayList();
            for (String s : all) {
                boolean required = s.equalsIgnoreCase("Easting") || s.equalsIgnoreCase("Northing") || s.equalsIgnoreCase("Elevation") || s.equalsIgnoreCase("PointDepth") || s.equalsIgnoreCase("UpholeTime") || s.equalsIgnoreCase("Killed") || s.equalsIgnoreCase("UpholeCorrection") || s.equalsIgnoreCase("LineNumber") || s.equalsIgnoreCase("PointNumber") || s.equalsIgnoreCase("PointIndex") || s.equalsIgnoreCase("Polarity");
                required = required || s.equalsIgnoreCase("ShotID");
                required = required || s.equalsIgnoreCase("ReceiverID");
                required = required || s.startsWith("DTA");
                required = required || s.startsWith("DATUM");
                required = required || s.startsWith("INITIAL");
                if (required = required || s.startsWith("GEOMERR")) continue;
                this.m_columns.add(s);
            }
            this.m_list.setListData(this.m_columns.toArray());
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }

    protected void dropColumn(String tableName, String columnName) {
        try {
            IDatabaseConnection database = RefractionStaticsProject.singleton().geometryDatabase();
            if (!database.columnExists(tableName, columnName)) {
                return;
            }
            String sql = String.format("ALTER TABLE %s DROP COLUMN %s", tableName, columnName);
            database.executeUpdateStatement(sql);
            this.Dropped = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void dropColumns(boolean shot, boolean rec) {
        try {
            int[] sel = this.m_list.getSelectedIndices();
            if (sel == null) {
                return;
            }
            for (int n = 0; n < sel.length; ++n) {
                int index = sel[n];
                String s = this.m_columns.get(index);
                if (shot) {
                    this.dropColumn("Shot", s);
                }
                if (!rec) continue;
                this.dropColumn("Receiver", s);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_dropRecButton) {
                this.dropColumns(false, true);
                this.reloadColumns();
                return;
            }
            if (e.getSource() == this.m_dropShotButton) {
                this.dropColumns(true, false);
                this.reloadColumns();
                return;
            }
            if (e.getSource() == this.m_dropBothButton) {
                this.dropColumns(true, true);
                this.reloadColumns();
                return;
            }
            if (e.getSource() == this.m_btnCancel) {
                this.dispose();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

