/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Plugins;

import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.Tools_Ensemble;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Sequence;
import com.PecosCore.Seismic.ISeismicFile;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Parameter.TextFieldInt;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Windows.Ensemble.Sequence.Sequence_MainWidget;
import com.PecosLibrary.Windows.Java2D.Ensemble.Java2D_EnsembleAxisEnum;
import com.PecosLibrary.Windows.Java2D.Ensemble.Java2D_VertStackedEnsembleDisplayWidget;
import com.PecosLibrary.Windows.Shared.CardWidget;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Plugin_DataDisplayWidget
extends JSplitPane
implements ItemListener,
ChangeListener,
ActionListener,
GenericObjectListener.Listener {
    protected CardWidget m_cardWidget = new CardWidget();
    protected Java2D_VertStackedEnsembleDisplayWidget m_mainWidget = new Java2D_VertStackedEnsembleDisplayWidget(1);
    protected Sequence_MainWidget m_sequenceWidget;
    protected ISeismicFile m_seismic;
    protected TextFieldInt m_firstTraceText = new TextFieldInt();
    protected TextFieldInt m_traceCountText = new TextFieldInt();
    protected JSlider m_firstTraceSlider = new JSlider();
    protected boolean m_bIgnoreSlider = true;
    protected JButton m_reloadButton;
    protected long[] m_indices = new long[400];
    protected Ensemble m_inputEnsemble;
    protected Ensemble m_processedEnsemble;
    protected long m_traceCount;

    public Plugin_DataDisplayWidget(ISeismicFile seismic) {
        super(1);
        try {
            this.m_seismic = seismic;
            this.m_seismic.getListenerController().addListener(this);
            this.setLeftComponent(this.createDisplayWidget());
            this.setRightComponent(this.createOptionsWidget());
            this.setResizeWeight(1.0);
            this.m_mainWidget.setAxisType(Java2D_EnsembleAxisEnum.UniformSpacing);
            this.m_mainWidget.setVisibleCount(1);
            this.m_mainWidget.addZoomer();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected JComponent createDisplayWidget() {
        try {
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            panel.add((Component)this.m_mainWidget, "Center");
            panel.add((Component)this.createIOWidget(), "North");
            return panel;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createIOWidget() {
        try {
            LinearLayoutWidget widget = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null);
            widget.createLabel("Count", 0, 0);
            this.m_traceCountText.setPreferredSize(new Dimension(75, 15));
            widget.addComponent(this.m_traceCountText, 0);
            widget.createLabel("First", 0, 0);
            this.m_firstTraceText.setPreferredSize(new Dimension(75, 15));
            widget.addComponent(this.m_firstTraceText, 0);
            this.m_traceCountText.addActionListener(this);
            this.m_firstTraceText.addActionListener(this);
            widget.addComponent(this.m_firstTraceSlider, 10);
            this.m_firstTraceSlider.addChangeListener(this);
            this.m_reloadButton = widget.createButton("Reload", this, 0);
            return widget;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createOptionsWidget() {
        try {
            this.m_sequenceWidget = new Sequence_MainWidget("Data", EnsembleWorker_Sequence.SequenceType.Interactive);
            this.m_sequenceWidget.sequence().addListener(this);
            return this.m_sequenceWidget;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected void loadEnsemble() {
        try {
            if (!this.m_seismic.isFileOK()) {
                this.handleSeismicChanged();
                return;
            }
            int first = this.m_firstTraceText.getInt(1);
            int count = this.m_traceCountText.getInt(100);
            for (int n = 0; n < count; ++n) {
                this.m_indices[n] = first + n - 1;
            }
            this.m_inputEnsemble.clearDictionary();
            this.m_inputEnsemble.clearTraces(false);
            this.m_seismic.populateEnsemble(this.m_inputEnsemble, this.m_indices, count, true, true);
            Tools_Ensemble.computeAverageAmplitude(this.m_inputEnsemble, "AVGAMP");
            Tools_Ensemble.computeMaximumAmplitude(this.m_inputEnsemble, "MAXAMP");
            this.performWorkOnInputEnsemble();
            this.m_mainWidget.setEnsemble(0, this.m_processedEnsemble);
            this.m_mainWidget.clearAndLoadWigglePaintables();
            this.m_mainWidget.unzoom();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void performWorkOnInputEnsemble() {
        try {
            this.m_processedEnsemble.clearTraces(true);
            this.m_inputEnsemble.copyToOtherEnsemble(this.m_processedEnsemble);
            this.m_processedEnsemble = this.m_sequenceWidget.sequence().work(this.m_processedEnsemble);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void handleSeismicChanged() {
        try {
            this.m_bIgnoreSlider = true;
            this.clear();
            this.m_traceCountText.setEnabled(this.m_seismic.isFileOK());
            this.m_firstTraceText.setEnabled(this.m_seismic.isFileOK());
            this.m_firstTraceSlider.setEnabled(this.m_seismic.isFileOK());
            this.m_reloadButton.setEnabled(this.m_seismic.isFileOK());
            if (!this.m_seismic.isFileOK()) {
                return;
            }
            int traceCount = (int)this.m_seismic.traceCount();
            this.m_firstTraceText.setRange(1, traceCount);
            this.m_traceCountText.setRange(10, 400);
            this.m_firstTraceText.setText("1");
            this.m_firstTraceSlider.setValue(1);
            this.m_firstTraceSlider.setMaximum(traceCount);
            this.m_bIgnoreSlider = false;
            this.loadEnsemble();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void clear() {
    }

    protected void tryToLaunchBatchPicker(Object data) {
        try {
            JOptionPane.showMessageDialog(null, "This feature is not supported for plugin data files.", "Feature not supported", 0);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_firstTraceText) {
                int index = Tools_Widget.extractInteger(this.m_firstTraceText, 1, 1, (int)this.m_traceCount - 2);
                this.m_firstTraceSlider.setValue(index);
            }
            this.loadEnsemble();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        try {
            if (e.getSource() == this.m_firstTraceSlider) {
                if (this.m_bIgnoreSlider) {
                    return;
                }
                int value = this.m_firstTraceSlider.getValue();
                this.m_firstTraceText.setText(Integer.toString(value));
                this.loadEnsemble();
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (sender == this.m_seismic) {
                this.handleSeismicChanged();
                return;
            }
            if (sender == this.m_sequenceWidget.sequence()) {
                if (this.m_sequenceWidget.sequence().MessageData.SequenceModified) {
                    this.performWorkOnInputEnsemble();
                    this.m_mainWidget.forcePaintAll();
                }
                if (this.m_sequenceWidget.sequence().MessageData.MessageFromWorker) {
                    this.tryToLaunchBatchPicker(data);
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }
}

