/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.MDI;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Windows.MDI.MDIDesktopManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.beans.PropertyVetoException;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;

public class MDIDesktopPane
extends JDesktopPane {
    private static int FRAME_OFFSET = 20;
    private MDIDesktopManager m_manager;

    public MDIDesktopPane() {
        try {
            this.m_manager = new MDIDesktopManager(this);
            this.setDesktopManager(this.m_manager);
            this.setDragMode(1);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        try {
            super.setBounds(x, y, w, h);
            this.checkDesktopSize();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public Component add(JInternalFrame frame) {
        try {
            Point p;
            JInternalFrame[] array = this.getAllFrames();
            Component retval = super.add(frame);
            this.checkDesktopSize();
            if (array.length > 0) {
                p = array[0].getLocation();
                p.x += FRAME_OFFSET;
                p.y += FRAME_OFFSET;
            } else {
                p = new Point(0, 0);
            }
            frame.setLocation(p.x, p.y);
            if (frame.isResizable()) {
                int w = this.getWidth() - this.getWidth() / 3;
                int h = this.getHeight() - this.getHeight() / 3;
                if ((double)w < frame.getMinimumSize().getWidth()) {
                    w = (int)frame.getMinimumSize().getWidth();
                }
                if ((double)h < frame.getMinimumSize().getHeight()) {
                    h = (int)frame.getMinimumSize().getHeight();
                }
                frame.setSize(w, h);
            }
            this.moveToFront(frame);
            frame.setVisible(true);
            try {
                frame.setSelected(true);
            }
            catch (PropertyVetoException e) {
                e.printStackTrace();
                frame.toBack();
            }
            return retval;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    @Override
    public void remove(Component c) {
        try {
            super.remove(c);
            this.checkDesktopSize();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void cascadeFrames() {
        try {
            int x = 0;
            int y = 0;
            JInternalFrame[] allFrames = this.getAllFrames();
            this.m_manager.setNormalSize();
            int frameHeight = this.getBounds().height - 5 - allFrames.length * FRAME_OFFSET;
            int frameWidth = this.getBounds().width - 5 - allFrames.length * FRAME_OFFSET;
            for (int i = allFrames.length - 1; i >= 0; --i) {
                allFrames[i].setSize(frameWidth, frameHeight);
                allFrames[i].setLocation(x, y);
                x += FRAME_OFFSET;
                y += FRAME_OFFSET;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void tileFrames() {
        try {
            JInternalFrame[] allFrames = this.getAllFrames();
            if (allFrames == null) {
                return;
            }
            if (allFrames.length < 1) {
                return;
            }
            this.m_manager.setNormalSize();
            int frameWidth = this.getBounds().width / allFrames.length;
            int x = 0;
            for (int i = 0; i < allFrames.length; ++i) {
                allFrames[i].setSize(frameWidth, this.getBounds().height);
                allFrames[i].setLocation(x, 0);
                x += frameWidth;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setAllSize(Dimension d) {
        try {
            this.setMinimumSize(d);
            this.setMaximumSize(d);
            this.setPreferredSize(d);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setAllSize(int width, int height) {
        try {
            this.setAllSize(new Dimension(width, height));
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    private void checkDesktopSize() {
        try {
            if (this.getParent() != null && this.isVisible()) {
                this.m_manager.resizeDesktop();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

