/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.LWRS;

import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Sequence;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Action.QC.Action_ComputeProfileSemblance;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Seismic.SeismicProfile;
import com.PecosLibrary.Stack.Semblance;
import com.PecosLibrary.Stack.SemblanceProfileVelocityCollection;
import com.PecosLibrary.Stack.VelocityLocation;
import com.PecosLibrary.Tools.BitmapEnum;
import com.PecosLibrary.Windows.ApplicationFrames.ISaveableFrame;
import com.PecosLibrary.Windows.Ensemble.Sequence.Sequence_MainWidget;
import com.PecosLibrary.Windows.Java2D.Java2D_SimpleComposite;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import com.PecosLibrary.Windows.Java2D.Java2D_Widget;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_TimeGrid;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_ButtonPressed;
import com.PecosLibrary.Windows.LWRS.LwrsCreateStacksWidget;
import com.PecosLibrary.Windows.LWRS.LwrsHvaWidget;
import com.PecosLibrary.Windows.LWRS.LwrsSemblanceWidget;
import com.PecosLibrary.Windows.Refraction.Picking.PickerGizmoWidget;
import com.PecosLibrary.Windows.Shared.BitmapCardWidget;
import com.PecosLibrary.Windows.Stack.ProfileSelectorWidget;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LwrsWidget
extends JSplitPane
implements ItemListener,
GenericObjectListener.Listener,
Messenger.Listener,
ActionListener,
ChangeListener,
ISaveableFrame {
    protected SharedData m_sharedData = new SharedData();
    protected ProfileSelectorWidget m_profileWidget;
    protected BitmapCardWidget m_bitmapCardWidget = new BitmapCardWidget();
    protected Sequence_MainWidget m_workerWidget;
    protected EnsembleWorker_Sequence m_sequence;
    protected JTabbedPane m_rightTabs = new JTabbedPane();
    protected PickerGizmoWidget m_pickerGizmoWidget;
    protected GridLayoutWidget m_sembWidget;
    protected JTextField m_velMinText = new JTextField("7000");
    protected JTextField m_velMaxText = new JTextField("15000");
    protected JTextField m_velCountText = new JTextField("120");
    protected JTextField m_timeMinText = new JTextField("0");
    protected JTextField m_timeMaxText = new JTextField("1100");
    protected JTextField m_timeDigiText = new JTextField("4");
    protected JTextField m_minOffText = new JTextField("1200");
    protected JTextField m_maxOffText = new JTextField("7000");
    protected JTextField m_muteText = new JTextField("25");
    protected JButton m_btnComputeSemblance;
    protected LwrsSemblanceWidget m_semblanceWidget;
    protected LwrsCreateStacksWidget m_createStacksWidget;
    protected ArrayList<LwrsHvaWidget> m_hvaWidgets = new ArrayList();
    protected JButton m_btnReloadPickeVel;
    protected Java2D_SimpleComposite m_widgetPickedVel;
    protected JLabel m_lblPicked = new JLabel("", 2);
    protected Java2D_UserEventConsumer_ButtonPressed m_leftClickUEC;

    @Override
    public String TAB_NAME() {
        return "com.PecosLibrary.Windows.LWRS.LwrsWidget";
    }

    @Override
    public String TAB_LABEL() {
        return "ULWS";
    }

    @Override
    public String TAB_DESCRIPTION() {
        return "ULWS";
    }

    @Override
    public boolean TAB_UNIQUE() {
        return true;
    }

    public SeismicProfile selectedProfile() {
        try {
            SeismicProfile profile = this.m_profileWidget.selectedProfile();
            return profile;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public LwrsWidget() {
        super(1);
        try {
            this.setLeftComponent(this.createLeft());
            this.setRightComponent(this.createRight());
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected JComponent createLeft() {
        try {
            this.m_profileWidget = new ProfileSelectorWidget(false, this, 0);
            this.m_bitmapCardWidget.addComponent(BitmapEnum.Profile, this.m_profileWidget, "Profile selection");
            this.m_workerWidget = new Sequence_MainWidget("ULWS", EnsembleWorker_Sequence.SequenceType.Interactive);
            this.m_sequence = this.m_workerWidget.sequence();
            this.m_sequence.addListener(this);
            this.m_bitmapCardWidget.addComponent(BitmapEnum.Diagram, this.createSemblance(), "Semblance computation");
            this.m_bitmapCardWidget.addComponent(BitmapEnum.Sequence, this.m_workerWidget, "Ensemble processing sequence");
            this.m_pickerGizmoWidget = new PickerGizmoWidget();
            this.m_bitmapCardWidget.addComponent(BitmapEnum.PickControl, this.m_pickerGizmoWidget, "Pick controls");
            return this.m_bitmapCardWidget;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    protected JComponent createRight() {
        try {
            this.m_rightTabs.addChangeListener(this);
            this.m_semblanceWidget = new LwrsSemblanceWidget(null);
            this.m_rightTabs.addTab("Velocity picker", this.m_semblanceWidget);
            LinearLayoutWidget main = LinearLayoutWidget.vert(3, null);
            LinearLayoutWidget top = main.createHorizontal(3, null, 0);
            this.m_btnReloadPickeVel = top.createButton("Reload picked velocity", this, 0);
            top.addComponent(this.m_lblPicked, 10);
            this.m_widgetPickedVel = new Java2D_SimpleComposite(false);
            main.addComponent(this.m_widgetPickedVel, 10);
            this.m_rightTabs.addTab("Picked Velocity", main);
            this.m_createStacksWidget = new LwrsCreateStacksWidget(this.m_sharedData, null, this.m_sequence);
            this.m_rightTabs.addTab("Create stacks", this.m_createStacksWidget);
            this.m_hvaWidgets = new ArrayList();
            for (int n = 1; n <= 3; ++n) {
                LwrsHvaWidget w = new LwrsHvaWidget(this.m_sharedData, null, this.m_sequence);
                this.m_hvaWidgets.add(w);
                this.m_rightTabs.addTab("HVA #" + Integer.toString(n), w);
            }
            return this.m_rightTabs;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    protected JComponent createSemblance() {
        try {
            LinearLayoutWidget main = LinearLayoutWidget.vert(4, null);
            main.addComponent(this.createSembOptionsWidget(), 0);
            JLabel lbl = new JLabel("<html>Be sure to prepare the processing sequence, including statics, <br>on the next tab before computing semblance</html>");
            lbl.setBorder(BorderFactory.createRaisedBevelBorder());
            lbl.setBackground(Color.yellow);
            main.addComponent(lbl, 0);
            this.m_btnComputeSemblance = main.createButton("Compute semblances for entire line", this, 0);
            main.addStretch(10);
            return main;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    protected JComponent createSembOptionsWidget() {
        try {
            GridLayoutWidget grid = new GridLayoutWidget(0, "Velocity function options");
            int row = 0;
            grid.addSimple(row++, new JLabel("Minimum velocity"), this.m_velMinText);
            grid.addSimple(row++, new JLabel("Maximum velocity"), this.m_velMaxText);
            grid.addSimple(row++, new JLabel("Velocity count"), this.m_velCountText);
            grid.addSimple(row++, new JLabel("Minimum time"), this.m_timeMinText);
            grid.addSimple(row++, new JLabel("Maximum time"), this.m_timeMaxText);
            grid.addSimple(row++, new JLabel("Sample interval"), this.m_timeDigiText);
            grid.addSimple(row++, new JLabel("Stretch mute percent"), this.m_muteText);
            grid.addSimple(row++, new JLabel("Minimum offset"), this.m_minOffText);
            grid.addSimple(row++, new JLabel("Maximum offset"), this.m_maxOffText);
            return grid;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    protected void prepSemblanceOptions(Semblance semb) {
        try {
            semb.ExtraWaveletShaping = false;
            double x1 = Tools_Widget.extractDouble(this.m_minOffText, 0.0, 0.0, 25000.0);
            double x2 = Tools_Widget.extractDouble(this.m_maxOffText, 0.0, x1 + 100.0, 30000.0);
            semb.setOffsetRange(x1, x2);
            double v1 = Tools_Widget.extractDouble(this.m_velMinText, 1000.0, 10.0, 25000.0);
            double v2 = Tools_Widget.extractDouble(this.m_velMaxText, 7000.0, v1 + 100.0, 30000.0);
            int numv = Tools_Widget.extractInteger(this.m_velCountText, 50, 20, 200);
            semb.setVelocityRange(v1, v2);
            semb.setNumVelocities(numv);
            double t1 = Tools_Widget.extractDouble(this.m_timeMinText, 100.0, 0.0, 3000.0);
            double t2 = Tools_Widget.extractDouble(this.m_timeMaxText, 2000.0, t1 + 100.0, 100000.0);
            double digi = Tools_Widget.extractDouble(this.m_timeDigiText, 8.0, 1.0, 32.0);
            semb.setTimeRange(t1, t2);
            semb.setDigi(digi);
            double mute = Tools_Widget.extractDouble(this.m_muteText, 25.0, 5.0, 200.0);
            semb.setStretchMutePercent(mute);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        try {
            System.out.println("stateChanged " + this.m_rightTabs.getSelectedIndex());
            if (this.m_rightTabs.getSelectedIndex() == 1) {
                this.reloadPickedVel();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_btnComputeSemblance) {
                this.computeSemblance();
                return;
            }
            if (e.getSource() == this.m_btnReloadPickeVel) {
                this.reloadPickedVel();
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void reloadPickedVel() {
        try {
            this.m_lblPicked.setText(" ");
            this.m_lblPicked.setForeground(Color.red);
            SeismicProfile sp = this.selectedProfile();
            this.m_widgetPickedVel.setHorizontalTitle("Profile bin number");
            Java2D_Widget w = this.m_widgetPickedVel.mainWidget();
            w.clearPaintableList();
            w.clearEventConsumerList();
            w.addZoomer();
            if (this.m_leftClickUEC == null) {
                this.m_leftClickUEC = new Java2D_UserEventConsumer_ButtonPressed(1);
                this.m_leftClickUEC.addListener(this);
            }
            if (sp == null) {
                this.m_lblPicked.setText("Profile not selected");
            } else if (!sp.semblanceProfileVolume().valid()) {
                this.m_lblPicked.setText("Profile semblance not computed");
            } else if (sp.semblanceProfileVelocityCollection().getNumPickedBins() < 1) {
                this.m_lblPicked.setText("No picks");
            } else {
                Java2D_Paintable_TimeGrid grid = sp.getVelocityAlongSemblanceProfile();
                w.addPaintable(grid, -9999);
                w.addPaintable(sp.semblanceProfileVelocityCollection(), -9999);
                w.addEventConsumer(this.m_leftClickUEC);
            }
            w.transform().setTechnique(Java2D_Transform.Technique.Inverted);
            w.mooz();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void handlePickedVelocityClick() {
        try {
            SemblanceProfileVelocityCollection vc = this.selectedProfile().semblanceProfileVelocityCollection();
            int mouseX = this.m_leftClickUEC.PixelX;
            int nearestBin = 0;
            int minDist = 100000;
            for (int b = 0; b < vc.numBins(); ++b) {
                VelocityLocation loc = vc.getVelocityLocation(b);
                int dist = Math.abs(loc.PixelX - mouseX);
                if (loc.numPicks() < 1) {
                    dist += 10;
                }
                if (dist >= minDist) continue;
                minDist = dist;
                nearestBin = b;
            }
            this.m_semblanceWidget.setCurrentBin(nearestBin);
            this.m_rightTabs.setSelectedIndex(0);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void computeSemblance() {
        try {
            Action_ComputeProfileSemblance action = new Action_ComputeProfileSemblance();
            action.m_profile = this.selectedProfile();
            if (action.m_profile == null) {
                JOptionPane.showMessageDialog(null, "Select a profile first", "", 0);
                return;
            }
            if (action.m_profile.binCount() < 1) {
                JOptionPane.showMessageDialog(null, "Profile not valid", "", 0);
                return;
            }
            this.prepSemblanceOptions(action.m_semblance);
            this.m_sequence.getParametersFromWidgets();
            action.m_sequence = this.m_sequence;
            RefractionStaticsProject.singleton().executeSingleAction(action);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void handleProfileChanged() {
        try {
            this.m_semblanceWidget.setSeismicProfile(this.selectedProfile());
            this.m_createStacksWidget.setSeismicProfile(this.selectedProfile());
            for (LwrsHvaWidget w : this.m_hvaWidgets) {
                w.setSeismicProfile(this.selectedProfile());
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleMessenger(Messenger.Message message, Object sender, Object data) {
        try {
            if (message == Messenger.Message.ProfileSemblanceRecomputed) {
                this.handleProfileChanged();
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (sender == this.m_leftClickUEC) {
                this.handlePickedVelocityClick();
                return;
            }
            if (sender == this.m_profileWidget) {
                this.handleProfileChanged();
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public static class SharedData {
        public Ensemble StackEnsemble;
    }
}

