/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Java2D.UserEventHandler;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintParameter;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_Table;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumerBase;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventDataWrapper;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventOrigin;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class Java2D_UserEventConsumer_Selector
extends Java2D_UserEventConsumerBase
implements ActionListener {
    public int MouseButton = 1;
    public int PixelX;
    public int PixelY;
    public double WorldX;
    public double WorldY;
    public boolean ShiftDown;
    public boolean AltDown;
    public boolean ControlDown;
    public Java2D_Paintable_Table PaintableTable = null;
    public JComponent Owner;
    protected JPopupMenu m_popupMenu = null;
    public int SelectedID = -9999;
    public boolean MultiSelect = true;
    public int PlotIndex = -9999;

    public Java2D_UserEventConsumer_Selector(JComponent owner) {
        this.Owner = owner;
    }

    @Override
    public void handleUserEvent(Java2D_UserEventDataWrapper eventData) {
        try {
            boolean okay;
            int code;
            this.SelectedID = -9999;
            if (this.PaintableTable == null) {
                return;
            }
            boolean mouseOkay = eventData.UserEventOrigin == Java2D_UserEventOrigin.MousePressed && eventData.InputMouseEvent.getButton() == this.MouseButton;
            this.PlotIndex = -9999;
            if (eventData.UserEventOrigin == Java2D_UserEventOrigin.KeyPressed && (code = eventData.InputKeyEvent.getKeyCode()) >= 49 && code <= 57) {
                this.PlotIndex = code - 49;
            }
            boolean bl = okay = mouseOkay || this.PlotIndex >= 0;
            if (!okay) {
                return;
            }
            this.PixelX = eventData.PixelX;
            this.PixelY = eventData.PixelY;
            this.WorldX = eventData.Transform.getWorldFromPixel_X(this.PixelX);
            this.WorldY = eventData.Transform.getWorldFromPixel_Y(this.PixelY);
            this.ShiftDown = eventData.IsShiftDown;
            this.AltDown = eventData.IsAltDown;
            this.ControlDown = eventData.IsControlDown;
            if (!this.PaintableTable.prepMouseLocation(this.PixelX, this.PixelY)) {
                return;
            }
            if (this.PaintableTable.NearestList.size() == 1 || !this.MultiSelect) {
                this.SelectedID = this.PaintableTable.NearestID;
                this.broadcast(this, null);
                return;
            }
            if (this.Owner != null) {
                this.m_popupMenu = new JPopupMenu();
                String colC = this.PaintableTable.columnC();
                if (colC == null) {
                    colC = "";
                }
                for (Java2D_Paintable_Table.NearestEntry entry : this.PaintableTable.NearestList) {
                    MenuItem item = new MenuItem(entry.ID);
                    if (this.PaintableTable.NearestColorValid) {
                        item.setText(String.format("ID = %d, %s = %f", entry.ID, colC, entry.ColorValue));
                    } else {
                        item.setText(String.format("ID = %d,", entry.ID));
                    }
                    item.addActionListener(this);
                    this.m_popupMenu.add(item);
                }
                this.m_popupMenu.show(this.Owner, this.PixelX, this.PixelY);
                this.m_popupMenu.setVisible(true);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() instanceof MenuItem) {
                MenuItem item = (MenuItem)e.getSource();
                this.SelectedID = item.ID;
                this.broadcast(this, null);
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void paint(Java2D_PaintParameter paintParameter) {
    }

    @Override
    public void handleImageJustPainted() {
    }

    protected static class MenuItem
    extends JMenuItem {
        public int ID = -9999;

        public MenuItem(int id) {
            this.ID = id;
        }
    }
}

