/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Java2D.UserEventHandler;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintParameter;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumerBase;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventDataWrapper;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventOrigin;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;

public class Java2D_UserEventConsumer_Rectangle
extends Java2D_UserEventConsumerBase {
    public boolean DrawRectangle = false;
    public Color LineColor = Color.BLACK;
    public Stroke LineStroke = new BasicStroke(2.0f);
    public boolean FillRectangle = true;
    public Color FillColor = new Color(192, 192, 255, 128);
    public boolean Dragging = false;
    public boolean BroadcastWhenDragging = true;
    public int MouseButton = 3;
    public int StartPixelX;
    public int StartPixelY;
    public int EndPixelX;
    public int EndPixelY;
    public double StartWorldX;
    public double StartWorldY;
    public double EndWorldX;
    public double EndWorldY;
    public boolean RequestMooz = true;
    public boolean PaintFullWidth = false;

    @Override
    public void handleUserEvent(Java2D_UserEventDataWrapper eventData) {
        try {
            if (!this.Dragging) {
                this.RequestMooz = false;
                this.NeedsToBePainted = false;
                if (eventData.UserEventOrigin != Java2D_UserEventOrigin.MousePressed) {
                    return;
                }
                if (eventData.InputMouseEvent.getButton() != this.MouseButton) {
                    return;
                }
                this.StartPixelX = eventData.PixelX;
                this.StartPixelY = eventData.PixelY;
                this.StartWorldX = eventData.Transform.getWorldFromPixel_X(this.StartPixelX);
                this.StartWorldY = eventData.Transform.getWorldFromPixel_Y(this.StartPixelY);
                this.EndPixelY = eventData.PixelY;
                this.EndPixelX = eventData.PixelX;
                this.EndWorldX = eventData.Transform.getWorldFromPixel_X(this.EndPixelX);
                this.EndWorldY = eventData.Transform.getWorldFromPixel_Y(this.EndPixelY);
                this.Dragging = true;
                return;
            }
            if (eventData.UserEventOrigin == Java2D_UserEventOrigin.MouseDragged) {
                this.RequestMooz = false;
                this.NeedsToBePainted = true;
                this.EndPixelY = eventData.PixelY;
                this.EndPixelX = eventData.PixelX;
                this.EndWorldX = eventData.Transform.getWorldFromPixel_X(this.EndPixelX);
                this.EndWorldY = eventData.Transform.getWorldFromPixel_Y(this.EndPixelY);
                if (this.BroadcastWhenDragging) {
                    this.broadcast(this, null);
                }
                return;
            }
            if (eventData.UserEventOrigin == Java2D_UserEventOrigin.MouseReleased) {
                this.NeedsToBePainted = false;
                this.Dragging = false;
                this.EndPixelY = eventData.PixelY;
                this.EndPixelX = eventData.PixelX;
                this.EndWorldX = eventData.Transform.getWorldFromPixel_X(this.EndPixelX);
                this.EndWorldY = eventData.Transform.getWorldFromPixel_Y(this.EndPixelY);
                this.RequestMooz = Math.abs(this.EndPixelX - this.StartPixelX) < 5 || Math.abs(this.EndPixelY - this.StartPixelY) < 5;
                this.broadcast(this, null);
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void paint(Java2D_PaintParameter paintParameter) {
        try {
            if (!this.Dragging) {
                return;
            }
            Graphics2D g2d = paintParameter.G2D;
            if (this.PaintFullWidth) {
                int width = paintParameter.Transform.sizeX();
                int minPixelY = Math.min(this.StartPixelY, this.EndPixelY);
                int height = 1 + Math.abs(this.StartPixelY - this.EndPixelY);
                if (this.FillRectangle) {
                    g2d.setColor(this.FillColor);
                    g2d.fillRect(0, minPixelY, width, height);
                }
            } else {
                int minPixelX = Math.min(this.StartPixelX, this.EndPixelX);
                int width = 1 + Math.abs(this.StartPixelX - this.EndPixelX);
                int minPixelY = Math.min(this.StartPixelY, this.EndPixelY);
                int height = 1 + Math.abs(this.StartPixelY - this.EndPixelY);
                if (this.DrawRectangle) {
                    g2d.setColor(this.LineColor);
                    g2d.setStroke(this.LineStroke);
                    g2d.drawRect(minPixelX, minPixelY, width, height);
                }
                if (this.FillRectangle) {
                    g2d.setColor(this.FillColor);
                    g2d.fillRect(minPixelX, minPixelY, width, height);
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleImageJustPainted() {
        try {
            this.Dragging = false;
            this.NeedsToBePainted = false;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

