/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Java2D.UserEventHandler;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.SharedApplicationData;
import com.PecosLibrary.Refraction.MoveoutTrendData;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintParameter;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumerBase;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventDataWrapper;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventOrigin;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Stroke;
import javax.swing.JOptionPane;

public class Java2D_UserEventConsumer_MoveoutTrend
extends Java2D_UserEventConsumerBase {
    public boolean DrawRectangle = false;
    public Color LineColor = Color.YELLOW;
    public Stroke LineStroke = new BasicStroke(4.0f);
    public int m_nextPointIndex = 0;
    public float[] m_offset = new float[200];
    public float[] m_time = new float[200];
    public float m_currentOffset = 0.0f;
    public float m_currentTime = 0.0f;
    public int PointCount = 0;
    public float[] Offset = new float[200];
    public float[] Time = new float[200];
    public boolean ForceTimeIncrease = true;
    public float MinRequiredOffsetIncrease = 50.0f;
    public MoveoutTrendData TrendData = null;
    public boolean ForceIncreasingVelocity = false;
    protected long m_currentClickTime = System.currentTimeMillis();
    protected long m_priorClickTime = 0L;
    public boolean MouseIsMoving = false;
    public boolean BroadCastWhenMouseMoves = false;

    protected void checkPoints() {
        try {
            for (int n = 1; n < this.PointCount; ++n) {
                float offsetChange = this.Offset[n] - this.Offset[n - 1];
                if (!(offsetChange < this.MinRequiredOffsetIncrease)) continue;
                this.PointCount = 0;
                JOptionPane.showMessageDialog(null, "Sequential points must increase in time and offset", "Cannot add trend", 0);
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleUserEvent(Java2D_UserEventDataWrapper eventData) {
        try {
            this.NeedsToBePainted = false;
            this.MouseIsMoving = false;
            if (eventData.UserEventOrigin == Java2D_UserEventOrigin.KeyPressed) {
                int keyCode = eventData.InputKeyEvent.getKeyCode();
                boolean add = false;
                boolean finish = false;
                if (keyCode == 65) {
                    add = true;
                }
                if (keyCode == 70) {
                    add = true;
                    finish = true;
                }
                if (add) {
                    this.m_offset[this.m_nextPointIndex] = (float)eventData.WorldX;
                    this.m_time[this.m_nextPointIndex] = (float)eventData.WorldY;
                    ++this.m_nextPointIndex;
                    this.NeedsToBePainted = true;
                }
                if (finish) {
                    this.PointCount = this.m_nextPointIndex;
                    for (int n = 0; n < this.PointCount; ++n) {
                        this.Offset[n] = this.m_offset[n];
                        this.Time[n] = this.m_time[n];
                        if (this.TrendData == null) continue;
                        if (this.TrendData.ApplyLMO) {
                            this.Time[n] = this.Time[n] + (float)(1000.0 * (double)this.Offset[n] / this.TrendData.LmoVel);
                        }
                        if (!this.TrendData.ApplyTrendData) continue;
                        double x = this.TrendData.Selected.X;
                        double y = this.TrendData.Selected.Y;
                        this.Time[n] = this.Time[n] + this.TrendData.getTime(x, y, this.Offset[n], true);
                    }
                    this.m_nextPointIndex = 0;
                    this.checkPoints();
                    if (this.PointCount > 0) {
                        this.broadcast(this, null);
                    }
                }
                return;
            }
            if (eventData.UserEventOrigin == Java2D_UserEventOrigin.MousePressed) {
                if (eventData.InputMouseEvent.getButton() != 1) {
                    return;
                }
                boolean useCustomClick = SharedApplicationData.singleton().getParameterTree().bool_get("UseCustomDoubleClick", false);
                long doubleClickTime = SharedApplicationData.singleton().getParameterTree().int_get("DoubleClickTime", 300);
                doubleClickTime = Math.max(doubleClickTime, 100L);
                doubleClickTime = Math.min(doubleClickTime, 1000L);
                this.m_currentClickTime = System.currentTimeMillis();
                long timeSinceLast = this.m_currentClickTime - this.m_priorClickTime;
                this.m_priorClickTime = this.m_currentClickTime;
                boolean isDoubleClick = false;
                if (useCustomClick) {
                    isDoubleClick = timeSinceLast < doubleClickTime;
                } else {
                    boolean bl = isDoubleClick = eventData.InputMouseEvent.getClickCount() >= 2;
                }
                if (isDoubleClick) {
                    if (this.m_nextPointIndex <= 0) {
                        System.out.println("bizarre, m_nextPointIndex <= 0");
                        return;
                    }
                    this.PointCount = this.m_nextPointIndex;
                    for (int n = 0; n < this.PointCount; ++n) {
                        this.Offset[n] = this.m_offset[n];
                        this.Time[n] = this.m_time[n];
                        if (this.TrendData == null) continue;
                        if (this.TrendData.ApplyLMO) {
                            this.Time[n] = this.Time[n] + (float)(1000.0 * (double)this.Offset[n] / this.TrendData.LmoVel);
                        }
                        if (!this.TrendData.ApplyTrendData) continue;
                        double x = this.TrendData.Selected.X;
                        double y = this.TrendData.Selected.Y;
                        this.Time[n] = this.Time[n] + this.TrendData.getTime(x, y, this.Offset[n], true);
                    }
                    this.m_nextPointIndex = 0;
                    this.checkPoints();
                    if (this.PointCount > 0) {
                        this.broadcast(this, null);
                    }
                    return;
                }
                System.out.println("m_nextPointIndex = " + this.m_nextPointIndex);
                this.m_offset[this.m_nextPointIndex] = (float)eventData.WorldX;
                this.m_time[this.m_nextPointIndex] = (float)eventData.WorldY;
                ++this.m_nextPointIndex;
                this.NeedsToBePainted = true;
                return;
            }
            if (eventData.UserEventOrigin == Java2D_UserEventOrigin.MouseMoved) {
                this.m_currentOffset = (float)eventData.WorldX;
                this.m_currentTime = (float)eventData.WorldY;
                this.NeedsToBePainted = true;
                this.MouseIsMoving = true;
                if (this.BroadCastWhenMouseMoves) {
                    this.broadcast(this, null);
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void paintLine(Java2D_PaintParameter paintParameter, double x1, double t1, double x2, double t2) {
        try {
            Graphics2D g2d = paintParameter.G2D;
            Java2D_Transform transform = paintParameter.Transform;
            double scaleX = transform.scaleX();
            double shiftX = transform.shiftX();
            double scaleY = transform.scaleY();
            double shiftY = transform.shiftY();
            int ix1 = (int)(x1 * scaleX + shiftX);
            int iy1 = (int)(t1 * scaleY + shiftY);
            int ix2 = (int)(x2 * scaleX + shiftX);
            int iy2 = (int)(t2 * scaleY + shiftY);
            g2d.drawLine(ix1, iy1, ix2, iy2);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void paint(Java2D_PaintParameter paintParameter) {
        try {
            Graphics2D g2d = paintParameter.G2D;
            g2d.setColor(Color.blue);
            Java2D_Transform transform = paintParameter.Transform;
            Font m_valueFont = new Font("SansSerif", 0, 15);
            g2d.setFont(m_valueFont);
            String s = "Click 'a' to add a control point";
            int width = g2d.getFontMetrics().stringWidth(s);
            int h = 2 + g2d.getFontMetrics().getHeight();
            g2d.drawString(s, transform.sizeX() - width - 10, h);
            s = "Click 'f' to finish";
            g2d.drawString(s, transform.sizeX() - width - 10, 2 * h);
            g2d.setStroke(this.LineStroke);
            g2d.setColor(this.LineColor);
            if (this.m_nextPointIndex <= 0) {
                this.paintLine(paintParameter, 0.0, 0.0, this.m_currentOffset, this.m_currentTime);
                return;
            }
            this.paintLine(paintParameter, 0.0, 0.0, this.m_offset[0], this.m_time[0]);
            this.paintLine(paintParameter, this.m_offset[this.m_nextPointIndex - 1], this.m_time[this.m_nextPointIndex - 1], this.m_currentOffset, this.m_currentTime);
            for (int n = 0; n < this.m_nextPointIndex - 1; ++n) {
                this.paintLine(paintParameter, this.m_offset[n], this.m_time[n], this.m_offset[n + 1], this.m_time[n + 1]);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleImageJustPainted() {
        try {
            this.NeedsToBePainted = false;
            this.m_nextPointIndex = 0;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

