/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Java2D.UserEventHandler;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Refraction.Tomography.InteractiveModel.TomoInteractiveModel_DelayTime;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintParameter;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumerBase;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventDataWrapper;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventOrigin;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;

public class Java2D_UserEventConsumer_DelayTimeModel
extends Java2D_UserEventConsumerBase {
    public boolean DrawRectangle = false;
    public Color LineColorOkay = Color.BLUE;
    public Color LineColorBad = Color.RED;
    public Stroke LineStroke = new BasicStroke(4.0f);
    protected int m_numRefractors = 0;
    protected int m_numPoints = 0;
    protected float[] m_offset = new float[200];
    protected float[] m_time = new float[200];
    protected float[] m_velocity = new float[200];
    protected float[] m_delaytime = new float[200];
    protected float m_currentOffset = 0.0f;
    protected float m_currentTime = 0.0f;
    protected float m_currentVelocity = 0.0f;
    protected boolean m_currentValid = false;
    protected String m_reasonNotValid = "";
    public boolean IsMouseMoveEvent = false;
    public boolean IsDoubleClickEvent = false;
    public boolean ApplyLMO = false;
    public double VelocityLMO = 5000.0;

    public int numRefractors() {
        return this.m_numRefractors;
    }

    public int numPoints() {
        return this.m_numPoints;
    }

    public float currentVelocity() {
        return this.m_currentVelocity;
    }

    public boolean currentValid() {
        return this.m_currentValid;
    }

    public String reasonNotValid() {
        return this.m_reasonNotValid;
    }

    public void prepDelayTimeModel(TomoInteractiveModel_DelayTime model, boolean addCurrent) {
        try {
            model.clearPicks();
            for (int n = 0; n < this.m_numPoints; ++n) {
                model.addPick(this.m_offset[n], this.m_time[n]);
            }
            if (addCurrent) {
                model.addPick(this.m_currentOffset, this.m_currentTime);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void handleMouseMove() {
        try {
            this.m_currentValid = false;
            if (this.m_numPoints == 0) {
                if (this.m_currentOffset < 1.0f || this.m_currentTime < 1.0f) {
                    this.m_reasonNotValid = "Offset and time must be greater than zero";
                    return;
                }
                this.m_currentVelocity = 1000.0f * this.m_currentOffset / this.m_currentTime;
                this.m_numRefractors = 0;
                this.m_currentValid = true;
                return;
            }
            float deltaOffset = this.m_currentOffset - this.m_offset[this.m_numPoints - 1];
            float deltaTime = this.m_currentTime - this.m_time[this.m_numPoints - 1];
            if (deltaOffset < 1.0f || deltaTime < 1.0f) {
                this.m_reasonNotValid = "Offset and time must increase";
                return;
            }
            this.m_currentVelocity = 1000.0f * deltaOffset / deltaTime;
            if (this.m_currentVelocity <= 1.001f * this.m_velocity[this.m_numPoints - 1]) {
                this.m_reasonNotValid = "Velocity must increase";
                return;
            }
            this.m_currentValid = true;
            this.m_time[this.m_numPoints] = this.m_currentTime;
            this.m_offset[this.m_numPoints] = this.m_currentOffset;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleUserEvent(Java2D_UserEventDataWrapper eventData) {
        try {
            this.IsDoubleClickEvent = false;
            this.IsMouseMoveEvent = false;
            float time = (float)eventData.WorldY;
            float offset = (float)eventData.WorldX;
            if (this.ApplyLMO) {
                time += 1000.0f * offset / (float)this.VelocityLMO;
            }
            this.NeedsToBePainted = false;
            if (eventData.UserEventOrigin == Java2D_UserEventOrigin.MouseMoved) {
                this.m_currentOffset = offset;
                this.m_currentTime = time;
                this.handleMouseMove();
                this.NeedsToBePainted = true;
                this.IsMouseMoveEvent = true;
                this.broadcast(this, null);
                return;
            }
            if (eventData.UserEventOrigin == Java2D_UserEventOrigin.MousePressed) {
                if (eventData.InputMouseEvent.getClickCount() == 1) {
                    if (this.m_currentValid) {
                        this.m_currentOffset = offset;
                        this.m_currentTime = time;
                        this.m_time[this.m_numPoints] = time;
                        this.m_offset[this.m_numPoints] = offset;
                        ++this.m_numPoints;
                        float doff = this.m_offset[this.m_numPoints - 1];
                        float dt = this.m_time[this.m_numPoints - 1];
                        if (this.m_numPoints >= 2) {
                            doff = this.m_offset[this.m_numPoints - 1] - this.m_offset[this.m_numPoints - 2];
                            dt = this.m_time[this.m_numPoints - 1] - this.m_time[this.m_numPoints - 2];
                        }
                        this.m_velocity[this.m_numPoints - 1] = 1000.0f * doff / dt;
                        this.NeedsToBePainted = true;
                    }
                    return;
                }
                if (eventData.InputMouseEvent.getClickCount() >= 2 && this.m_currentValid) {
                    this.IsDoubleClickEvent = true;
                    this.broadcast(this, null);
                    this.m_numPoints = 0;
                    this.NeedsToBePainted = true;
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void paintLine(Java2D_PaintParameter paintParameter, double x1, double t1, double x2, double t2, boolean extrapolate) {
        try {
            Graphics2D g2d = paintParameter.G2D;
            Java2D_Transform transform = paintParameter.Transform;
            double scaleX = transform.scaleX();
            double shiftX = transform.shiftX();
            double scaleY = transform.scaleY();
            double shiftY = transform.shiftY();
            if (this.ApplyLMO) {
                t1 -= 1000.0 * x1 / this.VelocityLMO;
                t2 -= 1000.0 * x2 / this.VelocityLMO;
            }
            int ix1 = (int)(x1 * scaleX + shiftX);
            int iy1 = (int)(t1 * scaleY + shiftY);
            int ix2 = (int)(x2 * scaleX + shiftX);
            int iy2 = (int)(t2 * scaleY + shiftY);
            if (!extrapolate) {
                g2d.drawLine(ix1, iy1, ix2, iy2);
                return;
            }
            double dx = ix2 - ix1;
            double dy = iy2 - iy1;
            if (Math.abs(dx) < 4.0 && Math.abs(dy) < 4.0) {
                return;
            }
            double bigs = 300.0;
            ix2 = ix1 + (int)(bigs * dx);
            iy2 = iy1 + (int)(bigs * dy);
            g2d.drawLine(ix1, iy1, ix2, iy2);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void paint(Java2D_PaintParameter paintParameter) {
        try {
            Graphics2D g2d = paintParameter.G2D;
            if (this.m_currentValid) {
                g2d.setColor(this.LineColorOkay);
            } else {
                g2d.setColor(this.LineColorBad);
            }
            g2d.setStroke(this.LineStroke);
            if (this.m_numPoints <= 0) {
                this.paintLine(paintParameter, 0.0, 0.0, this.m_currentOffset, this.m_currentTime, true);
                return;
            }
            this.paintLine(paintParameter, 0.0, 0.0, this.m_offset[0], this.m_time[0], false);
            for (int n = 1; n < this.m_numPoints; ++n) {
                this.paintLine(paintParameter, this.m_offset[n - 1], this.m_time[n - 1], this.m_offset[n], this.m_time[n], false);
            }
            this.paintLine(paintParameter, this.m_offset[this.m_numPoints - 1], this.m_time[this.m_numPoints - 1], this.m_currentOffset, this.m_currentTime, true);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleImageJustPainted() {
        try {
            this.NeedsToBePainted = false;
            this.m_numPoints = 0;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

