/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Java2D.TablePlot;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Tools.Tools_GraphicalObjectLibrary;
import com.PecosLibrary.Windows.Java2D.TablePlot.Java2D_TablePlotImage_Single;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class Java2D_TablePlotWidget_Stacked
extends JPanel
implements ActionListener,
ComponentListener,
KeyListener,
MouseWheelListener,
MouseMotionListener,
MouseListener {
    protected ArrayList<Java2D_TablePlotImage_Single> m_list = new ArrayList();
    protected int m_numVisible = 3;
    public int m_vertLineCoord = -9;
    protected Table_Abstract m_table;
    protected JPopupMenu m_popupMenu = null;
    protected int m_popopRow = 0;

    public Java2D_TablePlotWidget_Stacked() {
        try {
            for (int n = 0; n < 10; ++n) {
                this.m_list.add(new Java2D_TablePlotImage_Single());
            }
            this.addComponentListener(this);
            this.addMouseMotionListener(this);
            this.addMouseWheelListener(this);
            this.addMouseListener(this);
            this.addKeyListener(this);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public int getNumVisible() {
        return this.m_numVisible;
    }

    public void setNumVisible(int numVisible) {
        this.m_numVisible = Math.max(numVisible, 1);
        this.m_numVisible = Math.min(this.m_numVisible, this.m_list.size());
        this.repaint();
    }

    public void setTable(Table_Abstract table) {
        try {
            this.m_table = table;
            for (Java2D_TablePlotImage_Single image : this.m_list) {
                image.setTable(table);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public boolean getColumnsUserSelectable(int index) {
        try {
            return this.m_list.get(index).getColumnsUserSelectable();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    public void setColumnsUserSelectable(int index, boolean columnsUserSelectable) {
        try {
            this.m_list.get(index).setColumnsUserSelectable(columnsUserSelectable);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setBackgroundColor(int index, Color c) {
        try {
            this.m_list.get(index).setBackgroundColor(c);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void clearColumnNames(int index) {
        try {
            this.m_list.get(index).clearColumnNames();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void addColumnName(int index, String colName) {
        try {
            this.m_list.get(index).addColumnName(colName);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        try {
            Dimension size = this.getSize();
            Graphics2D g2d = (Graphics2D)g;
            int pixPerPlot = size.height / this.m_numVisible;
            for (int n = 0; n < this.m_numVisible; ++n) {
                int top = n * pixPerPlot;
                int left = 0;
                BufferedImage image = this.m_list.get(n).image(left, top, size.width, pixPerPlot);
                g2d.drawImage((Image)image, left, n * pixPerPlot, null);
            }
            g2d.setColor(Color.lightGray);
            g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_1);
            g2d.drawLine(this.m_vertLineCoord, 0, this.m_vertLineCoord, size.height);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void drawVerticalLine(int x) {
        try {
            this.m_vertLineCoord = x;
            this.repaint();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        try {
            this.repaint();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
        try {
            this.requestFocus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() instanceof MenuItem) {
                MenuItem mi = (MenuItem)e.getSource();
                if (mi.ClearContents) {
                    this.m_list.get(this.m_popopRow).clearColumnNames();
                } else {
                    this.m_list.get(this.m_popopRow).addColumnName(mi.Column);
                }
                this.repaint();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void showPopupmenu(int row, MouseEvent event) {
        try {
            this.m_popupMenu = new JPopupMenu();
            MenuItem item = new MenuItem("Clear selected columns");
            item.setText("Clear selected columns");
            item.addActionListener(this);
            item.ClearContents = true;
            this.m_popupMenu.add(item);
            this.m_popupMenu.addSeparator();
            ArrayList<String> columns = this.m_table.column_listOfNames();
            for (String column : columns) {
                item = new MenuItem(column);
                item.setText(column);
                item.addActionListener(this);
                this.m_popupMenu.add(item);
            }
            this.m_popopRow = row;
            this.m_popupMenu.show(event.getComponent(), event.getX(), event.getY());
            this.m_popupMenu.setVisible(true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
        try {
            int n;
            for (n = 0; n < this.m_numVisible; ++n) {
                if (!this.m_list.get(n).checkIfLockClick(event.getX(), event.getY())) continue;
                this.repaint();
                return;
            }
            if (this.m_table == null) {
                return;
            }
            for (n = 0; n < this.m_numVisible; ++n) {
                if (!this.m_list.get(n).insideImage(event.getX(), event.getY())) continue;
                if (this.m_list.get(n).getColumnsUserSelectable()) {
                    this.showPopupmenu(n, event);
                } else {
                    JOptionPane.showMessageDialog(null, "Contents of the plot are controlled by the application", "Cannot modify display", 0);
                }
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
    }

    @Override
    public void keyPressed(KeyEvent event) {
    }

    @Override
    public void keyReleased(KeyEvent event) {
    }

    @Override
    public void keyTyped(KeyEvent event) {
    }

    @Override
    public void mouseDragged(MouseEvent event) {
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        try {
            this.drawVerticalLine(event.getX());
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent event) {
    }

    protected static class MenuItem
    extends JMenuItem {
        public boolean ClearContents = false;
        public String Column = "";

        public MenuItem(String col) {
            this.Column = col;
        }
    }
}

