/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Java2D.TablePlot;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosLibrary.Tools.BitmapEnum;
import com.PecosLibrary.Tools.Tools_Bitmap;
import com.PecosLibrary.Tools.Tools_FontLibrary;
import com.PecosLibrary.Tools.Tools_GraphicalObjectLibrary;
import com.PecosLibrary.Tools.Tools_Plot;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.ImageIcon;

public class Java2D_TablePlotImage_Single {
    protected BufferedImage m_image = null;
    protected int m_pixelX = 0;
    protected int m_pixelY = 0;
    protected boolean m_dirty = true;
    protected Table_Abstract m_table;
    protected boolean m_columnsUserSelectable = true;
    protected ArrayList<NameIndexPair> m_columnList = new ArrayList();
    protected boolean m_locked = false;
    protected boolean m_valid = false;
    protected double m_min;
    protected double m_max;
    protected double m_scale;
    protected double m_shift;
    protected double m_scaleX = 1.0;
    protected double m_shiftX = 0.0;
    protected int m_horizontalAxisHeight = 0;
    protected int m_verticalAxisWidth = 80;
    protected int m_plotWidth = 100;
    protected Color m_backgroundColor = new Color(233, 233, 233);
    protected Color[] m_colorList = new Color[4];
    protected ImageIcon m_iconLock;
    protected ImageIcon m_iconUnlock;
    protected Image m_imageLock;
    protected Image m_imageUnlock;

    public Java2D_TablePlotImage_Single() {
        try {
            this.m_colorList[0] = Color.BLUE;
            this.m_colorList[1] = Color.RED;
            this.m_colorList[2] = Color.GREEN;
            this.m_colorList[3] = Color.CYAN;
            this.m_iconLock = Tools_Bitmap.makeIcon(BitmapEnum.Lock.Bitmap);
            this.m_iconUnlock = Tools_Bitmap.makeIcon(BitmapEnum.Unlock.Bitmap);
            this.m_imageLock = this.m_iconLock.getImage();
            this.m_imageUnlock = this.m_iconUnlock.getImage();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setBackgroundColor(Color c) {
        try {
            if (c != null) {
                this.m_backgroundColor = c;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setTable(Table_Abstract table) {
        this.m_table = table;
        this.m_dirty = true;
    }

    public boolean getColumnsUserSelectable() {
        return this.m_columnsUserSelectable;
    }

    public void setColumnsUserSelectable(boolean columnsUserSelectable) {
        this.m_columnsUserSelectable = columnsUserSelectable;
    }

    public void clearColumnNames() {
        try {
            this.m_dirty = true;
            this.m_columnList.clear();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void addColumnName(String colName) {
        try {
            this.m_dirty = true;
            NameIndexPair nip = new NameIndexPair();
            nip.Valid = false;
            nip.ColumnName = colName;
            this.m_columnList.add(nip);
            this.m_valid = false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public boolean insideImage(int x, int y) {
        try {
            boolean inx = x > this.m_pixelX && x < this.m_pixelX + this.m_image.getWidth();
            boolean iny = y > this.m_pixelY && y < this.m_pixelY + this.m_image.getHeight();
            return inx && iny;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    public boolean checkIfLockClick(int x, int y) {
        try {
            boolean iny;
            int w = this.m_imageLock.getWidth(null);
            int h = this.m_imageLock.getHeight(null);
            boolean inx = x > this.m_pixelX && x < this.m_pixelX + w;
            boolean bl = iny = y > this.m_pixelY && y < this.m_pixelY + h;
            if (inx && iny) {
                this.m_locked = !this.m_locked;
                this.m_dirty = true;
                return true;
            }
            return false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    public BufferedImage image(int left, int top, int width, int height) {
        try {
            this.m_pixelX = left;
            this.m_pixelY = top;
            boolean resized = this.resizeImage(width, height);
            if (!this.m_dirty && !resized) {
                return this.m_image;
            }
            int w = this.m_image.getWidth();
            int h = this.m_image.getHeight();
            this.m_valid = false;
            Graphics2D g2d = this.m_image.createGraphics();
            g2d.setColor(this.m_backgroundColor);
            g2d.fillRect(0, 0, w, h);
            g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_3);
            if (this.m_table == null) {
                return this.m_image;
            }
            if (this.m_table.row_count() < 1) {
                return this.m_image;
            }
            this.m_verticalAxisWidth = 80;
            this.m_horizontalAxisHeight = 0;
            this.m_plotWidth = w - this.m_verticalAxisWidth;
            if (this.m_plotWidth < 10) {
                return this.m_image;
            }
            double minRow = -1.0;
            double maxRow = this.m_table.row_count();
            this.m_scaleX = (double)(w - 1 - this.m_verticalAxisWidth) / (maxRow - minRow);
            this.m_shiftX = (double)this.m_verticalAxisWidth - this.m_scaleX * minRow;
            this.plotEntry(g2d);
            g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_1);
            this.plotAxis(g2d);
            g2d.setColor(Color.black);
            g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_2);
            g2d.drawLine(this.m_verticalAxisWidth, 0, this.m_verticalAxisWidth, h);
            g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_2);
            g2d.drawRect(0, 0, w, h);
            this.m_dirty = false;
            return this.m_image;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    protected void plotAxis(Graphics2D g2d) {
        try {
            int width;
            String s;
            if (!this.m_valid) {
                return;
            }
            int w = this.m_image.getWidth();
            double range = this.m_max - this.m_min;
            double tick = Tools_Plot.tickMarkInterval(range, 10);
            int temp = (int)(this.m_min / tick);
            g2d.setFont(Tools_FontLibrary.AxisFont);
            int stringHeight = g2d.getFontMetrics().getHeight();
            int stickLeft = this.m_verticalAxisWidth - 0;
            g2d.setColor(Color.BLACK);
            int priorY = -99999;
            g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_1);
            for (double v = (double)temp * tick; v < this.m_max; v += tick) {
                String s2 = Tools_Strings.doubleToString(v, range, true);
                int iy = (int)(v * this.m_scale + this.m_shift);
                g2d.setColor(Color.LIGHT_GRAY);
                g2d.drawLine(stickLeft, iy, 2000, iy);
                int stringWidth = g2d.getFontMetrics().stringWidth(s2);
                int strLeft = stickLeft - stringWidth;
                strLeft = Math.max(strLeft, 0);
                if (Math.abs(iy - priorY) <= 20) continue;
                priorY = iy;
                g2d.setColor(Color.BLACK);
                g2d.drawString(s2, strLeft, iy + 4);
            }
            if (this.m_locked) {
                g2d.drawImage(this.m_imageLock, 0, 0, null);
            } else {
                g2d.drawImage(this.m_imageUnlock, 0, 0, null);
            }
            int top = 4;
            int maxWidth = 0;
            boolean numValid = false;
            for (NameIndexPair nip : this.m_columnList) {
                if (nip.Index < 0) continue;
                s = nip.ColumnName;
                width = g2d.getFontMetrics().stringWidth(s);
                maxWidth = Math.max(width + 5, maxWidth);
                top += stringHeight;
            }
            g2d.setColor(this.m_backgroundColor);
            g2d.fillRect(this.m_verticalAxisWidth, 0, maxWidth, top);
            g2d.setColor(Color.BLACK);
            g2d.drawRect(this.m_verticalAxisWidth, 0, maxWidth, top);
            top = stringHeight + 1;
            for (NameIndexPair nip : this.m_columnList) {
                if (nip.Index < 0) continue;
                g2d.setColor(nip.PlotColor);
                s = nip.ColumnName;
                width = g2d.getFontMetrics().stringWidth(s);
                g2d.drawString(s, this.m_verticalAxisWidth + 2, top);
                top += stringHeight;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void plotEntry(Graphics2D g2d) {
        try {
            this.m_valid = false;
            int num = 0;
            for (NameIndexPair nameIndexPair : this.m_columnList) {
                nameIndexPair.Index = -9999;
                nameIndexPair.Valid = this.m_table.column_exists(nameIndexPair.ColumnName);
                boolean bl = this.m_valid = this.m_valid || nameIndexPair.Valid;
                if (!nameIndexPair.Valid) continue;
                nameIndexPair.PlotColor = this.m_colorList[num % 4];
                ++num;
                nameIndexPair.Index = this.m_table.column_indexOfColumn(nameIndexPair.ColumnName);
            }
            if (!this.m_valid) {
                return;
            }
            if (!this.m_locked) {
                this.m_min = Double.MAX_VALUE;
                this.m_max = Double.MIN_VALUE;
                for (int row = 0; row < this.m_table.row_count(); ++row) {
                    for (NameIndexPair nip : this.m_columnList) {
                        if (nip.Index < 0) continue;
                        double v = this.m_table.getDouble(row, nip.Index);
                        this.m_min = Math.min(this.m_min, v);
                        this.m_max = Math.max(this.m_max, v);
                    }
                }
                double range = Math.max(0.1, this.m_max - this.m_min);
                double buff = range * 0.05;
                this.m_max += buff;
                this.m_min -= buff;
            }
            this.m_scale = -((double)this.m_image.getHeight()) / (this.m_max - this.m_min);
            this.m_shift = 0.0 - this.m_scale * this.m_max;
            g2d.setColor(Color.blue);
            for (NameIndexPair nameIndexPair : this.m_columnList) {
                if (nameIndexPair.Index < 0) continue;
                g2d.setColor(nameIndexPair.PlotColor);
                for (int n = 1; n < this.m_table.row_count(); ++n) {
                    int x1 = (int)(this.m_scaleX * (double)(n - 1) + this.m_shiftX);
                    int x2 = (int)(this.m_scaleX * (double)n + this.m_shiftX);
                    double v1 = this.m_table.getDouble(n - 1, nameIndexPair.Index);
                    double v2 = this.m_table.getDouble(n, nameIndexPair.Index);
                    int y1 = (int)(this.m_scale * v1 + this.m_shift);
                    int y2 = (int)(this.m_scale * v2 + this.m_shift);
                    g2d.drawLine(x1, y1, x2, y2);
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected boolean resizeImage(int width, int height) {
        try {
            if (this.m_image == null) {
                this.m_image = new BufferedImage(width, height, 2);
                return true;
            }
            if (this.m_image.getWidth() != width || this.m_image.getHeight() != height) {
                this.m_image = new BufferedImage(width, height, 2);
                return true;
            }
            return false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return true;
        }
    }

    protected class NameIndexPair {
        public Color PlotColor = Color.BLACK;
        public String ColumnName;
        public boolean Valid;
        public int Index;

        protected NameIndexPair() {
        }
    }
}

