/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Java2D.Paintables;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.Table_Memory;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Range_Double;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintParameter;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintableInterface;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import java.awt.Color;
import java.awt.Graphics2D;
import java.io.RandomAccessFile;

public class Java2D_Polygon
implements Java2D_PaintableInterface {
    public double[] X;
    public double[] Y;
    protected int[] m_pixelX = new int[3];
    protected int[] m_pixelY = new int[3];
    public Color FillColor = new Color(192, 255, 192);
    public double m_cos;
    public double m_sin;
    public double m_x;
    public double m_y;

    public Java2D_Polygon(double[] x, double[] y) {
        try {
            if (x.length < 3) {
                return;
            }
            this.X = new double[x.length];
            this.Y = new double[x.length];
            for (int n = 0; n < x.length; ++n) {
                this.X[n] = x[n];
                this.Y[n] = y[n];
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public Java2D_Polygon(int len) {
        try {
            if (len < 3) {
                return;
            }
            this.X = new double[len];
            this.Y = new double[len];
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public Java2D_Polygon() {
    }

    public void filterEnsemble(Ensemble e, boolean RequireShotInsidePolygon, boolean RequireReceiverInsidePolygon, boolean RequireCdpInsidePolygon) {
        try {
            int indexSX = e.dictionary().getEntryIndex("Shot", "Easting");
            int indexSY = e.dictionary().getEntryIndex("Shot", "Northing");
            int indexRX = e.dictionary().getEntryIndex("Receiver", "Easting");
            int indexRY = e.dictionary().getEntryIndex("Receiver", "Northing");
            for (int n = e.traceCount() - 1; n >= 0; --n) {
                boolean kill = false;
                EnsembleTrace t = e.trace(n);
                double sx = t.header().getDouble(indexSX);
                double sy = t.header().getDouble(indexSY);
                double rx = t.header().getDouble(indexRX);
                double ry = t.header().getDouble(indexRY);
                double cx = 0.5 * (sx + rx);
                double cy = 0.5 * (sy + ry);
                if (RequireShotInsidePolygon && !this.contains(sx, sy)) {
                    kill = true;
                }
                if (RequireReceiverInsidePolygon && !this.contains(rx, ry)) {
                    kill = true;
                }
                if (RequireCdpInsidePolygon && !this.contains(cx, cy)) {
                    kill = true;
                }
                if (!kill) continue;
                e.removeTrace(n);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public static void test() {
        try {
            Java2D_Polygon p = new Java2D_Polygon(4);
            p.X[0] = 0.0;
            p.Y[0] = 0.0;
            p.X[1] = 100.0;
            p.Y[1] = 0.0;
            p.X[2] = 100.0;
            p.Y[2] = 100.0;
            p.X[3] = 0.0;
            p.Y[3] = 100.0;
            if (p.contains(50.0, 50.0)) {
                System.out.println("contains");
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void clear() {
        this.X = null;
        this.Y = null;
    }

    public boolean valid() {
        if (this.X == null || this.Y == null) {
            return false;
        }
        return this.X.length >= 3 && this.Y.length >= 3;
    }

    public void read(String fileName) throws Exception {
        try {
            this.X = null;
            this.Y = null;
            if (!Tools_FileSystem.exists_file(fileName)) {
                return;
            }
            RandomAccessFile file = new RandomAccessFile(fileName, "rw");
            int magic = file.readInt();
            if (magic != 941854) {
                throw new Exception("magic != 941854");
            }
            int version = file.readInt();
            if (version == 1000) {
                int num = file.readInt();
                if (num < 3) {
                    file.close();
                    return;
                }
                this.X = new double[num];
                this.Y = new double[num];
                for (int n = 0; n < num; ++n) {
                    this.X[n] = file.readDouble();
                    this.Y[n] = file.readDouble();
                }
            }
            file.close();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void save(String fileName) {
        try {
            RandomAccessFile file = new RandomAccessFile(fileName, "rw");
            int magic = 941854;
            int version = 1000;
            file.writeInt(magic);
            file.writeInt(version);
            if (version == 1000) {
                if (this.X == null) {
                    file.writeInt(0);
                    file.close();
                    return;
                }
                file.writeInt(this.X.length);
                for (int n = 0; n < this.X.length; ++n) {
                    file.writeDouble(this.X[n]);
                    file.writeDouble(this.Y[n]);
                }
            }
            file.close();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public Java2D_Polygon duplicate() {
        try {
            if (this.X != null) {
                return new Java2D_Polygon(this.X, this.Y);
            }
            return new Java2D_Polygon();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return new Java2D_Polygon();
        }
    }

    public boolean contains(double x, double y) {
        try {
            if (this.X == null) {
                return false;
            }
            this.m_x = x;
            this.m_y = y;
            double minX = Double.MAX_VALUE;
            double maxX = Double.MIN_VALUE;
            double minY = Double.MAX_VALUE;
            double maxY = Double.MIN_VALUE;
            double minDist = Double.MAX_VALUE;
            int nearest = -9999;
            for (int n = 0; n < this.X.length; ++n) {
                minX = Math.min(this.X[n], minX);
                maxX = Math.max(this.X[n], maxX);
                minY = Math.min(this.Y[n], minY);
                maxY = Math.max(this.Y[n], maxY);
                double dist = Math.abs(this.m_x - this.X[n]) + Math.abs(this.m_y - this.Y[n]);
                if (!(dist < minDist)) continue;
                nearest = n;
                minDist = dist;
            }
            double minRange = Math.min(maxX - minX, maxY - minY);
            double maxRange = Math.max(maxX - minX, maxY - minY);
            if (minDist < 1.0E-5 * maxRange) {
                return true;
            }
            if (y >= maxY) {
                return false;
            }
            if (y <= minY) {
                return false;
            }
            if (x >= maxX) {
                return false;
            }
            if (x <= minX) {
                return false;
            }
            double delta = 3.1415558973857936E-4;
            double angle = 0.0 - delta;
            this.m_cos = 1.0;
            this.m_sin = 0.0;
            boolean hits = true;
            while (hits) {
                hits = false;
                this.m_cos = Math.cos(angle += delta);
                this.m_sin = Math.sin(angle);
                for (int n = 0; n < this.X.length && !hits; ++n) {
                    double minS = (this.X[n] - this.m_x) * this.m_cos + (this.Y[n] - this.m_y) * this.m_sin;
                    if (!(minS > 0.0)) continue;
                    double x1 = x + minS * this.m_cos;
                    double y1 = y + minS * this.m_sin;
                    double dist = Math.abs(x1 - this.X[n]) + Math.abs(y1 - this.Y[n]);
                    if (!(dist < 1.0E-7 * maxRange)) continue;
                    hits = true;
                }
            }
            int numEdgesHit = 0;
            for (int n = 0; n < this.X.length - 1; ++n) {
                if (!this.edgeCut(this.X[n], this.Y[n], this.X[n + 1], this.Y[n + 1])) continue;
                ++numEdgesHit;
            }
            if (this.edgeCut(this.X[0], this.Y[0], this.X[this.X.length - 1], this.Y[this.X.length - 1])) {
                ++numEdgesHit;
            }
            return numEdgesHit % 2 == 1;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    protected boolean edgeCut(double x1, double y1, double x2, double y2) {
        try {
            double denom = this.m_sin * (x2 - x1) - this.m_cos * (y2 - y1);
            if (Math.abs(denom) < 1.0E-7) {
                return false;
            }
            double r = (this.m_sin * (this.m_x - x1) - this.m_cos * (this.m_y - y1)) / denom;
            if (r <= 0.0 || r >= 1.0) {
                return false;
            }
            double s = 0.0;
            s = Math.abs(this.m_cos) > 0.01 ? (x1 - this.m_x + r * (x2 - x1)) / this.m_cos : (y1 - this.m_y + r * (y2 - y1)) / this.m_sin;
            return s > 0.0;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    @Override
    public boolean Java2D_ImageContentsDirty(int supplementalData) {
        return false;
    }

    @Override
    public int Java2D_MaximumPaintLevel(int supplementalData) {
        return 0;
    }

    @Override
    public void Java2D_Paint(Java2D_PaintParameter paintParameter, int supplementalData) {
        try {
            if (this.X == null) {
                return;
            }
            if (this.X.length < 2) {
                return;
            }
            if (this.m_pixelY.length != this.X.length) {
                this.m_pixelY = new int[this.X.length];
                this.m_pixelX = new int[this.X.length];
            }
            if (paintParameter.PaintLevel != 0) {
                return;
            }
            Java2D_Transform transform = paintParameter.Transform;
            Graphics2D g2d = paintParameter.G2D;
            g2d.setColor(this.FillColor);
            double scaleX = transform.scaleX();
            double shiftX = transform.shiftX();
            double scaleY = transform.scaleY();
            double shiftY = transform.shiftY();
            for (int n = 0; n < this.X.length; ++n) {
                this.m_pixelX[n] = (int)(scaleX * this.X[n] + shiftX);
                this.m_pixelY[n] = (int)(scaleY * this.Y[n] + shiftY);
            }
            g2d.fillPolygon(this.m_pixelX, this.m_pixelY, this.m_pixelX.length);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_RangeWorld(Range_Double rangeX, Range_Double rangeY, int supplementalData) {
        try {
            if (this.X == null) {
                return;
            }
            rangeX.expandRange(this.X);
            rangeY.expandRange(this.Y);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_RangeColor(Range_Double rangeC, int supplementalData) {
    }

    public void writeToXML() {
        try {
            Table_Memory table = new Table_Memory();
            int indexX = table.column_append("X", DataType.Double);
            int indexY = table.column_append("Y", DataType.Double);
            for (int n = 0; n < this.X.length; ++n) {
                table.row_increment();
                table.putDouble(n, indexX, this.X[n]);
                table.putDouble(n, indexY, this.Y[n]);
            }
            String path = RefractionStaticsProject.singleton().projectPath() + "/polygon.txt";
            table.exportColumn(path);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_PaintDatum(Java2D_PaintParameter paintParameter) {
    }
}

