/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Java2D.Paintables;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Range_Double;
import com.PecosLibrary.Windows.Java2D.Java2D_ColorArrayWrapper;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintParameter;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintableInterface;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import java.awt.Graphics2D;

public class Java2D_Paintable_TimeGrid
implements Java2D_PaintableInterface {
    protected boolean m_bContentsChangedSinceLastPaint = true;
    protected int m_numTimes;
    protected int m_numX;
    protected float[][] m_data;
    protected boolean[][] m_valid;
    protected boolean m_rangeDirty = true;
    protected float m_max = Float.MIN_VALUE;
    protected float m_min = Float.MAX_VALUE;
    protected double m_time0 = 0.0;
    protected double m_digi = 4.0;
    protected double m_startX = 0.0;
    protected double m_deltaX = 1.0;

    public int numTimes() {
        return this.m_numTimes;
    }

    public int numX() {
        return this.m_numX;
    }

    public Java2D_Paintable_TimeGrid(int numX, int numTimes) {
        try {
            this.m_numX = numX;
            this.m_numTimes = numTimes;
            this.m_data = new float[this.m_numX][this.m_numTimes];
            this.m_valid = new boolean[this.m_numX][this.m_numTimes];
            for (int x = 0; x < this.m_numX; ++x) {
                for (int t = 0; t < this.m_numTimes; ++t) {
                    this.m_valid[x][t] = false;
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setTime(double time0, double digi) {
        try {
            this.m_bContentsChangedSinceLastPaint = true;
            this.m_time0 = time0;
            this.m_digi = Math.max(digi, 0.001);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setX(double startX, double deltaX) {
        try {
            this.m_bContentsChangedSinceLastPaint = true;
            this.m_startX = startX;
            this.m_deltaX = Math.max(deltaX, 1.0E-5);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void clear() {
        try {
            this.m_bContentsChangedSinceLastPaint = true;
            this.m_rangeDirty = true;
            for (int x = 0; x < this.m_numX; ++x) {
                for (int t = 0; t < this.m_numTimes; ++t) {
                    this.m_valid[x][t] = false;
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void set(int x, int t, float v) {
        try {
            this.m_bContentsChangedSinceLastPaint = true;
            this.m_rangeDirty = true;
            this.m_data[x][t] = v;
            this.m_valid[x][t] = true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void computeRange() {
        try {
            this.m_rangeDirty = false;
            this.m_min = Float.MAX_VALUE;
            this.m_max = Float.MIN_VALUE;
            for (int x = 0; x < this.m_numX; ++x) {
                for (int t = 0; t < this.m_numTimes; ++t) {
                    if (!this.m_valid[x][t]) continue;
                    this.m_min = Math.min(this.m_min, this.m_data[x][t]);
                    this.m_max = Math.max(this.m_max, this.m_data[x][t]);
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public float max() {
        try {
            if (this.m_rangeDirty) {
                this.computeRange();
            }
            return this.m_max;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return Float.MIN_VALUE;
        }
    }

    public float min() {
        try {
            if (this.m_rangeDirty) {
                this.computeRange();
            }
            return this.m_min;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return Float.MAX_VALUE;
        }
    }

    @Override
    public boolean Java2D_ImageContentsDirty(int supplementalData) {
        return this.m_bContentsChangedSinceLastPaint;
    }

    @Override
    public int Java2D_MaximumPaintLevel(int supplementalData) {
        return 0;
    }

    @Override
    public void Java2D_Paint(Java2D_PaintParameter paintParameter, int supplementalData) {
        try {
            Java2D_ColorArrayWrapper colorWrapper = paintParameter.ColorArrayWrapper;
            Java2D_Transform transform = paintParameter.Transform;
            Graphics2D g2d = paintParameter.G2D;
            double scaleX = transform.scaleX();
            double shiftX = transform.shiftX();
            double scaleY = transform.scaleY();
            double shiftY = transform.shiftY();
            int pixPerX = 1 + (int)(scaleX * this.m_deltaX);
            float pixPerTime = (float)(scaleY * this.m_digi);
            int plotPixPerTime = 1 + (int)pixPerTime;
            for (int n = 0; n < this.m_numX; ++n) {
                double coord = this.m_startX + this.m_deltaX * ((double)n - 0.5);
                int x = (int)(scaleX * coord + shiftX);
                double time = this.m_time0 - 0.5 * this.m_digi;
                double pixY = scaleY * time + shiftY;
                for (int s = 0; s < this.m_numTimes; ++s) {
                    if (!this.m_valid[n][s]) continue;
                    double val = this.m_data[n][s];
                    if (colorWrapper.valueOK(val)) {
                        g2d.setColor(colorWrapper.colorUsingValue(val));
                        g2d.fillRect(x, (int)pixY, pixPerX, plotPixPerTime);
                    }
                    pixY += (double)pixPerTime;
                }
            }
            this.m_bContentsChangedSinceLastPaint = false;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_RangeWorld(Range_Double rangeX, Range_Double rangeY, int supplementalData) {
        try {
            double x1 = this.m_startX;
            double x2 = this.m_startX + this.m_deltaX * (double)(this.m_numX - 1);
            double y1 = this.m_time0;
            double y2 = this.m_time0 + this.m_digi * (double)(this.m_numTimes - 1);
            rangeX.expandRange(x1);
            rangeX.expandRange(x2);
            rangeY.expandRange(y1);
            rangeY.expandRange(y2);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_RangeColor(Range_Double rangeC, int supplementalData) {
        try {
            double max = this.max();
            double min = this.min();
            if (max >= min) {
                rangeC.expandRange(min);
                rangeC.expandRange(max);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_PaintDatum(Java2D_PaintParameter paintParameter) {
    }
}

