/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Java2D.Paintables;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Map.HashMap_Integer;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Range_Double;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Tools.Tools_GraphicalObjectLibrary;
import com.PecosLibrary.Windows.Java2D.Java2D_ColorArrayWrapper;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintParameter;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintableInterface;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;

public class Java2D_Paintable_SelectedEntries
implements Java2D_PaintableInterface {
    protected ArrayList<Entry> m_list = new ArrayList();
    protected String m_table;
    protected String m_colNameID;

    public void clearList() {
        this.m_list.clear();
    }

    public void add(int id, Color c) {
        Entry e = new Entry();
        e.ID = id;
        e.PointColor = c;
        this.m_list.add(e);
    }

    public Java2D_Paintable_SelectedEntries(String table) {
        this.m_table = table;
        this.m_colNameID = table + "ID";
    }

    @Override
    public boolean Java2D_ImageContentsDirty(int supplementalData) {
        return false;
    }

    @Override
    public int Java2D_MaximumPaintLevel(int supplementalData) {
        return 0;
    }

    @Override
    public void Java2D_Paint(Java2D_PaintParameter paintParameter, int supplementalData) {
        try {
            if (paintParameter.PaintLevel != 0) {
                return;
            }
            Java2D_ColorArrayWrapper colorWrapper = paintParameter.ColorArrayWrapper;
            Java2D_Transform transform = paintParameter.Transform;
            Graphics2D g2d = paintParameter.G2D;
            double scaleX = transform.scaleX();
            double shiftX = transform.shiftX();
            double scaleY = transform.scaleY();
            double shiftY = transform.shiftY();
            Table_Abstract table = null;
            HashMap_Integer map = null;
            if (this.m_table.equalsIgnoreCase("Receiver")) {
                table = RefractionStaticsProject.singleton().receiverTable();
                map = RefractionStaticsProject.singleton().receiverMap();
            }
            if (this.m_table.equalsIgnoreCase("Shot")) {
                table = RefractionStaticsProject.singleton().shotTable();
                map = RefractionStaticsProject.singleton().shotMap();
            }
            if (table == null) {
                return;
            }
            int colID = table.column_indexOfColumn(this.m_colNameID);
            int colX = table.column_indexOfColumn("Easting");
            int colY = table.column_indexOfColumn("Northing");
            double sizeWorld = 60.0;
            if (RefractionStaticsProject.singleton().units_feet()) {
                sizeWorld = 205.0;
            }
            int size = (int)(scaleX * sizeWorld);
            size = Math.max(size, 13);
            size = Math.min(size, 33);
            int h = size / 2;
            g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_0);
            for (Entry e : this.m_list) {
                if (!map.containsKey(e.ID)) continue;
                int row = map.get(e.ID);
                double x = table.getDouble(row, colX);
                double y = table.getDouble(row, colY);
                int ix = (int)(scaleX * x + shiftX);
                int iy = (int)(scaleY * y + shiftY);
                g2d.setColor(e.PointColor);
                g2d.fillOval(ix - h, iy - h, size, size);
                g2d.setColor(Color.BLACK);
                g2d.drawOval(ix - h, iy - h, size, size);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_RangeWorld(Range_Double rangeX, Range_Double rangeY, int supplementalData) {
    }

    @Override
    public void Java2D_RangeColor(Range_Double rangeC, int supplementalData) {
    }

    @Override
    public void Java2D_PaintDatum(Java2D_PaintParameter paintParameter) {
    }

    protected class Entry {
        public int ID = -9999;
        public Color PointColor = Color.black;

        protected Entry() {
        }
    }
}

