/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Java2D.Paintables;

import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleFirstBreakPickPlotData;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Ensemble.Tools_Ensemble;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Range_Double;
import com.PecosCore.Windows.Java2D.Java2D_PointSymbol;
import com.PecosLibrary.Tools.Tools_GraphicalObjectLibrary;
import com.PecosLibrary.Windows.Java2D.Java2D_EnsembleColorArray;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintParameter;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintableInterface;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public class Java2D_Paintable_Ensemble_Color
implements Java2D_PaintableInterface {
    protected Ensemble m_ensemble = null;
    public int NumberOfTracesPainted = 0;
    public boolean ImageContentsDirty = true;
    public int MaxOverlayLevel = 1;
    public boolean UseGrayScale = false;
    public double ScaleX;
    public double ShiftX;
    public double ScaleY;
    public double ShiftY;
    public double Left;
    public double Right;
    public double Top;
    public double Bottom;
    public int Height;
    protected Graphics2D m_g2d = null;
    public float WiggleOverlap = 1.1f;
    public float WiggleClipping = 1.1f;
    public boolean ApplyClipping = false;
    public boolean IndividualTraceAmplitudeScaling = true;
    protected float[] m_data = new float[3];
    protected double TempScalar;
    protected int MidPixel;
    protected double SampleScaleY;
    protected double SampleShiftY;
    protected double InverseSampleScaleY;
    protected double InverseSampleShiftY;

    @Override
    public boolean Java2D_ImageContentsDirty(int supplementalData) {
        return this.ImageContentsDirty;
    }

    @Override
    public int Java2D_MaximumPaintLevel(int supplementalData) {
        return this.MaxOverlayLevel;
    }

    protected void paintOverlays(Java2D_PaintParameter paintParameter, Object supplementalData) {
        try {
            EnsembleFirstBreakPickPlotData pickPlotData = this.m_ensemble.pickPlotData();
            for (int k = 0; k < pickPlotData.size(); ++k) {
                EnsembleFirstBreakPickPlotData.Entry entry = pickPlotData.getEntry(k);
                if (!this.m_ensemble.dictionary().containsEntry("Trace", entry.Column)) continue;
                this.m_g2d.setColor(entry.PickColor);
                int w = entry.SymbolSize;
                int w2 = w / 2;
                int index = this.m_ensemble.dictionary().getEntryIndex("Trace", entry.Column);
                for (int n = 0; n < this.m_ensemble.traceCount(); ++n) {
                    EnsembleTrace trace = this.m_ensemble.trace(n);
                    float pick = trace.header().getFloat(index);
                    if (!trace.PlotData.Visible || !(pick > -980.0f)) continue;
                    float shift = trace.data().getTotalFirstSampleShifts();
                    float shifted = pick + shift;
                    int py = (int)(this.ScaleY * (double)shifted + this.ShiftY);
                    int px = trace.PlotData.PixelX;
                    if (entry.Symbol == Java2D_PointSymbol.FilledSquare) {
                        this.m_g2d.fillRect(px - w2, py - w2, w, w);
                    }
                    if (entry.Symbol == Java2D_PointSymbol.FilledOval) {
                        this.m_g2d.fillOval(px - w2, py - w2, w, w);
                    }
                    if (entry.Symbol == Java2D_PointSymbol.HollowSquare) {
                        this.m_g2d.drawRect(px - w2, py - w2, w, w);
                    }
                    if (entry.Symbol == Java2D_PointSymbol.HollowOval) {
                        this.m_g2d.drawOval(px - w2, py - w2, w, w);
                    }
                    if (entry.Symbol == Java2D_PointSymbol.X) {
                        this.m_g2d.drawLine(px - w2, py - w2, px + w2, py + w2);
                        this.m_g2d.drawLine(px + w2, py - w2, px - w2, py + w2);
                    }
                    if (entry.Symbol != Java2D_PointSymbol.Plus) continue;
                    this.m_g2d.drawLine(px - w2, py, px + w2, py);
                    this.m_g2d.drawLine(px, py - w2, px, py + w2);
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public Ensemble ensemble() {
        return this.m_ensemble;
    }

    public void setEnsemble(Ensemble ensemble) {
        try {
            this.m_ensemble = ensemble;
            if (this.m_ensemble != null) {
                Tools_Ensemble.killTraces(this.m_ensemble);
            }
            this.clearTracePlotData();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void clearTracePlotData() {
        try {
            if (this.m_ensemble == null) {
                return;
            }
            for (int n = 0; n < this.m_ensemble.traceCount(); ++n) {
                EnsembleTrace trace = this.m_ensemble.trace(n);
                trace.PlotData.Visible = false;
                trace.PlotData.DataOK = trace.data().absoluteMax() > 1.0E-10f;
                trace.PlotData.PixelX = -999999;
                trace.PlotData.WorldX = -999999.0;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void Java2D_Paint(Java2D_PaintParameter paintParameter, int supplementalData) {
        try {
            EnsembleTrace trace;
            int n;
            if (this.m_ensemble == null) {
                return;
            }
            this.ScaleX = paintParameter.Transform.scaleX();
            this.ShiftX = paintParameter.Transform.shiftX();
            this.ScaleY = paintParameter.Transform.scaleY();
            this.ShiftY = paintParameter.Transform.shiftY();
            this.Left = paintParameter.Transform.actualLeft();
            this.Right = paintParameter.Transform.actualRight();
            this.Top = paintParameter.Transform.actualTop();
            this.Bottom = paintParameter.Transform.actualBottom();
            this.Height = paintParameter.Transform.sizeY();
            this.m_g2d = paintParameter.G2D;
            if (paintParameter.PaintLevel >= 1) {
                this.paintOverlays(paintParameter, supplementalData);
                this.m_g2d = null;
                return;
            }
            this.clearTracePlotData();
            this.NumberOfTracesPainted = 0;
            Tools_Ensemble.killTraces(this.m_ensemble);
            for (n = 0; n < this.m_ensemble.traceCount(); ++n) {
                trace = this.m_ensemble.trace(n);
                if (trace.traceOkay() && trace.PlotData.ShowTrace) {
                    trace.PlotData.WorldX = this.NumberOfTracesPainted;
                    trace.PlotData.PixelX = (int)(this.ScaleX * trace.PlotData.WorldX + this.ShiftX);
                    ++this.NumberOfTracesPainted;
                }
                if (!(trace.PlotData.WorldX >= this.Left) || !(trace.PlotData.WorldX <= this.Right) || !trace.PlotData.ShowTrace || !trace.traceOkay()) continue;
                trace.PlotData.Visible = true;
            }
            if (this.NumberOfTracesPainted < 1) {
                this.m_g2d = null;
                return;
            }
            if (this.IndividualTraceAmplitudeScaling) {
                for (n = 0; n < this.m_ensemble.traceCount(); ++n) {
                    float max;
                    trace = this.m_ensemble.trace(n);
                    if (!trace.PlotData.Visible) continue;
                    trace.PlotData.WiggleScalar = max = Math.max(1.0E-20f, trace.data().absoluteMax());
                }
            } else {
                EnsembleTrace trace2;
                int n2;
                float ensembleMaximum = 1.0E-20f;
                for (n2 = 0; n2 < this.m_ensemble.traceCount(); ++n2) {
                    trace2 = this.m_ensemble.trace(n2);
                    if (!trace2.PlotData.Visible) continue;
                    float max = Math.max(1.0E-20f, trace2.data().absoluteMax());
                    ensembleMaximum = Math.max(ensembleMaximum, max);
                }
                for (n2 = 0; n2 < this.m_ensemble.traceCount(); ++n2) {
                    trace2 = this.m_ensemble.trace(n2);
                    if (!trace2.PlotData.Visible) continue;
                    trace2.PlotData.WiggleScalar = ensembleMaximum;
                }
            }
            Java2D_EnsembleColorArray colors = Java2D_EnsembleColorArray.singleton();
            if (this.UseGrayScale) {
                colors = Java2D_EnsembleColorArray.singletonGrayScale();
            }
            for (int n3 = 0; n3 < this.m_ensemble.traceCount(); ++n3) {
                EnsembleTrace trace3 = this.m_ensemble.trace(n3);
                if (!trace3.PlotData.Visible || !trace3.hasData()) continue;
                double time0 = trace3.data().getFirstSampleCoord_WithShifts();
                double digi = trace3.data().getSampleInterval();
                trace3.PlotData.ShiftY = this.ShiftY + this.ScaleY * time0;
                trace3.PlotData.ScaleY = digi * this.ScaleY;
                trace3.PlotData.InverseScaleY = 1.0 / trace3.PlotData.ScaleY;
                trace3.PlotData.InverseShiftY = -trace3.PlotData.ShiftY / trace3.PlotData.ScaleY;
            }
            this.m_g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_0);
            int branchIndex = -999;
            if (this.m_ensemble.dictionary().containsEntry("Trace", "Branch_DelayTime")) {
                branchIndex = this.m_ensemble.dictionary().getEntryIndex("Trace", "Branch_DelayTime");
            }
            for (int n4 = 0; n4 < this.m_ensemble.traceCount(); ++n4) {
                EnsembleTrace trace4 = this.m_ensemble.trace(n4);
                if (!trace4.PlotData.Visible || !trace4.hasData()) continue;
                if (this.m_data.length != trace4.data().length()) {
                    this.m_data = new float[trace4.data().length()];
                }
                trace4.data().copyToArray(this.m_data);
                double time0 = trace4.data().getFirstSampleCoord_WithShifts();
                double digi = trace4.data().getSampleInterval();
                double pixPerSample = digi * this.ScaleY;
                double currentPixelY = time0 * this.ScaleY + this.ShiftY;
                int height = 1 + (int)pixPerSample;
                int leftPixel = (int)(this.ScaleX * (trace4.PlotData.WorldX - 0.5) + this.ShiftX);
                int width = 1 + (int)this.ScaleX;
                colors.setScaleMax(trace4.PlotData.WiggleScalar);
                for (int s = 0; s < this.m_data.length; ++s) {
                    colors.setColor(this.m_g2d, this.m_data[s]);
                    this.m_g2d.fillRect(leftPixel, (int)currentPixelY, width, height);
                    currentPixelY += pixPerSample;
                }
            }
            this.m_g2d = null;
            this.ImageContentsDirty = false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
        this.m_g2d = null;
    }

    protected void wiggle(EnsembleTrace trace) {
    }

    @Override
    public void Java2D_RangeWorld(Range_Double rangeX, Range_Double rangeY, int supplementalData) {
        try {
            if (this.m_ensemble == null) {
                return;
            }
            if (this.m_ensemble.traceCount() < 1) {
                return;
            }
            this.m_ensemble.expandTimeRange(rangeY);
            rangeX.expandRange(0.0);
            int numOK = 0;
            for (int n = 0; n < this.m_ensemble.traceCount(); ++n) {
                if (!this.m_ensemble.trace(n).traceOkay() || !this.m_ensemble.trace((int)n).PlotData.ShowTrace) continue;
                ++numOK;
            }
            rangeX.expandRange(numOK);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void Java2D_RangeColor(Range_Double rangeC, int supplementalData) {
    }

    public static BufferedImage createBufferedImage(Ensemble e) {
        try {
            int nt = e.traceCount();
            int ns = e.trace(0).data().length();
            float max = 1.0E-5f;
            long start = System.currentTimeMillis();
            for (int n = 0; n < e.traceCount(); ++n) {
                EnsembleTrace trace = e.trace(n);
                max = Math.max(max, trace.data().absoluteMax());
            }
            float scalar = 255.0f / max;
            float[] data = new float[ns];
            int[] red = new int[256];
            int[] blue = new int[256];
            for (int n = 0; n < 256; ++n) {
                Color r = new Color(255, 255 - n, 255 - n);
                red[n] = r.getRGB();
                Color b = new Color(255 - n, 255 - n, 255);
                blue[n] = b.getRGB();
            }
            BufferedImage image = new BufferedImage(nt, ns, 1);
            for (int n = 0; n < e.traceCount(); ++n) {
                EnsembleTrace trace = e.trace(n);
                trace.data().copyToArray(data);
                scalar = 255.0f / (1.0E-7f + trace.data().absoluteMax());
                for (int s = 0; s < ns; ++s) {
                    image.setRGB(n, s, 0);
                    float v = data[s];
                    if (v > 0.0f) {
                        image.setRGB(n, s, blue[(int)(scalar * v)]);
                        continue;
                    }
                    v = -v;
                    image.setRGB(n, s, red[(int)(scalar * v)]);
                }
            }
            long tim = System.currentTimeMillis() - start;
            System.out.println("createBufferedImage time = " + tim);
            return image;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    @Override
    public void Java2D_PaintDatum(Java2D_PaintParameter paintParameter) {
    }
}

