/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Java2D.Paintables;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Range_Double;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosLibrary.Tools.Tools_FontLibrary;
import com.PecosLibrary.Tools.Tools_GraphicalObjectLibrary;
import com.PecosLibrary.Tools.Tools_Plot;
import com.PecosLibrary.Windows.Java2D.Java2D_ColorArrayWrapper;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintParameter;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintableInterface;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import java.awt.Color;
import java.awt.Graphics2D;

public class Java2D_Paintable_AxisLines
implements Java2D_PaintableInterface {
    public boolean DrawHorizontalLines = true;
    public boolean DrawVerticalLines = false;
    public double HorizontalLineSpacing = 50.0;
    public double VerticalLineSpacing = 100.0;
    public Color HorizontalLineColor = Color.LIGHT_GRAY;
    public Color VerticalLineColor = Color.LIGHT_GRAY;
    public boolean DrawLeftText = false;
    public boolean DrawRightText = false;

    @Override
    public boolean Java2D_ImageContentsDirty(int supplementalData) {
        return false;
    }

    @Override
    public int Java2D_MaximumPaintLevel(int supplementalData) {
        return 0;
    }

    @Override
    public void Java2D_Paint(Java2D_PaintParameter paintParameter, int supplementalData) {
        try {
            int ic;
            double tick;
            double range;
            if (paintParameter.PaintLevel != 0) {
                return;
            }
            Java2D_ColorArrayWrapper colorWrapper = paintParameter.ColorArrayWrapper;
            Java2D_Transform transform = paintParameter.Transform;
            Graphics2D g2d = paintParameter.G2D;
            g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_0);
            double scaleX = transform.scaleX();
            double shiftX = transform.shiftX();
            double scaleY = transform.scaleY();
            double shiftY = transform.shiftY();
            g2d.setFont(Tools_FontLibrary.AxisFont);
            int stringHeight = g2d.getFontMetrics().getHeight();
            if (this.DrawHorizontalLines) {
                g2d.setColor(this.HorizontalLineColor);
                range = transform.actualRangeY();
                tick = Tools_Plot.tickMarkInterval(range, 10);
                ic = (int)(transform.actualMinY() / tick) - 1;
                for (double y = (double)ic * tick; y < transform.actualMaxY(); y += tick) {
                    int iy = (int)(scaleY * y + shiftY);
                    String s = Tools_Strings.doubleToString(y, range, true);
                    g2d.setColor(this.HorizontalLineColor);
                    g2d.drawLine(0, iy, transform.sizeX(), iy);
                    if (this.DrawLeftText) {
                        g2d.setColor(Color.BLACK);
                        g2d.drawString(s, 3, iy + 4);
                    }
                    if (!this.DrawRightText) continue;
                    g2d.setColor(Color.BLACK);
                    g2d.drawString(s, transform.sizeX() - g2d.getFontMetrics().stringWidth(s) - 3, iy + 4);
                }
            }
            if (this.DrawVerticalLines) {
                g2d.setColor(this.VerticalLineColor);
                range = transform.actualRangeX();
                tick = Tools_Plot.tickMarkInterval(range, 10);
                ic = (int)(transform.actualLeft() / tick) - 1;
                for (double x = (double)ic * tick; x < transform.actualRight(); x += tick) {
                    int ix = (int)(scaleX * x + shiftX);
                    g2d.setColor(this.HorizontalLineColor);
                    g2d.drawLine(ix, 0, ix, transform.sizeY());
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_RangeWorld(Range_Double rangeX, Range_Double rangeY, int supplementalData) {
    }

    @Override
    public void Java2D_RangeColor(Range_Double rangeC, int supplementalData) {
    }

    @Override
    public void Java2D_PaintDatum(Java2D_PaintParameter paintParameter) {
    }
}

