/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Java2D.Paintables;

import com.PecosCore.Data.Seismic.SparseCmpGatherManager;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Range_Double;
import com.PecosCore.Windows.Java2D.Java2D_PointSymbol;
import com.PecosLibrary.Windows.Java2D.Java2D_ColorArrayWrapper;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintParameter;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintableInterface;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import java.awt.Color;
import java.awt.Graphics2D;

public class Java2D_PaintablePointArray
implements Java2D_PaintableInterface {
    protected double[] m_x;
    protected double[] m_y;
    protected double[] m_c;
    protected double[] m_s;
    protected int[] m_id;
    protected boolean m_bContentsChangedSinceLastPaint = true;
    protected Java2D_PointSymbol m_symbol = Java2D_PointSymbol.FilledOval;
    public Color SymbolColor = Color.BLUE;
    public int SymbolSize = 5;
    public boolean UseColorScale = true;
    protected boolean m_isSparse = false;

    public Java2D_PaintablePointArray(SparseCmpGatherManager sparse) {
        try {
            this.m_isSparse = true;
            if (sparse.size() < 1) {
                return;
            }
            this.setLength(sparse.size());
            for (int n = 0; n < this.m_x.length; ++n) {
                this.m_x[n] = sparse.getCmpX(n);
                this.m_y[n] = sparse.getCmpY(n);
                this.m_c[n] = 0.0;
                this.m_s[n] = 0.0;
            }
            this.SymbolColor = new Color(255, 111, 111, 128);
            this.m_symbol = Java2D_PointSymbol.FilledOval;
            this.SymbolSize = 11;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public Java2D_PaintablePointArray() {
    }

    public static Java2D_PaintablePointArray synthetic(int len) {
        try {
            Java2D_PaintablePointArray pa = new Java2D_PaintablePointArray();
            pa.setLength(len);
            for (int n = 0; n < len; ++n) {
                pa.setX(n, n);
                pa.setY(n, 2 * n);
                pa.setC(n, n);
                pa.setS(n, n);
            }
            return pa;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public void setLength(int length) {
        try {
            this.m_bContentsChangedSinceLastPaint = true;
            this.m_x = null;
            this.m_y = null;
            this.m_c = null;
            this.m_s = null;
            this.m_id = null;
            if (length < 1) {
                return;
            }
            this.m_x = new double[length];
            this.m_y = new double[length];
            this.m_c = new double[length];
            this.m_s = new double[length];
            this.m_id = new int[length];
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setDirty() {
        this.m_bContentsChangedSinceLastPaint = true;
    }

    public void setX(int n, double v) {
        this.m_x[n] = v;
    }

    public void setY(int n, double v) {
        this.m_y[n] = v;
    }

    public void setC(int n, double v) {
        this.m_c[n] = v;
    }

    public void setS(int n, double v) {
        this.m_s[n] = v;
    }

    public void setID(int n, int v) {
        this.m_id[n] = v;
    }

    public boolean colorOK() {
        if (this.m_c == null) {
            return false;
        }
        return this.m_c.length >= 1;
    }

    public boolean worldOK() {
        if (this.m_x == null) {
            return false;
        }
        if (this.m_x.length < 1) {
            return false;
        }
        if (this.m_y == null) {
            return false;
        }
        return this.m_y.length >= 1;
    }

    @Override
    public boolean Java2D_ImageContentsDirty(int supplementalData) {
        return this.m_bContentsChangedSinceLastPaint;
    }

    @Override
    public int Java2D_MaximumPaintLevel(int supplementalData) {
        return 0;
    }

    @Override
    public void Java2D_Paint(Java2D_PaintParameter paintParameter, int supplementalData) {
        try {
            if (!this.worldOK()) {
                return;
            }
            if (paintParameter.PaintLevel != 0) {
                return;
            }
            Java2D_ColorArrayWrapper colorWrapper = paintParameter.ColorArrayWrapper;
            Java2D_Transform transform = paintParameter.Transform;
            Graphics2D g2d = paintParameter.G2D;
            double scaleX = transform.scaleX();
            double shiftX = transform.shiftX();
            double scaleY = transform.scaleY();
            double shiftY = transform.shiftY();
            g2d.setColor(this.SymbolColor);
            int half = this.SymbolSize / 2;
            half = Math.max(half, 1);
            this.SymbolSize = 2 * half + 1;
            if (this.m_isSparse) {
                g2d.setColor(this.SymbolColor);
                this.SymbolSize = 13;
                half = this.SymbolSize / 2;
                half = Math.max(half, 1);
                this.SymbolSize = 2 * half + 1;
                for (int n = 0; n < this.m_x.length; ++n) {
                    int ix = (int)(scaleX * this.m_x[n] + shiftX);
                    int iy = (int)(scaleY * this.m_y[n] + shiftY);
                    g2d.fillOval(ix - half, iy - half, this.SymbolSize, this.SymbolSize);
                }
            } else if (!this.UseColorScale) {
                g2d.setColor(this.SymbolColor);
                for (int n = 0; n < this.m_x.length; ++n) {
                    int ix = (int)(scaleX * this.m_x[n] + shiftX);
                    int iy = (int)(scaleY * this.m_y[n] + shiftY);
                    g2d.fillRect(ix - half, iy - half, this.SymbolSize, this.SymbolSize);
                }
            } else {
                for (int n = 0; n < this.m_x.length; ++n) {
                    if (!colorWrapper.valueOK(this.m_c[n])) continue;
                    int ix = (int)(scaleX * this.m_x[n] + shiftX);
                    int iy = (int)(scaleY * this.m_y[n] + shiftY);
                    Color color = colorWrapper.colorUsingValue(this.m_c[n]);
                    g2d.setColor(color);
                    g2d.fillRect(ix - half, iy - half, this.SymbolSize, this.SymbolSize);
                }
            }
            this.m_bContentsChangedSinceLastPaint = false;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_RangeWorld(Range_Double rangeX, Range_Double rangeY, int supplementalData) {
        try {
            if (!this.worldOK()) {
                return;
            }
            rangeX.expandRange(this.m_x);
            rangeY.expandRange(this.m_y);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_RangeColor(Range_Double rangeC, int supplementalData) {
        try {
            if (this.m_isSparse) {
                return;
            }
            if (!this.colorOK()) {
                return;
            }
            rangeC.expandRange(this.m_c);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_PaintDatum(Java2D_PaintParameter paintParameter) {
    }
}

