/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Java2D;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Range_Double;
import com.PecosLibrary.Tools.Tools_ColorLibrary;
import com.PecosLibrary.Tools.Tools_GraphicalObjectLibrary;
import com.PecosLibrary.Windows.Java2D.Java2D_ColorArrayWrapper;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintParameter;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintableObjectData;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import java.awt.image.BufferedImage;
import java.util.ArrayList;

public class Java2D_BufferedImageWrapper {
    protected BufferedImage m_image = null;
    protected ArrayList<Java2D_PaintableObjectData> m_paintableObjectList = new ArrayList();
    public boolean ImageContentsPainted = false;
    protected Range_Double m_rangeX = new Range_Double();
    protected Range_Double m_rangeY = new Range_Double();
    protected Range_Double m_rangeC = new Range_Double();
    protected boolean m_bForceImagePaint = false;
    protected Java2D_PaintParameter m_paintParameter = new Java2D_PaintParameter();
    protected double m_recentPaintLeft = 0.0;
    protected double m_recentPaintRight = 0.0;
    protected double m_recentPaintTop = 0.0;
    protected double m_recentPaintBottom = 0.0;
    protected boolean PrintMessages = false;
    public boolean PaintOverlays = false;

    public Java2D_BufferedImageWrapper(Java2D_Transform transform, Java2D_ColorArrayWrapper colorArrayWrapper) {
        try {
            this.m_paintParameter.Transform = transform;
            this.m_paintParameter.ColorArrayWrapper = colorArrayWrapper;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setColorArrayWrapper(Java2D_ColorArrayWrapper colorArrayWrapper) {
        try {
            this.m_paintParameter.ColorArrayWrapper = colorArrayWrapper;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void recomputeAllRanges() {
        try {
            this.m_rangeX.clearRange();
            this.m_rangeY.clearRange();
            this.m_rangeC.clearRange();
            for (Java2D_PaintableObjectData displayObjectData : this.m_paintableObjectList) {
                displayObjectData.Paintable.Java2D_RangeWorld(this.m_rangeX, this.m_rangeY, displayObjectData.Supplemental);
                displayObjectData.Paintable.Java2D_RangeColor(this.m_rangeC, displayObjectData.Supplemental);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void recomputeColorRange() {
        try {
            this.m_rangeC.clearRange();
            for (Java2D_PaintableObjectData displayObjectData : this.m_paintableObjectList) {
                displayObjectData.Paintable.Java2D_RangeColor(this.m_rangeC, displayObjectData.Supplemental);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public Range_Double rangeX() {
        return this.m_rangeX;
    }

    public Range_Double rangeY() {
        return this.m_rangeY;
    }

    public Range_Double rangeC() {
        return this.m_rangeC;
    }

    public ArrayList<Java2D_PaintableObjectData> displayList() {
        return this.m_paintableObjectList;
    }

    public void setRequireDisplay() {
        if (this.PrintMessages) {
            System.out.println(String.format("setRequireDisplay ", new Object[0]));
        }
        this.m_bForceImagePaint = true;
    }

    /*
     * WARNING - void declaration
     */
    public BufferedImage image() {
        try {
            if (!this.imageNeedsPainting()) {
                if (this.PrintMessages) {
                    System.out.println(String.format("BufferedImage image imageNeedsPainting() == false", new Object[0]));
                }
                this.ImageContentsPainted = false;
                return this.m_image;
            }
            if (this.PrintMessages) {
                System.out.println(String.format("BufferedImage image ", new Object[0]));
            }
            this.ImageContentsPainted = true;
            int w = this.m_image.getWidth();
            int h = this.m_image.getHeight();
            this.m_paintParameter.G2D = this.m_image.createGraphics();
            this.m_paintParameter.G2D.setColor(Tools_ColorLibrary.BufferedImage_Background);
            this.m_paintParameter.G2D.fillRect(0, 0, w, h);
            this.m_paintParameter.G2D.setStroke(Tools_GraphicalObjectLibrary.Stroke_1);
            if (!this.m_paintParameter.Transform.transformValid()) {
                this.m_paintParameter.G2D = null;
                return this.m_image;
            }
            this.m_paintParameter.ColorArrayWrapper.clearHistogram();
            this.recomputeColorRange();
            if (this.m_rangeC.rangeValid()) {
                this.m_paintParameter.ColorArrayWrapper.setColorScaleRange(this.m_rangeC.rangeMin(), this.m_rangeC.rangeMax());
            }
            this.m_paintParameter.TextRects.clear();
            this.m_paintParameter.PaintLevel = 0;
            for (Java2D_PaintableObjectData java2D_PaintableObjectData : this.m_paintableObjectList) {
                java2D_PaintableObjectData.Paintable.Java2D_Paint(this.m_paintParameter, java2D_PaintableObjectData.Supplemental);
            }
            if (this.PaintOverlays) {
                void var4_9;
                int maxOverlayLevel = 0;
                for (Java2D_PaintableObjectData pod : this.m_paintableObjectList) {
                    int level = pod.Paintable.Java2D_MaximumPaintLevel(pod.Supplemental);
                    maxOverlayLevel = Math.max(maxOverlayLevel, level);
                }
                boolean bl = true;
                while (var4_9 <= maxOverlayLevel) {
                    this.m_paintParameter.PaintLevel = var4_9;
                    for (Java2D_PaintableObjectData pod : this.m_paintableObjectList) {
                        pod.Paintable.Java2D_Paint(this.m_paintParameter, pod.Supplemental);
                    }
                    ++var4_9;
                }
            }
            this.m_recentPaintBottom = this.m_paintParameter.Transform.actualBottom();
            this.m_recentPaintTop = this.m_paintParameter.Transform.actualTop();
            this.m_recentPaintLeft = this.m_paintParameter.Transform.actualLeft();
            this.m_recentPaintRight = this.m_paintParameter.Transform.actualRight();
            this.m_paintParameter.G2D = null;
            this.m_bForceImagePaint = false;
            return this.m_image;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    protected boolean imageNeedsPainting() {
        try {
            int viewWidth = this.m_paintParameter.Transform.sizeX();
            int viewHeight = this.m_paintParameter.Transform.sizeY();
            viewWidth = Math.max(viewWidth, 20);
            viewHeight = Math.max(viewHeight, 20);
            if (this.m_image == null) {
                this.m_image = new BufferedImage(viewWidth, viewHeight, 2);
                return true;
            }
            if (this.m_image.getWidth() != viewWidth || this.m_image.getHeight() != viewHeight) {
                this.m_image = new BufferedImage(viewWidth, viewHeight, 2);
                return true;
            }
            for (Java2D_PaintableObjectData displayObjectData : this.m_paintableObjectList) {
                if (!displayObjectData.Paintable.Java2D_ImageContentsDirty(displayObjectData.Supplemental)) continue;
                if (this.PrintMessages) {
                    System.out.println("dirty, " + displayObjectData.Paintable.getClass().getName());
                }
                return true;
            }
            double diffX = Math.abs(this.m_recentPaintLeft - this.m_paintParameter.Transform.actualLeft()) + Math.abs(this.m_recentPaintRight - this.m_paintParameter.Transform.actualRight());
            double diffY = Math.abs(this.m_recentPaintTop - this.m_paintParameter.Transform.actualTop()) + Math.abs(this.m_recentPaintBottom - this.m_paintParameter.Transform.actualBottom());
            double maxAllowedErrorX = 1.0E-6 * this.m_paintParameter.Transform.actualRangeX();
            double maxAllowedErrorY = 1.0E-6 * this.m_paintParameter.Transform.actualRangeY();
            if (diffX > maxAllowedErrorX) {
                return true;
            }
            if (diffY > maxAllowedErrorY) {
                return true;
            }
            if (this.PrintMessages) {
                System.out.println("m_bForceImagePaint " + Boolean.toString(this.m_bForceImagePaint));
            }
            return this.m_bForceImagePaint;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }
}

