/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Java2D.Ensemble;

import com.PecosCore.Shared.ExceptionMonitor;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.lang.ref.WeakReference;
import javax.swing.JScrollBar;

public class Java2D_EnsembleScrollBar
extends JScrollBar
implements AdjustmentListener {
    protected int m_direction;
    public boolean m_bIgnore = true;
    protected double m_rangeMin = 0.0;
    protected double m_rangeMax = 110.0;
    protected double m_viewMin = 0.0;
    protected double m_viewMax = 110.0;
    protected WeakReference<Listener> m_listener;

    public Java2D_EnsembleScrollBar(int dir, Listener listener) {
        super(dir);
        try {
            if (listener != null) {
                this.m_listener = new WeakReference<Listener>(listener);
            }
            this.addAdjustmentListener(this);
            this.setEnabled(false);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        try {
            Listener listener;
            if (this.m_bIgnore) {
                return;
            }
            double extent = this.getVisibleAmount();
            if (extent > 99998.0) {
                this.unzoom();
                return;
            }
            double viewRange = extent * (this.m_rangeMax - this.m_rangeMin) / 10000.0;
            double alpha = (this.m_rangeMax - this.m_rangeMin - (this.m_viewMax - this.m_viewMin)) / (10000.0 - extent);
            double min = (double)this.getValue() * alpha + this.m_rangeMin;
            double max = min + viewRange;
            if (this.m_listener != null && (listener = (Listener)this.m_listener.get()) != null) {
                listener.handleEnsembleScrollBar(this, this.getOrientation(), min, max);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void unzoom() {
        try {
            this.m_bIgnore = true;
            this.setValues(0, 10000, 0, 10000);
            this.setEnabled(false);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setValues(double rangeMin, double rangeMax, double viewMin, double viewMax) {
        try {
            this.m_bIgnore = true;
            viewMin = Math.max(viewMin, rangeMin);
            viewMax = Math.min(viewMax, rangeMax);
            this.m_rangeMin = rangeMin;
            this.m_rangeMax = rangeMax;
            this.m_viewMin = viewMin;
            this.m_viewMax = viewMax;
            if (viewMax - viewMin >= rangeMax - rangeMin) {
                this.unzoom();
                return;
            }
            double extent = 10000.0 * (viewMax - viewMin) / (rangeMax - rangeMin);
            double alpha = (10000.0 - extent) / (rangeMax - rangeMin - (viewMax - viewMin));
            double beta = 0.0 - alpha * rangeMin;
            double value = alpha * viewMin + beta;
            this.setValues((int)value, (int)extent, 0, 10000);
            if (!this.isEnabled()) {
                this.setEnabled(true);
            }
            this.m_bIgnore = false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.setEnabled(false);
        }
    }

    public static interface Listener {
        public void handleEnsembleScrollBar(Java2D_EnsembleScrollBar var1, int var2, double var3, double var5);
    }
}

