/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Java2D.ColorWidgets;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Tools.BitmapEnum;
import com.PecosLibrary.Tools.Tools_Bitmap;
import com.PecosLibrary.Windows.Java2D.ColorWidgets.Java2D_HorizontalColorWidget;
import com.PecosLibrary.Windows.Java2D.Java2D_ColorArrayWrapper;
import com.PecosLibrary.Windows.Shared.PopupMenuButton;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.WeakReference;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class Java2D_HorizontalColorCompositeWidget
extends LinearLayoutWidget
implements Java2D_HorizontalColorWidget.Listener,
PopupMenuButton.Listener,
ActionListener {
    protected WeakReference<Listener> m_listener;
    protected Java2D_HorizontalColorWidget m_widget;
    protected JButton m_clearKillZonesButton;
    protected PopupMenuButton m_sharedColorButton;
    protected String m_str_to_global = "Copy current color scale range to global (shared) range";
    protected String m_str_from_global = "Copy global color scale range to current range";
    protected JTextField m_scaleMaxTextField = new JTextField(" ");
    protected JTextField m_scaleMinTextField = new JTextField(" ");
    protected JCheckBox m_scaleLockCheckBox = new JCheckBox("Lock");

    public Java2D_HorizontalColorCompositeWidget(Listener listener) {
        super(LinearLayoutWidget.Direction.Vertical, 0, null);
        try {
            if (listener != null) {
                this.m_listener = new WeakReference<Listener>(listener);
            }
            this.m_widget = new Java2D_HorizontalColorWidget(this);
            this.addComponent(this.m_widget, 10);
            LinearLayoutWidget bottom = this.createLinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 0, null, 0);
            this.m_clearKillZonesButton = Tools_Bitmap.makeButton(bottom, BitmapEnum.ClearDead, (ActionListener)this);
            this.m_sharedColorButton = new PopupMenuButton(null, "Global", this);
            this.m_sharedColorButton.setToolTipText("Global color scale options");
            this.m_sharedColorButton.addOption(this.m_str_to_global);
            this.m_sharedColorButton.addOption(this.m_str_from_global);
            bottom.addComponent(this.m_clearKillZonesButton, 0);
            bottom.addComponent(this.m_sharedColorButton, 0);
            bottom.addComponent(this.m_scaleLockCheckBox, 0);
            bottom.addComponent(this.m_scaleMinTextField, 10);
            bottom.addComponent(this.m_scaleMaxTextField, 10);
            this.m_scaleLockCheckBox.setSelected(false);
            this.m_scaleMinTextField.setEnabled(false);
            this.m_scaleMaxTextField.setEnabled(false);
            this.m_scaleMinTextField.addActionListener(this);
            this.m_scaleMaxTextField.addActionListener(this);
            this.m_scaleLockCheckBox.addActionListener(this);
            Tools_FontChanger.changeSizeOfFont(this, -2, null, true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handlePopupMenuButton(PopupMenuButton button, String text) {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            if (button == this.m_sharedColorButton && text.equalsIgnoreCase(this.m_str_to_global)) {
                p.ColorScaleRangeMin = Tools_Widget.extractDouble(this.m_scaleMinTextField, this.getColorArrayWrapper().rangeMin(), -1.0E20, 1.0E20);
                p.ColorScaleRangeMax = Tools_Widget.extractDouble(this.m_scaleMaxTextField, this.getColorArrayWrapper().rangeMax(), p.ColorScaleRangeMin + 0.01, 1.0E20);
                p.ColorScaleRangeValid = true;
                return;
            }
            if (button == this.m_sharedColorButton && text.equalsIgnoreCase(this.m_str_from_global)) {
                if (!p.ColorScaleRangeValid) {
                    JOptionPane.showMessageDialog(null, "Shared color range not valid", "Scale error", 0);
                    return;
                }
                double min = p.ColorScaleRangeMin;
                double max = p.ColorScaleRangeMax;
                this.m_scaleMinTextField.setText(Tools_Strings.doubleToString(min, max - min));
                this.m_scaleMaxTextField.setText(Tools_Strings.doubleToString(max, max - min));
                this.m_scaleLockCheckBox.setSelected(true);
                this.m_scaleMinTextField.setEnabled(true);
                this.m_scaleMaxTextField.setEnabled(true);
                this.getColorArrayWrapper().setRangeLocked(false);
                this.getColorArrayWrapper().setColorScaleRange(min, max);
                this.getColorArrayWrapper().setRangeLocked(true);
                this.m_widget.repaint();
                this.sendChange();
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void horizontalColorWidgetJustPainted(Object sender) {
        try {
            double min = this.getColorArrayWrapper().rangeMin();
            double max = this.getColorArrayWrapper().rangeMax();
            this.m_scaleMinTextField.setText(Tools_Strings.doubleToString(min, max - min));
            this.m_scaleMaxTextField.setText(Tools_Strings.doubleToString(max, max - min));
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void horizontalColorWidgetModified(Object sender) {
        try {
            this.sendChange();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void repaintScale() {
        this.m_widget.repaint();
    }

    public void setLabel(String lbl) {
        try {
            this.m_widget.setTitle(lbl);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void sendChange() {
        try {
            Listener listener;
            if (this.m_listener != null && (listener = (Listener)this.m_listener.get()) != null) {
                listener.horizontalColorMapCompositeChanged(this);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public Java2D_ColorArrayWrapper getColorArrayWrapper() {
        return this.m_widget.getColorArrayWrapper();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_scaleLockCheckBox) {
                boolean selected = this.m_scaleLockCheckBox.isSelected();
                this.m_scaleMinTextField.setEnabled(selected);
                this.m_scaleMaxTextField.setEnabled(selected);
                this.m_widget.getColorArrayWrapper().setRangeLocked(selected);
                if (!selected) {
                    this.m_widget.repaint();
                    this.sendChange();
                }
                return;
            }
            if (e.getSource() == this.m_scaleMinTextField) {
                double min = Tools_Widget.extractDouble(this.m_scaleMinTextField, this.getColorArrayWrapper().rangeMin(), -1.0E20, 1.0E20);
                double max = Tools_Widget.extractDouble(this.m_scaleMaxTextField, this.getColorArrayWrapper().rangeMax(), min + 0.01, 1.0E20);
                this.getColorArrayWrapper().setRangeLocked(false);
                this.getColorArrayWrapper().setColorScaleRange(min, max);
                this.getColorArrayWrapper().setRangeLocked(true);
                this.m_widget.repaint();
                this.sendChange();
                return;
            }
            if (e.getSource() == this.m_scaleMinTextField || e.getSource() == this.m_scaleMaxTextField) {
                double max = Tools_Widget.extractDouble(this.m_scaleMaxTextField, this.getColorArrayWrapper().rangeMax(), -1.0E20, 1.0E20);
                double min = Tools_Widget.extractDouble(this.m_scaleMinTextField, this.getColorArrayWrapper().rangeMin(), -1.0E20, max - 0.01);
                this.getColorArrayWrapper().setRangeLocked(false);
                this.getColorArrayWrapper().setColorScaleRange(min, max);
                this.getColorArrayWrapper().setRangeLocked(true);
                this.m_widget.repaint();
                this.sendChange();
                return;
            }
            if (e.getSource() == this.m_clearKillZonesButton) {
                this.getColorArrayWrapper().clearDead();
                this.m_widget.repaint();
                this.sendChange();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static interface Listener {
        public void horizontalColorMapCompositeChanged(Object var1);
    }
}

