/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.JDBC;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.SharedApplicationData;
import com.PecosLibrary.Tools.Tools_FontLibrary;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

public class SqlStatementSelectorButton
extends JButton
implements ActionListener,
MouseListener {
    protected WeakReference<Listener> m_listener;
    protected String m_sqlType;

    public SqlStatementSelectorButton(String sqlType, String buttonText, Listener listener) {
        try {
            this.m_sqlType = sqlType;
            this.setText(buttonText);
            this.addMouseListener(this);
            this.m_listener = new WeakReference<Listener>(listener);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() instanceof MenuItem) {
                MenuItem mi = (MenuItem)e.getSource();
                Listener listener = (Listener)this.m_listener.get();
                if (listener != null) {
                    listener.handleSqlButton(this, mi.SQL);
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void mouseClicked(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    protected void showPopupMenu(MouseEvent event) {
        try {
            JPopupMenu popupMenu = new JPopupMenu();
            ArrayList<String> list = SharedApplicationData.singleton().getListSQL(this.m_sqlType);
            if (list.size() < 1) {
                JOptionPane.showMessageDialog(null, "No saved SQL statements", "", 0);
                return;
            }
            for (String sql : list) {
                MenuItem item = new MenuItem(sql);
                item.addActionListener(this);
                popupMenu.add(item);
            }
            popupMenu.show(event.getComponent(), event.getX(), event.getY());
            popupMenu.setVisible(true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
        try {
            this.showPopupMenu(event);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
    }

    protected class MenuItem
    extends JMenuItem {
        public String SQL;

        public MenuItem(String sql) {
            try {
                this.SQL = sql;
                this.setText(sql);
                this.setFont(Tools_FontLibrary.MONO10);
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }
    }

    public static interface Listener {
        public void handleSqlButton(SqlStatementSelectorButton var1, String var2);
    }
}

