/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.JDBC;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Pecos;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.ComboStringListWrapper;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class OverwriteUsingImportedTableDialog
extends JDialog
implements GenericObjectListener.Listener,
ActionListener {
    protected String m_tableName;
    protected RefractionStaticsProject m_project;
    protected JButton m_btnCancel = new JButton("Close");
    protected JButton m_btnInterpolate = new JButton("Import");
    protected ComboStringListWrapper m_importTableCombo = new ComboStringListWrapper();
    protected ComboStringListWrapper m_importColumnValCombo = new ComboStringListWrapper();
    protected ComboStringListWrapper m_importColumnXCombo = new ComboStringListWrapper();
    protected ComboStringListWrapper m_importColumnYCombo = new ComboStringListWrapper();
    protected JTextField m_txtMinValid = new JTextField("-1000");
    protected ComboStringListWrapper m_exportColumnCombo = new ComboStringListWrapper();

    public OverwriteUsingImportedTableDialog(String tableName) {
        try {
            this.m_tableName = tableName;
            this.m_project = RefractionStaticsProject.singleton();
            this.getContentPane().setLayout(new BorderLayout());
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            LinearLayoutWidget sub = main.createLinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, "Select column to modify", 0);
            sub.addComponent(this.m_exportColumnCombo, 0);
            this.m_exportColumnCombo.setStringArray(this.m_project.geometryDatabase().listOfColumnNames(this.m_tableName));
            GridLayoutWidget grid = main.createGridLayoutWidget(3, "Select the table and columns", 0);
            int row = 0;
            grid.addSimple(row++, new JLabel("Select table"), this.m_importTableCombo);
            grid.addSimple(row++, new JLabel("Easting column"), this.m_importColumnXCombo);
            grid.addSimple(row++, new JLabel("Northing column"), this.m_importColumnYCombo);
            grid.addSimple(row++, new JLabel("Value column"), this.m_importColumnValCombo);
            grid.addSimple(row++, new JLabel("Min valid import value"), this.m_txtMinValid);
            this.m_importTableCombo.listener().addListener(this);
            this.m_importTableCombo.setStringArray(this.m_project.importDatabase().getTableNames());
            String tempTableName = this.m_importTableCombo.getSelectedString();
            ArrayList<String> list = this.m_project.importDatabase().listOfColumnNames(tempTableName);
            LinearLayoutWidget bottom = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null);
            bottom.addStretch(10);
            bottom.addComponent(this.m_btnInterpolate, 0);
            bottom.addComponent(this.m_btnCancel, 0);
            bottom.addStretch(10);
            this.m_btnInterpolate.addActionListener(this);
            this.m_btnCancel.addActionListener(this);
            this.getContentPane().add((Component)main, "Center");
            this.getContentPane().add((Component)bottom, "South");
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.setDefaultCloseOperation(1);
            this.pack();
            this.reloadColumns();
            this.setSize(this.getSize().width + 200, this.getSize().height);
            this.setTitle("Overwrite using imported data");
            this.setLocationRelativeTo(null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void showDialog() {
        try {
            try {
                this.m_importTableCombo.setStringArray(this.m_project.importDatabase().getTableNames());
                this.reloadColumns();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setVisible(true);
            this.requestFocus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void reloadColumns() {
        try {
            String tableName = this.m_importTableCombo.getSelectedString();
            ArrayList<String> list = this.m_project.importDatabase().listOfColumnNames(tableName);
            this.m_importColumnValCombo.setStringArray(list);
            this.m_importColumnXCombo.setStringArray(list);
            this.m_importColumnYCombo.setStringArray(list);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected IDatabaseConnection database() {
        try {
            return RefractionStaticsProject.singleton().geometryDatabase();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (sender == this.m_importTableCombo) {
                this.reloadColumns();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected boolean doStuff() {
        try {
            boolean required;
            String col = this.m_exportColumnCombo.getSelectedString();
            boolean bl = required = col.equalsIgnoreCase("Easting") || col.equalsIgnoreCase("Northing") || col.equalsIgnoreCase("ShotID") || col.equalsIgnoreCase("ReceiverID");
            if (required) {
                JOptionPane.showMessageDialog(null, "Cannot modify a required column", " ", 0);
                return false;
            }
            Table_Abstract exportTable = null;
            if (this.m_tableName.equalsIgnoreCase("Shot")) {
                exportTable = this.m_project.shotTable();
            }
            if (this.m_tableName.equalsIgnoreCase("Receiver")) {
                exportTable = this.m_project.receiverTable();
            }
            String importTableName = this.m_importTableCombo.getSelectedString();
            String importColX = this.m_importColumnXCombo.getSelectedString();
            String importColY = this.m_importColumnYCombo.getSelectedString();
            String importVal = this.m_importColumnValCombo.getSelectedString();
            double min = Tools_Widget.extractDouble(this.m_txtMinValid, -1000.0, -1.0E20, 1.0E20);
            String sql = String.format("SELECT %s, %s, %s FROM %s", importColX, importColY, importVal, importTableName);
            Table_Abstract importTable = this.m_project.importDatabase().extractTableDataUsingQuery(importTableName, sql, Pecos.MaxQueryRowCount);
            int colImportX = importTable.column_indexOfColumn(importColX);
            int colImportY = importTable.column_indexOfColumn(importColY);
            int colImportV = importTable.column_indexOfColumn(importVal);
            int colExportX = exportTable.column_indexOfColumn("Easting");
            int colExportY = exportTable.column_indexOfColumn("Northing");
            int colExportV = exportTable.column_indexOfColumn(col);
            for (int row = 0; row < exportTable.row_count(); ++row) {
                double minDist = 1.0E80;
                double bestValue = 0.0;
                double x = exportTable.getDouble(row, colExportX);
                double y = exportTable.getDouble(row, colExportY);
                for (int n = 0; n < importTable.row_count(); ++n) {
                    double dx = x - importTable.getDouble(n, colImportX);
                    double dy = y - importTable.getDouble(n, colImportY);
                    double v = importTable.getDouble(n, colImportV);
                    double dist = dx * dx + dy * dy;
                    if (!(dist < minDist) || !(v >= min)) continue;
                    minDist = dist;
                    bestValue = v;
                }
                exportTable.putDouble(row, colExportV, bestValue);
            }
            this.m_project.geometryDatabase().writeColumnContentsToDatabase(exportTable, col);
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_btnInterpolate) {
                if (!this.doStuff()) {
                    return;
                }
                this.dispose();
                return;
            }
            if (e.getSource() == this.m_btnCancel) {
                this.dispose();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

