/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.JDBC;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Shared.Pecos;
import com.PecosCore.Shared.Range_Double;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.ComboStringListWrapper;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.Math.AxisGrid_Interpolator;
import com.PecosLibrary.Math.InverseSquareGrid;
import com.PecosLibrary.Math.Kriging;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.ApplicationFrames.ISaveableFrame;
import com.PecosLibrary.Windows.Java2D.Java2D_SimpleComposite;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import com.PecosLibrary.Windows.Java2D.Java2D_Widget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class KrigingTestWidget
extends JSplitPane
implements ActionListener,
GenericObjectListener.Listener,
Messenger.Listener,
ItemListener,
ISaveableFrame {
    protected ComboStringListWrapper m_tableCombo = new ComboStringListWrapper();
    protected JButton m_reloadTableButton;
    protected ComboStringListWrapper m_xCombo = new ComboStringListWrapper();
    protected ComboStringListWrapper m_yCombo = new ComboStringListWrapper();
    protected ComboStringListWrapper m_cCombo = new ComboStringListWrapper();
    protected JTextField m_txtC0 = new JTextField("0");
    protected JTextField m_txtC1 = new JTextField("10");
    protected JTextField m_txtA = new JTextField("5000");
    protected JTextField m_txtGridSize = new JTextField("300");
    protected Java2D_SimpleComposite m_plotWidget = new Java2D_SimpleComposite(true);
    protected JButton m_krigeButton;
    protected JButton m_isqButton;
    protected JButton m_triButton;
    protected Range_Double m_rx = new Range_Double();
    protected Range_Double m_ry = new Range_Double();
    protected double[] m_x = null;
    protected double[] m_y = null;
    protected double[] m_z = null;
    protected Kriging m_kriger = null;
    protected InverseSquareGrid m_isq = null;
    protected AxisGrid_Interpolator m_grid = null;

    @Override
    public String TAB_NAME() {
        return "com.PecosLibrary.Windows.JDBC.KrigingTestWidget";
    }

    @Override
    public String TAB_LABEL() {
        return "Interpolation test";
    }

    @Override
    public String TAB_DESCRIPTION() {
        return "Interpolation test";
    }

    @Override
    public boolean TAB_UNIQUE() {
        return true;
    }

    public KrigingTestWidget() {
        super(1);
        try {
            this.setRightComponent(this.m_plotWidget);
            this.setLeftComponent(this.createMainWidget());
            Messenger.singleton().addListener(this);
            this.reloadListOfTable();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public JComponent createMainWidget() {
        try {
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
            LinearLayoutWidget temp = main.createVertical(0, "Selected imported table", 0);
            temp.addComponent(this.m_tableCombo, 0);
            this.m_tableCombo.listener().addListener(this);
            this.m_reloadTableButton = temp.createButton("Reload list of tables", this, 0);
            GridLayoutWidget grid = main.createGridLayoutWidget(0, "Selected axes", 0);
            int row = 0;
            grid.addSimple(row++, new JLabel("X axis"), this.m_xCombo);
            grid.addSimple(row++, new JLabel("Y axis"), this.m_yCombo);
            grid.addSimple(row++, new JLabel("Z axis"), this.m_cCombo);
            grid.addSimple(row++, new JLabel("GridSize"), this.m_txtGridSize);
            this.m_xCombo.listener().addListener(this);
            this.m_yCombo.listener().addListener(this);
            this.m_cCombo.listener().addListener(this);
            this.m_xCombo.setPreferredSelected("X");
            this.m_yCombo.setPreferredSelected("Y");
            this.m_cCombo.setPreferredSelected("Z1");
            JTabbedPane tabs = new JTabbedPane();
            this.m_krigeButton = new JButton("Krige");
            this.m_krigeButton.addActionListener(this);
            grid = new GridLayoutWidget(0, null);
            row = 0;
            grid.addSimple(row++, new JLabel("C0"), this.m_txtC0);
            grid.addSimple(row++, new JLabel("C1"), this.m_txtC1);
            grid.addSimple(row++, new JLabel("Decay distance"), this.m_txtA);
            grid.addSimple(row++, new JLabel(" "), this.m_krigeButton);
            tabs.addTab("Kriging", grid);
            temp = main.createVertical(0, null, 0);
            this.m_isqButton = temp.createButton("Compute inverse square", this, 0);
            temp.addStretch(10);
            tabs.addTab("ISQ", temp);
            temp = main.createVertical(0, null, 0);
            this.m_triButton = temp.createButton("Compute grid-based smoother", this, 0);
            temp.addStretch(10);
            tabs.addTab("Grid", temp);
            main.addComponent(tabs, 0);
            main.addStretch(10);
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected void reloadListOfTable() {
        try {
            IDatabaseConnection database = RefractionStaticsProject.singleton().importDatabase();
            ArrayList<String> tables = database.getTableNames();
            this.m_tableCombo.setStringArray(tables);
            this.reloadListOfColumns();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadListOfColumns() {
        try {
            IDatabaseConnection database = RefractionStaticsProject.singleton().importDatabase();
            ArrayList<String> tables = database.getTableNames();
            if (tables.size() < 1) {
                this.m_xCombo.setStringArray(new ArrayList<String>());
                this.m_yCombo.setStringArray(new ArrayList<String>());
                this.m_cCombo.setStringArray(new ArrayList<String>());
                return;
            }
            String tableName = this.m_tableCombo.getSelectedString();
            ArrayList<String> cols = database.listOfColumnNames(tableName);
            this.m_xCombo.setStringArray(cols);
            this.m_yCombo.setStringArray(cols);
            this.m_cCombo.setStringArray(cols);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadPlot() {
        try {
            Java2D_Widget w = this.m_plotWidget.mainWidget();
            w.clearPaintableList();
            if (this.m_kriger != null) {
                this.m_plotWidget.setColorTitle("Kriging");
                w.addPaintable(this.m_kriger, -9999);
            }
            if (this.m_isq != null) {
                this.m_plotWidget.setColorTitle("Inverse square");
                w.addPaintable(this.m_isq, -9999);
            }
            if (this.m_grid != null) {
                this.m_plotWidget.setColorTitle("Grid");
                w.addPaintable(this.m_grid, -9999);
            }
            w.transform().setTechnique(Java2D_Transform.Technique.Basemap);
            w.mooz();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void prepArrays() {
        try {
            this.m_rx.clearRange();
            this.m_ry.clearRange();
            this.m_x = null;
            this.m_y = null;
            this.m_z = null;
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            String tableName = this.m_tableCombo.getSelectedString();
            String xName = this.m_xCombo.getSelectedString();
            String yName = this.m_yCombo.getSelectedString();
            String cName = this.m_cCombo.getSelectedString();
            String sql = String.format("SELECT * FROM %s", tableName);
            IDatabaseConnection database = project.importDatabase();
            Table_Abstract table = database.extractTableDataUsingQuery(tableName, sql, Pecos.MaxQueryRowCount);
            ArrayList<Integer> validList = new ArrayList<Integer>();
            int indexX = table.column_indexOfColumn(xName);
            int indexY = table.column_indexOfColumn(yName);
            int indexZ = table.column_indexOfColumn(cName);
            for (int row = 0; row < table.row_count(); ++row) {
                String sx = table.getString(row, indexX);
                String sy = table.getString(row, indexY);
                String sz = table.getString(row, indexZ);
                boolean okay = sx.length() > 0 && sy.length() > 0 && sz.length() > 0;
                try {
                    double x = Double.parseDouble(sx);
                    double y = Double.parseDouble(sy);
                    double z = Double.parseDouble(sz);
                    okay = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!okay) continue;
                validList.add(new Integer(row));
            }
            if (validList.size() < 1) {
                return;
            }
            this.m_x = new double[validList.size()];
            this.m_y = new double[validList.size()];
            this.m_z = new double[validList.size()];
            int count = 0;
            for (Integer i : validList) {
                int row = i;
                this.m_x[count] = table.getDouble(row, indexX);
                this.m_y[count] = table.getDouble(row, indexY);
                this.m_z[count] = table.getDouble(row, indexZ);
                this.m_rx.expandRange(this.m_x[count]);
                this.m_ry.expandRange(this.m_y[count]);
                ++count;
            }
            this.m_rx.addPercentBuffer(10.0);
            this.m_ry.addPercentBuffer(10.0);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void delaunay() {
        try {
            this.clearAll();
            this.prepArrays();
            if (this.m_x == null) {
                return;
            }
            this.m_grid = new AxisGrid_Interpolator();
            this.m_grid.ApplyPlane = true;
            this.m_grid.setInputData(this.m_x, this.m_y, this.m_z);
            double gridSize = Tools_Widget.extractDouble(this.m_txtGridSize, 100.0, 20.0, 2000.0);
            this.m_grid.createGrid(2000.0, gridSize, true);
            this.reloadPlot();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void isq() {
        try {
            this.clearAll();
            this.prepArrays();
            if (this.m_x == null) {
                return;
            }
            this.m_isq = new InverseSquareGrid();
            this.m_isq.setInputData(this.m_x, this.m_y, this.m_z);
            double gridSize = Tools_Widget.extractDouble(this.m_txtGridSize, 100.0, 20.0, 2000.0);
            this.m_isq.createGrid(2000.0, gridSize);
            this.reloadPlot();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void krige() {
        try {
            this.clearAll();
            this.prepArrays();
            double gridSize = Tools_Widget.extractDouble(this.m_txtGridSize, 100.0, 20.0, 2000.0);
            if (this.m_x == null) {
                return;
            }
            this.m_kriger = new Kriging();
            this.m_kriger.setInputData(this.m_x, this.m_y, this.m_z);
            double C0 = Tools_Widget.extractDouble(this.m_txtC0, 0.0, 0.0, 100.0);
            double C1 = Tools_Widget.extractDouble(this.m_txtC1, 10.0, 1.0, 100.0);
            double A = Tools_Widget.extractDouble(this.m_txtA, 100.0, 1.0, 50000.0);
            this.m_kriger.setOrdinaryCovarianceModel(C0, C1, A);
            this.m_kriger.createGrid(2000.0, gridSize);
            this.reloadPlot();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void clearAll() {
        this.m_kriger = null;
        this.m_isq = null;
        this.m_grid = null;
    }

    @Override
    public void handleMessenger(Messenger.Message message, Object sender, Object data) {
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (sender == this.m_tableCombo) {
                this.reloadListOfColumns();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_reloadTableButton) {
                this.reloadListOfTable();
                return;
            }
            if (e.getSource() == this.m_isqButton) {
                this.isq();
                return;
            }
            if (e.getSource() == this.m_triButton) {
                this.delaunay();
                return;
            }
            if (e.getSource() == this.m_krigeButton) {
                this.krige();
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

