/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.JDBC;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.Table_Memory;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.Windows.Shared.FileWidget;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ImportColumnDelimitedTableDialog
extends JDialog
implements GenericObjectListener.Listener,
ActionListener,
ListSelectionListener,
ItemListener,
DocumentListener {
    protected LinearLayoutWidget m_buttonPanel = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null);
    protected LinearLayoutWidget m_mainPanel = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
    protected LinearLayoutWidget m_namePanel = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, "Database table name");
    protected JTextField m_nameText = new JTextField("");
    protected JCheckBox m_colNameOnFirstLineCheck = new JCheckBox("First line contains column names");
    protected JCheckBox m_stringCheck = new JCheckBox("File contains text data");
    protected JComboBox<String> m_sepCombo = new JComboBox();
    protected JLabel m_statusLabel = new JLabel("Please select an ASCII file", 0);
    protected JButton m_btnOK = new JButton("Import");
    protected JButton m_btnCancel = new JButton("Cancel");
    protected IDatabaseConnection m_database;
    protected FileWidget m_fileWidget;
    protected ArrayList<String> m_existingTables = new ArrayList();
    protected Table_Abstract m_table = null;

    public ImportColumnDelimitedTableDialog(Frame parent, String title, IDatabaseConnection database, boolean assumeText) {
        super(parent, title, true);
        try {
            this.getContentPane().setLayout(new BorderLayout());
            this.m_database = database;
            if (this.m_database != null) {
                this.m_existingTables = database.getTableNames();
            }
            this.getContentPane().add((Component)this.m_mainPanel, "Center");
            if (this.m_database != null) {
                this.m_mainPanel.addComponent(this.m_namePanel, 0);
                this.m_namePanel.addComponent(this.m_nameText, 0);
                this.m_nameText.getDocument().addDocumentListener(this);
            }
            this.m_fileWidget = new FileWidget(false, 3, "Select ASCII file", this);
            this.m_mainPanel.addComponent(this.m_fileWidget, 0);
            this.m_colNameOnFirstLineCheck.setSelected(true);
            this.m_colNameOnFirstLineCheck.setEnabled(false);
            this.m_mainPanel.addComponent(this.m_colNameOnFirstLineCheck, 0);
            this.m_mainPanel.addComponent(this.m_stringCheck, 0);
            if (assumeText) {
                this.m_stringCheck.setSelected(true);
                this.m_stringCheck.setEnabled(false);
            }
            this.m_sepCombo.addItem("Comma");
            this.m_sepCombo.addItem("Space");
            this.m_sepCombo.setSelectedIndex(0);
            LinearLayoutWidget sub = this.m_mainPanel.createHorizontal(0, null, 0);
            sub.addComponent(new JLabel("How are columns separated:"), 0);
            sub.addComponent(this.m_sepCombo, 10);
            this.m_mainPanel.addComponent(this.m_statusLabel, 0);
            this.m_statusLabel.setForeground(Color.red);
            this.m_buttonPanel.addStretch(12);
            this.m_buttonPanel.addComponent(this.m_btnOK, 0);
            this.m_buttonPanel.addComponent(this.m_btnCancel, 0);
            this.m_buttonPanel.addStretch(12);
            this.m_btnOK.addActionListener(this);
            this.m_btnCancel.addActionListener(this);
            this.m_btnOK.setEnabled(false);
            this.getContentPane().add((Component)this.m_buttonPanel, "South");
            this.setDefaultCloseOperation(2);
            this.pack();
            Dimension d = this.getSize();
            this.setSize(d.width + 300, d.height);
            this.setLocationRelativeTo(null);
            this.checkStuff();
            this.setVisible(true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void checkStuff() {
        try {
            String fileName;
            this.m_btnOK.setEnabled(false);
            if (this.m_database != null) {
                String name = this.m_nameText.getText();
                if (name.length() < 1) {
                    this.m_statusLabel.setText("Please enter table name");
                    this.m_statusLabel.setForeground(Color.red);
                    return;
                }
                if (!Tools_Strings.isAlphaNumeric(name, true, false)) {
                    this.m_statusLabel.setText("Name cannot contain spaces or special characters");
                    this.m_statusLabel.setForeground(Color.red);
                    return;
                }
                if (Tools_Strings.startsWithNumber(name)) {
                    this.m_statusLabel.setText("Name cannot start with a number");
                    this.m_statusLabel.setForeground(Color.red);
                    return;
                }
                boolean exists = false;
                for (String s : this.m_existingTables) {
                    exists = exists || s.equalsIgnoreCase(name);
                }
                if (exists) {
                    this.m_statusLabel.setText("A table with that name already exists");
                    this.m_statusLabel.setForeground(Color.red);
                    return;
                }
            }
            if ((fileName = this.m_fileWidget.getText()).length() < 1) {
                this.m_statusLabel.setText("Please select the ASCII file");
                this.m_statusLabel.setForeground(Color.red);
                return;
            }
            if (!Tools_FileSystem.exists_file(fileName)) {
                this.m_statusLabel.setText("The selected file does not exist");
                this.m_statusLabel.setForeground(Color.red);
                return;
            }
            this.m_statusLabel.setText("Parameters look okay....");
            this.m_statusLabel.setForeground(Color.blue);
            this.m_btnOK.setEnabled(true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            this.checkStuff();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
    }

    public Table_Abstract table() {
        return this.m_table;
    }

    protected boolean importData_NameOnFirstLine() {
        try {
            String fileName;
            BufferedReader br;
            String line;
            boolean useComma = this.m_sepCombo.getSelectedIndex() == 0;
            boolean useSpace = this.m_sepCombo.getSelectedIndex() == 1;
            String name = "Temporary";
            if (this.m_database != null) {
                name = this.m_nameText.getText();
            }
            if ((line = (br = new BufferedReader(new FileReader(fileName = this.m_fileWidget.getText()))).readLine()) == null) {
                JOptionPane.showMessageDialog(null, "Failed to read first line in file", "Import failed", 0);
                return false;
            }
            if (useComma && Tools_Strings.containsDoubleChar(line, ',')) {
                JOptionPane.showMessageDialog(null, "The first line cannot contain ',,'", "Import failed", 0);
                return false;
            }
            ArrayList<String> originalColumnNames = null;
            if (useComma) {
                originalColumnNames = Tools_Strings.tokenizer_comma(line, true);
            }
            if (useSpace) {
                originalColumnNames = Tools_Strings.tokenizer_space(line, false);
            }
            System.out.println("originalColumnNames count = " + Integer.toString(originalColumnNames.size()));
            ArrayList<Object> columnNames = new ArrayList<Object>();
            HashMap<Object, Object> hash = new HashMap<Object, Object>();
            for (String originalColName : originalColumnNames) {
                Object colName = Tools_Strings.removeCrap(originalColName);
                if (Tools_Strings.startsWithNumber((String)colName)) {
                    colName = "COL" + (String)colName;
                }
                System.out.println(String.format("%s   ===>    %s", originalColName, colName));
                columnNames.add(colName);
                if (hash.containsKey(colName)) {
                    JOptionPane.showMessageDialog(null, "Column names not unique: " + (String)colName, "Import failed", 0);
                    return false;
                }
                hash.put(colName, colName);
            }
            this.m_table = new Table_Memory();
            this.m_table.setName(name);
            boolean isText = this.m_stringCheck.isSelected();
            DataType type = DataType.Double;
            if (isText) {
                type = DataType.Text;
            }
            for (int col = 0; col < columnNames.size(); ++col) {
                String colName = (String)columnNames.get(col);
                this.m_table.column_append(colName, type);
            }
            String colNameID = name + "ID";
            boolean overwriteID = false;
            if (!this.m_table.column_exists(colNameID)) {
                overwriteID = true;
            }
            int indexID = this.m_table.column_append(colNameID, DataType.Int);
            int nextID = 1000;
            line = br.readLine();
            while (line != null) {
                ArrayList<String> tokens = null;
                if (useComma) {
                    tokens = Tools_Strings.tokenizer_improved(line, ',');
                }
                if (useSpace) {
                    tokens = Tools_Strings.tokenizer_space(line, false);
                }
                if (tokens.size() >= columnNames.size()) {
                    int row = this.m_table.row_increment();
                    for (int col = 0; col < columnNames.size(); ++col) {
                        String token = tokens.get(col);
                        double v = -999999.0;
                        String str = "";
                        if (token.length() > 0 && !token.equalsIgnoreCase("NULL")) {
                            try {
                                if (!isText) {
                                    v = Double.parseDouble(token);
                                } else {
                                    str = Tools_Strings.removeMostSpecialChars(token);
                                }
                            }
                            catch (Exception exxx) {
                                v = -999999.0;
                                System.out.println(String.format("%d  %d  %s", row, col, token));
                            }
                        }
                        if (isText) {
                            this.m_table.putString(row, col, str);
                            continue;
                        }
                        this.m_table.putDouble(row, col, v);
                    }
                    if (overwriteID) {
                        this.m_table.putInt(row, indexID, nextID++);
                    }
                }
                line = br.readLine();
            }
            br.close();
            if (this.m_database != null) {
                this.m_database.createDatabaseTable(this.m_table);
                this.m_database.appendTable(this.m_table, 0);
            }
            return true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    protected boolean importData() {
        try {
            if (this.m_colNameOnFirstLineCheck.isSelected()) {
                return this.importData_NameOnFirstLine();
            }
            return true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_btnCancel) {
                this.dispose();
                return;
            }
            if (e.getSource() == this.m_btnOK) {
                if (!this.importData()) {
                    return;
                }
                this.dispose();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        try {
            this.checkStuff();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        try {
            this.checkStuff();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        try {
            this.checkStuff();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

