/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.JDBC;

import com.PecosCore.Data.TraceTable.Huge.ITraceTable;
import com.PecosCore.Data.TraceTable.ITraceTableScannerMonitor;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Data.TraceTable.TraceTable_ScannerBase;
import com.PecosLibrary.Math.Grid3D;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;

public class FoldMapWidget
extends LinearLayoutWidget
implements ActionListener,
GenericObjectListener.Listener,
ITraceTableScannerMonitor {
    protected GenericObjectListener m_listener = new GenericObjectListener();
    protected JCheckBox m_chkDisplay = new JCheckBox("Display fold (if computed)");
    protected JTextField m_txtMin = new JTextField("0");
    protected JTextField m_txtMax = new JTextField("30000");
    protected JCheckBox m_chkNeedPick = new JCheckBox("Require valid pick");
    protected JProgressBar m_progress = new JProgressBar();
    protected JButton m_btnCompute;
    protected Grid3D m_grid;

    public GenericObjectListener listener() {
        return this.m_listener;
    }

    public FoldMapWidget() {
        super(LinearLayoutWidget.Direction.Vertical, 0, null);
        try {
            this.addComponent(this.m_chkDisplay, 0);
            this.m_chkDisplay.addActionListener(this);
            GridLayoutWidget grid = this.createGridLayoutWidget(0, 0);
            grid.addSimple(0, new JLabel("Min offset"), this.m_txtMin);
            grid.addSimple(1, new JLabel("Max offset"), this.m_txtMax);
            grid.addSimple(2, new JLabel(" "), this.m_chkNeedPick);
            this.m_btnCompute = this.createButton("Compute fold map", this, 0);
            this.addComponent(this.m_progress, 0);
            this.m_progress.setMaximum(1000);
            this.m_progress.setMinimum(0);
            this.addStretch(10);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void setPercentDone(double percent) {
        try {
            if (this.m_progress != null) {
                this.m_progress.setValue((int)(10.0 * percent));
                this.m_progress.paintImmediately(0, 0, 777, 33);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void setMessage(String message) {
    }

    public Grid3D getFoldMap() {
        try {
            if (!this.m_chkDisplay.isSelected()) {
                return null;
            }
            return this.m_grid;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected void compute() {
        try {
            this.m_grid = RefractionStaticsProject.singleton().getEmptyGrid3D();
            this.m_chkDisplay.setSelected(true);
            double min = Tools_Widget.extractDouble(this.m_txtMin, 0.0, 0.0, 100000.0);
            double max = Tools_Widget.extractDouble(this.m_txtMax, 30000.0, min + 1.0, min + 100000.0);
            FoldScanner scanner = new FoldScanner(min, max, this.m_chkNeedPick.isSelected(), this.m_grid);
            ITraceTable table = RefractionStaticsProject.singleton().traceTableWrapper().traceTable();
            scanner.scan(table, this);
            this.m_progress.setValue(0);
            this.m_listener.broadcast(this, null);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_btnCompute) {
                this.compute();
                return;
            }
            if (e.getSource() == this.m_chkDisplay) {
                this.m_listener.broadcast(this, null);
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
    }

    protected class FoldScanner
    extends TraceTable_ScannerBase {
        protected double m_min;
        protected double m_max;
        protected Grid3D m_grid;
        protected boolean m_needPick;

        public FoldScanner(double min, double max, boolean needPick, Grid3D grid) {
            try {
                this.m_min = min;
                this.m_max = max;
                this.m_grid = grid;
                this.m_needPick = needPick;
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        @Override
        public void work() throws Exception {
            try {
                if (this.m_offset < this.m_min || this.m_offset >= this.m_max) {
                    return;
                }
                if (this.m_needPick && this.m_fbp < 1.0f) {
                    return;
                }
                this.m_grid.setWorldLocation(this.m_midX, this.m_midY);
                float[][] data = this.m_grid.data();
                int i = this.m_grid.InlineGridIndex;
                int c = this.m_grid.CrosslineGridIndex;
                if (i < 0) {
                    return;
                }
                if (i >= this.m_grid.numInline()) {
                    return;
                }
                if (c < 0) {
                    return;
                }
                if (c >= this.m_grid.numCrossline()) {
                    return;
                }
                data[i][c] = data[i][c] + 1.0f;
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        @Override
        public void finishScan() throws Exception {
        }
    }
}

