/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.JDBC;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Windows.Shared.ComboStringListWrapper;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;

public class DeleteColumnsDialog
extends JDialog
implements ActionListener,
ItemListener {
    protected ComboStringListWrapper m_combo = new ComboStringListWrapper();
    protected JButton m_dropButton;
    protected JCheckBox m_chkDropShot = new JCheckBox("Drop from Shot table");
    protected JCheckBox m_chkDropRec = new JCheckBox("Drop from Receiver table");
    protected JButton m_btnCancel;
    protected IDatabaseConnection m_database;
    protected String m_tableName;
    public boolean Dropped = false;
    protected boolean m_isMainDatabase;

    public DeleteColumnsDialog(String tableName, Frame parent, String title, IDatabaseConnection database) {
        super(parent, title, true);
        try {
            this.m_tableName = tableName;
            this.m_database = database;
            this.m_isMainDatabase = database == RefractionStaticsProject.singleton().geometryDatabase();
            LinearLayoutWidget temp = LinearLayoutWidget.vert(0, null);
            temp.addComponent(new JLabel("Select column to drop"), 0);
            temp.addComponent(this.m_combo, 0);
            if (this.m_isMainDatabase) {
                temp.addComponent(this.m_chkDropShot, 0);
                temp.addComponent(this.m_chkDropRec, 0);
            }
            this.m_dropButton = this.m_isMainDatabase ? temp.createButton("Drop column from selected tables", this, 0) : temp.createButton("Drop selected column from table", this, 0);
            this.m_btnCancel = temp.createButton("Close", this, 0);
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)temp, "Center");
            this.reloadColumns();
            this.setDefaultCloseOperation(2);
            this.pack();
            this.setLocationRelativeTo(null);
            this.setVisible(true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void reloadColumns() {
        try {
            ArrayList<String> all = null;
            all = this.m_isMainDatabase ? this.m_database.listOfColumnNames("Shot", "Receiver") : this.m_database.listOfColumnNames(this.m_tableName);
            ArrayList<String> list = new ArrayList<String>();
            for (String s : all) {
                boolean required = s.equalsIgnoreCase("Easting") || s.equalsIgnoreCase("Northing") || s.equalsIgnoreCase("Elevation") || s.equalsIgnoreCase("PointDepth") || s.equalsIgnoreCase("UpholeTime") || s.equalsIgnoreCase("Killed") || s.equalsIgnoreCase("UpholeCorrection") || s.equalsIgnoreCase("LineNumber") || s.equalsIgnoreCase("PointNumber") || s.equalsIgnoreCase("PointIndex") || s.equalsIgnoreCase("Polarity");
                required = required || s.equalsIgnoreCase("ShotID");
                required = required || s.equalsIgnoreCase("ReceiverID");
                required = required || s.startsWith("DTA");
                required = required || s.startsWith("DATUM");
                required = required || s.startsWith("INITIAL");
                if (required = required || s.startsWith("GEOMERR")) continue;
                list.add(s);
            }
            this.m_combo.setStringArray(list);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }

    protected void dropColumn(String tableName) {
        try {
            String columnName = this.m_combo.getSelectedString();
            if (!this.m_database.columnExists(tableName, columnName)) {
                return;
            }
            String sql = String.format("ALTER TABLE %s DROP COLUMN %s", tableName, columnName);
            this.m_database.executeUpdateStatement(sql);
            this.Dropped = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_dropButton) {
                if (this.m_isMainDatabase) {
                    if (this.m_chkDropRec.isSelected()) {
                        this.dropColumn("Receiver");
                    }
                    if (this.m_chkDropShot.isSelected()) {
                        this.dropColumn("Shot");
                    }
                } else {
                    this.dropColumn(this.m_tableName);
                }
                this.reloadColumns();
                return;
            }
            if (e.getSource() == this.m_btnCancel) {
                this.dispose();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

