/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.JDBC;

import com.PecosCore.Shared.AppType;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.SharedApplicationData;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.JDBC.SqlStatementSelectorButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ColumnMathDialog
extends JDialog
implements ActionListener,
ListSelectionListener,
ItemListener,
DocumentListener,
SqlStatementSelectorButton.Listener {
    protected LinearLayoutWidget m_buttonPanel = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null);
    protected JButton m_btnCancel = new JButton("Close");
    protected JList m_sampleList = new JList();
    protected ArrayList<String> m_samples = new ArrayList();
    protected JList m_userList = new JList();
    protected ArrayList<String> m_userSql = new ArrayList();
    protected JTextField m_txtUpdate = new JTextField("");
    protected JTextField m_txtShotUpdate = new JTextField("");
    protected JTextField m_txtReceiverUpdate = new JTextField("");
    protected JTextField m_txtOtherUpdate = new JTextField("");
    protected JButton m_runShotButton = new JButton("Update Shot");
    protected JButton m_runReceiverButton = new JButton("Update Receiver");
    protected JCheckBox m_checkShowWarning = new JCheckBox("Show warning");
    protected JButton m_runOtherButton = new JButton("Update");
    protected JLabel m_messageLabel = new JLabel(" ", 0);
    protected GridLayoutWidget m_gridWidget = new GridLayoutWidget(3, null);
    protected LinearLayoutWidget m_mainPanel = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
    protected IDatabaseConnection m_database;
    protected String m_tableName;
    protected boolean m_shotOrRecTable = false;
    protected JButton m_saveSqlButton;
    protected boolean m_bIsGeomShotTable = false;
    protected boolean m_bIsGeomRecTable = false;
    protected boolean m_ignoreEvent = false;
    public boolean RunTraceOkay = false;
    public String TraceSQL = "";

    public ColumnMathDialog(String tableName, Frame parent, String title, IDatabaseConnection database) {
        super(parent, title, true);
        try {
            RefractionStaticsProject project;
            if (AppType.isRefraction() && database == (project = RefractionStaticsProject.singleton()).geometryDatabase()) {
                this.m_bIsGeomShotTable = tableName.equalsIgnoreCase("Shot");
                this.m_bIsGeomRecTable = tableName.equalsIgnoreCase("Receiver");
                boolean bl = this.m_shotOrRecTable = this.m_bIsGeomShotTable || this.m_bIsGeomRecTable;
            }
            if (AppType.isVelocity()) {
                this.m_bIsGeomShotTable = tableName.equalsIgnoreCase("Shot");
                this.m_bIsGeomRecTable = tableName.equalsIgnoreCase("Receiver");
                this.m_shotOrRecTable = this.m_bIsGeomShotTable || this.m_bIsGeomRecTable;
            }
            this.m_database = database;
            this.m_tableName = tableName;
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)this.m_mainPanel, "Center");
            this.m_samples.add("EASTING = EASTING + GEOMERR_DIST * Cos( GEOMERR_AZ ) WHERE GEOMERR_DIST > 50");
            this.m_samples.add("NORTHING = NORTHING + GEOMERR_DIST * Sin( GEOMERR_AZ ) WHERE GEOMERR_DIST > 50");
            this.m_samples.add("KILLED = TRUE WHERE NOISELEVEL > 20");
            this.m_samples.add("DTA_DELAYTIME_1 = -9999");
            this.m_mainPanel.createLabel("Example SQL statements - click to select and customize", 2, 0);
            this.m_mainPanel.addComponent(new JScrollPane(this.m_sampleList), 10);
            this.m_sampleList.setListData(this.m_samples.toArray());
            this.m_sampleList.addListSelectionListener(this);
            this.m_sampleList.setSelectionMode(0);
            this.m_mainPanel.createLabel("Saved SQL statements - click to select and customize", 2, 0);
            this.m_mainPanel.addComponent(new JScrollPane(this.m_userList), 20);
            this.m_userList.setListData(this.m_userSql.toArray());
            this.m_userList.addListSelectionListener(this);
            this.m_userList.setSelectionMode(0);
            this.m_mainPanel.createLabel("Edit the update statement", 2, 0);
            this.m_mainPanel.addComponent(this.m_txtUpdate, 0);
            this.m_txtUpdate.getDocument().addDocumentListener(this);
            this.m_mainPanel.addComponent(this.m_gridWidget, 0);
            if (this.m_shotOrRecTable) {
                this.m_gridWidget.addComponent(this.m_txtShotUpdate, 0, 0, 1.0, 10.0);
                this.m_gridWidget.addComponent(this.m_runShotButton, 0, 1, 1.0, 0.0);
                this.m_gridWidget.addComponent(this.m_txtReceiverUpdate, 1, 0, 1.0, 10.0);
                this.m_gridWidget.addComponent(this.m_runReceiverButton, 1, 1, 1.0, 0.0);
                this.m_gridWidget.addComponent(this.m_checkShowWarning, 2, 1, 1.0, 0.0);
                this.m_checkShowWarning.setSelected(true);
                this.m_gridWidget.addComponent(this.m_messageLabel, 2, 0, 1.0, 10.0);
                this.m_runShotButton.addActionListener(this);
                this.m_runReceiverButton.addActionListener(this);
                this.m_txtShotUpdate.setEditable(false);
                this.m_txtReceiverUpdate.setEditable(false);
            } else {
                this.m_gridWidget.addComponent(this.m_txtOtherUpdate, 0, 0, 1.0, 10.0);
                this.m_gridWidget.addComponent(this.m_runOtherButton, 0, 1, 1.0, 0.0);
                this.m_gridWidget.addComponent(this.m_messageLabel, 1, 0, 1.0, 10.0);
                this.m_runOtherButton.addActionListener(this);
                this.m_txtOtherUpdate.setEditable(false);
            }
            this.m_buttonPanel.addComponent(this.m_btnCancel, 0);
            this.m_buttonPanel.addStretch(12);
            this.m_saveSqlButton = this.m_buttonPanel.createButton("Save current statement", this, 0);
            this.m_btnCancel.addActionListener(this);
            this.reloadUser();
            this.getContentPane().add((Component)this.m_buttonPanel, "South");
            this.setDefaultCloseOperation(2);
            this.setSize(950, 780);
            this.setLocationRelativeTo(null);
            this.setVisible(true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void reloadUser() {
        try {
            this.m_userSql = SharedApplicationData.singleton().getListSQL("Math");
            this.m_userList.setListData(this.m_userSql.toArray());
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        try {
            int index;
            if (this.m_ignoreEvent) {
                return;
            }
            this.m_ignoreEvent = true;
            if (e.getSource() == this.m_sampleList) {
                index = this.m_sampleList.getSelectedIndex();
                if (index >= 0) {
                    this.m_txtUpdate.setText(this.m_samples.get(index));
                }
                this.m_userList.clearSelection();
            }
            if (e.getSource() == this.m_userList) {
                index = this.m_userList.getSelectedIndex();
                if (index >= 0) {
                    this.m_txtUpdate.setText(this.m_userSql.get(index));
                }
                this.m_sampleList.clearSelection();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
        this.m_ignoreEvent = false;
    }

    protected void runShot() {
        String error = "";
        try {
            int res;
            if (this.m_checkShowWarning.isSelected() && (res = JOptionPane.showConfirmDialog(this, "Okay to modify contents of the SHOT table?", "Confirm column modification", 2, 2, null)) != 0) {
                return;
            }
            String sql = this.m_txtShotUpdate.getText();
            this.m_database.executeUpdateStatement(sql);
            if (AppType.isRefraction()) {
                RefractionStaticsProject.singleton().loadShotTableFromMemoryDatabase();
            }
            return;
        }
        catch (Exception ex) {
            error = ex.getMessage();
            ExceptionMonitor.add(ex);
            try {
                JOptionPane.showMessageDialog(null, "See System/Exceptions window for details", "Shot update failed", 0);
            }
            catch (Exception ex2) {
                ExceptionMonitor.add(ex2);
            }
            return;
        }
    }

    protected void runRec() {
        String error = "";
        try {
            int res;
            if (this.m_checkShowWarning.isSelected() && (res = JOptionPane.showConfirmDialog(this, "Okay to modify contents of the RECEIVER table?", "Confirm column modification", 2, 2, null)) != 0) {
                return;
            }
            String sql = this.m_txtReceiverUpdate.getText();
            this.m_database.executeUpdateStatement(sql);
            if (AppType.isRefraction()) {
                RefractionStaticsProject.singleton().loadReceiverTableFromMemoryDatabase();
            }
            return;
        }
        catch (Exception ex) {
            error = ex.getMessage();
            ExceptionMonitor.add(ex);
            try {
                JOptionPane.showMessageDialog(null, "See System/Exceptions window for details", "Receiver update failed", 0);
            }
            catch (Exception ex2) {
                ExceptionMonitor.add(ex2);
            }
            return;
        }
    }

    protected void runOther() {
        String error = "";
        try {
            String sql = this.m_txtOtherUpdate.getText();
            this.m_database.executeUpdateStatement(sql);
            return;
        }
        catch (Exception ex) {
            error = ex.getMessage();
            ExceptionMonitor.add(ex);
            try {
                JOptionPane.showMessageDialog(null, "See System/Exceptions window for details", "Table update failed", 0);
            }
            catch (Exception ex2) {
                ExceptionMonitor.add(ex2);
            }
            return;
        }
    }

    @Override
    public void handleSqlButton(SqlStatementSelectorButton button, String text) {
        try {
            this.m_txtUpdate.setText(text);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void runTrace() {
        try {
            this.RunTraceOkay = true;
            this.TraceSQL = this.m_txtUpdate.getText();
            this.dispose();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_runShotButton) {
                this.runShot();
                return;
            }
            if (e.getSource() == this.m_runReceiverButton) {
                this.runRec();
                return;
            }
            if (e.getSource() == this.m_runOtherButton) {
                if (this.m_tableName.equalsIgnoreCase("Trace")) {
                    this.runTrace();
                } else {
                    this.runOther();
                }
                return;
            }
            if (e.getSource() == this.m_saveSqlButton) {
                String sql = this.m_txtUpdate.getText();
                if (sql == null) {
                    return;
                }
                if (sql.length() < 1) {
                    return;
                }
                SharedApplicationData.singleton().appendSQL("Math", sql);
                this.reloadUser();
            }
            if (e.getSource() == this.m_btnCancel) {
                this.dispose();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void updateShotRec() {
        try {
            String update = this.m_txtUpdate.getText();
            this.m_txtShotUpdate.setText("UPDATE Shot SET " + update);
            this.m_txtReceiverUpdate.setText("UPDATE Receiver SET " + update);
            boolean bad = Tools_Strings.startsWithIgnoreCase(update, "ShotID") || Tools_Strings.startsWithIgnoreCase(update, "ReceiverID");
            this.m_runReceiverButton.setEnabled(!bad);
            this.m_runShotButton.setEnabled(!bad);
            if (bad) {
                this.m_messageLabel.setText("Cannot change required column");
                this.m_messageLabel.setForeground(Color.red);
            } else {
                this.m_messageLabel.setText("   ");
                this.m_messageLabel.setForeground(Color.blue);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void updateOther() {
        try {
            String update = this.m_txtUpdate.getText();
            this.m_txtOtherUpdate.setText("UPDATE " + this.m_tableName + " SET " + update);
            this.m_runOtherButton.setEnabled(true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        try {
            if (this.m_shotOrRecTable) {
                this.updateShotRec();
            } else {
                this.updateOther();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        try {
            if (this.m_shotOrRecTable) {
                this.updateShotRec();
            } else {
                this.updateOther();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        try {
            if (this.m_shotOrRecTable) {
                this.updateShotRec();
            } else {
                this.updateOther();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

