/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.JDBC;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.Refraction.Tools_RefractionStaticsProject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class AddColumnDialog
extends JDialog
implements ActionListener,
ItemListener {
    protected LinearLayoutWidget m_buttonPanel = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null);
    protected GridLayoutWidget m_mainWidget = new GridLayoutWidget(3, null);
    protected JButton m_btnOK = new JButton("Add column to selected table(s)");
    protected JButton m_btnCancel = new JButton("Cancel");
    protected JCheckBox m_addShotCheck = new JCheckBox("Add column to Shot table");
    protected JCheckBox m_addReceiverCheck = new JCheckBox("Add column to Receiver table");
    protected JTextField m_txtName = new JTextField("");
    protected JComboBox<String> m_dataTypeCombo = new JComboBox();
    protected IDatabaseConnection m_database;
    protected String m_tableName;
    protected boolean m_shotOrRecTable = false;
    protected Table_Abstract m_shotTable = null;
    protected Table_Abstract m_recTable = null;

    public AddColumnDialog(String tableName, Frame parent, String title, IDatabaseConnection database, Table_Abstract shotTable, Table_Abstract recTable) {
        super(parent, title, true);
        try {
            this.m_shotTable = shotTable;
            this.m_recTable = recTable;
            this.m_database = database;
            this.m_tableName = tableName;
            this.m_shotOrRecTable = tableName.equalsIgnoreCase("Shot") || tableName.equalsIgnoreCase("Receiver");
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)this.m_mainWidget, "Center");
            int row = 0;
            if (this.m_shotOrRecTable) {
                this.m_mainWidget.addComponent(this.m_addShotCheck, row, 1, 1.0, 5.0);
                this.m_addShotCheck.setSelected(true);
                this.m_mainWidget.addComponent(this.m_addReceiverCheck, ++row, 1, 1.0, 5.0);
                this.m_addReceiverCheck.setSelected(true);
                ++row;
            }
            this.m_mainWidget.addComponent(new JLabel("Column name"), row, 0, 1.0, 1.0);
            this.m_mainWidget.addComponent(this.m_txtName, row, 1, 1.0, 5.0);
            this.m_mainWidget.addComponent(new JLabel("Data type"), ++row, 0, 1.0, 1.0);
            this.m_mainWidget.addComponent(this.m_dataTypeCombo, row, 1, 1.0, 5.0);
            this.m_dataTypeCombo.setEditable(false);
            this.m_dataTypeCombo.addItem("Integer");
            this.m_dataTypeCombo.addItem("Float (double precision)");
            this.m_dataTypeCombo.setSelectedIndex(1);
            this.m_buttonPanel.addComponent(this.m_btnOK, 0);
            this.m_buttonPanel.addComponent(this.m_btnCancel, 0);
            this.m_buttonPanel.addStretch(12);
            this.m_btnOK.addActionListener(this);
            this.m_btnCancel.addActionListener(this);
            this.getContentPane().add((Component)this.m_buttonPanel, "South");
            this.setDefaultCloseOperation(2);
            this.pack();
            this.setLocationRelativeTo(null);
            this.setVisible(true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }

    protected boolean addColumn() {
        try {
            DataType dt = DataType.Double;
            if (this.m_dataTypeCombo.getSelectedIndex() == 0) {
                dt = DataType.Int;
            }
            String colName = this.m_txtName.getText();
            if ((colName = Tools_RefractionStaticsProject.getValidColumnName(colName, true, false)).length() < 1) {
                this.m_txtName.setText("");
                return false;
            }
            if (this.m_shotOrRecTable) {
                if (this.m_addReceiverCheck.isSelected()) {
                    if (this.m_recTable != null) {
                        this.m_recTable.column_append(colName, dt);
                    }
                    this.m_database.addColumn("Receiver", colName, dt);
                }
                if (this.m_addShotCheck.isSelected()) {
                    if (this.m_shotTable != null) {
                        this.m_shotTable.column_append(colName, dt);
                    }
                    this.m_database.addColumn("Shot", colName, dt);
                }
            } else {
                this.m_database.addColumn(this.m_tableName, colName, dt);
            }
            Messenger.broadcast(Messenger.Message.ColumnsModified, null, null);
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_btnOK) {
                if (!this.addColumn()) {
                    return;
                }
                this.dispose();
                return;
            }
            if (e.getSource() == this.m_btnCancel) {
                this.dispose();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

