/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Geometry;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.Table_Memory;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Data.Table_SimpleModel;
import com.PecosLibrary.Geometry.GeometryProject_Base;
import com.PecosLibrary.Geometry.GeometryProject_Pattern;
import com.PecosLibrary.Geometry.GeometryProject_SPS;
import com.PecosLibrary.Windows.ASCII.AsciiColumnDefWidgets;
import com.PecosLibrary.Windows.ASCII.AsciiImportData;
import com.PecosLibrary.Windows.Geometry.PatternBinningWidget;
import com.PecosLibrary.Windows.Shared.ScrollTable;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.table.DefaultTableModel;

public class PatternProjectWidget
extends JTabbedPane
implements ActionListener,
GenericObjectListener.Listener {
    protected GeometryProject_Pattern m_project;
    protected AsciiColumnDefWidgets m_shotWidgets;
    protected AsciiColumnDefWidgets m_receiverWidgets;
    protected TableInfo m_shotTableInfo;
    protected TableInfo m_receiverTableInfo;
    protected PatternBinningWidget m_binWidget;

    public PatternProjectWidget(String name) {
        try {
            this.m_project = new GeometryProject_Pattern(name);
            this.m_shotWidgets = new AsciiColumnDefWidgets(true, true, this.m_project.asciiImportData(GeometryProject_Base.Shot));
            this.m_receiverWidgets = new AsciiColumnDefWidgets(true, true, this.m_project.asciiImportData(GeometryProject_Base.Receiver));
            this.m_shotTableInfo = new TableInfo();
            this.m_receiverTableInfo = new TableInfo();
            this.m_binWidget = new PatternBinningWidget(this.m_project);
            this.addTab("Shot", this.createAllComponents(this.m_shotWidgets, this.m_shotTableInfo, GeometryProject_SPS.Shot));
            this.addTab("Receiver", this.createAllComponents(this.m_receiverWidgets, this.m_receiverTableInfo, GeometryProject_SPS.Receiver));
            this.addTab("Binning", this.m_binWidget);
            this.reloadAllTables();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void populateTable(ArrayList<String> lines, AsciiImportData importData, TableInfo tableInfo, int firstLine) {
        try {
            tableInfo.TableWidget.table().setModel(new DefaultTableModel());
            tableInfo.TableData = new Table_Memory();
            this.m_project.TableHash.put(tableInfo.Key, tableInfo.TableData);
            if (lines.size() < 1) {
                tableInfo.StatusLabel.setText("You must select an ASCII file first");
                tableInfo.StatusLabel.setForeground(Color.red);
                return;
            }
            if (importData.getColumnCount() < 1) {
                tableInfo.StatusLabel.setText("You must define at least one column first");
                tableInfo.StatusLabel.setForeground(Color.red);
                return;
            }
            Table_Abstract importedTable = tableInfo.TableData;
            if (!importData.prepTable(importedTable)) {
                tableInfo.StatusLabel.setText("Column definitions not valid");
                tableInfo.StatusLabel.setForeground(Color.red);
                return;
            }
            for (int row = firstLine - 1; row < lines.size(); ++row) {
                String s = lines.get(row);
                importData.addRow(importedTable, s, -999999);
            }
            if (importedTable.row_count() < 1) {
                importedTable = null;
                tableInfo.StatusLabel.setText("No valid rows in ASCII file");
                tableInfo.StatusLabel.setForeground(Color.red);
                return;
            }
            tableInfo.StatusLabel.setText("Row count: " + importedTable.row_count());
            tableInfo.StatusLabel.setForeground(Color.blue);
            tableInfo.TableWidget.table().setModel(new Table_SimpleModel(tableInfo.TableData));
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadAllTables() {
        try {
            this.populateTable(this.m_receiverWidgets.asciiFileWidget().lines(), this.m_receiverWidgets.asciiImportData(), this.m_receiverTableInfo, this.m_receiverWidgets.firstValidLine());
            this.m_shotWidgets.firstValidLine();
            this.populateTable(this.m_shotWidgets.asciiFileWidget().lines(), this.m_shotWidgets.asciiImportData(), this.m_shotTableInfo, this.m_shotWidgets.firstValidLine());
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_receiverTableInfo.ReloadButton) {
                this.populateTable(this.m_receiverWidgets.asciiFileWidget().lines(), this.m_receiverWidgets.asciiImportData(), this.m_receiverTableInfo, this.m_receiverWidgets.firstValidLine());
                return;
            }
            if (e.getSource() == this.m_shotTableInfo.ReloadButton) {
                this.populateTable(this.m_shotWidgets.asciiFileWidget().lines(), this.m_shotWidgets.asciiImportData(), this.m_shotTableInfo, this.m_shotWidgets.firstValidLine());
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected JComponent createAllComponents(AsciiColumnDefWidgets asciiWidgets, TableInfo tableWidgets, String key) {
        try {
            asciiWidgets.asciiImportData().listener().addListener(this);
            asciiWidgets.asciiFileSelectionWidget().getListenerController().addListener(this);
            JSplitPane splitter = new JSplitPane(1);
            asciiWidgets.setColumnDefFileName(this.m_project.columnDefinitionFileName(key));
            asciiWidgets.setAsciiFileName(this.m_project.asciiFileName(key));
            asciiWidgets.setFileControlsVisible(false);
            asciiWidgets.hideAllFileWidgets(true);
            splitter.setLeftComponent(asciiWidgets.leftWidget());
            splitter.setRightComponent(asciiWidgets.rightWidget());
            tableWidgets.Key = key;
            LinearLayoutWidget main = LinearLayoutWidget.vert(0, null);
            LinearLayoutWidget top = main.createHorizontal(0, null, 0);
            top.addComponent(tableWidgets.ReloadButton, 0);
            top.addComponent(tableWidgets.StatusLabel, 10);
            tableWidgets.ReloadButton.addActionListener(this);
            main.addComponent(tableWidgets.TableWidget, 10);
            JSplitPane mainSplitter = new JSplitPane(0);
            mainSplitter.setTopComponent(splitter);
            mainSplitter.setBottomComponent(main);
            return mainSplitter;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (sender == this.m_shotWidgets.asciiFileSelectionWidget()) {
                this.m_project.setAsciiFileName(GeometryProject_Base.Shot, this.m_shotWidgets.asciiFileSelectionWidget().getText());
                this.reloadAllTables();
                return;
            }
            if (sender == this.m_receiverWidgets.asciiFileSelectionWidget()) {
                this.m_project.setAsciiFileName(GeometryProject_Base.Receiver, this.m_receiverWidgets.asciiFileSelectionWidget().getText());
                this.reloadAllTables();
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected class TableInfo {
        public boolean Valid = false;
        public String Key = "";
        public ScrollTable TableWidget = new ScrollTable();
        public JButton ReloadButton = new JButton("Reload table");
        public JLabel StatusLabel = new JLabel("", 0);
        public Table_Abstract TableData = new Table_Memory();

        protected TableInfo() {
        }
    }
}

