/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Echos;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Windows.Echos.EchosDatabaseImportExportSharedData;
import com.PecosLibrary.Windows.Echos.IShotRecTableModelProvider;
import com.PecosLibrary.Windows.Wizard.ISimpleWizardPage;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class Page_SelectSolution
extends LinearLayoutWidget
implements ISimpleWizardPage,
ActionListener,
GenericObjectListener.Listener,
ItemListener {
    EchosDatabaseImportExportSharedData _data;
    JComboBox _cmbSolution = new JComboBox();
    JLabel _lblSolution = new JLabel("Select Solution");
    IShotRecTableModelProvider _tableModelProvider;

    public Page_SelectSolution(EchosDatabaseImportExportSharedData data, IShotRecTableModelProvider tableModelProvider) {
        super(LinearLayoutWidget.Direction.Vertical, 3, null);
        try {
            this._tableModelProvider = tableModelProvider;
            this._data = data;
            GridLayoutWidget gridWidget = this.createGridLayoutWidget(0, "", 10);
            Dimension dim = new Dimension();
            dim.height = 40;
            dim.width = 200;
            this._lblSolution.setMaximumSize(dim);
            this._cmbSolution.setMaximumSize(dim);
            this._lblSolution.setMinimumSize(dim);
            this._cmbSolution.setMinimumSize(dim);
            gridWidget.addComponent(this._lblSolution, 0, 0);
            gridWidget.addComponent(this._cmbSolution, 0, 1);
            this._cmbSolution.addItemListener(this);
            this.fillSolutionCombo(this._cmbSolution);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    void fillSolutionCombo(JComboBox comboBox) {
        try {
            int nModels = this._tableModelProvider.getModelCount();
            if (nModels == 0) {
                return;
            }
            Object objSelected = comboBox.getSelectedItem();
            comboBox.removeAllItems();
            for (int i = 0; i < nModels; ++i) {
                String sModelName = this._tableModelProvider.getModelName(i);
                comboBox.addItem(sModelName);
            }
            if (objSelected instanceof String) {
                String sSelectedColumn = (String)objSelected;
                int nItemsInCombo = comboBox.getItemCount();
                int iSelectedItemIndex = -1;
                for (int i = 0; i < nItemsInCombo; ++i) {
                    String sItem = comboBox.getItemAt(i).toString();
                    if (!sItem.equals(sSelectedColumn)) continue;
                    iSelectedItemIndex = i;
                }
                if (iSelectedItemIndex >= 0) {
                    comboBox.setSelectedIndex(iSelectedItemIndex);
                }
            }
            if (comboBox.getSelectedIndex() < 0 && comboBox.getItemCount() > 0) {
                comboBox.setSelectedIndex(0);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void leavingPage() {
    }

    @Override
    public void activatePage() {
    }

    @Override
    public boolean okayToGoToNextPage() {
        try {
            boolean bSolutionSelected = this._data.Solution.length() > 0;
            return bSolutionSelected;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    @Override
    public void dialogJustOpened() {
    }

    @Override
    public GenericObjectListener listener() {
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        try {
            Object objSelected = this._cmbSolution.getSelectedItem();
            if (objSelected instanceof String) {
                String sSelectedItem;
                this._data.Solution = sSelectedItem = objSelected.toString();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

