/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Echos;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Echos.TableExportResult;
import com.PecosLibrary.Echos.XtEchos;
import com.PecosLibrary.Echos.XtEchosColumnMap;
import com.PecosLibrary.Echos.XtParadigmTableTools;
import com.PecosLibrary.Windows.Echos.EchosDatabaseImportExportSharedData;
import com.PecosLibrary.Windows.Echos.IShotRecTableModelProvider;
import com.PecosLibrary.Windows.Echos.Page_ColumnMap;
import com.PecosLibrary.Windows.Echos.Page_EchosLine;
import com.PecosLibrary.Windows.Echos.Page_EchosSurvey;
import com.PecosLibrary.Windows.Echos.Page_SelectSolution;
import com.PecosLibrary.Windows.Wizard.SimpleWizardDialog;
import java.util.ArrayList;
import javax.swing.JOptionPane;

public class ExportToEchosDatabaseDialog {
    SimpleWizardDialog _dialog;
    Page_ColumnMap _shotColumnMapPage;
    Page_ColumnMap _receiverColumnMapPage;
    Page_EchosSurvey _echosSurveyPage;
    Page_EchosLine _echosLinePage;
    Page_SelectSolution _solutionSelectPage;
    ArrayList<SimpleWizardDialog.Page> _pages;
    EchosDatabaseImportExportSharedData _sharedData;
    IShotRecTableModelProvider _tableModelProvider;
    String _sApp;

    public ExportToEchosDatabaseDialog(String sApp, String sSolution, String sSurvey, String sHost, int iLine, IShotRecTableModelProvider tableModelProvider) {
        try {
            this._sApp = sApp;
            this.initializePages(false, sSolution, sSurvey, sHost, iLine, tableModelProvider);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public ExportToEchosDatabaseDialog(String sApp, String sSurvey, String sHost, int iLine, IShotRecTableModelProvider tableModelProvider) {
        try {
            this._sApp = sApp;
            this.initializePages(true, "", sSurvey, sHost, iLine, tableModelProvider);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    void initializePages(boolean bSelectSolution, String sSolution, String sSurvey, String sHost, int iLine, IShotRecTableModelProvider tableModelProvider) {
        try {
            this._tableModelProvider = tableModelProvider;
            this._sharedData = new EchosDatabaseImportExportSharedData();
            this._sharedData.Solution = sSolution;
            this._sharedData.EchosSurvey = sSurvey;
            this._sharedData.EchosHost = sHost;
            this._sharedData.EchosLineID = iLine;
            this._sharedData.ShotColumnMap = XtEchosColumnMap.getDefaultShotResidualStaticMap();
            this._sharedData.RecColumnMap = XtEchosColumnMap.getDefaultRecResidualStaticMap();
            this._echosSurveyPage = new Page_EchosSurvey(this._sharedData);
            this._echosLinePage = new Page_EchosLine(this._sharedData);
            this._shotColumnMapPage = new Page_ColumnMap(false, "SHOT Column map", "SHOT", this._sharedData, tableModelProvider, false);
            this._receiverColumnMapPage = new Page_ColumnMap(false, "STATION Column map", "STATION", this._sharedData, tableModelProvider, false);
            this._solutionSelectPage = new Page_SelectSolution(this._sharedData, tableModelProvider);
            this._pages = new ArrayList();
            if (bSelectSolution) {
                this._pages.add(new SimpleWizardDialog.Page(this._solutionSelectPage, "Select Solution", "Solution"));
            }
            this._pages.add(new SimpleWizardDialog.Page(this._echosSurveyPage, "Echos Survey", "Survey"));
            this._pages.add(new SimpleWizardDialog.Page(this._echosLinePage, "Echos Line", "Line"));
            this._pages.add(new SimpleWizardDialog.Page(this._shotColumnMapPage, "SHOT Model", "SHOT"));
            this._pages.add(new SimpleWizardDialog.Page(this._receiverColumnMapPage, "STATION Model", "STATION"));
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public boolean showDialog() {
        try {
            this._dialog = new SimpleWizardDialog(this._pages, "Export to Echos SeisDataDB", 800, 700);
            this._dialog.showDialog();
            if (this._dialog.Finish) {
                TableExportResult shotResult = null;
                TableExportResult recResult = null;
                XtEchosColumnMap shotColumnMap = this._shotColumnMapPage.getColumnMap();
                XtEchosColumnMap recColumnMap = this._receiverColumnMapPage.getColumnMap();
                boolean bShotExportFailed = false;
                boolean bRecExportFailed = false;
                Exception shotError = null;
                Exception recError = null;
                Table_Abstract shotGeometryTable = this._tableModelProvider.getShotTable();
                Table_Abstract recGeometryTable = this._tableModelProvider.getRecTable();
                int iModelIndex = this._tableModelProvider.getModelIndex(this._sharedData.Solution);
                Table_Abstract shotTable = this._tableModelProvider.getShotModel(iModelIndex);
                Table_Abstract recTable = this._tableModelProvider.getRecModel(iModelIndex);
                if (this._sharedData.EchosSurveyInstance == null) {
                    throw new Exception("null EchosSurveyInstance");
                }
                String sLine = XtEchos.getLineName(this._sharedData.EchosLineID, this._sharedData.EchosSurveyInstance);
                try {
                    shotResult = XtParadigmTableTools.exportTableColumnToEchos(shotGeometryTable, shotTable, shotColumnMap, this._sharedData.EchosSurvey, sLine, this._sharedData.EchosHost);
                }
                catch (Exception error) {
                    bShotExportFailed = true;
                    shotError = error;
                    ExceptionMonitor.add(error);
                }
                try {
                    if (!bShotExportFailed) {
                        recResult = XtParadigmTableTools.exportTableColumnToEchos(recGeometryTable, recTable, recColumnMap, this._sharedData.EchosSurvey, sLine, this._sharedData.EchosHost);
                    }
                }
                catch (Exception error) {
                    bRecExportFailed = true;
                    recError = error;
                    ExceptionMonitor.add(error);
                }
                if (!bShotExportFailed && !bRecExportFailed) {
                    sb = new StringBuilder();
                    sb.append("Export to Echos Success\n");
                    sb.append("SHOT Rows in Echos : " + Integer.toString(shotResult.NumEchosRows) + "\n");
                    sb.append("SHOT Rows in " + this._sApp + " : " + Integer.toString(shotResult.NumXtGeoRows) + "\n");
                    sb.append("Matching SHOT Rows  : " + Integer.toString(shotResult.NumKeyMatches) + "\n");
                    sb.append("Missing SHOT Rows  : " + Integer.toString(shotResult.NumKeyMisses) + "\n");
                    sb.append("STATION Rows in Echos : " + Integer.toString(recResult.NumEchosRows) + "\n");
                    sb.append("STATION Rows in " + this._sApp + " : " + Integer.toString(recResult.NumXtGeoRows) + "\n");
                    sb.append("Matching STATION Rows  : " + Integer.toString(recResult.NumKeyMatches) + "\n");
                    sb.append("Missing STATION Rows  : " + Integer.toString(recResult.NumKeyMisses) + "\n");
                    JOptionPane.showMessageDialog(null, sb.toString());
                } else if (bShotExportFailed) {
                    sb = new StringBuilder();
                    sb.append("Export to Echos Failed for SHOT\n");
                    sb.append(shotError.getMessage());
                    JOptionPane.showMessageDialog(null, sb.toString());
                } else if (bRecExportFailed) {
                    sb = new StringBuilder();
                    sb.append("Export to Echos Failed for STATION\n");
                    sb.append(recError.getMessage());
                    JOptionPane.showMessageDialog(null, sb.toString());
                }
                return true;
            }
            return false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }
}

