/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Echos;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.Table_Memory;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Data.Table_SimpleModel;
import com.PecosLibrary.Echos.XtEchos;
import com.PecosLibrary.Echos.XtStudyInfo;
import com.PecosLibrary.Echos.XtStudyInfoList;
import com.PecosLibrary.Windows.Echos.ForcedListSelectionModel;
import com.PecosLibrary.Windows.Shared.ScrollTable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class EchosSurveysWidget
extends LinearLayoutWidget
implements ActionListener,
GenericObjectListener.Listener {
    protected Table_Abstract m_surveyTable = new Table_Memory();
    protected Table_SimpleModel m_tableModel;
    protected ScrollTable m_scrollTable;
    protected int m_indexName;
    protected int m_indexType;
    protected int m_indexAdministrator;
    protected int m_indexHost;
    protected int m_indexPath;
    protected int m_indexModifyDate;

    public EchosSurveysWidget() {
        super(LinearLayoutWidget.Direction.Vertical, 3, null);
        try {
            this.m_scrollTable = new ScrollTable();
            this.addComponent(this.m_scrollTable, 10);
            this.m_surveyTable.setName("Surveys");
            this.m_indexName = this.m_surveyTable.column_append("Name", DataType.Text);
            this.m_indexType = this.m_surveyTable.column_append("type", DataType.Text);
            this.m_indexAdministrator = this.m_surveyTable.column_append("Administrator", DataType.Text);
            this.m_indexHost = this.m_surveyTable.column_append("Host", DataType.Text);
            this.m_indexPath = this.m_surveyTable.column_append("Path", DataType.Text);
            this.m_indexModifyDate = this.m_surveyTable.column_append("Modify Date", DataType.Text);
            this.m_tableModel = new Table_SimpleModel(this.m_surveyTable);
            this.m_scrollTable.table().setModel(this.m_tableModel);
            this.m_scrollTable.table().getColumnModel().getColumn(this.m_indexName).setMinWidth(200);
            this.m_scrollTable.table().getColumnModel().getColumn(this.m_indexType).setMinWidth(130);
            this.m_scrollTable.table().getColumnModel().getColumn(this.m_indexAdministrator).setMinWidth(130);
            this.m_scrollTable.table().getColumnModel().getColumn(this.m_indexHost).setMinWidth(130);
            this.m_scrollTable.table().getColumnModel().getColumn(this.m_indexPath).setMinWidth(130);
            this.m_scrollTable.table().getColumnModel().getColumn(this.m_indexModifyDate).setMinWidth(130);
            this.m_scrollTable.table().setSelectionModel(new ForcedListSelectionModel());
            this.reloadTable();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public int getSelectedRow() {
        int iRow = -1;
        try {
            iRow = this.m_scrollTable.table().getSelectedRow();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            iRow = -1;
        }
        return iRow;
    }

    public String getSelectedName() {
        String sName = "";
        try {
            int iSelectedRow = this.getSelectedRow();
            if (iSelectedRow >= 0) {
                sName = this.m_surveyTable.getString(iSelectedRow, this.m_indexName);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
        return sName;
    }

    public String getSelectedHost() {
        String sHost = "";
        try {
            int iSelectedRow = this.getSelectedRow();
            if (iSelectedRow >= 0) {
                sHost = this.m_surveyTable.getString(iSelectedRow, this.m_indexHost);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
        return sHost;
    }

    protected void reloadTable() {
        try {
            if (XtEchos.ParadigmEnvironment == null) {
                throw new Exception("Uninitialized Paradigm environment");
            }
            if (XtEchos.ParadigmEnvironment != null) {
                XtStudyInfoList studyInfoList = XtEchos.getStudyInfoList();
                int nStudies = studyInfoList.size();
                Object selectedStudyInfo = null;
                for (int i = 0; i < nStudies; ++i) {
                    XtStudyInfo info = studyInfoList.get(i);
                    String sName = info.getName();
                    String sHost = info.getHost();
                    System.out.println(sName);
                    int row = this.m_surveyTable.row_increment();
                    this.m_surveyTable.putString(row, this.m_indexName, sName);
                    int iStudyType = info.getStudyType();
                    int iSurveyType = info.getSurveyType();
                    int k = 0;
                    if (iStudyType != iSurveyType) {
                        ++k;
                    }
                    String sSurveyType = "";
                    if (iSurveyType == 1) {
                        sSurveyType = "Survey 2D";
                    } else if (iSurveyType == 2) {
                        sSurveyType = "Survey 3D";
                    }
                    String sOwner = info.getOwner();
                    String sStudyPath = info.getStudyPath();
                    String sCreateDate = info.getCreateDate();
                    String sModifyDate = info.getModifyDate();
                    String sComment = info.getComment();
                    String sUnits = info.getWorkUnit();
                    this.m_surveyTable.putString(row, this.m_indexType, sSurveyType);
                    this.m_surveyTable.putString(row, this.m_indexAdministrator, sOwner);
                    this.m_surveyTable.putString(row, this.m_indexHost, sHost);
                    this.m_surveyTable.putString(row, this.m_indexPath, sStudyPath);
                    this.m_surveyTable.putString(row, this.m_indexModifyDate, sModifyDate);
                    this.m_tableModel.fireTableDataChanged();
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
    }

    public int getSelectedSurveyType() {
        String sHost = "";
        try {
            int iSelectedRow = this.getSelectedRow();
            String sType = this.m_surveyTable.getString(iSelectedRow, this.m_indexType);
            int iSurveyType = 0;
            if (sType.equals("Survey 2D")) {
                return 1;
            }
            if (sType.equals("Survey 3D")) {
                return 2;
            }
            return iSurveyType;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return 0;
        }
    }

    public void setSurvey(String sSurvey, String sHost) {
        try {
            int nRows = this.m_surveyTable.row_count();
            int iSelectedRow = -1;
            for (int iRow = 0; iRow < nRows; ++iRow) {
                String sTmpSurvey = this.m_surveyTable.getString(iRow, this.m_indexName);
                String sTmpHost = this.m_surveyTable.getString(iRow, this.m_indexHost);
                if (!sTmpSurvey.equals(sSurvey) || !sTmpHost.equals(sHost)) continue;
                iSelectedRow = iRow;
            }
            int iCurrentSelectedRow = this.getSelectedRow();
            if (iSelectedRow >= 0 && iCurrentSelectedRow != iSelectedRow) {
                this.m_scrollTable.table().setRowSelectionInterval(iSelectedRow, iSelectedRow);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

