/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Echos;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.Table_Memory;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Data.Table_SimpleModel;
import com.PecosLibrary.Echos.XtEchos;
import com.PecosLibrary.Echos.XtLineInfo;
import com.PecosLibrary.Echos.XtParadigmSurvey;
import com.PecosLibrary.Windows.Echos.ForcedListSelectionModel;
import com.PecosLibrary.Windows.Shared.ScrollTable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class EchosLineWidget
extends LinearLayoutWidget
implements ActionListener,
GenericObjectListener.Listener {
    protected Table_Abstract m_lineTable = new Table_Memory();
    protected Table_SimpleModel m_tableModel;
    protected ScrollTable m_scrollTable;
    protected int m_indexName;
    protected int m_indexShortName;
    protected int m_indexID;
    XtParadigmSurvey _survey = null;

    public EchosLineWidget() {
        super(LinearLayoutWidget.Direction.Vertical, 3, null);
        try {
            this.m_scrollTable = new ScrollTable();
            this.addComponent(this.m_scrollTable, 10);
            this.m_lineTable.setName("Lines");
            this.m_indexName = this.m_lineTable.column_append("Name", DataType.Text);
            this.m_indexShortName = this.m_lineTable.column_append("Short Name", DataType.Text);
            this.m_indexID = this.m_lineTable.column_append("ID", DataType.Int);
            this.m_tableModel = new Table_SimpleModel(this.m_lineTable);
            this.m_scrollTable.table().setModel(this.m_tableModel);
            this.m_scrollTable.table().getColumnModel().getColumn(this.m_indexName).setMinWidth(200);
            this.m_scrollTable.table().setSelectionModel(new ForcedListSelectionModel());
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setSurvey(XtParadigmSurvey survey) {
        try {
            int iSelectedLine = this.getSelectedID();
            this._survey = survey;
            this.reloadTable();
            this.setLineID(iSelectedLine);
            int iSelectedRow = this.getSelectedRow();
            if (iSelectedRow < 0) {
                this.m_scrollTable.table().setRowSelectionInterval(0, 0);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public XtParadigmSurvey getSurvey() {
        return this._survey;
    }

    public int getSelectedRow() {
        int iRow = -1;
        try {
            iRow = this.m_scrollTable.table().getSelectedRow();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            iRow = -1;
        }
        return iRow;
    }

    public String getSelectedName() {
        String sName = "";
        try {
            int iSelectedRow = this.getSelectedRow();
            if (iSelectedRow >= 0) {
                sName = this.m_lineTable.getString(iSelectedRow, this.m_indexName);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
        return sName;
    }

    public String getSelectedShortName() {
        String sName = "";
        try {
            int iSelectedRow = this.getSelectedRow();
            if (iSelectedRow >= 0) {
                sName = this.m_lineTable.getString(iSelectedRow, this.m_indexShortName);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
        return sName;
    }

    public int getSelectedID() {
        int id = -1;
        try {
            int iSelectedRow = this.getSelectedRow();
            if (iSelectedRow >= 0) {
                id = Integer.parseInt(this.m_lineTable.getString(iSelectedRow, this.m_indexID));
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
        return id;
    }

    protected void reloadTable() {
        try {
            if (this._survey == null) {
                return;
            }
            if (XtEchos.ParadigmEnvironment == null) {
                throw new Exception("Uninitialized Paradigm environment");
            }
            int nLines = this._survey.getNumLineInfo();
            for (int i = 0; i < nLines; ++i) {
                XtLineInfo line = this._survey.getLineInfo(i);
                if (line == null) {
                    int jjjj = 0;
                    ++jjjj;
                }
                String sLineName = line.getName();
                String sShortName = line.getShortName();
                int iLineID = (int)line.getId();
                int row = this.m_lineTable.row_increment();
                this.m_lineTable.putString(row, this.m_indexName, sLineName);
                this.m_lineTable.putString(row, this.m_indexShortName, sShortName);
                this.m_lineTable.putString(row, this.m_indexID, Integer.toString(iLineID));
                this.m_tableModel.fireTableDataChanged();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
    }

    public void setLineID(int iLine) {
        try {
            int nRows = this.m_lineTable.row_count();
            int iSelectedRow = -1;
            for (int iRow = 0; iRow < nRows; ++iRow) {
                String sTmpID = this.m_lineTable.getString(iRow, this.m_indexID);
                Integer id = Integer.parseInt(sTmpID);
                if (id != iLine) continue;
                iSelectedRow = iRow;
            }
            int iCurrentSelectedRow = this.getSelectedRow();
            if (iSelectedRow >= 0 && iCurrentSelectedRow != iSelectedRow) {
                this.m_scrollTable.table().setRowSelectionInterval(iSelectedRow, iSelectedRow);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

