/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.ConvertedWave;

import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ConvertedWaveStaticsDialog
extends JDialog
implements GenericObjectListener.Listener,
ActionListener,
DocumentListener {
    protected RefractionStaticsProject m_project;
    protected JButton m_btnCancel = new JButton("Close");
    protected JButton m_btnOK = new JButton("Create statics field");
    protected JTextField m_txtStaticsField = new JTextField("Shear");
    protected JLabel m_lblStaticsField = new JLabel(" ");
    protected JTextField m_txtFinalDatum = new JTextField("6000");
    protected JTextField m_txtRepVel = new JTextField("5000");
    protected String m_paramFile;
    protected ParameterTree m_tree = new ParameterTree();
    public boolean OK = false;

    public double datum() {
        return Tools_Widget.extractDouble(this.m_txtFinalDatum, -20000.0, -20000.0, 100000.0);
    }

    public double repVel() {
        return Tools_Widget.extractDouble(this.m_txtRepVel, 1000.0, 100.0, 20000.0);
    }

    public String columnName() {
        try {
            return "STATICS_" + this.m_txtStaticsField.getText();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return "";
        }
    }

    public ConvertedWaveStaticsDialog() {
        try {
            this.m_project = RefractionStaticsProject.singleton();
            this.m_paramFile = this.m_project.guiOptionsPath() + "/ConvWaveStatics.xml";
            this.m_tree.read(this.m_paramFile);
            this.getContentPane().setLayout(new BorderLayout());
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            GridLayoutWidget grid = main.createGridLayoutWidget(3, 0);
            int row = 0;
            grid.addSimple(row++, new JLabel("Statics name"), this.m_txtStaticsField);
            grid.addSimple(row++, new JLabel("Database column name"), this.m_lblStaticsField);
            grid.addSimple(row++, new JLabel("Final datum"), this.m_txtFinalDatum);
            grid.addSimple(row++, new JLabel("Replacement velocity"), this.m_txtRepVel);
            this.m_txtStaticsField.setText(this.m_tree.string_get("Name", "ShearStatics"));
            this.m_txtFinalDatum.setText(Double.toString(this.m_tree.double_get("Datum", 1000.0)));
            this.m_txtRepVel.setText(Double.toString(this.m_tree.double_get("RepVel", 1000.0)));
            this.m_txtStaticsField.getDocument().addDocumentListener(this);
            LinearLayoutWidget bottom = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null);
            bottom.addStretch(10);
            bottom.addComponent(this.m_btnOK, 0);
            bottom.addComponent(this.m_btnCancel, 0);
            bottom.addStretch(10);
            this.m_btnOK.addActionListener(this);
            this.m_btnCancel.addActionListener(this);
            this.getContentPane().add((Component)main, "Center");
            this.getContentPane().add((Component)bottom, "South");
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.setDefaultCloseOperation(2);
            this.pack();
            this.setSize(this.getSize().width + 200, this.getSize().height);
            this.setTitle("Compute shear statics");
            this.setLocationRelativeTo(null);
            this.checkName();
            this.setVisible(true);
            this.requestFocus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void checkName() {
        try {
            this.m_btnOK.setEnabled(false);
            String name = this.m_txtStaticsField.getText();
            this.m_lblStaticsField.setText("");
            if (name.length() < 3) {
                this.m_lblStaticsField.setForeground(Color.red);
                this.m_lblStaticsField.setText("Name must have at least 3 characters");
                return;
            }
            if (!Tools_Strings.isAlphaNumeric(name, true, false)) {
                this.m_lblStaticsField.setForeground(Color.red);
                this.m_lblStaticsField.setText("Spaces and special characters not allowed");
                return;
            }
            if (Tools_Strings.startsWithNumber(name)) {
                this.m_lblStaticsField.setForeground(Color.red);
                this.m_lblStaticsField.setText("Name cannot start with a number");
                return;
            }
            String colName = "STATICS_" + name;
            this.m_btnOK.setEnabled(true);
            this.m_lblStaticsField.setForeground(Color.blue);
            this.m_lblStaticsField.setText(colName);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        try {
            this.checkName();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        try {
            this.checkName();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        try {
            this.checkName();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected IDatabaseConnection database() {
        try {
            return RefractionStaticsProject.singleton().geometryDatabase();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_btnOK) {
                this.OK = true;
                this.dispose();
                return;
            }
            if (e.getSource() == this.m_btnCancel) {
                this.dispose();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

