/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Action;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Action.Action_Sequence;
import com.PecosLibrary.Action.Action_Thread;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.Action.ActionSequence_Widget;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.Timer;

public class Dialog_ActionSequence
extends JDialog
implements ActionListener {
    protected Timer m_timer = new Timer(1000, this);
    protected boolean m_bStartedThread = false;
    protected int m_timerCount = 0;
    protected ActionSequence_Widget m_actionWidget;
    protected JButton m_btnClose = new JButton("Close");
    protected Action_Thread m_thread;

    public Dialog_ActionSequence(Action_Sequence sequence) {
        try {
            this.getContentPane().setLayout(new BorderLayout());
            this.m_thread = new Action_Thread();
            this.m_actionWidget = new ActionSequence_Widget(this.m_thread);
            this.getContentPane().add((Component)this.m_actionWidget, "Center");
            LinearLayoutWidget w = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null);
            w.addStretch(10);
            w.addComponent(this.m_btnClose, 0);
            w.addStretch(10);
            this.m_btnClose.setEnabled(false);
            this.m_btnClose.addActionListener(this);
            this.getContentPane().add((Component)w, "South");
            if (sequence == null) {
                sequence = RefractionStaticsProject.singleton().actionSequence();
            }
            this.m_thread.setSequence(sequence);
            this.m_timer.start();
            int h = 450 + 14 * sequence.size();
            this.setSize(700, h);
            this.setLocationRelativeTo(null);
            this.setTitle("Project: " + RefractionStaticsProject.singleton().name());
            this.setDefaultCloseOperation(2);
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.setVisible(true);
            this.requestFocus();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public Dialog_ActionSequence(Action_Sequence sequence, String name) {
        try {
            this.getContentPane().setLayout(new BorderLayout());
            this.m_thread = new Action_Thread();
            this.m_actionWidget = new ActionSequence_Widget(this.m_thread);
            this.getContentPane().add((Component)this.m_actionWidget, "Center");
            LinearLayoutWidget w = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null);
            w.addStretch(10);
            w.addComponent(this.m_btnClose, 0);
            w.addStretch(10);
            this.m_btnClose.setEnabled(false);
            this.m_btnClose.addActionListener(this);
            this.getContentPane().add((Component)w, "South");
            if (sequence == null) {
                sequence = RefractionStaticsProject.singleton().actionSequence();
            }
            this.m_thread.setSequence(sequence);
            this.m_timer.start();
            int h = 450 + 14 * sequence.size();
            this.setSize(700, h);
            this.setLocationRelativeTo(null);
            this.setTitle("Project: " + name);
            this.setDefaultCloseOperation(2);
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.setVisible(true);
            this.requestFocus();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_timer) {
                ++this.m_timerCount;
                if (this.m_timerCount <= 1) {
                    return;
                }
                if (!this.m_bStartedThread) {
                    System.out.println(" ==> Timer m_bStartedThread");
                    this.m_bStartedThread = true;
                    this.m_thread.startThread();
                    return;
                }
                if (this.m_thread.isAlive()) {
                    this.m_actionWidget.updateGUI();
                    return;
                }
                if (this.m_thread.finished()) {
                    System.out.println(" ==> Timer thread.finished()");
                    this.m_actionWidget.updateGUI();
                    this.m_timer.stop();
                    this.m_btnClose.setEnabled(true);
                    this.dispose();
                    return;
                }
            }
            if (e.getSource() == this.m_btnClose) {
                this.dispose();
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

