/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.ASCII;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosCore.Tools.Tools_XML;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AsciiImportData
extends AbstractTableModel {
    protected ArrayList<Column> m_columns = new ArrayList();
    public int SelectedColumnIndex = -1;
    public boolean UseDataType = true;
    protected GenericObjectListener m_listener = new GenericObjectListener();

    public ArrayList<Column> columns() {
        return this.m_columns;
    }

    public boolean hasColumn(String name) {
        try {
            for (Column c : this.m_columns) {
                if (!name.equalsIgnoreCase(c.Name)) continue;
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    public GenericObjectListener listener() {
        return this.m_listener;
    }

    public void prepColumnIndices(Table_Abstract table) {
        try {
            for (Column col : this.m_columns) {
                col.ColumnIndex = -999;
                if (!col.WriteToHeader || !table.column_exists(col.Name)) continue;
                col.ColumnIndex = table.column_indexOfColumn(col.Name);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void add(DataType dt, String name, int first, int last, boolean export, boolean applyElev, boolean applyCoord, int offset, DataType exportType) {
        try {
            Column c = new Column();
            c.Name = name;
            c.Type = dt;
            c.FirstColumn = first;
            c.LastColumn = last;
            c.WriteToHeader = export;
            c.ApplyCoordScalar = applyCoord;
            c.ApplyElevScalar = applyElev;
            c.Offset = offset;
            c.ExportType = exportType;
            this.m_columns.add(c);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void setDef(String name, boolean export, boolean applyElev, boolean applyCoord, int offset, DataType exportType) {
        try {
            for (Column c : this.m_columns) {
                if (!c.Name.equalsIgnoreCase(name)) continue;
                c.WriteToHeader = export;
                c.ApplyCoordScalar = applyCoord;
                c.ApplyElevScalar = applyElev;
                c.Offset = offset;
                c.ExportType = exportType;
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void defShotMap() {
        try {
            this.setDef("Easting", true, false, true, 73, DataType.Int);
            this.setDef("Northing", true, false, true, 77, DataType.Int);
            this.setDef("Uphole", true, false, false, 95, DataType.Short);
            this.setDef("Static", true, false, false, 99, DataType.Short);
            this.setDef("Elevation", true, true, false, 45, DataType.Int);
            this.setDef("Depth", true, true, false, 49, DataType.Int);
            this.setDef("WaterDepth", true, true, false, 61, DataType.Int);
            this.setDef("LineNumber", true, false, false, 181, DataType.Int);
            this.setDef("PointNumber", true, false, false, 185, DataType.Int);
            this.setDef("PointIndex", true, false, false, 189, DataType.Int);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void defRecMap() {
        try {
            this.setDef("Easting", true, false, true, 81, DataType.Int);
            this.setDef("Northing", true, false, true, 85, DataType.Int);
            this.setDef("Static", true, false, false, 101, DataType.Short);
            this.setDef("Elevation", true, true, false, 41, DataType.Int);
            this.setDef("WaterDepth", true, true, false, 65, DataType.Int);
            this.setDef("LineNumber", true, false, false, 193, DataType.Int);
            this.setDef("PointNumber", true, false, false, 197, DataType.Int);
            this.setDef("PointIndex", true, false, false, 201, DataType.Int);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void add(DataType dt, String name, int first, int last) {
        try {
            Column c = new Column();
            c.Name = name;
            c.Type = dt;
            c.FirstColumn = first;
            c.LastColumn = last;
            this.m_columns.add(c);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void createPattern_Shot() {
        try {
            this.clear();
            this.add(DataType.Int, "FFID", 2, 7);
            this.add(DataType.Int, "ShotPeg", 9, 13);
            this.add(DataType.Double, "SkidI", 15, 23);
            this.add(DataType.Double, "SkidC", 25, 32);
            this.add(DataType.Double, "Depth", 34, 38);
            this.add(DataType.Double, "RLSW", 40, 45);
            this.add(DataType.Int, "Ch1", 47, 50);
            this.add(DataType.Int, "Ch2", 52, 55);
            this.add(DataType.Int, "Ch3", 57, 60);
            this.add(DataType.Int, "Ch4", 62, 65);
            this.add(DataType.Int, "Peg1", 67, 71);
            this.add(DataType.Int, "Peg2", 73, 77);
            this.add(DataType.Int, "Peg3", 79, 83);
            this.add(DataType.Int, "Peg4", 85, 92);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void createPattern_Rec() {
        try {
            this.clear();
            this.add(DataType.Int, "Peg", 2, 7);
            this.add(DataType.Double, "Distance", 9, 14);
            this.add(DataType.Double, "Elevation", 16, 21);
            this.add(DataType.Double, "Easting", 23, 31);
            this.add(DataType.Double, "Northing", 33, 41);
            this.add(DataType.Double, "Increment", 43, 48);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void createDefSPS_Ver21() {
        try {
            this.clear();
            this.add(DataType.Double, "RecordID", 1, 1);
            this.add(DataType.Int, "LineNumber", 2, 11);
            this.add(DataType.Int, "PointNumber", 12, 21);
            this.add(DataType.Int, "PointIndex", 24, 24);
            this.add(DataType.Int, "PointCode", 25, 26);
            this.add(DataType.Double, "Static", 27, 30);
            this.add(DataType.Double, "Depth", 31, 34);
            this.add(DataType.Double, "Datum", 35, 38);
            this.add(DataType.Double, "Uphole", 39, 40);
            this.add(DataType.Double, "WaterDepth", 41, 46);
            this.add(DataType.Double, "Easting", 47, 55);
            this.add(DataType.Double, "Northing", 56, 65);
            this.add(DataType.Double, "Elevation", 66, 71);
            this.add(DataType.Double, "DayOfYear", 72, 74);
            this.add(DataType.Double, "Time", 75, 80);
            this.emitChange();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void createDefSPS_Ver0() {
        try {
            this.clear();
            this.add(DataType.Double, "RecordID", 1, 1);
            this.add(DataType.Int, "LineNumber", 2, 17);
            this.add(DataType.Int, "PointNumber", 18, 25);
            this.add(DataType.Int, "PointIndex", 26, 26);
            this.add(DataType.Int, "PointCode", 27, 28);
            this.add(DataType.Double, "Static", 29, 32);
            this.add(DataType.Double, "Depth", 33, 36);
            this.add(DataType.Double, "SeismicDatum", 37, 40);
            this.add(DataType.Double, "Uphole", 41, 42);
            this.add(DataType.Double, "WaterDepth", 43, 46);
            this.add(DataType.Double, "Easting", 47, 55);
            this.add(DataType.Double, "Northing", 56, 65);
            this.add(DataType.Double, "Elevation", 66, 71);
            this.add(DataType.Double, "DayOfYear", 72, 74);
            this.add(DataType.Double, "Time", 75, 80);
            this.emitChange();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void createDefXPS_Ver0() {
        try {
            this.clear();
            this.add(DataType.Double, "RecordID", 1, 1);
            this.add(DataType.Double, "FieldTapeNumber", 2, 7);
            this.add(DataType.Int, "FFID", 8, 11);
            this.add(DataType.Int, "FFIDIncrement", 12, 12);
            this.add(DataType.Double, "InstrumentCode", 13, 13);
            this.add(DataType.Int, "ShotLineNumber", 14, 29);
            this.add(DataType.Int, "ShotPointNumber", 30, 37);
            this.add(DataType.Int, "ShotPointIndex", 38, 38);
            this.add(DataType.Int, "FromChannel", 39, 42);
            this.add(DataType.Int, "ToChannel", 43, 46);
            this.add(DataType.Int, "ChannelIncrement", 47, 47);
            this.add(DataType.Int, "ReceiverLineNumber", 48, 63);
            this.add(DataType.Int, "FromReceiverPointNumber", 64, 71);
            this.add(DataType.Int, "ToReceiverPointNumber", 72, 79);
            this.add(DataType.Int, "ReceiverPointIndex", 80, 80);
            this.emitChange();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void createDefXPS_Ver21() {
        try {
            this.clear();
            this.add(DataType.Double, "RecordID", 1, 1);
            this.add(DataType.Double, "FieldTapeNumber", 2, 7);
            this.add(DataType.Int, "FFID", 8, 15);
            this.add(DataType.Int, "FFIDIncrement", 16, 16);
            this.add(DataType.Double, "InstrumentCode", 17, 17);
            this.add(DataType.Int, "ShotLineNumber", 18, 27);
            this.add(DataType.Int, "ShotPointNumber", 28, 37);
            this.add(DataType.Int, "ShotPointIndex", 38, 38);
            this.add(DataType.Int, "FromChannel", 39, 43);
            this.add(DataType.Int, "ToChannel", 44, 48);
            this.add(DataType.Int, "ChannelIncrement", 49, 49);
            this.add(DataType.Int, "ReceiverLineNumber", 50, 59);
            this.add(DataType.Int, "FromReceiverPointNumber", 60, 69);
            this.add(DataType.Int, "ToReceiverPointNumber", 70, 79);
            this.add(DataType.Int, "ReceiverPointIndex", 80, 80);
            this.emitChange();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void emitChange() {
    }

    public void remove(int row) {
        try {
            if (row >= 0 && row < this.m_columns.size()) {
                this.m_columns.remove(row);
                if (this.m_columns.size() >= 1) {
                    this.SelectedColumnIndex = Math.max(this.SelectedColumnIndex, 0);
                    this.SelectedColumnIndex = Math.min(this.SelectedColumnIndex, this.m_columns.size() - 1);
                } else {
                    this.SelectedColumnIndex = -1;
                }
                this.emitChange();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setColumns(int row, int col1, int col2) {
        try {
            if (row >= 0 && row < this.m_columns.size()) {
                this.m_columns.get((int)row).FirstColumn = col1;
                this.m_columns.get((int)row).LastColumn = col2;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void add() {
        try {
            this.m_columns.add(new Column());
            this.SelectedColumnIndex = this.m_columns.size() - 1;
            this.emitChange();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void clear() {
        try {
            this.m_columns.clear();
            this.SelectedColumnIndex = -1;
            this.emitChange();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public boolean prepTable(Table_Abstract table) {
        try {
            table.column_removeAll();
            for (Column col : this.m_columns) {
                if (col.Name.isEmpty()) {
                    return false;
                }
                if (col.LastColumn <= 0) {
                    return false;
                }
                if (col.FirstColumn <= 0) {
                    return false;
                }
                col.ColumnIndex = table.column_append(col.Name, col.Type);
            }
            return true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    public void addRow(Table_Abstract table, String line) {
        try {
            this.addRow(table, line, -999999);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void addRow(Table_Abstract table, String line, int defVal) {
        try {
            if (line.isEmpty()) {
                return;
            }
            int len = line.length();
            int row = table.row_increment();
            for (Column col : this.m_columns) {
                int c1 = Math.max(0, col.FirstColumn - 1);
                int c2 = Math.min(len - 1, col.LastColumn - 1);
                if (c2 >= c1) {
                    String sub = line.substring(c1, c2 + 1);
                    if (Tools_Strings.isAllSpace(sub)) {
                        table.putInt(row, col.ColumnIndex, defVal);
                        continue;
                    }
                    if (col.Type == DataType.Int) {
                        table.putInt(row, col.ColumnIndex, Tools_Strings.toInt(sub, defVal));
                    }
                    if (col.Type == DataType.Double) {
                        table.putDouble(row, col.ColumnIndex, Tools_Strings.toDouble(sub, defVal));
                    }
                    if (col.Type == DataType.Long) {
                        table.putLong(row, col.ColumnIndex, Tools_Strings.toLong(sub, defVal));
                    }
                    if (col.Type != DataType.Text) continue;
                    table.putString(row, col.ColumnIndex, sub);
                    continue;
                }
                table.putInt(row, col.ColumnIndex, defVal);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void writeToNode(Element node) {
        try {
            for (Column col : this.m_columns) {
                Element subNode = node.getOwnerDocument().createElement("Column");
                node.appendChild(subNode);
                subNode.setAttribute("Column", col.Name);
                subNode.setAttribute("Type", col.Type.Description);
                subNode.setAttribute("First", Integer.toString(col.FirstColumn));
                subNode.setAttribute("Last", Integer.toString(col.LastColumn));
                subNode.setAttribute("Offset", Integer.toString(col.Offset));
                subNode.setAttribute("WriteToHeader", Boolean.toString(col.WriteToHeader));
                subNode.setAttribute("ApplyCoordScalar", Boolean.toString(col.ApplyCoordScalar));
                subNode.setAttribute("ApplyElevScalar", Boolean.toString(col.ApplyElevScalar));
                subNode.setAttribute("ExportType", col.ExportType.Description);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void readFromNode(Element node) {
        try {
            ArrayList<Element> nodes = Tools_XML.getChildListWithTagName(node, "Column");
            for (Element element : nodes) {
                if (!element.hasAttribute("Column") || !element.hasAttribute("Type")) continue;
                Column col = new Column();
                col.Name = element.getAttribute("Column");
                col.FirstColumn = Tools_XML.getInt(element, "First", -9999);
                col.LastColumn = Tools_XML.getInt(element, "Last", -9999);
                col.Type = DataType.typeFromDescription(element.getAttribute("Type"));
                col.Offset = Tools_XML.getInt(element, "Offset", 0);
                col.WriteToHeader = Tools_XML.getBoolean(element, "WriteToHeader", false);
                col.ApplyCoordScalar = Tools_XML.getBoolean(element, "ApplyCoordScalar", false);
                col.ApplyElevScalar = Tools_XML.getBoolean(element, "ApplyElevScalar", false);
                col.ExportType = DataType.typeFromDescription(element.getAttribute("ExportType"));
                this.m_columns.add(col);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void save(String fileName) {
        try {
            Document document = Tools_XML.createDocument();
            Element root = document.createElement("Columns");
            document.appendChild(root);
            this.writeToNode(root);
            Tools_XML.writeDocumentToFile(document, fileName);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void read(String fileName) {
        try {
            this.m_columns.clear();
            if (!Tools_FileSystem.exists_file(fileName)) {
                return;
            }
            Document doc = Tools_XML.readDocument(fileName);
            Element root = (Element)doc.getFirstChild();
            this.readFromNode(root);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return true;
    }

    @Override
    public int getRowCount() {
        return this.m_columns.size();
    }

    @Override
    public int getColumnCount() {
        if (this.UseDataType) {
            return 4;
        }
        return 3;
    }

    @Override
    public Object getValueAt(int row, int column) {
        try {
            if (row < 0 || row >= this.m_columns.size()) {
                return "";
            }
            if (column < 0 || column >= 4) {
                return "";
            }
            Column col = this.m_columns.get(row);
            if (this.UseDataType) {
                if (column == 0) {
                    return col.Name;
                }
                if (column == 1) {
                    return col.Type.Description;
                }
                if (column == 2) {
                    return Integer.toString(col.FirstColumn);
                }
                if (column == 3) {
                    return Integer.toString(col.LastColumn);
                }
            } else {
                if (column == 0) {
                    return col.Name;
                }
                if (column == 1) {
                    return Integer.toString(col.FirstColumn);
                }
                if (column == 2) {
                    return Integer.toString(col.LastColumn);
                }
            }
            return "";
        }
        catch (Exception error) {
            error.printStackTrace();
            return "";
        }
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        try {
            if (value == null) {
                return;
            }
            if (!(value instanceof String)) {
                return;
            }
            Column col = this.m_columns.get(row);
            String v = (String)value;
            if (this.UseDataType) {
                if (column == 0) {
                    v = Tools_Strings.removeSpace(v);
                    v = Tools_Strings.removeMostSpecialChars(v);
                    if ((v = Tools_Strings.removeCrap(v)).length() < 2) {
                        return;
                    }
                    col.Name = v;
                }
                if (column == 1) {
                    col.Type = DataType.typeFromDescription(v);
                }
                if (column == 2) {
                    col.FirstColumn = Integer.parseInt(v);
                    col.FirstColumn = Math.max(col.FirstColumn, 1);
                }
                if (column == 3) {
                    col.LastColumn = Integer.parseInt(v);
                    col.LastColumn = Math.max(col.LastColumn, 1);
                }
            } else {
                if (column == 0) {
                    v = Tools_Strings.removeSpace(v);
                    v = Tools_Strings.removeMostSpecialChars(v);
                    if ((v = Tools_Strings.removeCrap(v)).length() < 2) {
                        return;
                    }
                    col.Name = v;
                }
                if (column == 1) {
                    col.FirstColumn = Integer.parseInt(v);
                    col.FirstColumn = Math.max(col.FirstColumn, 1);
                }
                if (column == 2) {
                    col.LastColumn = Integer.parseInt(v);
                    col.LastColumn = Math.max(col.LastColumn, 1);
                }
            }
            this.m_listener.broadcast(this, null);
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    @Override
    public String getColumnName(int column) {
        try {
            if (this.UseDataType) {
                if (column == 0) {
                    return "Column";
                }
                if (column == 1) {
                    return "Type";
                }
                if (column == 2) {
                    return "From";
                }
                if (column == 3) {
                    return "To";
                }
            } else {
                if (column == 0) {
                    return "Column";
                }
                if (column == 1) {
                    return "From";
                }
                if (column == 2) {
                    return "To";
                }
            }
            return "bad column";
        }
        catch (Exception error) {
            error.printStackTrace();
            return "getColumnName exception";
        }
    }

    public static class Column {
        public String Name = "ERROR";
        public DataType Type = DataType.Int;
        public int FirstColumn = -1;
        public int LastColumn = -1;
        public boolean WriteToHeader = true;
        public DataType ExportType = DataType.Int;
        public int Offset = 100;
        public boolean ApplyCoordScalar = false;
        public boolean ApplyElevScalar = false;
        public int ColumnIndex = -9999;
    }
}

