/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Velocity;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Stack.VelocityLocationCollection;

public class VelocityMoveoutLookup {
    protected float[] m_vel;
    protected int m_count;
    protected double m_x;
    protected double m_y;
    protected float m_digi;
    protected float m_t0;
    protected double m_maxOffset;
    protected double m_minOffset;
    protected int m_numOffsets;
    protected float m_muteStretch;
    protected int[] m_muteIndex;
    protected short[][] m_lowerIndex;
    protected float[][] m_lowerWeight;

    public VelocityMoveoutLookup(double x, double y, VelocityLocationCollection vlc, float t0, float digi, int count, double minOffset, double maxOffset, int numOffsets, float muteStretch) throws Exception {
        try {
            this.m_t0 = t0;
            this.m_digi = digi;
            this.m_x = x;
            this.m_y = y;
            this.m_count = count;
            this.m_muteStretch = muteStretch;
            this.m_minOffset = minOffset;
            this.m_maxOffset = maxOffset;
            this.m_numOffsets = numOffsets;
            vlc.setRequestedInterp(t0, digi, count);
            this.m_vel = vlc.getVelocity(x, y);
            this.m_lowerIndex = new short[this.m_numOffsets][count];
            this.m_lowerWeight = new float[this.m_numOffsets][count];
            this.m_muteIndex = new int[this.m_numOffsets];
            float muteFactor = 0.01f * this.m_muteStretch + 1.0f;
            for (int n = 0; n < this.m_numOffsets; ++n) {
                this.m_muteIndex[n] = -999;
                double offset = this.m_minOffset + (double)n * (this.m_maxOffset - this.m_minOffset) / (double)(this.m_numOffsets - 1);
                for (int s = 0; s < count; ++s) {
                    double time0 = (double)t0 + (double)s * (double)digi;
                    double v = this.m_vel[s];
                    double fac = 1000000.0 * offset * offset / (v * v);
                    double timeNMO = Math.sqrt(time0 * time0 + fac + 1.0E-6);
                    double outputIndex = (timeNMO - (double)this.m_t0) / (double)this.m_digi;
                    this.m_lowerIndex[n][s] = (short)outputIndex;
                    this.m_lowerIndex[n][s] = (short)Math.max(this.m_lowerIndex[n][s], 0);
                    this.m_lowerWeight[n][s] = 1.0f - ((float)outputIndex - (float)this.m_lowerIndex[n][s]);
                    this.m_lowerWeight[n][s] = (short)Math.max(this.m_lowerWeight[n][s], 0.0f);
                    double ratio = timeNMO / ((double)0.001f + time0);
                    if (!(ratio < (double)muteFactor) || this.m_muteIndex[n] >= 0) continue;
                    this.m_muteIndex[n] = s;
                }
                this.m_muteIndex[n] = Math.max(this.m_muteIndex[n], 0);
                this.m_muteIndex[n] = Math.min(this.m_muteIndex[n], count - 1);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void stack(float[] stack, float[] input, float[] weight, double offset) throws Exception {
        try {
            int muteIndex;
            double offsetIndex = (double)(this.m_numOffsets - 1) * (offset - this.m_minOffset) / (this.m_maxOffset - this.m_minOffset);
            int nearestIndex = (int)(0.5 + offsetIndex);
            nearestIndex = Math.max(0, nearestIndex);
            nearestIndex = Math.min(this.m_numOffsets - 1, nearestIndex);
            short[] lowerIndex = this.m_lowerIndex[nearestIndex];
            float[] lowerWeight = this.m_lowerWeight[nearestIndex];
            for (int s = muteIndex = this.m_muteIndex[nearestIndex]; s < this.m_count; ++s) {
                float w;
                int inputIndex = lowerIndex[s];
                if (inputIndex < this.m_count) {
                    w = lowerWeight[s];
                    stack[s] = stack[s] + input[inputIndex] * lowerWeight[s];
                }
                if (++inputIndex >= this.m_count) continue;
                w = 1.0f - lowerWeight[s];
                stack[s] = stack[s] + input[inputIndex] * lowerWeight[s];
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }
}

