/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Triangulation;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Math.Matrix_Simple;
import com.PecosLibrary.Triangulation.Point_dt;
import com.PecosLibrary.Triangulation.Triangle_dt;

public class Triangle_Interpolator {
    protected boolean m_valid = false;
    protected Triangle_dt m_triangle;
    protected Matrix_Simple m_matrix = new Matrix_Simple(3, 3);
    protected Matrix_Simple m_rhs = new Matrix_Simple(3, 1);
    public double a1;
    public double b1;
    public double c1;
    public double a2;
    public double b2;
    public double c2;
    public double a3;
    public double b3;
    public double c3;
    public int id1;
    public int id2;
    public int id3;
    public double z1;
    public double z2;
    public double z3;
    public double w1;
    public double w2;
    public double w3;

    public boolean valid() {
        return this.m_valid;
    }

    public Triangle_dt triangle() {
        return this.m_triangle;
    }

    public void prepWeights(double x, double y) throws Exception {
        try {
            if (!this.m_valid) {
                throw new Exception("m_valid == false");
            }
            this.w1 = this.a1 + this.b1 * x + this.c1 * y;
            this.w2 = this.a2 + this.b2 * x + this.c2 * y;
            this.w3 = this.a3 + this.b3 * x + this.c3 * y;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void setTriangle(Triangle_dt t) {
        try {
            this.m_valid = false;
            this.m_triangle = t;
            if (this.m_triangle == null) {
                return;
            }
            if (this.m_triangle.isHalfplane()) {
                return;
            }
            Point_dt p1 = this.m_triangle.p1();
            Point_dt p2 = this.m_triangle.p2();
            Point_dt p3 = this.m_triangle.p3();
            this.id1 = p1.id;
            this.id2 = p2.id;
            this.id3 = p3.id;
            this.z1 = p1.z;
            this.z2 = p2.z;
            this.z3 = p3.z;
            double[][] m = this.m_matrix.Data;
            double[][] rhs = this.m_rhs.Data;
            m[0][0] = 1.0;
            m[0][1] = p1.x;
            m[0][2] = p1.y;
            m[1][0] = 1.0;
            m[1][1] = p2.x;
            m[1][2] = p2.y;
            m[2][0] = 1.0;
            m[2][1] = p3.x;
            m[2][2] = p3.y;
            rhs[0][0] = 1.0;
            rhs[1][0] = 0.0;
            rhs[2][0] = 0.0;
            Matrix_Simple soln = this.m_matrix.solve(this.m_rhs);
            this.a1 = soln.Data[0][0];
            this.b1 = soln.Data[1][0];
            this.c1 = soln.Data[2][0];
            m[0][0] = 1.0;
            m[0][1] = p1.x;
            m[0][2] = p1.y;
            m[1][0] = 1.0;
            m[1][1] = p2.x;
            m[1][2] = p2.y;
            m[2][0] = 1.0;
            m[2][1] = p3.x;
            m[2][2] = p3.y;
            rhs[0][0] = 0.0;
            rhs[1][0] = 1.0;
            rhs[2][0] = 0.0;
            soln = this.m_matrix.solve(this.m_rhs);
            this.a2 = soln.Data[0][0];
            this.b2 = soln.Data[1][0];
            this.c2 = soln.Data[2][0];
            m[0][0] = 1.0;
            m[0][1] = p1.x;
            m[0][2] = p1.y;
            m[1][0] = 1.0;
            m[1][1] = p2.x;
            m[1][2] = p2.y;
            m[2][0] = 1.0;
            m[2][1] = p3.x;
            m[2][2] = p3.y;
            rhs[0][0] = 0.0;
            rhs[1][0] = 0.0;
            rhs[2][0] = 1.0;
            soln = this.m_matrix.solve(this.m_rhs);
            this.a3 = soln.Data[0][0];
            this.b3 = soln.Data[1][0];
            this.c3 = soln.Data[2][0];
            this.m_valid = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

