/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Refraction;

import com.PecosCore.Data.Column_Abstract;
import com.PecosCore.Data.Column_Int;
import com.PecosCore.Data.DataType;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.Table_Memory;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Map.HashMap_Integer;
import com.PecosCore.Math.Grid3D_Conversion;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Shared.Pecos;
import com.PecosCore.Shared.PolygonUsage;
import com.PecosCore.Shared.Range_Double;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosCore.Windows.Java2D.Java2D_PointSymbol;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.Math.AxisGrid_LinearFit;
import com.PecosLibrary.Math.Grid3D;
import com.PecosLibrary.Math.IGrid2D_Conversion;
import com.PecosLibrary.Math.Interpolator_EmptyGrid;
import com.PecosLibrary.Math.InversePowerInterpolator;
import com.PecosLibrary.Math.SpatialInterpolator;
import com.PecosLibrary.Refraction.ProjectGridAnalyzer;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Uphole.UpholeModel;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_Table;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Polygon;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JOptionPane;

public class Tools_RefractionStaticsProject {
    protected double m_sum1;
    protected double m_sum2;

    protected void updateSumInverseFourth(Table_Abstract table, String colName, double x1, double y1, double min, double max) {
        try {
            int indexX = table.column_indexOfColumn("Easting");
            int indexY = table.column_indexOfColumn("Northing");
            int indexDead = table.column_indexOfColumn("Killed");
            int indexV = table.column_indexOfColumn(colName);
            for (int n = 0; n < table.row_count(); ++n) {
                double v = table.getDouble(n, indexV);
                boolean dead = table.getBool(n, indexDead);
                if (dead || !(v >= min) || !(v <= max)) continue;
                double dx = x1 - table.getDouble(n, indexX);
                double dy = y1 - table.getDouble(n, indexY);
                double dsq = dx * dx + dy * dy + 0.1;
                double w = 1000000.0 / (1000000.0 + dsq * dsq);
                this.m_sum1 += v * w;
                this.m_sum2 += w;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void interpolateBadValuesUsingInverseFourth(String colName, double min, double max) {
        try {
            Table_Abstract shotTable = RefractionStaticsProject.singleton().shotTable();
            Table_Abstract recTable = RefractionStaticsProject.singleton().receiverTable();
            for (int iter = 1; iter <= 2; ++iter) {
                Table_Abstract table = shotTable;
                if (iter == 2) {
                    table = recTable;
                }
                int indexX = table.column_indexOfColumn("Easting");
                int indexY = table.column_indexOfColumn("Northing");
                int indexDead = table.column_indexOfColumn("Killed");
                int indexV = table.column_indexOfColumn(colName);
                for (int n = 0; n < table.row_count(); ++n) {
                    double v = table.getDouble(n, indexV);
                    boolean dead = table.getBool(n, indexDead);
                    if (!dead && !(v < min) && !(v > max)) continue;
                    double x = table.getDouble(n, indexX);
                    double y = table.getDouble(n, indexY);
                    this.m_sum1 = 0.0;
                    this.m_sum2 = 1.0E-25;
                    this.updateSumInverseFourth(shotTable, colName, x, y, min, max);
                    this.updateSumInverseFourth(recTable, colName, x, y, min, max);
                    v = this.m_sum1 / this.m_sum2;
                    table.putDouble(n, indexV, v);
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void interpolateFromTableToTable(Table_Abstract tableFrom, Table_Abstract tableTo, String colName) {
        try {
            if (!tableTo.column_exists(colName)) {
                tableTo.column_append(colName, DataType.Double);
            }
            int indexX = tableTo.column_indexOfColumn("Easting");
            int indexY = tableTo.column_indexOfColumn("Northing");
            int indexV = tableTo.column_append(colName, DataType.Double);
            for (int n = 0; n < tableTo.row_count(); ++n) {
                double x = tableTo.getDouble(n, indexX);
                double y = tableTo.getDouble(n, indexY);
                this.m_sum1 = 0.0;
                this.m_sum2 = 1.0E-25;
                this.updateSumInverseFourth(tableFrom, colName, x, y, -1.0E20, 1.0E20);
                double v = this.m_sum1 / this.m_sum2;
                tableTo.putDouble(n, indexV, v);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static void confirmReceiverTableInExternalDatabase(IDatabaseConnection conn) {
        try {
            Table_Abstract externalTable = null;
            HashMap_Integer externalHash = null;
            if (!conn.tableExists("Receiver")) {
                externalTable = new Table_Memory();
                externalTable.setName("Receiver");
                externalTable.column_append("ReceiverID", DataType.Int);
                conn.createDatabaseTable(externalTable);
                conn.appendTable(externalTable, 0);
            }
            externalTable = conn.extractTableDataUsingQuery("Receiver", "SELECT * FROM Receiver", 0);
            externalHash = externalTable.createMapID();
            boolean added = false;
            Table_Abstract table = RefractionStaticsProject.singleton().receiverTable();
            int indexProjectID = table.column_indexOfColumn("ReceiverID");
            int indexID = externalTable.column_indexOfColumn("ReceiverID");
            for (int r = 0; r < table.row_count(); ++r) {
                int id = table.getInt(r, indexProjectID);
                if (externalHash.containsKey(id)) continue;
                int row = externalTable.row_increment();
                externalTable.putInt(row, indexID, id);
                added = true;
            }
            if (added) {
                conn.dropTable("Receiver");
                conn.createDatabaseTable(externalTable);
                conn.appendTable(externalTable, 0);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static void confirmShotTableInExternalDatabase(IDatabaseConnection conn) {
        try {
            Table_Abstract externalTable = null;
            HashMap_Integer externalHash = null;
            if (!conn.tableExists("Shot")) {
                externalTable = new Table_Memory();
                externalTable.setName("Shot");
                externalTable.column_append("ShotID", DataType.Int);
                conn.createDatabaseTable(externalTable);
                conn.appendTable(externalTable, 0);
            }
            externalTable = conn.extractTableDataUsingQuery("Shot", "SELECT * FROM Shot", 0);
            externalHash = externalTable.createMapID();
            boolean added = false;
            Table_Abstract table = RefractionStaticsProject.singleton().shotTable();
            int indexProjectID = table.column_indexOfColumn("ShotID");
            int indexID = externalTable.column_indexOfColumn("ShotID");
            for (int r = 0; r < table.row_count(); ++r) {
                int id = table.getInt(r, indexProjectID);
                if (externalHash.containsKey(id)) continue;
                int row = externalTable.row_increment();
                externalTable.putInt(row, indexID, id);
                added = true;
            }
            if (added) {
                conn.dropTable("Shot");
                conn.createDatabaseTable(externalTable);
                conn.appendTable(externalTable, 0);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static String getValidColumnName(String colName, boolean showDialog, boolean mustNotBeRequiredColumn) {
        try {
            colName = Tools_Strings.removeSpace(colName);
            if (colName.length() < 1) {
                return "";
            }
            if ((colName = colName.toUpperCase()).length() < 3) {
                if (showDialog) {
                    JOptionPane.showMessageDialog(null, "Column name must have at least 3 characters", "Column name not valid", 0);
                }
                return "";
            }
            if (Tools_Strings.startsWithNumber(colName)) {
                if (showDialog) {
                    JOptionPane.showMessageDialog(null, "Column name cannot start with a number", "Column name not valid", 0);
                }
                return "";
            }
            if (Tools_Strings.underscoreEnd(colName) || Tools_Strings.underscoreStart(colName)) {
                if (showDialog) {
                    JOptionPane.showMessageDialog(null, "Column name cannot begin or end with an underscore", "Column name not valid", 0);
                }
                return "";
            }
            if (!Tools_Strings.isAlphaNumeric(colName, true, true)) {
                if (showDialog) {
                    JOptionPane.showMessageDialog(null, "Column name cannot contain special characters", "Column name not valid", 0);
                }
                return "";
            }
            if (!mustNotBeRequiredColumn) {
                return colName;
            }
            boolean required = colName.equalsIgnoreCase("Easting") || colName.equalsIgnoreCase("Northing") || colName.equalsIgnoreCase("Elevation") || colName.equalsIgnoreCase("PointDepth") || colName.equalsIgnoreCase("UpholeTime") || colName.equalsIgnoreCase("Killed") || colName.equalsIgnoreCase("UpholeCorrection") || colName.equalsIgnoreCase("LineNumber") || colName.equalsIgnoreCase("PointNumber") || colName.equalsIgnoreCase("PointIndex") || colName.equalsIgnoreCase("Polarity");
            required = required || colName.equalsIgnoreCase("ShotID");
            required = required || colName.equalsIgnoreCase("ReceiverID");
            required = required || colName.startsWith("DTA");
            required = required || colName.startsWith("DATUM");
            required = required || colName.startsWith("INITIAL");
            boolean bl = required = required || colName.startsWith("GEOMERR");
            if (required) {
                if (showDialog) {
                    JOptionPane.showMessageDialog(null, "Column name may conflict with required columns", "Column name not valid", 0);
                }
                return "";
            }
            return colName;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return "";
        }
    }

    public static void convertToZeroMean(String col) {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            double s1 = 0.0;
            double s2 = 1.0E-30;
            for (int t = 0; t <= 1; ++t) {
                Table_Abstract table = project.shotTable();
                if (t == 1) {
                    table = project.receiverTable();
                }
                if (!table.column_exists(col)) continue;
                int index = table.column_indexOfColumn(col);
                int indexKilled = table.column_indexOfColumn("Killed");
                for (int row = 0; row < table.row_count(); ++row) {
                    if (table.getBool(row, indexKilled)) continue;
                    double v = table.getDouble(row, index);
                    s1 += v;
                    s2 += 1.0;
                }
            }
            double avg = s1 / s2;
            for (int t = 0; t <= 1; ++t) {
                Table_Abstract table = project.shotTable();
                if (t == 1) {
                    table = project.receiverTable();
                }
                if (!table.column_exists(col)) continue;
                int index = table.column_indexOfColumn(col);
                int indexKilled = table.column_indexOfColumn("Killed");
                for (int row = 0; row < table.row_count(); ++row) {
                    if (table.getBool(row, indexKilled)) continue;
                    double v = table.getDouble(row, index);
                    table.putDouble(row, index, v -= avg);
                }
                project.geometryDatabase().writeColumnContentsToDatabase(table, col);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static int getIDUsingLinePoint_NeighborPoint(Table_Abstract table, boolean positive, int line, int point) {
        try {
            int colKilled = table.column_indexOfColumn("Killed");
            int colLine = table.column_indexOfColumn("LineNumber");
            int colPoint = table.column_indexOfColumn("PointNumber");
            int colID = table.column_indexOfColumn("ShotID");
            int currID = -9999;
            int minDist = 1000000;
            int bestID = -9999;
            for (int row = 0; row < table.row_count(); ++row) {
                if (table.getBool(row, colKilled) || line != table.getInt(row, colLine)) continue;
                int testPoint = table.getInt(row, colPoint);
                int dist = Math.abs(point - testPoint);
                if (dist < minDist) {
                    if (positive) {
                        if (testPoint > point) {
                            bestID = table.getInt(row, colID);
                            minDist = dist;
                        }
                    } else if (testPoint < point) {
                        bestID = table.getInt(row, colID);
                        minDist = dist;
                    }
                }
                if (testPoint != point) continue;
                currID = table.getInt(row, colID);
            }
            if (bestID > 0) {
                return bestID;
            }
            return currID;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return -9999;
        }
    }

    public static int getIDUsingLinePoint_NeighborLine(Table_Abstract table, boolean positive, int line, int point) {
        try {
            int colKilled = table.column_indexOfColumn("Killed");
            int colLine = table.column_indexOfColumn("LineNumber");
            int colPoint = table.column_indexOfColumn("PointNumber");
            int colID = table.column_indexOfColumn("ShotID");
            int currID = -9999;
            int minDist = 1000000;
            int bestID = -9999;
            for (int row = 0; row < table.row_count(); ++row) {
                if (table.getBool(row, colKilled) || point != table.getInt(row, colPoint)) continue;
                int testLine = table.getInt(row, colLine);
                int dist = Math.abs(line - testLine);
                if (dist < minDist) {
                    if (positive) {
                        if (testLine > line) {
                            bestID = table.getInt(row, colID);
                            minDist = dist;
                        }
                    } else if (testLine < line) {
                        bestID = table.getInt(row, colID);
                        minDist = dist;
                    }
                }
                if (testLine != line) continue;
                currID = table.getInt(row, colID);
            }
            if (bestID > 0) {
                return bestID;
            }
            return currID;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return -9999;
        }
    }

    public static int getIDUsingLinePoint(Table_Abstract table, int line, int point) {
        try {
            int colKilled = table.column_indexOfColumn("Killed");
            int colLine = table.column_indexOfColumn("LineNumber");
            int colPoint = table.column_indexOfColumn("PointNumber");
            int colID = table.column_indexOfColumn("ShotID");
            for (int row = 0; row < table.row_count(); ++row) {
                if (table.getBool(row, colKilled) || line != table.getInt(row, colLine) && point != table.getInt(row, colPoint)) continue;
                return table.getInt(row, colID);
            }
            return -9999;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return -9999;
        }
    }

    public static ArrayList<String> listOfColumns(String versionName, String prefix) {
        try {
            IDatabaseConnection database = RefractionStaticsProject.singleton().getVersionDatabase(versionName);
            ArrayList<String> recColList = database.listOfColumnNames("Receiver");
            ArrayList<String> shotColList = database.listOfColumnNames("Shot");
            database = null;
            System.gc();
            ArrayList<String> intersection = new ArrayList<String>();
            for (String rec : recColList) {
                boolean ok = false;
                for (String shot : shotColList) {
                    if (!rec.equalsIgnoreCase(shot)) continue;
                    ok = true;
                }
                if (!ok || !rec.startsWith(prefix)) continue;
                intersection.add(rec);
            }
            Collections.sort(intersection);
            return intersection;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return new ArrayList<String>();
        }
    }

    public static void copyColumn(String fromColumn, String toColumn, boolean copyShot, boolean copyRec, Table_Abstract destShotTable, Table_Abstract destRecTable, IDatabaseConnection destinationDatabase) {
        try {
            double dVal;
            int i;
            int iToColumnIndex;
            int iFromColumnIndex;
            int count;
            Table_Abstract srcShotTable = RefractionStaticsProject.singleton().shotTable();
            Table_Abstract srcRecTable = RefractionStaticsProject.singleton().receiverTable();
            if (copyShot) {
                count = srcShotTable.row_count();
                iFromColumnIndex = srcShotTable.column_indexOfColumn(fromColumn);
                iToColumnIndex = destShotTable.column_indexOfColumn(toColumn);
                if (count == destShotTable.row_count()) {
                    for (i = 0; i < count; ++i) {
                        dVal = srcShotTable.getDouble(i, iFromColumnIndex);
                        destShotTable.putDouble(i, iToColumnIndex, dVal);
                    }
                    destinationDatabase.writeColumnContentsToDatabase(destShotTable, toColumn);
                }
            }
            if (copyRec) {
                count = srcRecTable.row_count();
                iFromColumnIndex = srcRecTable.column_indexOfColumn(fromColumn);
                iToColumnIndex = destRecTable.column_indexOfColumn(toColumn);
                if (count == destRecTable.row_count()) {
                    for (i = 0; i < count; ++i) {
                        dVal = srcRecTable.getDouble(i, iFromColumnIndex);
                        destRecTable.putDouble(i, iToColumnIndex, dVal);
                    }
                    destinationDatabase.writeColumnContentsToDatabase(destRecTable, toColumn);
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static void copyColumn(String fromColumn, String toColumn, boolean copyShot, boolean copyRec) {
        try {
            String sql;
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            if (copyRec) {
                sql = String.format("UPDATE RECEIVER SET %s = %s", toColumn, fromColumn);
                p.geometryDatabase().executeUpdateStatement(sql);
            }
            if (copyShot) {
                sql = String.format("UPDATE SHOT SET %s = %s", toColumn, fromColumn);
                p.geometryDatabase().executeUpdateStatement(sql);
            }
            p.reloadAllData();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static ArrayList<String> getColumnList_Intersection(String prefix) {
        try {
            ArrayList<String> columnsSrc = RefractionStaticsProject.singleton().shotTable().column_listOfNames();
            ArrayList<String> columnsRec = RefractionStaticsProject.singleton().receiverTable().column_listOfNames();
            ArrayList<String> cols = new ArrayList<String>();
            for (String rec : columnsRec) {
                boolean ok = false;
                for (String src : columnsSrc) {
                    if (!src.equalsIgnoreCase(rec)) continue;
                    ok = true;
                }
                if (!ok || !rec.startsWith(prefix)) continue;
                cols.add(rec);
            }
            Collections.sort(cols);
            return cols;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    public static ArrayList<String> getColumnList_Intersection(Table_Abstract shotTable, Table_Abstract recTable) {
        try {
            ArrayList<String> columnsSrc = shotTable.column_listOfNames();
            ArrayList<String> columnsRec = recTable.column_listOfNames();
            ArrayList<String> cols = new ArrayList<String>();
            for (String rec : columnsRec) {
                boolean ok = false;
                for (String src : columnsSrc) {
                    if (!src.equalsIgnoreCase(rec)) continue;
                    ok = true;
                }
                if (!ok) continue;
                cols.add(rec);
            }
            Collections.sort(cols);
            return cols;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    public static ArrayList<String> getColumnList_Intersection() {
        try {
            ArrayList<String> columnsSrc = RefractionStaticsProject.singleton().shotTable().column_listOfNames();
            ArrayList<String> columnsRec = RefractionStaticsProject.singleton().receiverTable().column_listOfNames();
            ArrayList<String> cols = new ArrayList<String>();
            for (String rec : columnsRec) {
                boolean ok = false;
                for (String src : columnsSrc) {
                    if (!src.equalsIgnoreCase(rec)) continue;
                    ok = true;
                }
                if (!ok) continue;
                cols.add(rec);
            }
            Collections.sort(cols);
            return cols;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    public static ArrayList<String> getColumnList_Union() {
        try {
            ArrayList<String> columns = RefractionStaticsProject.singleton().shotTable().column_listOfNames();
            ArrayList<String> columnsRec = RefractionStaticsProject.singleton().receiverTable().column_listOfNames();
            for (String rec : columnsRec) {
                boolean ok = false;
                for (String s : columns) {
                    ok = ok || s.equalsIgnoreCase(rec);
                }
                if (ok) continue;
                columns.add(rec);
            }
            Collections.sort(columns);
            return columns;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    public static void shiftColumnValue_Double(String colName, double shift) {
        try {
            double v;
            int row;
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            Table_Abstract table = p.receiverTable();
            int index = table.column_indexOfColumn(colName);
            for (row = 0; row < table.row_count(); ++row) {
                v = table.getDouble(row, index);
                table.putDouble(row, index, v + shift);
            }
            table = p.shotTable();
            index = table.column_indexOfColumn(colName);
            for (row = 0; row < table.row_count(); ++row) {
                v = table.getDouble(row, index);
                table.putDouble(row, index, v + shift);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static void setColumnValue_Double(String colName, double value) {
        try {
            Tools_RefractionStaticsProject.confirmColumn(colName, DataType.Double);
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            int index = p.shotTable().column_indexOfColumn(colName);
            p.shotTable().column_setToValue(index, value);
            index = p.receiverTable().column_indexOfColumn(colName);
            p.receiverTable().column_setToValue(index, value);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static void confirmColumn(RefractionStaticsProject p, String colName, DataType type) {
        try {
            boolean needReload = false;
            if (!p.geometryDatabase().columnExists("Shot", colName)) {
                needReload = true;
                p.geometryDatabase().addColumn("Shot", colName, type);
            }
            if (!p.geometryDatabase().columnExists("Receiver", colName)) {
                needReload = true;
                p.geometryDatabase().addColumn("Receiver", colName, type);
            }
            if (!p.shotTable().column_exists(colName)) {
                needReload = true;
            }
            if (!p.receiverTable().column_exists(colName)) {
                needReload = true;
            }
            if (needReload) {
                p.reloadAllData();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static void confirmColumn(String colName, DataType type) {
        try {
            Tools_RefractionStaticsProject.confirmColumn(RefractionStaticsProject.singleton(), colName, type);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static void createTemporaryColumn(String sourceColName, String tempColName, Table_Abstract table) {
        try {
            int indexTo = table.column_append(tempColName, DataType.Double);
            int indexFrom = table.column_indexOfColumn(sourceColName);
            for (int row = 0; row < table.row_count(); ++row) {
                table.putDouble(row, indexTo, table.getDouble(row, indexFrom));
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static void createTemporaryColumn(String sourceColName, String tempColName) {
        try {
            Tools_RefractionStaticsProject.createTemporaryColumn(sourceColName, tempColName, RefractionStaticsProject.singleton().receiverTable());
            Tools_RefractionStaticsProject.createTemporaryColumn(sourceColName, tempColName, RefractionStaticsProject.singleton().shotTable());
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static void computeInterpolatedTable(Table_Abstract table, double smoothRadius, boolean inverseFourth) {
        try {
            int colX = table.column_indexOfColumn("Easting");
            int colY = table.column_indexOfColumn("Northing");
            ArrayList<String> columns = Tools_RefractionStaticsProject.getColumnList_Intersection();
            ArrayList<InterpConnections> list = new ArrayList<InterpConnections>();
            Table_Abstract shotTable = RefractionStaticsProject.singleton().shotTable();
            Table_Abstract recTable = RefractionStaticsProject.singleton().receiverTable();
            for (String column : columns) {
                boolean coord = column.equalsIgnoreCase("Easting") || column.equalsIgnoreCase("Northing");
                if (coord) continue;
                InterpConnections conn = new InterpConnections();
                conn.Name = column;
                conn.EnsembleIndex = table.column_append(column, DataType.Double);
                conn.ReceiverColumnIndex = recTable.column_indexOfColumn(column);
                conn.ShotColumnIndex = shotTable.column_indexOfColumn(column);
                list.add(conn);
            }
            int colRecX = recTable.column_indexOfColumn("Easting");
            int colRecY = recTable.column_indexOfColumn("Northing");
            int colRecDead = recTable.column_indexOfColumn("Killed");
            int colShotX = shotTable.column_indexOfColumn("Easting");
            int colShotY = shotTable.column_indexOfColumn("Northing");
            int colShotDead = shotTable.column_indexOfColumn("Killed");
            smoothRadius = Math.max(smoothRadius, 1.0);
            smoothRadius *= smoothRadius;
            if (inverseFourth) {
                smoothRadius *= smoothRadius;
            }
            for (int n = 0; n < table.row_count(); ++n) {
                double v;
                double w;
                double r;
                double dy;
                double dx;
                double yp;
                double xp;
                boolean killed;
                int k;
                for (InterpConnections conn : list) {
                    conn.Sum1 = 0.0;
                    conn.Sum2 = 1.0E-60;
                }
                double x = table.getDouble(n, colX);
                double y = table.getDouble(n, colY);
                for (k = 0; k < recTable.row_count(); ++k) {
                    killed = recTable.getBool(k, colRecDead);
                    if (killed) continue;
                    xp = recTable.getDouble(k, colRecX);
                    yp = recTable.getDouble(k, colRecY);
                    dx = x - xp;
                    dy = y - yp;
                    r = dx * dx + dy * dy;
                    if (inverseFourth) {
                        r *= r;
                    }
                    w = smoothRadius / (smoothRadius + r);
                    for (InterpConnections conn : list) {
                        if (conn.ReceiverColumnIndex < 0) continue;
                        v = recTable.getDouble(k, conn.ReceiverColumnIndex);
                        conn.Sum1 += w * v;
                        conn.Sum2 += w;
                    }
                }
                for (k = 0; k < shotTable.row_count(); ++k) {
                    killed = shotTable.getBool(k, colShotDead);
                    if (killed) continue;
                    xp = shotTable.getDouble(k, colShotX);
                    yp = shotTable.getDouble(k, colShotY);
                    dx = x - xp;
                    dy = y - yp;
                    r = dx * dx + dy * dy;
                    if (inverseFourth) {
                        r *= r;
                    }
                    w = smoothRadius / (smoothRadius + r);
                    for (InterpConnections conn : list) {
                        if (conn.ShotColumnIndex < 0) continue;
                        v = shotTable.getDouble(k, conn.ShotColumnIndex);
                        conn.Sum1 += w * v;
                        conn.Sum2 += w;
                    }
                }
                for (InterpConnections conn : list) {
                    double v2 = conn.Sum1 / conn.Sum2;
                    table.putDouble(n, conn.EnsembleIndex, v2);
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static void computeInterpolatedHeaders(Ensemble ensemble, String tableName, String tableNameX, String columnNameX, String tableNameY, String columnNameY) {
        try {
            ArrayList<String> columns = Tools_RefractionStaticsProject.getColumnList_Union();
            ArrayList<InterpConnections> list = new ArrayList<InterpConnections>();
            Table_Abstract shotTable = RefractionStaticsProject.singleton().shotTable();
            Table_Abstract recTable = RefractionStaticsProject.singleton().receiverTable();
            for (String s : columns) {
                InterpConnections conn = new InterpConnections();
                conn.Name = s;
                conn.EnsembleIndex = ensemble.dictionary().addEntry(tableName, s, DataType.Double);
                conn.ReceiverColumnIndex = -999;
                conn.ShotColumnIndex = -999;
                if (shotTable.column_exists(s)) {
                    conn.ShotColumnIndex = shotTable.column_indexOfColumn(s);
                }
                if (recTable.column_exists(s)) {
                    conn.ReceiverColumnIndex = recTable.column_indexOfColumn(s);
                }
                list.add(conn);
            }
            int indexX = ensemble.dictionary().getEntryIndex(tableNameX, columnNameX);
            int indexY = ensemble.dictionary().getEntryIndex(tableNameY, columnNameY);
            int colRecX = recTable.column_indexOfColumn("Easting");
            int colRecY = recTable.column_indexOfColumn("Northing");
            int colRecDead = recTable.column_indexOfColumn("Killed");
            int colShotX = shotTable.column_indexOfColumn("Easting");
            int colShotY = shotTable.column_indexOfColumn("Northing");
            int colShotDead = shotTable.column_indexOfColumn("Killed");
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                double v;
                double w;
                double r;
                double dy;
                double dx;
                double yp;
                double xp;
                boolean killed;
                int k;
                for (InterpConnections conn : list) {
                    conn.Sum1 = 0.0;
                    conn.Sum2 = 1.0E-60;
                }
                Column_Abstract header = ensemble.trace(n).header();
                double x = header.getDouble(indexX);
                double y = header.getDouble(indexY);
                for (k = 0; k < recTable.row_count(); ++k) {
                    killed = recTable.getBool(k, colRecDead);
                    if (killed) continue;
                    xp = recTable.getDouble(k, colRecX);
                    yp = recTable.getDouble(k, colRecY);
                    dx = x - xp;
                    dy = y - yp;
                    r = dx * dx + dy * dy;
                    w = 1.0 / (1.0 + r);
                    for (InterpConnections conn : list) {
                        if (conn.ReceiverColumnIndex < 0) continue;
                        v = recTable.getDouble(k, conn.ReceiverColumnIndex);
                        conn.Sum1 += w * v;
                        conn.Sum2 += w;
                    }
                }
                for (k = 0; k < shotTable.row_count(); ++k) {
                    killed = shotTable.getBool(k, colShotDead);
                    if (killed) continue;
                    xp = shotTable.getDouble(k, colShotX);
                    yp = shotTable.getDouble(k, colShotY);
                    dx = x - xp;
                    dy = y - yp;
                    r = dx * dx + dy * dy;
                    w = 1.0 / (1.0 + r);
                    for (InterpConnections conn : list) {
                        if (conn.ShotColumnIndex < 0) continue;
                        v = shotTable.getDouble(k, conn.ShotColumnIndex);
                        conn.Sum1 += w * v;
                        conn.Sum2 += w;
                    }
                }
                for (InterpConnections conn : list) {
                    double v2 = conn.Sum1 / conn.Sum2;
                    header.putDouble(conn.EnsembleIndex, v2);
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static Range_Double getRange(String colName, boolean useShot, boolean useRec) {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            Range_Double range = new Range_Double();
            if (useShot && p.shotTable().column_exists(colName)) {
                p.shotTable().column_range(colName, range);
            }
            if (useRec && p.receiverTable().column_exists(colName)) {
                p.receiverTable().column_range(colName, range);
            }
            return range;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    public static void computeDistanceMoved(RefractionStaticsProject project) {
        try {
            Tools_RefractionStaticsProject.confirmColumn(project, "DistanceMoved", DataType.Double);
            Tools_RefractionStaticsProject.confirmColumn(project, "AzimuthMoved", DataType.Double);
            Tools_RefractionStaticsProject.computeDistanceMoved(project, "Shot");
            Tools_RefractionStaticsProject.computeDistanceMoved(project, "Receiver");
            project.reloadAllData();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static void computeDistanceMoved() {
        try {
            Tools_RefractionStaticsProject.computeDistanceMoved(RefractionStaticsProject.singleton());
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static void computeDistanceMoved(RefractionStaticsProject p, String tableName) {
        try {
            String sql = String.format("SELECT * FROM %s", tableName);
            Table_Abstract table = p.geometryDatabase().extractTableDataUsingQuery(tableName, sql, Pecos.MaxQueryRowCount);
            Tools_RefractionStaticsProject.computeDistanceMoved(table);
            p.geometryDatabase().writeColumnContentsToDatabase(table, "DistanceMoved");
            p.geometryDatabase().writeColumnContentsToDatabase(table, "AzimuthMoved");
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static void computeDistanceMoved(Table_Abstract table) {
        try {
            int indexX0 = table.column_indexOfColumn("InitialEasting");
            int indexY0 = table.column_indexOfColumn("InitialNorthing");
            int indexX1 = table.column_indexOfColumn("Easting");
            int indexY1 = table.column_indexOfColumn("Northing");
            int indexMoved = table.column_append("DistanceMoved", DataType.Double);
            int indexAz = table.column_append("AzimuthMoved", DataType.Double);
            for (int row = 0; row < table.row_count(); ++row) {
                double x0 = table.getDouble(row, indexX0);
                double x1 = table.getDouble(row, indexX1);
                double y0 = table.getDouble(row, indexY0);
                double y1 = table.getDouble(row, indexY1);
                double dx = x1 - x0;
                double dy = y1 - y0;
                double d = Math.sqrt(1.0E-20 + dx * dx + dy * dy);
                double az = 0.0;
                if (d >= 0.1) {
                    az = 180.0 * Math.atan2(dy, dx) / Math.PI;
                }
                table.putDouble(row, indexMoved, d);
                table.putDouble(row, indexAz, az);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static Java2D_Paintable_Table loadGeomPO(String tableName) {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            String sql = String.format("SELECT Easting, Northing, %sID FROM %s WHERE KILLED = FALSE", tableName, tableName);
            Table_Abstract table = p.geometryDatabase().extractTableDataUsingQuery(tableName, sql, Pecos.MaxQueryRowCount);
            Java2D_Paintable_Table painter = new Java2D_Paintable_Table();
            painter.setTable(table);
            painter.setAxisX("Easting");
            painter.setAxisY("Northing");
            painter.UseColorScale = false;
            painter.FixedColor = Color.BLACK;
            painter.Size_Pixel = 3;
            return painter;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    public static Java2D_Paintable_Table loadGeomPO(String tableName, int size, Color color) {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            String sql = String.format("SELECT Easting, Northing, %sID FROM %s WHERE KILLED = FALSE", tableName, tableName);
            Table_Abstract table = p.geometryDatabase().extractTableDataUsingQuery(tableName, sql, Pecos.MaxQueryRowCount);
            Java2D_Paintable_Table painter = new Java2D_Paintable_Table();
            painter.setTable(table);
            painter.setAxisX("Easting");
            painter.setAxisY("Northing");
            painter.UseColorScale = false;
            painter.FixedColor = Color.BLACK;
            painter.Size_Pixel = 3;
            return painter;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    public static Java2D_Paintable_Table loadGeomPO(String tableName, String colName) {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            String sql = String.format("SELECT Easting, Northing, %s, %sID FROM %s WHERE KILLED = FALSE", colName, tableName, tableName);
            Table_Abstract table = p.geometryDatabase().extractTableDataUsingQuery(tableName, sql, Pecos.MaxQueryRowCount);
            Java2D_Paintable_Table painter = new Java2D_Paintable_Table();
            painter.setTable(table);
            painter.setAxisX("Easting");
            painter.setAxisY("Northing");
            painter.setAxisC(colName);
            painter.UseColorScale = true;
            painter.FixedColor = Color.BLACK;
            painter.Size_Pixel = 3;
            painter.Symbol = Java2D_PointSymbol.FilledSquare;
            painter.Size_UsePixel = false;
            painter.Size_World = p.units_feet() ? 80.0 : 25.0;
            return painter;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    public static boolean columnExists(String columnName, boolean checkShot, boolean checkRec) {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            boolean shotOK = true;
            boolean recOK = true;
            if (checkRec) {
                recOK = p.receiverTable().column_exists(columnName);
            }
            if (checkShot) {
                shotOK = p.shotTable().column_exists(columnName);
            }
            return shotOK && recOK;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    public static void tieColumnAverage(String sourceColumnName, String modifiedColumnName, double min, double max) throws Exception {
        try {
            double sourceAverage = Tools_RefractionStaticsProject.computeAverage(sourceColumnName, min, max);
            double modAverage = Tools_RefractionStaticsProject.computeAverage(modifiedColumnName, min, max);
            double shift = sourceAverage - modAverage;
            String sql = String.format("UPDATE SHOT SET %s = %s + %f WHERE KILLED = FALSE", modifiedColumnName, modifiedColumnName, Float.valueOf((float)shift));
            RefractionStaticsProject.singleton().geometryDatabase().executeUpdateStatement(sql);
            sql = String.format("UPDATE RECEIVER SET %s = %s + %f WHERE KILLED = FALSE", modifiedColumnName, modifiedColumnName, Float.valueOf((float)shift));
            RefractionStaticsProject.singleton().geometryDatabase().executeUpdateStatement(sql);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public static double computeAverage(String columnName, double min, double max) throws Exception {
        try {
            double v;
            boolean dead;
            int row;
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            double sum = 0.0;
            double count = 1.0E-5;
            Table_Abstract table = p.receiverTable();
            int indexDead = -9999;
            if (table.column_exists("Killed")) {
                indexDead = table.column_indexOfColumn("Killed");
            }
            int indexV = table.column_indexOfColumn(columnName);
            for (row = 0; row < table.row_count(); ++row) {
                dead = false;
                if (indexDead >= 0) {
                    dead = table.getBool(row, indexDead);
                }
                if (dead || !((v = table.getDouble(row, indexV)) >= min) || !(v <= max)) continue;
                sum += v;
                count += 1.0;
            }
            table = p.shotTable();
            indexDead = -9999;
            if (table.column_exists("Killed")) {
                indexDead = table.column_indexOfColumn("Killed");
            }
            indexV = table.column_indexOfColumn(columnName);
            for (row = 0; row < table.row_count(); ++row) {
                dead = false;
                if (indexDead >= 0) {
                    dead = table.getBool(row, indexDead);
                }
                if (dead || !((v = table.getDouble(row, indexV)) >= min) || !(v <= max)) continue;
                sum += v;
                count += 1.0;
            }
            return sum / count;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return 0.0;
        }
    }

    public static void clipColumn(String columnName, double min, double max, PolygonUsage polyUsage) throws Exception {
        try {
            Table_Abstract shotTable = RefractionStaticsProject.singleton().shotTable();
            Table_Abstract recTable = RefractionStaticsProject.singleton().receiverTable();
            IDatabaseConnection database = RefractionStaticsProject.singleton().geometryDatabase();
            Tools_RefractionStaticsProject.clipColumn(columnName, min, max, polyUsage, shotTable, recTable, database);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static void clipColumn(String columnName, double min, double max, PolygonUsage polyUsage, Table_Abstract shotTable, Table_Abstract recTable, IDatabaseConnection database) throws Exception {
        try {
            boolean ok;
            double v;
            double y;
            double x;
            int row;
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            Java2D_Polygon poly = p.polygon();
            if (!poly.valid() && polyUsage != PolygonUsage.NotUsed) {
                throw new Exception("poly.valid() == false");
            }
            boolean inside = poly.valid() && polyUsage == PolygonUsage.Inside;
            boolean outside = poly.valid() && polyUsage == PolygonUsage.Outside;
            Table_Abstract table = recTable;
            int indexX = table.column_indexOfColumn("Easting");
            int indexY = table.column_indexOfColumn("Northing");
            int indexV = table.column_indexOfColumn(columnName);
            for (row = 0; row < table.row_count(); ++row) {
                x = table.getDouble(row, indexX);
                y = table.getDouble(row, indexY);
                v = table.getDouble(row, indexV);
                ok = true;
                if (inside) {
                    boolean bl = ok = poly.contains(x, y);
                }
                if (outside) {
                    boolean bl = ok = !poly.contains(x, y);
                }
                if (!ok) continue;
                if (v < min) {
                    table.putDouble(row, indexV, min);
                }
                if (!(v > max)) continue;
                table.putDouble(row, indexV, max);
            }
            database.writeColumnContentsToDatabase(table, columnName);
            table = shotTable;
            indexX = table.column_indexOfColumn("Easting");
            indexY = table.column_indexOfColumn("Northing");
            indexV = table.column_indexOfColumn(columnName);
            for (row = 0; row < table.row_count(); ++row) {
                x = table.getDouble(row, indexX);
                y = table.getDouble(row, indexY);
                v = table.getDouble(row, indexV);
                ok = true;
                if (inside) {
                    boolean bl = ok = poly.contains(x, y);
                }
                if (outside) {
                    boolean bl = ok = !poly.contains(x, y);
                }
                if (!ok) continue;
                if (v < min) {
                    table.putDouble(row, indexV, min);
                }
                if (!(v > max)) continue;
                table.putDouble(row, indexV, max);
            }
            database.writeColumnContentsToDatabase(table, columnName);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public static void selectNearestReceiver(double x, double y) throws Exception {
        try {
            Table_Abstract table = RefractionStaticsProject.singleton().receiverTable();
            int indexX = table.column_indexOfColumn("Easting");
            int indexY = table.column_indexOfColumn("Northing");
            int indexK = table.column_indexOfColumn("Killed");
            int indexID = table.column_indexOfColumn("ReceiverID");
            double minDist = Double.MAX_VALUE;
            int id = -9999;
            for (int row = 0; row < table.row_count(); ++row) {
                double dy;
                double dx;
                double d2;
                double x1 = table.getDouble(row, indexX);
                double y1 = table.getDouble(row, indexY);
                boolean killed = table.getBool(row, indexK);
                if (killed || !((d2 = (dx = x - x1) * dx + (dy = y - y1) * dy) < minDist)) continue;
                minDist = d2;
                id = table.getInt(row, indexID);
            }
            if (id >= 0) {
                Messenger.broadcastReceiverSelected(null, id);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public static void selectNearestShot(double x, double y) throws Exception {
        try {
            Table_Abstract table = RefractionStaticsProject.singleton().shotTable();
            int indexX = table.column_indexOfColumn("Easting");
            int indexY = table.column_indexOfColumn("Northing");
            int indexK = table.column_indexOfColumn("Killed");
            int indexID = table.column_indexOfColumn("ShotID");
            double minDist = Double.MAX_VALUE;
            int id = -9999;
            for (int row = 0; row < table.row_count(); ++row) {
                double dy;
                double dx;
                double d2;
                double x1 = table.getDouble(row, indexX);
                double y1 = table.getDouble(row, indexY);
                boolean killed = table.getBool(row, indexK);
                if (killed || !((d2 = (dx = x - x1) * dx + (dy = y - y1) * dy) < minDist)) continue;
                minDist = d2;
                id = table.getInt(row, indexID);
            }
            if (id >= 0) {
                Messenger.broadcastShotSelected(null, id);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public static void setColumnToConstant(String columnName, double val, PolygonUsage polyUsage) throws Exception {
        try {
            Table_Abstract shotTable = RefractionStaticsProject.singleton().shotTable();
            Table_Abstract recTable = RefractionStaticsProject.singleton().receiverTable();
            IDatabaseConnection database = RefractionStaticsProject.singleton().geometryDatabase();
            Tools_RefractionStaticsProject.setColumnToConstant(columnName, val, polyUsage, shotTable, recTable, database);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public static void setColumnToConstant(String columnName, double val, PolygonUsage polyUsage, Table_Abstract shotTable, Table_Abstract recTable, IDatabaseConnection database) throws Exception {
        try {
            boolean ok;
            double y;
            double x;
            int row;
            Java2D_Polygon poly = RefractionStaticsProject.singleton().polygon();
            if (!poly.valid() && polyUsage != PolygonUsage.NotUsed) {
                throw new Exception("poly.valid() == false");
            }
            boolean inside = poly.valid() && polyUsage == PolygonUsage.Inside;
            boolean outside = poly.valid() && polyUsage == PolygonUsage.Outside;
            Table_Abstract table = recTable;
            int indexX = table.column_indexOfColumn("Easting");
            int indexY = table.column_indexOfColumn("Northing");
            int indexV = table.column_append(columnName, DataType.Double);
            for (row = 0; row < table.row_count(); ++row) {
                x = table.getDouble(row, indexX);
                y = table.getDouble(row, indexY);
                ok = true;
                if (inside) {
                    boolean bl = ok = poly.contains(x, y);
                }
                if (outside) {
                    boolean bl = ok = !poly.contains(x, y);
                }
                if (!ok) continue;
                table.putDouble(row, indexV, val);
            }
            database.writeColumnContentsToDatabase(table, columnName);
            table = shotTable;
            indexX = table.column_indexOfColumn("Easting");
            indexY = table.column_indexOfColumn("Northing");
            indexV = table.column_append(columnName, DataType.Double);
            for (row = 0; row < table.row_count(); ++row) {
                x = table.getDouble(row, indexX);
                y = table.getDouble(row, indexY);
                ok = true;
                if (inside) {
                    boolean bl = ok = poly.contains(x, y);
                }
                if (outside) {
                    boolean bl = ok = !poly.contains(x, y);
                }
                if (!ok) continue;
                table.putDouble(row, indexV, val);
            }
            database.writeColumnContentsToDatabase(table, columnName);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public static void prepPolygonStatus(Table_Abstract table) throws Exception {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            Java2D_Polygon poly = p.polygon();
            if (!poly.valid()) {
                return;
            }
            int indexX = table.column_indexOfColumn("Easting");
            int indexY = table.column_indexOfColumn("Northing");
            int indexInside = table.column_append("Inside", DataType.Bool);
            for (int row = 0; row < table.row_count(); ++row) {
                table.putBool(row, indexInside, false);
                if (!poly.valid()) continue;
                double x = table.getDouble(row, indexX);
                double y = table.getDouble(row, indexY);
                table.putBool(row, indexInside, poly.contains(x, y));
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public static void cutAndRepairUsingPolygon(String columnName, PolygonUsage polyUsage) throws Exception {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            Table_Abstract recTable = p.receiverTable();
            Table_Abstract shotTable = p.shotTable();
            IDatabaseConnection database = p.geometryDatabase();
            Tools_RefractionStaticsProject.cutAndRepairUsingPolygon(columnName, polyUsage, shotTable, recTable, database);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public static void cutAndRepairUsingPolygon(String columnName, PolygonUsage polyUsage, Table_Abstract shotTable, Table_Abstract recTable, IDatabaseConnection database) throws Exception {
        try {
            double v1;
            double w;
            double v;
            double dy;
            double dx;
            boolean dead;
            boolean inside;
            double y;
            double x;
            double sum2;
            double sum1;
            int row;
            Tools_RefractionStaticsProject.prepPolygonStatus(recTable);
            Tools_RefractionStaticsProject.prepPolygonStatus(shotTable);
            int indexShotX = shotTable.column_indexOfColumn("Easting");
            int indexShotY = shotTable.column_indexOfColumn("Northing");
            int indexShotKilled = shotTable.column_indexOfColumn("Killed");
            int indexShotCol = shotTable.column_indexOfColumn(columnName);
            int indexShotInside = shotTable.column_append("Inside", DataType.Bool);
            int indexRecX = recTable.column_indexOfColumn("Easting");
            int indexRecY = recTable.column_indexOfColumn("Northing");
            int indexRecKilled = recTable.column_indexOfColumn("Killed");
            int indexRecCol = recTable.column_indexOfColumn(columnName);
            int indexRecInside = recTable.column_append("Inside", DataType.Bool);
            if (polyUsage == PolygonUsage.NotUsed) {
                return;
            }
            if (polyUsage == PolygonUsage.Outside) {
                for (row = 0; row < shotTable.row_count(); ++row) {
                    int r;
                    if (shotTable.getBool(row, indexShotInside)) continue;
                    sum1 = 0.0;
                    sum2 = 1.0E-50;
                    x = shotTable.getDouble(row, indexShotX);
                    y = shotTable.getDouble(row, indexShotY);
                    for (r = 0; r < recTable.row_count(); ++r) {
                        inside = recTable.getBool(r, indexRecInside);
                        dead = recTable.getBool(r, indexRecKilled);
                        if (dead || !inside) continue;
                        dx = x - recTable.getDouble(r, indexRecX);
                        dy = y - recTable.getDouble(r, indexRecY);
                        v = recTable.getDouble(r, indexRecCol);
                        w = 1.0 / (1.0 + dx * dx + dy * dy);
                        w *= w;
                        sum1 += v * w;
                        sum2 += w;
                    }
                    for (r = 0; r < shotTable.row_count(); ++r) {
                        inside = shotTable.getBool(r, indexShotInside);
                        dead = shotTable.getBool(r, indexShotKilled);
                        if (dead || !inside) continue;
                        dx = x - shotTable.getDouble(r, indexShotX);
                        dy = y - shotTable.getDouble(r, indexShotY);
                        v = shotTable.getDouble(r, indexShotCol);
                        w = 1.0 / (1.0 + dx * dx + dy * dy);
                        w *= w;
                        sum1 += v * w;
                        sum2 += w;
                    }
                    v1 = sum1 / sum2;
                    shotTable.putDouble(row, indexShotCol, v1);
                }
                for (row = 0; row < recTable.row_count(); ++row) {
                    int r;
                    if (recTable.getBool(row, indexRecInside)) continue;
                    sum1 = 0.0;
                    sum2 = 1.0E-50;
                    x = recTable.getDouble(row, indexRecX);
                    y = recTable.getDouble(row, indexRecY);
                    for (r = 0; r < recTable.row_count(); ++r) {
                        inside = recTable.getBool(r, indexRecInside);
                        dead = recTable.getBool(r, indexRecKilled);
                        if (dead || !inside) continue;
                        dx = x - recTable.getDouble(r, indexRecX);
                        dy = y - recTable.getDouble(r, indexRecY);
                        v = recTable.getDouble(r, indexRecCol);
                        w = 1.0 / (1.0 + dx * dx + dy * dy);
                        w *= w;
                        sum1 += v * w;
                        sum2 += w;
                    }
                    for (r = 0; r < shotTable.row_count(); ++r) {
                        inside = shotTable.getBool(r, indexShotInside);
                        dead = shotTable.getBool(r, indexShotKilled);
                        if (dead || !inside) continue;
                        dx = x - shotTable.getDouble(r, indexShotX);
                        dy = y - shotTable.getDouble(r, indexShotY);
                        v = shotTable.getDouble(r, indexShotCol);
                        w = 1.0 / (1.0 + dx * dx + dy * dy);
                        w *= w;
                        sum1 += v * w;
                        sum2 += w;
                    }
                    v1 = sum1 / sum2;
                    recTable.putDouble(row, indexRecCol, v1);
                }
            }
            if (polyUsage == PolygonUsage.Inside) {
                for (row = 0; row < shotTable.row_count(); ++row) {
                    int r;
                    if (!shotTable.getBool(row, indexShotInside)) continue;
                    sum1 = 0.0;
                    sum2 = 1.0E-50;
                    x = shotTable.getDouble(row, indexShotX);
                    y = shotTable.getDouble(row, indexShotY);
                    for (r = 0; r < recTable.row_count(); ++r) {
                        inside = recTable.getBool(r, indexRecInside);
                        dead = recTable.getBool(r, indexRecKilled);
                        if (dead || inside) continue;
                        dx = x - recTable.getDouble(r, indexRecX);
                        dy = y - recTable.getDouble(r, indexRecY);
                        v = recTable.getDouble(r, indexRecCol);
                        w = 1.0 / (1.0 + dx * dx + dy * dy);
                        w *= w;
                        sum1 += v * w;
                        sum2 += w;
                    }
                    for (r = 0; r < shotTable.row_count(); ++r) {
                        inside = shotTable.getBool(r, indexShotInside);
                        dead = shotTable.getBool(r, indexShotKilled);
                        if (dead || inside) continue;
                        dx = x - shotTable.getDouble(r, indexShotX);
                        dy = y - shotTable.getDouble(r, indexShotY);
                        v = shotTable.getDouble(r, indexShotCol);
                        w = 1.0 / (1.0 + dx * dx + dy * dy);
                        w *= w;
                        sum1 += v * w;
                        sum2 += w;
                    }
                    v1 = sum1 / sum2;
                    shotTable.putDouble(row, indexShotCol, v1);
                }
                for (row = 0; row < recTable.row_count(); ++row) {
                    int r;
                    if (!recTable.getBool(row, indexRecInside)) continue;
                    sum1 = 0.0;
                    sum2 = 1.0E-50;
                    x = recTable.getDouble(row, indexRecX);
                    y = recTable.getDouble(row, indexRecY);
                    for (r = 0; r < recTable.row_count(); ++r) {
                        inside = recTable.getBool(r, indexRecInside);
                        dead = recTable.getBool(r, indexRecKilled);
                        if (dead || inside) continue;
                        dx = x - recTable.getDouble(r, indexRecX);
                        dy = y - recTable.getDouble(r, indexRecY);
                        v = recTable.getDouble(r, indexRecCol);
                        w = 1.0 / (1.0 + dx * dx + dy * dy);
                        w *= w;
                        sum1 += v * w;
                        sum2 += w;
                    }
                    for (r = 0; r < shotTable.row_count(); ++r) {
                        inside = shotTable.getBool(r, indexShotInside);
                        dead = shotTable.getBool(r, indexShotKilled);
                        if (dead || inside) continue;
                        dx = x - shotTable.getDouble(r, indexShotX);
                        dy = y - shotTable.getDouble(r, indexShotY);
                        v = shotTable.getDouble(r, indexShotCol);
                        w = 1.0 / (1.0 + dx * dx + dy * dy);
                        w *= w;
                        sum1 += v * w;
                        sum2 += w;
                    }
                    v1 = sum1 / sum2;
                    recTable.putDouble(row, indexRecCol, v1);
                }
            }
            database.writeColumnContentsToDatabase(recTable, columnName);
            database.writeColumnContentsToDatabase(shotTable, columnName);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public static void smoothColumn(String columnName, double minValidValue, double smoothRadius, PolygonUsage polyUsage, String weightColumn) throws Exception {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            IDatabaseConnection database = p.geometryDatabase();
            Table_Abstract shotTable = p.shotTable();
            Table_Abstract recTable = p.receiverTable();
            Tools_RefractionStaticsProject.smoothColumn(columnName, minValidValue, smoothRadius, polyUsage, weightColumn, shotTable, recTable, database);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public static void smoothColumn(String columnName, double minValidValue, double smoothRadius, PolygonUsage polyUsage, String weightColumn, Table_Abstract shotTable, Table_Abstract recTable, IDatabaseConnection database) throws Exception {
        try {
            double smoothGridSize = smoothRadius / 10.0;
            ProjectGridAnalyzer gridAnalysis = new ProjectGridAnalyzer(smoothGridSize);
            gridAnalysis.prepareForInterpolation(columnName, (float)minValidValue, true, weightColumn, shotTable, recTable);
            gridAnalysis.smooth(polyUsage, smoothRadius);
            gridAnalysis.fromGridToTable(columnName, recTable, polyUsage);
            database.writeColumnContentsToDatabase(recTable, columnName);
            gridAnalysis.fromGridToTable(columnName, shotTable, polyUsage);
            database.writeColumnContentsToDatabase(shotTable, columnName);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public static void computeV0UsingSimpleUphole(double min, double max) {
        try {
            double w;
            double v0;
            double dy;
            double dx;
            int index;
            int r;
            double s2;
            double s1;
            double y;
            double x;
            int n;
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            Table_Abstract shotTable = p.shotTable();
            Table_Abstract recTable = p.receiverTable();
            int indexShotV0 = shotTable.column_append(Pecos.getColNameVel(0), DataType.Double);
            int indexShotX = shotTable.column_indexOfColumn("Easting");
            int indexShotY = shotTable.column_indexOfColumn("Northing");
            int indexUphole = shotTable.column_indexOfColumn("UpholeTime");
            int indexDepth = shotTable.column_indexOfColumn("PointDepth");
            int indexShotKilled = shotTable.column_indexOfColumn("Killed");
            int indexRecV0 = recTable.column_append(Pecos.getColNameVel(0), DataType.Double);
            int indexRecX = recTable.column_indexOfColumn("Easting");
            int indexRecY = recTable.column_indexOfColumn("Northing");
            Column_Int indices = new Column_Int();
            int count = 0;
            for (n = 0; n < shotTable.row_count(); ++n) {
                if (shotTable.getBool(n, indexShotKilled)) continue;
                double uphole = shotTable.getDouble(n, indexUphole);
                double depth = shotTable.getDouble(n, indexDepth);
                if (!(uphole >= 1.0) || !(depth >= 1.0)) continue;
                double v02 = 1000.0 * depth / uphole;
                v02 = Math.max(v02, min);
                v02 = Math.min(v02, max);
                shotTable.putDouble(n, indexShotV0, v02);
                indices.putInt(count, n);
                ++count;
            }
            if (count < 1) {
                return;
            }
            for (n = 0; n < shotTable.row_count(); ++n) {
                x = shotTable.getDouble(n, indexShotX);
                y = shotTable.getDouble(n, indexShotY);
                s1 = 0.0;
                s2 = 1.0E-30;
                for (r = 0; r < count; ++r) {
                    index = indices.getInt(r);
                    dx = x - shotTable.getDouble(index, indexShotX);
                    dy = y - shotTable.getDouble(index, indexShotY);
                    v0 = shotTable.getDouble(index, indexShotV0);
                    w = 0.1 / (0.1 + dx * dx + dy * dy);
                    s1 += v0 * w;
                    s2 += w;
                }
                shotTable.putDouble(n, indexShotV0, s1 / s2);
            }
            for (n = 0; n < recTable.row_count(); ++n) {
                x = recTable.getDouble(n, indexRecX);
                y = recTable.getDouble(n, indexRecY);
                s1 = 0.0;
                s2 = 1.0E-30;
                for (r = 0; r < count; ++r) {
                    index = indices.getInt(r);
                    dx = x - shotTable.getDouble(index, indexShotX);
                    dy = y - shotTable.getDouble(index, indexShotY);
                    v0 = shotTable.getDouble(index, indexShotV0);
                    w = 0.1 / (0.1 + dx * dx + dy * dy);
                    s1 += v0 * w;
                    s2 += w;
                }
                recTable.putDouble(n, indexRecV0, s1 / s2);
            }
            p.geometryDatabase().writeColumnContentsToDatabase(recTable, Pecos.getColNameVel(0));
            p.geometryDatabase().writeColumnContentsToDatabase(shotTable, Pecos.getColNameVel(0));
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public static void computeV0UsingUpholeModel(double min, double max) {
        try {
            double w;
            double v0;
            double dy;
            double dx;
            int i;
            double s2;
            double s1;
            double y;
            double x;
            int n;
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            Table_Abstract shotTable = p.shotTable();
            Table_Abstract recTable = p.receiverTable();
            int indexShotV0 = shotTable.column_append(Pecos.getColNameVel(0), DataType.Double);
            int indexShotX = shotTable.column_indexOfColumn("Easting");
            int indexShotY = shotTable.column_indexOfColumn("Northing");
            int indexRecV0 = recTable.column_append(Pecos.getColNameVel(0), DataType.Double);
            int indexRecX = recTable.column_indexOfColumn("Easting");
            int indexRecY = recTable.column_indexOfColumn("Northing");
            if (RefractionStaticsProject.singleton().getUphole() == null) {
                return;
            }
            UpholeModel uphole = RefractionStaticsProject.singleton().getUphole();
            for (n = 0; n < shotTable.row_count(); ++n) {
                x = shotTable.getDouble(n, indexShotX);
                y = shotTable.getDouble(n, indexShotY);
                s1 = 0.0;
                s2 = 1.0E-30;
                for (i = 0; i < uphole.getRowCount(); ++i) {
                    dx = x - uphole.getX(i);
                    dy = y - uphole.getY(i);
                    v0 = uphole.getVelocity(i, 0);
                    w = 0.1 / (0.1 + dx * dx + dy * dy);
                    s1 += v0 * w;
                    s2 += w;
                }
                shotTable.putDouble(n, indexShotV0, s1 / s2);
            }
            for (n = 0; n < recTable.row_count(); ++n) {
                x = recTable.getDouble(n, indexRecX);
                y = recTable.getDouble(n, indexRecY);
                s1 = 0.0;
                s2 = 1.0E-30;
                for (i = 0; i < uphole.getRowCount(); ++i) {
                    dx = x - uphole.getX(i);
                    dy = y - uphole.getY(i);
                    v0 = uphole.getVelocity(i, 0);
                    w = 0.1 / (0.1 + dx * dx + dy * dy);
                    s1 += v0 * w;
                    s2 += w;
                }
                recTable.putDouble(n, indexRecV0, s1 / s2);
            }
            p.geometryDatabase().writeColumnContentsToDatabase(recTable, Pecos.getColNameVel(0));
            p.geometryDatabase().writeColumnContentsToDatabase(shotTable, Pecos.getColNameVel(0));
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public static void smoothColumn(String columnName, double minValidValue, double smoothRadius, PolygonUsage polyUsage) throws Exception {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            IDatabaseConnection database = p.geometryDatabase();
            Table_Abstract shotTable = p.shotTable();
            Table_Abstract recTable = p.receiverTable();
            Tools_RefractionStaticsProject.smoothColumn(columnName, minValidValue, smoothRadius, polyUsage, shotTable, recTable, database);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public static void smoothColumn(String columnName, double minValidValue, double smoothRadius, PolygonUsage polyUsage, Table_Abstract srcTable, Table_Abstract recTable, IDatabaseConnection database) throws Exception {
        try {
            double smoothGridSize = smoothRadius / 10.0;
            smoothGridSize = Math.min(smoothGridSize, 100000.0);
            ProjectGridAnalyzer gridAnalysis = new ProjectGridAnalyzer(smoothGridSize);
            gridAnalysis.prepareForInterpolation(columnName, (float)minValidValue, false, "", srcTable, recTable);
            gridAnalysis.smooth(polyUsage, smoothRadius);
            gridAnalysis.fromGridToTable(columnName, recTable, polyUsage);
            database.writeColumnContentsToDatabase(recTable, columnName);
            gridAnalysis.fromGridToTable(columnName, srcTable, polyUsage);
            database.writeColumnContentsToDatabase(srcTable, columnName);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public static void addTableToGrid(Grid3D grid, String column, Table_Abstract table) throws Exception {
        try {
            int indexX = table.column_indexOfColumn("Easting");
            int indexY = table.column_indexOfColumn("Northing");
            int indexV = -9999;
            if (table.column_exists(column)) {
                indexV = table.column_indexOfColumn(column);
            }
            int indexKilled = table.column_indexOfColumn("Killed");
            if (indexV >= 0) {
                for (int row = 0; row < table.row_count(); ++row) {
                    if (table.getBool(row, indexKilled)) continue;
                    double x = table.getDouble(row, indexX);
                    double y = table.getDouble(row, indexY);
                    double v = table.getDouble(row, indexV);
                    grid.interp_Add(x, y, (float)v, 1.0f);
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public static void interpolateGrid(Grid3D grid, String column) throws Exception {
        try {
            Tools_RefractionStaticsProject.interpolateGrid(grid, column, 7);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public static void interpolateGrid(Grid3D grid, String column, int smoothRad) throws Exception {
        try {
            Tools_RefractionStaticsProject.interpolateGrid(grid, column, smoothRad, true, true);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public static void interpolateGrid(Grid3D grid, String column, int smoothRad, boolean useShot, boolean useRec) throws Exception {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            Table_Abstract recTable = p.receiverTable();
            Table_Abstract shotTable = p.shotTable();
            grid.interp_Prep();
            if (useShot) {
                Tools_RefractionStaticsProject.addTableToGrid(grid, column, shotTable);
            }
            if (useRec) {
                Tools_RefractionStaticsProject.addTableToGrid(grid, column, recTable);
            }
            grid.interp_Finish(smoothRad, true);
            grid.interp_Free();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public static Grid3D getInterpolatedGrid(double buffer, double gridSize, String column, boolean computeBestAngle) throws Exception {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            Grid3D grid = null;
            if (computeBestAngle) {
                double bestAngle = Tools_RefractionStaticsProject.findMinimumSurveyAreaAngle(p.shotTable(), p.receiverTable());
                Grid3D_Conversion gridCon = new Grid3D_Conversion();
                gridCon.setInlineAngle(bestAngle);
                gridCon.setBinSize(gridSize, gridSize);
                Tools_RefractionStaticsProject.gridRange3D(gridCon, buffer);
                grid = new Grid3D(gridCon);
            } else {
                grid = p.getEmptyGrid3D(buffer, gridSize, gridSize);
            }
            Tools_RefractionStaticsProject.interpolateGrid(grid, column);
            return grid;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public static Grid3D getExactGrid(double buffer, double gridSize, String column) throws Exception {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            Grid3D grid = p.getEmptyGrid3D(buffer, gridSize, gridSize);
            Table_Abstract recTable = p.receiverTable();
            Table_Abstract shotTable = p.shotTable();
            int indexShotX = shotTable.column_indexOfColumn("Easting");
            int indexShotY = shotTable.column_indexOfColumn("Northing");
            int indexShotV = -9999;
            if (shotTable.column_exists(column)) {
                indexShotV = shotTable.column_indexOfColumn(column);
            }
            int indexShotKilled = shotTable.column_indexOfColumn("Killed");
            int indexRecX = recTable.column_indexOfColumn("Easting");
            int indexRecY = recTable.column_indexOfColumn("Northing");
            int indexRecV = -9999;
            if (recTable.column_exists(column)) {
                indexRecV = recTable.column_indexOfColumn(column);
            }
            int indexRecKilled = recTable.column_indexOfColumn("Killed");
            float[][] data = grid.data();
            for (int i = 0; i < grid.numInline(); ++i) {
                System.out.println("getExactGrid " + i);
                for (int c = 0; c < grid.numCrossline(); ++c) {
                    double w;
                    double dy;
                    double dx;
                    double v;
                    double y;
                    double x;
                    int row;
                    double gx = grid.getWorldX_Indices(i, c);
                    double gy = grid.getWorldY_Indices(i, c);
                    double sum1 = 0.0;
                    double sum2 = 1.0E-80;
                    if (indexRecV >= 0) {
                        for (row = 0; row < recTable.row_count(); ++row) {
                            if (recTable.getBool(row, indexRecKilled)) continue;
                            x = recTable.getDouble(row, indexRecX);
                            y = recTable.getDouble(row, indexRecY);
                            v = recTable.getDouble(row, indexRecV);
                            dx = x - gx;
                            dy = y - gy;
                            w = gridSize / (gridSize + dx * dx + dy * dy);
                            w *= w;
                            sum1 += w * v;
                            sum2 += w;
                        }
                    }
                    if (indexShotV >= 0) {
                        for (row = 0; row < shotTable.row_count(); ++row) {
                            if (shotTable.getBool(row, indexShotKilled)) continue;
                            x = shotTable.getDouble(row, indexShotX);
                            y = shotTable.getDouble(row, indexShotY);
                            v = shotTable.getDouble(row, indexShotV);
                            dx = x - gx;
                            dy = y - gy;
                            w = gridSize / (gridSize + dx * dx + dy * dy);
                            w *= w;
                            sum1 += w * v;
                            sum2 += w;
                        }
                    }
                    data[i][c] = (float)(sum1 / sum2);
                }
            }
            return grid;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public static Interpolator_EmptyGrid getInterpolator_EmptyGrid(String columnName, double bin_size) throws Exception {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            return new Interpolator_EmptyGrid(p.shotTable(), p.receiverTable(), columnName, bin_size);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public static InversePowerInterpolator getInversePowerInterpolator(String columnName, String colNameWeight, double smoothRadius, boolean inverseSquare) throws Exception {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            Table_Abstract recTable = p.receiverTable();
            Table_Abstract shtTable = p.shotTable();
            int num = recTable.row_count() + shtTable.row_count() + 20;
            InversePowerInterpolator interp = new InversePowerInterpolator(smoothRadius, num);
            interp.add(shtTable, columnName, colNameWeight);
            interp.add(recTable, columnName, colNameWeight);
            return interp;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public static void smoothColumn_InversePower(String columnName, String colNameWeight, double smoothRadius, boolean inverseSquare) throws Exception {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            Table_Abstract recTable = p.receiverTable();
            Table_Abstract shtTable = p.shotTable();
            int num = recTable.row_count() + shtTable.row_count() + 20;
            InversePowerInterpolator interp = new InversePowerInterpolator(smoothRadius, num);
            interp.add(shtTable, columnName, colNameWeight);
            interp.add(recTable, columnName, colNameWeight);
            interp.get(shtTable, columnName, inverseSquare);
            interp.get(recTable, columnName, inverseSquare);
            p.geometryDatabase().writeColumnContentsToDatabase(shtTable, columnName);
            p.geometryDatabase().writeColumnContentsToDatabase(recTable, columnName);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public static void smoothColumn(String columnName, String colNameWeight, int smoothRadius, boolean saveToDatabase) throws Exception {
        try {
            double v;
            double w;
            double y;
            double x;
            int n;
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            Grid3D smoother = p.getSmootherGrid();
            smoother.interp_ZeroArrays();
            Table_Abstract table = p.receiverTable();
            int indexX = table.column_indexOfColumn("Easting");
            int indexY = table.column_indexOfColumn("Northing");
            int indexV = table.column_indexOfColumn(columnName);
            int indexW = -9999;
            if (colNameWeight != null) {
                indexW = table.column_indexOfColumn(colNameWeight);
            }
            for (n = 0; n < table.row_count(); ++n) {
                x = table.getDouble(n, indexX);
                y = table.getDouble(n, indexY);
                w = 1.0;
                v = table.getDouble(n, indexY);
                smoother.interp_Add(x, y, (float)v, (float)w);
            }
            table = p.shotTable();
            indexX = table.column_indexOfColumn("Easting");
            indexY = table.column_indexOfColumn("Northing");
            indexV = table.column_indexOfColumn(columnName);
            indexW = -9999;
            if (colNameWeight != null) {
                indexW = table.column_indexOfColumn(colNameWeight);
            }
            for (n = 0; n < table.row_count(); ++n) {
                x = table.getDouble(n, indexX);
                y = table.getDouble(n, indexY);
                w = 1.0;
                v = table.getDouble(n, indexY);
                smoother.interp_Add(x, y, (float)v, (float)w);
            }
            smoother.interp_Finish(smoothRadius);
            table = p.receiverTable();
            indexX = table.column_indexOfColumn("Easting");
            indexY = table.column_indexOfColumn("Northing");
            indexV = table.column_indexOfColumn(columnName);
            for (n = 0; n < table.row_count(); ++n) {
                x = table.getDouble(n, indexX);
                y = table.getDouble(n, indexY);
                float v2 = smoother.getNearestValue(x, y);
                table.putDouble(n, indexV, v2);
            }
            table = p.shotTable();
            indexX = table.column_indexOfColumn("Easting");
            indexY = table.column_indexOfColumn("Northing");
            indexV = table.column_indexOfColumn(columnName);
            for (n = 0; n < table.row_count(); ++n) {
                x = table.getDouble(n, indexX);
                y = table.getDouble(n, indexY);
                float v3 = smoother.getNearestValue(x, y);
                table.putDouble(n, indexV, v3);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public static void gridRange2D(IGrid2D_Conversion grid, double buffer) throws Exception {
        try {
            double y;
            double x;
            int n;
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            grid.prepareRangeFinder();
            Table_Abstract table = p.receiverTable();
            int indexX = table.column_indexOfColumn("Easting");
            int indexY = table.column_indexOfColumn("Northing");
            int indexKilled = table.column_indexOfColumn("Killed");
            for (n = 0; n < table.row_count(); ++n) {
                if (table.getBool(n, indexKilled)) continue;
                x = table.getDouble(n, indexX);
                y = table.getDouble(n, indexY);
                grid.addToRangeFinder(x, y, buffer);
            }
            table = p.shotTable();
            indexX = table.column_indexOfColumn("Easting");
            indexY = table.column_indexOfColumn("Northing");
            indexKilled = table.column_indexOfColumn("Killed");
            for (n = 0; n < table.row_count(); ++n) {
                if (table.getBool(n, indexKilled)) continue;
                x = table.getDouble(n, indexX);
                y = table.getDouble(n, indexY);
                grid.addToRangeFinder(x, y, buffer);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public static void gridRange2D(IGrid2D_Conversion grid) throws Exception {
        try {
            Tools_RefractionStaticsProject.gridRange2D(grid, 0.0);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public static double findMinimumSurveyAreaAngle(Table_Abstract shotTable, Table_Abstract recTable) throws Exception {
        try {
            double minArea = Double.MAX_VALUE;
            double minAngle = 0.7853981633974483;
            int numAngles = 5;
            double bigAngle = 1.5707963267948966;
            int totalChecks = 1 + 2 * numAngles;
            double increment = bigAngle / (double)(1 + totalChecks);
            for (int iter = 0; iter < 7; ++iter) {
                double currentMinAngle = minAngle;
                for (int a = -numAngles; a <= numAngles; ++a) {
                    double angle = currentMinAngle + (double)a * increment;
                    double area = Tools_RefractionStaticsProject.getSurveyAreaUsingAngle(angle, shotTable, recTable);
                    if (!(area < minArea)) continue;
                    minArea = area;
                    minAngle = angle;
                }
                bigAngle = 2.0 * increment;
                increment = bigAngle / (double)(1 + totalChecks);
            }
            return minAngle;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public static double findMaximumSurveyRangeAngle() throws Exception {
        try {
            double maxRange = 0.0;
            double maxAngle = 0.7853981633974483;
            int numAngles = 7;
            double bigAngle = Math.PI;
            int totalChecks = 1 + 2 * numAngles;
            double increment = bigAngle / (double)(1 + totalChecks);
            for (int iter = 0; iter < 5; ++iter) {
                double currentMaxAngle = maxAngle;
                for (int a = -numAngles; a <= numAngles; ++a) {
                    double angle = currentMaxAngle + (double)a * increment;
                    double range = Tools_RefractionStaticsProject.getSurveyMaxRangeUsingAngle(angle, null);
                    if (!(range > maxRange)) continue;
                    maxRange = range;
                    maxAngle = angle;
                }
                bigAngle = 2.0 * increment;
                increment = bigAngle / (double)(1 + totalChecks);
            }
            return maxAngle;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public static double getSurveyAreaUsingAngle(double angle, Table_Abstract shotTable, Table_Abstract recTable) throws Exception {
        try {
            Range_Double rx = new Range_Double();
            Range_Double ry = new Range_Double();
            double cos = Math.cos(angle);
            double sin = Math.sin(angle);
            for (int iter = 0; iter <= 1; ++iter) {
                Table_Abstract table = shotTable;
                if (iter == 1) {
                    table = recTable;
                }
                int indexX = table.column_indexOfColumn("Easting");
                int indexY = table.column_indexOfColumn("Northing");
                int indexKilled = table.column_indexOfColumn("Killed");
                for (int n = 0; n < table.row_count(); ++n) {
                    if (table.getBool(n, indexKilled)) continue;
                    double x = table.getDouble(n, indexX);
                    double y = table.getDouble(n, indexY);
                    double rotY = cos * y - sin * x;
                    double rotX = cos * x + sin * y;
                    rx.expandRange(rotX);
                    ry.expandRange(rotY);
                }
            }
            if (rx.rangeValid()) {
                return rx.range() * ry.range();
            }
            throw new Exception("Lots of stuff not valid");
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public static double getSurveyMaxRangeUsingAngle(double angle, Range_Double rx) throws Exception {
        try {
            if (rx == null) {
                rx = new Range_Double();
            }
            double cos = Math.cos(angle);
            double sin = Math.sin(angle);
            for (int iter = 0; iter <= 1; ++iter) {
                Table_Abstract table = RefractionStaticsProject.singleton().receiverTable();
                if (iter == 1) {
                    table = RefractionStaticsProject.singleton().shotTable();
                }
                int indexX = table.column_indexOfColumn("Easting");
                int indexY = table.column_indexOfColumn("Northing");
                int indexKilled = table.column_indexOfColumn("Killed");
                for (int n = 0; n < table.row_count(); ++n) {
                    if (table.getBool(n, indexKilled)) continue;
                    double x = table.getDouble(n, indexX);
                    double y = table.getDouble(n, indexY);
                    double rotX = cos * x + sin * y;
                    rx.expandRange(rotX);
                }
            }
            if (rx.rangeValid()) {
                return rx.range();
            }
            throw new Exception("Lots of stuff not valid");
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public static void gridRange3D(Grid3D_Conversion grid, double buffer, Table_Abstract shotTable, Table_Abstract recTable) throws Exception {
        try {
            double y;
            double x;
            int n;
            grid.prepareRangeFinder();
            Table_Abstract table = recTable;
            int indexX = table.column_indexOfColumn("Easting");
            int indexY = table.column_indexOfColumn("Northing");
            int indexKilled = table.column_indexOfColumn("Killed");
            for (n = 0; n < table.row_count(); ++n) {
                if (table.getBool(n, indexKilled)) continue;
                x = table.getDouble(n, indexX);
                y = table.getDouble(n, indexY);
                grid.addToRangeFinder(x, y, buffer);
            }
            table = shotTable;
            indexX = table.column_indexOfColumn("Easting");
            indexY = table.column_indexOfColumn("Northing");
            indexKilled = table.column_indexOfColumn("Killed");
            for (n = 0; n < table.row_count(); ++n) {
                if (table.getBool(n, indexKilled)) continue;
                x = table.getDouble(n, indexX);
                y = table.getDouble(n, indexY);
                grid.addToRangeFinder(x, y, buffer);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public static void gridRange3D(Grid3D_Conversion grid, double buffer) throws Exception {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            Tools_RefractionStaticsProject.gridRange3D(grid, buffer, p.shotTable(), p.receiverTable());
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public static void gridRange3D(Grid3D_Conversion grid) throws Exception {
        try {
            Tools_RefractionStaticsProject.gridRange3D(grid, 0.0);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public static Grid3D_Conversion getGrid3D(double gridSize) throws Exception {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            Grid3D_Conversion grid = p.getGrid3D_Conversion().clone();
            grid.setBinSize(gridSize, gridSize);
            Tools_RefractionStaticsProject.gridRange3D(grid);
            return grid;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public static Grid3D_Conversion getGrid3D() throws Exception {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            Grid3D_Conversion grid = p.getGrid3D_Conversion().clone();
            grid.prepareRangeFinder();
            Tools_RefractionStaticsProject.gridRange3D(grid);
            return grid;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public static Grid3D getEmptyGrid3D(Grid3D_Conversion inputGrid, double buffer, double gridSizeI, double gridSizeC, Table_Abstract shotTable, Table_Abstract recTable) throws Exception {
        try {
            Grid3D_Conversion grid = inputGrid.clone();
            grid.setBinSize(gridSizeI, gridSizeC);
            Tools_RefractionStaticsProject.gridRange3D(grid, buffer, shotTable, recTable);
            return new Grid3D(grid);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public static AxisGrid_LinearFit createAxisGrid_LinearFit(double binSize, int smearRadius) throws Exception {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            double minX = p.m_rangeX.rangeMin() - binSize;
            double maxX = p.m_rangeX.rangeMax() + binSize;
            int numX = (int)((maxX - minX) / binSize);
            double minY = p.m_rangeY.rangeMin() - binSize;
            double maxY = p.m_rangeY.rangeMax() + binSize;
            int numY = (int)((maxY - minY) / binSize);
            return new AxisGrid_LinearFit(minX, minY, binSize, binSize, numX, numY, smearRadius);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public static void prepareCoordinateTable(Table_Abstract tableID, Table_Abstract tableCoord) {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            int indexShotID = tableID.column_indexOfColumn("ShotID");
            int indexRecID = tableID.column_indexOfColumn("ReceiverID");
            int indexReceiverX = tableCoord.column_append("ReceiverX", DataType.Double);
            int indexReceiverY = tableCoord.column_append("ReceiverY", DataType.Double);
            int indexShotX = tableCoord.column_append("ShotX", DataType.Double);
            int indexShotY = tableCoord.column_append("ShotY", DataType.Double);
            int indexMidX = tableCoord.column_append("CdpX", DataType.Double);
            int indexMidY = tableCoord.column_append("CdpY", DataType.Double);
            int indexOff = tableCoord.column_append("Offset", DataType.Double);
            int indexAzimuth = tableCoord.column_append("Azimuth", DataType.Double);
            int irx = p.m_receiverTable.column_indexOfColumn("Easting");
            int iry = p.m_receiverTable.column_indexOfColumn("Northing");
            int isx = p.m_shotTable.column_indexOfColumn("Easting");
            int isy = p.m_shotTable.column_indexOfColumn("Northing");
            if (tableCoord != tableID) {
                tableCoord.row_clear(false);
            }
            int badness = 0;
            for (int n = 0; n < tableID.row_count(); ++n) {
                int recID = tableID.getInt(n, indexRecID);
                if (!p.m_receiverMap.containsKey(recID)) {
                    ++badness;
                }
                int recRow = p.m_receiverMap.get(recID);
                double rx = p.m_receiverTable.getDouble(recRow, irx);
                double ry = p.m_receiverTable.getDouble(recRow, iry);
                int shotID = tableID.getInt(n, indexShotID);
                int shotRow = p.m_shotMap.get(shotID);
                double sx = p.m_shotTable.getDouble(shotRow, isx);
                double sy = p.m_shotTable.getDouble(shotRow, isy);
                double dx = rx - sx;
                double dy = ry - sy;
                double off = Math.sqrt(1.0E-10 + dx * dx + dy * dy);
                double az = Math.atan2(dy, dx);
                double midX = 0.5 * (rx + sx);
                double midY = 0.5 * (ry + sy);
                int row = n;
                if (tableCoord != tableID) {
                    row = tableCoord.row_increment();
                }
                tableCoord.putDouble(row, indexReceiverX, rx);
                tableCoord.putDouble(row, indexReceiverY, ry);
                tableCoord.putDouble(row, indexShotX, sx);
                tableCoord.putDouble(row, indexShotY, sy);
                tableCoord.putDouble(row, indexOff, off);
                tableCoord.putDouble(row, indexAzimuth, az);
                tableCoord.putDouble(row, indexMidX, midX);
                tableCoord.putDouble(row, indexMidY, midY);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public static void smoothColumn_SpatialInterpolator(String columnName, double radius) {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            SpatialInterpolator si = new SpatialInterpolator();
            si.prep(0.5 * radius, 5.0 * radius);
            si.add(project.shotTable(), columnName);
            si.add(project.receiverTable(), columnName);
            si.interpolate(project.shotTable(), columnName);
            si.interpolate(project.receiverTable(), columnName);
            IDatabaseConnection db = project.geometryDatabase();
            db.writeColumnContentsToDatabase(project.shotTable(), columnName);
            db.writeColumnContentsToDatabase(project.receiverTable(), columnName);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public static class InterpConnections {
        public String Name;
        public int EnsembleIndex;
        public int ShotColumnIndex;
        public int ReceiverColumnIndex;
        public double Sum1;
        public double Sum2;
    }
}

