/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Refraction;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Ensemble.Tools_Ensemble;
import com.PecosCore.Map.HashMap_Integer;
import com.PecosCore.Math.Grid3D_Conversion;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Math.IGrid2D_Conversion;
import com.PecosLibrary.Refraction.RefractionStaticsProject;

public class Tools_Ensemble_RefractionProject {
    public static boolean computeCdpCoords(Ensemble ensemble) {
        try {
            if (RefractionStaticsProject.singleton().dim2D()) {
                return Tools_Ensemble_RefractionProject.computeCdpCoords2D(ensemble);
            }
            return Tools_Ensemble_RefractionProject.computeCdpCoords3D(ensemble);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    public static boolean computeCdpCoords2D(Ensemble ensemble) {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            if (ensemble == null) {
                return false;
            }
            if (!ensemble.dictionary().containsEntry("Trace", "Bin2D")) {
                return false;
            }
            int indexCdpX = ensemble.dictionary().addEntry("Trace", "CdpX", DataType.Double);
            int indexCdpY = ensemble.dictionary().addEntry("Trace", "CdpY", DataType.Double);
            int indexBin = ensemble.dictionary().getEntryIndex("Trace", "Bin2D");
            IGrid2D_Conversion grid = project.getGrid2D_Conversion();
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                int bin = trace.header().getInt(indexBin);
                double x = grid.getX(bin);
                double y = grid.getY(bin);
                trace.header().putDouble(indexCdpX, x);
                trace.header().putDouble(indexCdpY, y);
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    public static boolean computeCdpCoords3D(Ensemble ensemble) {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            if (ensemble == null) {
                return false;
            }
            if (!ensemble.dictionary().containsEntry("Trace", "Inline")) {
                return false;
            }
            if (!ensemble.dictionary().containsEntry("Trace", "Crossline")) {
                return false;
            }
            int indexMidX = ensemble.dictionary().addEntry("Trace", "MidX", DataType.Double);
            int indexMidY = ensemble.dictionary().addEntry("Trace", "MidY", DataType.Double);
            int indexCdpX = ensemble.dictionary().addEntry("Trace", "CdpX", DataType.Double);
            int indexCdpY = ensemble.dictionary().addEntry("Trace", "CdpY", DataType.Double);
            int indexInline = ensemble.dictionary().getEntryIndex("Trace", "Inline");
            int indexCrossline = ensemble.dictionary().getEntryIndex("Trace", "Crossline");
            Grid3D_Conversion grid = project.getGrid3D_Conversion();
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                int inline = trace.header().getInt(indexInline);
                int crossline = trace.header().getInt(indexCrossline);
                grid.setInlineCrossline(inline, crossline);
                double x = grid.WorldX;
                double y = grid.WorldY;
                trace.header().putDouble(indexCdpX, x);
                trace.header().putDouble(indexCdpY, y);
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    public static boolean computeMidCoords(Ensemble ensemble) {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            if (ensemble == null) {
                return false;
            }
            if (!ensemble.dictionary().containsEntry("Shot", "Easting")) {
                return false;
            }
            if (!ensemble.dictionary().containsEntry("Shot", "Northing")) {
                return false;
            }
            if (!ensemble.dictionary().containsEntry("Receiver", "Easting")) {
                return false;
            }
            if (!ensemble.dictionary().containsEntry("Receiver", "Northing")) {
                return false;
            }
            int indexMidX = ensemble.dictionary().addEntry("Trace", "MidX", DataType.Double);
            int indexMidY = ensemble.dictionary().addEntry("Trace", "MidY", DataType.Double);
            int indexSX = ensemble.dictionary().getEntryIndex("Shot", "Easting");
            int indexSY = ensemble.dictionary().getEntryIndex("Shot", "Northing");
            int indexRX = ensemble.dictionary().getEntryIndex("Receiver", "Easting");
            int indexRY = ensemble.dictionary().getEntryIndex("Receiver", "Northing");
            Grid3D_Conversion grid = project.getGrid3D_Conversion();
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                double x = 0.5 * (trace.header().getDouble(indexSX) + trace.header().getDouble(indexRX));
                double y = 0.5 * (trace.header().getDouble(indexSY) + trace.header().getDouble(indexRY));
                trace.header().putDouble(indexMidX, x);
                trace.header().putDouble(indexMidY, y);
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    public static void setTracePolarity(Ensemble ensemble, boolean updateEnsemble) throws Exception {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            if (!project.valid()) {
                return;
            }
            if (ensemble == null) {
                return;
            }
            if (!ensemble.dictionary().containsEntry("Shot", "Polarity")) {
                return;
            }
            if (!ensemble.dictionary().containsEntry("Receiver", "Polarity")) {
                return;
            }
            int indexShotPol = ensemble.dictionary().getEntryIndex("Shot", "Polarity");
            int indexRecPol = ensemble.dictionary().getEntryIndex("Receiver", "Polarity");
            int indexFlags = -9999;
            if (ensemble.dictionary().containsEntry("Trace", "Flags")) {
                indexFlags = ensemble.dictionary().getEntryIndex("Trace", "Flags");
            }
            int indexTracePol = ensemble.dictionary().addEntry("Trace", "Polarity", DataType.Float);
            if (updateEnsemble) {
                Table_Abstract shotTable = project.shotTable();
                HashMap_Integer shotMap = project.shotMap();
                int indexShotID = ensemble.dictionary().getEntryIndex("Shot", "ShotID");
                int colShotPol = shotTable.column_indexOfColumn("Polarity");
                Table_Abstract recTable = project.receiverTable();
                HashMap_Integer recMap = project.receiverMap();
                int indexRecID = ensemble.dictionary().getEntryIndex("Receiver", "ReceiverID");
                int colRecPol = recTable.column_indexOfColumn("Polarity");
                for (int n = 0; n < ensemble.traceCount(); ++n) {
                    EnsembleTrace trace = ensemble.trace(n);
                    int shotID = trace.header().getInt(indexShotID);
                    int recID = trace.header().getInt(indexRecID);
                    if (!shotMap.containsKey(shotID) || !recMap.containsKey(indexRecID)) continue;
                    int shotRow = shotMap.get(shotID);
                    int recRow = recMap.get(recID);
                    double shotPol = shotTable.getDouble(shotRow, colShotPol);
                    trace.header().putDouble(indexShotPol, shotPol);
                    double recPol = recTable.getDouble(recRow, colRecPol);
                    trace.header().putDouble(indexRecPol, recPol);
                }
            }
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                int recPolarity;
                int shotPolarity;
                int totalPolarity;
                EnsembleTrace trace = ensemble.trace(n);
                int tracePolarity = 1;
                if (indexFlags >= 0) {
                    boolean polarity = Tools_Ensemble.getFlag(trace, indexFlags, 1);
                    tracePolarity = polarity ? -1 : 1;
                }
                if ((totalPolarity = (shotPolarity = trace.header().getInt(indexShotPol)) * (recPolarity = trace.header().getInt(indexRecPol)) * tracePolarity) > 0) {
                    trace.data().setPolarity(1);
                } else {
                    trace.data().setPolarity(-1);
                }
                trace.header().putDouble(indexTracePol, totalPolarity);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }
}

