/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Refraction.Tomography.VNS;

import com.PecosCore.Data.Column_Double;
import com.PecosCore.Data.DataType;
import com.PecosCore.Data.History;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Map.HashMap_Integers;
import com.PecosCore.Math.Grid3D_Conversion;
import com.PecosCore.Seismic.Segy.Segy;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Pecos;
import com.PecosCore.Shared.Range_Double;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Windows.Shared.IProgressMonitor;
import com.PecosLibrary.Math.ArrayInterpolator3D;
import com.PecosLibrary.Math.Grid3D;
import com.PecosLibrary.Refraction.DelayTime.DelayTimeModel;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Tomography.InteractiveModel.TomoInteractiveModel_PickCollection;
import com.PecosLibrary.Refraction.Tomography.VNS.TomoInterpolator_VNS;
import com.PecosLibrary.Refraction.Tomography.VNS.TomoProfileV2_VNS;
import com.PecosLibrary.Refraction.Tools_RefractionStaticsProject;
import com.PecosLibrary.Refraction.Uphole.UpholeModel;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_PaintablePointArray;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Polygon;
import java.awt.Color;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;

public class Tomo_VNS {
    protected HashMap<String, double[][]> m_interpolatedGridHash = new HashMap();
    public HashMap_Integers<Element> SourceHash = new HashMap_Integers();
    public HashMap_Integers<Element> ReceiverHash = new HashMap_Integers();
    protected String m_srcFileName;
    protected String m_recFileName;
    protected double m_vti_constant_delta = 0.0;
    protected double m_vti_constant_epsilon = 0.1;
    protected boolean m_vti_constant_apply = false;
    protected double m_originX = 0.0;
    protected double m_originY = 0.0;
    protected double m_maxElevation = 0.0;
    protected double m_minElevation = 0.0;
    protected double m_binSizeHorz = 25.0;
    protected double m_binSizeVertTop = 25.0;
    protected double m_binSizeVertBottom = 25.0;
    protected double m_inlineAngle = 0.0;
    protected int m_numX = 0;
    protected int m_numY = 0;
    protected int m_numZ = 0;
    protected double m_cosineInlineAngle = 0.0;
    protected double m_sineInlineAngle = 0.0;
    protected double m_inverseBinSizeHorz = 1.0;
    protected boolean m_forceMarineSurvey;
    protected double m_waterVelocity;
    protected float[][] m_waterBottomDepth;
    protected String m_name = "";
    protected String m_gridFileName;
    protected String m_surfaceFileName;
    protected String m_waterBottomFileName;
    protected String m_rayCoverFileName;
    public static final String RayCoverFileName = "Ray.cover";
    public static final String ModelFileName = "Model.slowness";
    public static final String SurfaceFileName = "Model.surface";
    public static final String WaterBottomFileName = "WaterBottom.surface";
    public static final String ReceiverFileName = "Model.receivers";
    public static final String ShotFileName = "Model.shots";
    public static final String AnisotropyFileName = "Model.anisotropy";
    protected boolean[][] m_ray_coverage;
    protected float[][][] m_slowness;
    protected float[][][] m_weight;
    protected float[][][] m_error;
    protected float[][][] m_count;
    protected float[][][] m_blend;
    protected float[][][] m_initial_slowness;
    protected float[][] m_tempPlane1;
    protected float[][] m_tempPlane2;
    protected float[][] m_tempPlane3;
    protected float[][] m_surfaceElevation;
    protected float[][][] m_slownessCoarse;
    protected float[][][] m_countCoarse;
    protected float[][][] m_temp1Coarse;
    protected float[][][] m_temp2Coarse;
    protected float[][] m_tempCoarse1;
    protected float[][] m_tempCoarse2;
    protected int m_numCoarseX;
    protected int m_numCoarseY;
    protected String m_historyFileName;
    protected History m_history;
    public double WorldX;
    public double WorldY;
    public double WorldZ;
    public double GridX;
    public double GridY;
    public double FloatIndexX;
    public double FloatIndexY;
    public double FloatIndexZ;
    public int LowerIndexX;
    public int LowerIndexY;
    public int LowerIndexZ;
    public double LowerWeightX;
    public double LowerWeightY;
    public double LowerWeightZ;
    public double UpperWeightX;
    public double UpperWeightY;
    public double UpperWeightZ;
    public boolean LowerIndexValidX;
    public boolean LowerIndexValidY;
    public boolean LowerIndexValidZ;
    public boolean UpperIndexValidX;
    public boolean UpperIndexValidY;
    public boolean UpperIndexValidZ;
    public double InterpolatedElevation;
    public double InterpolatedWaterBottom;
    public float[] InterpolatedNodeZ = new float[20];
    public float[] InterpolatedSlowness = new float[20];
    public float[] InterpolatedBlend = new float[20];
    public float[] InterpolatedWeight = new float[20];
    public float[] InterpolatedCount = new float[20];
    public double SlownessAtWorld;
    public boolean OnEdge = false;
    public int EdgeIndexX;
    public int EdgeIndexY;
    public int UpperIndexX;
    public int UpperIndexY;
    public int UpperIndexZ = 0;
    public UpholeModel m_upholeModel = null;
    public static final int NumStraightLine = 10;
    public int[] StraightLineLowerIndexX = new int[10];
    public int[] StraightLineLowerIndexY = new int[10];
    public int[] StraightLineUpperIndexX = new int[10];
    public int[] StraightLineUpperIndexY = new int[10];
    public float[] StraightLineLowerWeightX = new float[10];
    public float[] StraightLineLowerWeightY = new float[10];
    public float[] StraightLineUpperWeightX = new float[10];
    public float[] StraightLineUpperWeightY = new float[10];
    public float[] StraightLineSlowness = new float[10];
    public float[] StraightLineTime = new float[10];
    public double StraightLineTotalTime;
    public boolean[] StraightLineLowerIndexValidX = new boolean[10];
    public boolean[] StraightLineLowerIndexValidY = new boolean[10];
    public boolean[] StraightLineUpperIndexValidX = new boolean[10];
    public boolean[] StraightLineUpperIndexValidY = new boolean[10];
    protected float[] m_nodeDepth;
    protected TomoInterpolator_VNS m_interpolator;
    public final double MinValidWeight = 1.0E-4f;
    public float[][][] SlownessChange_m0;
    public float[][][] SlownessChange_m1;
    public float[][][] SlownessChange_m2;
    public boolean AllowUpdateAcceleration = true;
    public int AccelerationIterations = 10;
    public float WeightTime = 1.0f;
    protected int m_tempIndexMinDepth = 0;
    protected int m_tempIndexMaxDepth = 0;
    protected float m_tempFractionMinDepth = 0.0f;
    protected float m_tempFractionMaxDepth = 0.0f;
    protected double[] m_tempVertSlowness = new double[100];
    public double TimeToIntermediateDatum = 0.0;
    public double TimeToFinalDatum = 0.0;
    public double IntermediateDatum = 0.0;
    public double FinalDatum = 0.0;
    public double Statics;
    protected double[] m_tempStaticsSlowness;
    protected int m_tempStaticsCount = 60;

    public void applyUpholeModel() {
        try {
            UpholeModel model = this.getUpholeModel();
            if (model == null) {
                throw new Exception("null uphole model");
            }
            float[] vels = new float[this.m_numZ];
            for (int ix = 0; ix < this.m_numX; ++ix) {
                block3: for (int iy = 0; iy < this.m_numY; ++iy) {
                    float[] slowness = this.m_slowness[ix][iy];
                    float surface = this.m_surfaceElevation[ix][iy];
                    this.setGridLocation(ix, iy);
                    model.getInterpolatedVelocity(this.WorldX, this.WorldY, surface, this.m_nodeDepth, vels);
                    double dMaxDepth = model.getInterpolatedMaxDepth(this.WorldX, this.WorldY);
                    double dUpholeBottomElev = (double)surface - dMaxDepth;
                    for (int iz = 0; iz < this.m_numZ; ++iz) {
                        double elev = surface - this.m_nodeDepth[iz];
                        if (elev >= dUpholeBottomElev) {
                            slowness[iz] = (float)(1000.0 / (double)vels[iz]);
                        }
                        if (elev < dUpholeBottomElev) continue block3;
                    }
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void importSegy(Segy segy, double datum, double sampleInterval) {
        try {
            ArrayInterpolator3D interp = new ArrayInterpolator3D();
            interp.addSegy(segy);
            for (int ix = 0; ix < this.m_numX; ++ix) {
                for (int iy = 0; iy < this.m_numY; ++iy) {
                    float[] slowness = this.m_slowness[ix][iy];
                    float surface = this.m_surfaceElevation[ix][iy];
                    this.setGridLocation(ix, iy);
                    float[] input = interp.nearest(this.WorldX, this.WorldY);
                    double bottom = datum - sampleInterval * (double)(input.length - 1);
                    for (int iz = 0; iz < this.m_numZ; ++iz) {
                        double v = input[0];
                        double z = surface - this.m_nodeDepth[iz];
                        if (z >= datum) {
                            v = input[0];
                        }
                        if (z <= bottom) {
                            v = input[input.length - 1];
                        }
                        if (z < datum && z > bottom) {
                            double actualIndex = (datum - z) / sampleInterval;
                            int lowerIndex = (int)actualIndex;
                            double upperWeight = actualIndex - (double)lowerIndex;
                            v = (1.0 - upperWeight) * (double)input[lowerIndex] + upperWeight * (double)input[lowerIndex + 1];
                        }
                        slowness[iz] = 1000.0f / (float)v;
                    }
                }
            }
            this.save(this.name());
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void applyUpholeVelocityLayer(String elevName, String velName) {
        try {
            double[][] z = this.m_interpolatedGridHash.get(elevName);
            double[][] v = this.m_interpolatedGridHash.get(velName);
            for (int ix = 0; ix < this.m_numX; ++ix) {
                for (int iy = 0; iy < this.m_numY; ++iy) {
                    float[] slowness = this.m_slowness[ix][iy];
                    float surface = this.m_surfaceElevation[ix][iy];
                    for (int iz = 0; iz < this.m_numZ; ++iz) {
                        float nodeZ = surface - this.m_nodeDepth[iz];
                        if (!((double)nodeZ > z[ix][iy])) continue;
                        slowness[iz] = (float)(1000.0 / v[ix][iy]);
                    }
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void createInterpolatedGrid(String name, Table_Abstract table, String colX, String colY, String colV) {
        try {
            int iy;
            int ix;
            this.m_interpolatedGridHash.remove(name);
            int indexX = table.column_indexOfColumn(colX);
            int indexY = table.column_indexOfColumn(colY);
            int indexV = table.column_indexOfColumn(colV);
            int numRows = table.row_count();
            double[] x = new double[numRows];
            double[] y = new double[numRows];
            double[] v = new double[numRows];
            for (int r = 0; r < numRows; ++r) {
                x[r] = table.getDouble(r, indexX);
                y[r] = table.getDouble(r, indexY);
                v[r] = table.getDouble(r, indexV);
            }
            double[][] array = new double[this.numX()][this.numY()];
            int gap = 5;
            for (ix = 0; ix < this.m_numX; ix += gap) {
                for (iy = 0; iy < this.m_numY; iy += gap) {
                    double val;
                    this.setGridLocation(ix, iy);
                    double s1 = 0.0;
                    double s2 = 1.0E-30;
                    for (int r = 0; r < numRows; ++r) {
                        double dx = this.WorldX - x[r];
                        double dy = this.WorldY - y[r];
                        double dsq = dx * dx + dy * dy;
                        double w = 10000.0 / (100.0 + dsq);
                        s1 += v[r] * w;
                        s2 += w;
                    }
                    array[ix][iy] = val = s1 / s2;
                }
            }
            for (ix = 0; ix < this.m_numX; ++ix) {
                for (iy = 0; iy < this.m_numY; ++iy) {
                    double val;
                    boolean done;
                    boolean onGapX = ix % gap == 0;
                    boolean onGapY = iy % gap == 0;
                    boolean bl = done = onGapX && onGapY;
                    if (done) continue;
                    int x1 = ix / gap;
                    int minX = (x1 *= gap) - 2 * gap;
                    int maxX = x1 + 3 * gap;
                    minX = Math.max(minX, 0);
                    maxX = Math.min(maxX, this.m_numX - 1);
                    int y1 = iy / gap;
                    int minY = (y1 *= gap) - 2 * gap;
                    int maxY = y1 + 3 * gap;
                    minY = Math.max(minY, 0);
                    maxY = Math.min(maxY, this.m_numY - 1);
                    double s1 = 0.0;
                    double s2 = 1.0E-20;
                    for (x1 = minX; x1 <= maxX; x1 += gap) {
                        for (y1 = minY; y1 <= maxY; y1 += gap) {
                            double dx = x1 - ix;
                            double dy = y1 - iy;
                            double dsq = dx * dx + dy * dy;
                            double w = 1.0 / (1.0 + dsq);
                            s1 += w * array[x1][y1];
                            s2 += w;
                        }
                    }
                    array[ix][iy] = val = s1 / s2;
                }
            }
            this.m_interpolatedGridHash.put(name, array);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public Element getShotElement(int id) {
        try {
            if (!this.SourceHash.containsKey(id)) {
                this.SourceHash.put(new Element(id), id);
            }
            return this.SourceHash.get(id);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public Element getReceiverElement(int id) {
        try {
            if (!this.ReceiverHash.containsKey(id)) {
                this.ReceiverHash.put(new Element(id), id);
            }
            return this.ReceiverHash.get(id);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public void saveReceiverHash() {
        try {
            this.saveElement(this.ReceiverHash, this.m_recFileName);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void saveSourceHash() {
        try {
            this.saveElement(this.SourceHash, this.m_srcFileName);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void restoreComputedResiduals() {
        try {
            for (Element e : this.SourceHash.getValues()) {
                e.Residual = e.ComputedResidual;
            }
            for (Element e : this.ReceiverHash.getValues()) {
                e.Residual = e.ComputedResidual;
            }
            this.saveElement(this.SourceHash, this.m_srcFileName);
            this.saveElement(this.ReceiverHash, this.m_recFileName);
            this.writeResidualsToDatabase();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void convertResidualsToZeroMean() {
        try {
            double w;
            double s1 = 0.0;
            double s2 = 1.0E-20;
            for (Element e : this.SourceHash.getValues()) {
                w = 1.0;
                s1 += w * e.Residual;
                s2 += w;
            }
            for (Element e : this.ReceiverHash.getValues()) {
                w = 1.0;
                s1 += w * e.Residual;
                s2 += w;
            }
            double avg = s1 / s2;
            for (Element e : this.SourceHash.getValues()) {
                e.Residual -= avg;
            }
            for (Element e : this.ReceiverHash.getValues()) {
                e.Residual -= avg;
            }
            this.saveElement(this.SourceHash, this.m_srcFileName);
            this.saveElement(this.ReceiverHash, this.m_recFileName);
            this.writeResidualsToDatabase();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public double vti_constant_delta() {
        return this.m_vti_constant_delta;
    }

    public double vti_constant_epsilon() {
        return this.m_vti_constant_epsilon;
    }

    public boolean vti_constant_apply() {
        return this.m_vti_constant_apply;
    }

    public void vti_constant_select(double delta, double epsilon) {
        this.m_vti_constant_delta = delta;
        this.m_vti_constant_epsilon = epsilon;
        this.m_vti_constant_apply = true;
    }

    public void vti_constant_off() {
        this.m_vti_constant_apply = false;
    }

    public double minElevation() {
        return this.m_minElevation;
    }

    public double maxElevation() {
        return this.m_maxElevation;
    }

    public double originX() {
        return this.m_originX;
    }

    public double originY() {
        return this.m_originY;
    }

    public double binSizeHorz() {
        return this.m_binSizeHorz;
    }

    public double binSizeVertTop() {
        return this.m_binSizeVertTop;
    }

    public double binSizeVertBottom() {
        return this.m_binSizeVertBottom;
    }

    public double inlineAngle() {
        return this.m_inlineAngle;
    }

    public int numX() {
        return this.m_numX;
    }

    public int numY() {
        return this.m_numY;
    }

    public int numZ() {
        return this.m_numZ;
    }

    public boolean forceMarineSurvey() {
        return this.m_forceMarineSurvey;
    }

    public double waterVelocity() {
        return this.m_waterVelocity;
    }

    public float[][] waterBottomElevation() {
        return this.m_waterBottomDepth;
    }

    public String name() {
        return this.m_name;
    }

    public void ray_cover_save() {
        try {
            Tools_FileSystem.saveArray_Bool2D(this.m_rayCoverFileName, this.ray_coverage());
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public boolean[][] ray_coverage() {
        try {
            if (this.m_ray_coverage == null) {
                this.m_ray_coverage = new boolean[this.m_numX][this.m_numY];
            }
            return this.m_ray_coverage;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public void ray_cover_clear(boolean v) {
        try {
            boolean[][] cover = this.ray_coverage();
            for (int x = 0; x < this.m_numX; ++x) {
                for (int y = 0; y < this.m_numY; ++y) {
                    cover[x][y] = v;
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public float[][][] slowness() {
        return this.m_slowness;
    }

    public void blend_apply() {
        try {
            if (this.m_initial_slowness == null) {
                this.prep_initial_slowness();
            }
            for (int x = 0; x < this.m_numX; ++x) {
                for (int y = 0; y < this.m_numY; ++y) {
                    for (int z = 0; z < this.m_numZ; ++z) {
                        float b = this.m_blend[x][y][z];
                        b = Math.max(b, 0.0f);
                        b = Math.min(b, 1.0f);
                        this.m_slowness[x][y][z] = b * this.m_initial_slowness[x][y][z] + (1.0f - b) * this.m_slowness[x][y][z];
                    }
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void prep_initial_slowness() {
        try {
            this.m_initial_slowness = new float[this.m_numX][this.m_numY][this.m_numZ];
            for (int x = 0; x < this.m_numX; ++x) {
                for (int y = 0; y < this.m_numY; ++y) {
                    for (int z = 0; z < this.m_numZ; ++z) {
                        this.m_initial_slowness[x][y][z] = this.m_slowness[x][y][z];
                    }
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public float[][][] blend() {
        return this.m_blend;
    }

    public float[][][] weight() {
        return this.m_weight;
    }

    public float[][][] error() {
        return this.m_error;
    }

    public float[][][] count() {
        return this.m_count;
    }

    public float[][] surfaceElevation() {
        return this.m_surfaceElevation;
    }

    public UpholeModel getUpholeModel() {
        return this.m_upholeModel;
    }

    public void setUpholeModel(UpholeModel upholeModel) {
        this.m_upholeModel = upholeModel;
    }

    public void importTricon(int num, Column_Double colX, Column_Double colD, Column_Double colV) {
        try {
            HashMap_Integers<CrapElement> crap = new HashMap_Integers<CrapElement>();
            for (int n = 0; n < num; ++n) {
                int x = (int)(0.5 + (double)colX.getFloat(n));
                if (!crap.containsKey(x)) {
                    crap.put(new CrapElement(), x);
                }
                ((CrapElement)crap.get((int)x)).X = x;
                ++((CrapElement)crap.get((int)x)).Count;
            }
            for (CrapElement ce : crap.getValues()) {
                ce.Slowness = new float[ce.Count];
                ce.Elevation = new float[ce.Count];
                ce.Count = 0;
            }
            for (int n = 0; n < num; ++n) {
                int x = (int)(0.5 + (double)colX.getFloat(n));
                double depth = colD.getDouble(n);
                double slow = 1000.0 / colV.getDouble(n);
                CrapElement ce = (CrapElement)crap.get(x);
                ce.Elevation[ce.Count] = (float)(0.0 - depth);
                ce.Slowness[ce.Count] = (float)slow;
                ++ce.Count;
            }
            Range_Double range = Tools_RefractionStaticsProject.getRange("Easting", true, true);
            double minX = range.rangeMin();
            for (int ix = 0; ix < this.m_numX; ++ix) {
                for (int iy = 0; iy < this.m_numY; ++iy) {
                    this.setGridLocation(ix, iy);
                    double deltaX = this.WorldX - minX;
                    deltaX = Math.max(deltaX, 0.0);
                    CrapElement nearestCE = null;
                    double minDiff = Double.MAX_VALUE;
                    for (CrapElement ce : crap.getValues()) {
                        double diff = Math.abs(deltaX - (double)ce.X);
                        if (!(diff < minDiff)) continue;
                        minDiff = diff;
                        nearestCE = ce;
                    }
                    float elevation = this.m_surfaceElevation[ix][iy];
                    for (int iz = 0; iz < this.m_numZ; ++iz) {
                        double z = elevation - this.m_nodeDepth[iz];
                        double minDZ = 1.0E33;
                        int nearest = 0;
                        for (int k = 0; k < nearestCE.Count; ++k) {
                            double dz = Math.abs(z - (double)nearestCE.Elevation[k]);
                            if (!(dz < minDZ)) continue;
                            minDZ = dz;
                            nearest = k;
                        }
                        this.m_slowness[ix][iy][iz] = nearestCE.Slowness[nearest];
                    }
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void computeVelocityUsingPicks() throws Exception {
        try {
            this.checkMem();
            TomoInteractiveModel_PickCollection pc = RefractionStaticsProject.singleton().tomoInteractiveModel_PickCollection();
            double depth = this.m_nodeDepth[this.m_nodeDepth.length - 1];
            pc.prepTempData(depth, 25.0);
            double[] vel = new double[this.m_numZ];
            for (int ix = 0; ix < this.m_numX; ++ix) {
                for (int iy = 0; iy < this.m_numY; ++iy) {
                    this.setGridLocation(ix, iy);
                    pc.computeInterpolatedProfile(this.WorldX, this.WorldY);
                    double[] v = pc.TempProfile;
                    double delta = pc.tempSize();
                    float[] slowness = this.m_slowness[ix][iy];
                    for (int iz = 0; iz < this.m_numZ; ++iz) {
                        int index;
                        double binDepth = this.m_nodeDepth[iz];
                        slowness[iz] = binDepth <= 0.0 ? (float)(1000.0 / v[0]) : ((index = (int)(binDepth / delta)) < v.length ? (float)(1000.0 / v[index]) : (float)(1000.0 / v[v.length - 1]));
                    }
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public synchronized void fireStraightLine(double sx, double sy, double sz, double rx, double ry, double rz) throws Exception {
        try {
            int n;
            double dx = (rx - sx) / 9.0;
            double dy = (ry - sy) / 9.0;
            double dz = (rz - sz) / 9.0;
            double delta = Math.sqrt(1.0E-20 + dx * dx + dy * dy + dz * dz);
            for (n = 0; n < 10; ++n) {
                double x = sx + dx * (double)n;
                double y = sy + dy * (double)n;
                double z = sz + dz * (double)n;
                this.setWorldLocation(x, y, true, true, false, false);
                this.StraightLineLowerIndexX[n] = this.LowerIndexX;
                this.StraightLineLowerIndexY[n] = this.LowerIndexY;
                this.StraightLineUpperIndexX[n] = this.UpperIndexX;
                this.StraightLineUpperIndexY[n] = this.UpperIndexY;
                this.StraightLineLowerWeightX[n] = (float)this.LowerWeightX;
                this.StraightLineLowerWeightY[n] = (float)this.LowerWeightY;
                this.StraightLineUpperWeightX[n] = (float)this.UpperWeightX;
                this.StraightLineUpperWeightY[n] = (float)this.UpperWeightY;
                this.StraightLineLowerIndexValidX[n] = this.LowerIndexValidX;
                this.StraightLineLowerIndexValidY[n] = this.LowerIndexValidY;
                this.StraightLineUpperIndexValidX[n] = this.UpperIndexValidX;
                this.StraightLineUpperIndexValidY[n] = this.UpperIndexValidY;
                this.StraightLineSlowness[n] = (float)this.SlownessAtWorld;
            }
            this.StraightLineTime[0] = 0.0f;
            for (n = 1; n < 10; ++n) {
                double avg = 0.5f * (this.StraightLineSlowness[n - 1] + this.StraightLineSlowness[n]);
                this.StraightLineTime[n] = this.StraightLineTime[n - 1] + (float)(avg * delta);
            }
            this.StraightLineTotalTime = this.StraightLineTime[9];
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public Tomo_VNS(String name) throws Exception {
        try {
            this.read(name);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public float[] nodeDepth() {
        return this.m_nodeDepth;
    }

    public static float[] computeNodeDepths(double maxDepth, double binSizeVertTop, double binSizeVertBottom) {
        try {
            binSizeVertTop = Math.max(binSizeVertTop, 1.0);
            binSizeVertBottom = Math.max(binSizeVertTop, binSizeVertBottom);
            maxDepth = Math.max(maxDepth, 4.0 * binSizeVertBottom);
            int maxNodes = 2 + (int)(maxDepth / binSizeVertTop);
            double[] depth = new double[maxNodes];
            double alpha = 0.0;
            double beta = 1.0;
            int maxIndex = 10;
            boolean keepGoing = true;
            while (keepGoing) {
                keepGoing = false;
                beta = binSizeVertTop - alpha;
                depth[0] = 0.0;
                boolean ok = true;
                for (int n = 1; n < maxNodes && ok; ++n) {
                    double size = alpha * (double)n + beta;
                    depth[n] = depth[n - 1] + size;
                    if (!(depth[n] > maxDepth)) continue;
                    if (size < binSizeVertBottom) {
                        keepGoing = true;
                    }
                    ok = false;
                    maxIndex = n;
                }
                if (!keepGoing) continue;
                alpha += 0.1;
            }
            int num = maxIndex + 1;
            float[] nodeDepth = new float[num];
            nodeDepth[0] = 0.0f;
            for (int n = 1; n < num; ++n) {
                double size = alpha * (double)n + beta;
                nodeDepth[n] = (float)((double)nodeDepth[n - 1] + size);
            }
            return nodeDepth;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public static float[] computeNodeDepths(double s1, double t1, double s2, double t2, double s3, double t3) {
        try {
            double d;
            int n;
            s1 = Math.max(s1, 1.0);
            s1 = Math.min(s1, 500.0);
            s2 = Math.max(s2, 1.0);
            s2 = Math.min(s2, 500.0);
            s3 = Math.max(s3, 1.0);
            s3 = Math.min(s3, 500.0);
            t1 = Math.max(t1, 1.01 * s1);
            t1 = Math.min(t1, 5000.0);
            t2 = Math.max(t2, 1.01 * s2);
            t2 = Math.min(t2, 5000.0);
            t3 = Math.max(t3, 1.01 * s3);
            t3 = Math.min(t3, 5000.0);
            int n1 = 1 + (int)(t1 / s1);
            int n2 = (int)(t2 / s2);
            int n3 = (int)(t3 / s3);
            int num = n1 + n2 + n3;
            float[] nodeDepth = new float[num];
            int index = 0;
            nodeDepth[index] = 0.0f;
            ++index;
            for (n = 1; n < n1; ++n) {
                d = (double)nodeDepth[index - 1] + s1;
                nodeDepth[index] = (float)d;
                ++index;
            }
            for (n = 0; n < n2; ++n) {
                d = (double)nodeDepth[index - 1] + s2;
                nodeDepth[index] = (float)d;
                ++index;
            }
            for (n = 0; n < n3; ++n) {
                d = (double)nodeDepth[index - 1] + s3;
                nodeDepth[index] = (float)d;
                ++index;
            }
            return nodeDepth;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public Tomo_VNS(double inlineAngle, double binSizeHorz, float[] nodeDepth, boolean allocateMemory, boolean forceMarineSurvey, double waterVelocity) throws Exception {
        try {
            this.m_forceMarineSurvey = forceMarineSurvey;
            this.m_waterVelocity = waterVelocity;
            int num = nodeDepth.length;
            this.m_nodeDepth = new float[num];
            for (int n = 0; n < num; ++n) {
                this.m_nodeDepth[n] = nodeDepth[n];
            }
            this.m_binSizeHorz = binSizeHorz;
            this.m_binSizeVertTop = nodeDepth[1] - nodeDepth[0];
            this.m_binSizeVertBottom = nodeDepth[num - 1] - nodeDepth[num - 2];
            this.m_inlineAngle = inlineAngle;
            this.computeInternals();
            double maxDepth = this.m_nodeDepth[this.m_nodeDepth.length - 1];
            double minGridX = Double.MAX_VALUE;
            double minGridY = Double.MAX_VALUE;
            double maxWaterDepth = Double.MIN_VALUE;
            this.m_minElevation = Double.MAX_VALUE;
            this.m_maxElevation = Double.MIN_VALUE;
            for (int loop = 0; loop <= 1; ++loop) {
                Table_Abstract table = RefractionStaticsProject.singleton().receiverTable();
                if (loop == 1) {
                    table = RefractionStaticsProject.singleton().shotTable();
                }
                int indexX = table.column_indexOfColumn("Easting");
                int indexY = table.column_indexOfColumn("Northing");
                int indexZ = table.column_indexOfColumn("Elevation");
                int indexDead = table.column_indexOfColumn("Killed");
                int indexWaterDepth = -9999;
                if (this.m_forceMarineSurvey) {
                    indexWaterDepth = table.column_indexOfColumn("WaterDepth");
                }
                for (int n = 0; n < table.row_count(); ++n) {
                    if (table.getBool(n, indexDead)) continue;
                    double x = table.getDouble(n, indexX);
                    double y = table.getDouble(n, indexY);
                    double z = table.getDouble(n, indexZ);
                    double waterDepth = 0.0;
                    if (this.m_forceMarineSurvey) {
                        if (z < 0.0) {
                            z = 0.0;
                        }
                        waterDepth = table.getDouble(n, indexWaterDepth);
                        maxWaterDepth = Math.max(maxWaterDepth, waterDepth);
                    }
                    this.m_maxElevation = Math.max(this.m_maxElevation, z);
                    this.m_minElevation = Math.min(this.m_minElevation, z);
                    this.setLowerIndices(x, y);
                    minGridX = Math.min(minGridX, this.GridX - this.m_binSizeHorz);
                    minGridY = Math.min(minGridY, this.GridY - this.m_binSizeHorz);
                }
            }
            this.m_originX = this.m_cosineInlineAngle * minGridX - this.m_sineInlineAngle * minGridY;
            this.m_originY = this.m_cosineInlineAngle * minGridY + this.m_sineInlineAngle * minGridX;
            boolean numMarinesNodes = false;
            if (this.m_forceMarineSurvey) {
                // empty if block
            }
            int minIndexX = Integer.MAX_VALUE;
            int minIndexY = Integer.MAX_VALUE;
            int maxIndexX = Integer.MIN_VALUE;
            int maxIndexY = Integer.MIN_VALUE;
            for (int loop = 0; loop <= 1; ++loop) {
                Table_Abstract table = RefractionStaticsProject.singleton().receiverTable();
                if (loop == 1) {
                    table = RefractionStaticsProject.singleton().shotTable();
                }
                int indexX = table.column_indexOfColumn("Easting");
                int indexY = table.column_indexOfColumn("Northing");
                int indexZ = table.column_indexOfColumn("Elevation");
                int indexDead = table.column_indexOfColumn("Killed");
                int indexWaterDepth = -9999;
                if (this.m_forceMarineSurvey) {
                    indexWaterDepth = table.column_indexOfColumn("WaterDepth");
                }
                for (int n = 0; n < table.row_count(); ++n) {
                    if (table.getBool(n, indexDead)) continue;
                    double x = table.getDouble(n, indexX);
                    double y = table.getDouble(n, indexY);
                    this.setLowerIndices(x, y);
                    minIndexX = Math.min(minIndexX, this.LowerIndexX - 1);
                    minIndexY = Math.min(minIndexY, this.LowerIndexY - 1);
                    maxIndexX = Math.max(maxIndexX, this.LowerIndexX + 2);
                    maxIndexY = Math.max(maxIndexY, this.LowerIndexY + 2);
                }
            }
            this.m_numX = 1 + maxIndexX - minIndexX;
            this.m_numY = 1 + maxIndexY - minIndexY;
            this.m_numZ = this.m_nodeDepth.length;
            if (this.m_forceMarineSurvey) {
                // empty if block
            }
            if (allocateMemory) {
                this.checkMem();
                this.initializeSurface();
                if (this.m_forceMarineSurvey) {
                    this.initializeWaterBottom();
                }
                this.setVelocityGradient(3000.0, 9000.0);
                this.writeResidualsToDatabase();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public History getHistory() {
        return this.m_history;
    }

    public void forceShallowVelocity(float depth, double vel) throws Exception {
        try {
            double s = 1000.0 / vel;
            for (int ix = 0; ix < this.m_numX; ++ix) {
                for (int iy = 0; iy < this.m_numY; ++iy) {
                    for (int iz = 0; iz < this.m_numZ; ++iz) {
                        if (!(this.m_nodeDepth[iz] < depth)) continue;
                        this.m_slowness[ix][iy][iz] = (float)s;
                    }
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void prepWaterVelocity() throws Exception {
        try {
            if (!this.forceMarineSurvey()) {
                return;
            }
            double s = 1000.0 / this.m_waterVelocity;
            for (int ix = 0; ix < this.m_numX; ++ix) {
                for (int iy = 0; iy < this.m_numY; ++iy) {
                    double depth = this.m_waterBottomDepth[ix][iy];
                    for (int iz = 0; iz < this.m_numZ; ++iz) {
                        if (!((double)this.m_nodeDepth[iz] < depth)) continue;
                        this.m_slowness[ix][iy][iz] = (float)s;
                    }
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void initializeWaterBottom() throws Exception {
        try {
            Grid3D grid = Tools_RefractionStaticsProject.getInterpolatedGrid(this.m_binSizeHorz, this.m_binSizeHorz, "WaterDepth", true);
            for (int ix = 0; ix < this.m_numX; ++ix) {
                for (int iy = 0; iy < this.m_numY; ++iy) {
                    float z;
                    this.setGridLocation(ix, iy);
                    this.m_waterBottomDepth[ix][iy] = z = grid.getNearestValue(this.WorldX, this.WorldY, true);
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public double surfaceMin() {
        try {
            double min = Double.MAX_VALUE;
            for (int ix = 0; ix < this.m_numX; ++ix) {
                for (int iy = 0; iy < this.m_numY; ++iy) {
                    min = Math.min(min, (double)this.m_surfaceElevation[ix][iy]);
                }
            }
            return min;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return 0.0;
        }
    }

    public double surfaceMax() {
        try {
            double max = Double.MIN_VALUE;
            for (int ix = 0; ix < this.m_numX; ++ix) {
                for (int iy = 0; iy < this.m_numY; ++iy) {
                    max = Math.max(max, (double)this.m_surfaceElevation[ix][iy]);
                }
            }
            return max;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return 0.0;
        }
    }

    public void initializeSurface() throws Exception {
        try {
            Grid3D surfGrid = Tools_RefractionStaticsProject.getInterpolatedGrid(this.m_binSizeHorz, this.m_binSizeHorz, "Elevation", true);
            if (this.m_surfaceElevation == null) {
                this.m_surfaceElevation = new float[this.m_numX][this.m_numY];
            }
            for (int ix = 0; ix < this.m_numX; ++ix) {
                for (int iy = 0; iy < this.m_numY; ++iy) {
                    this.setGridLocation(ix, iy);
                    float z = surfGrid.getNearestValue(this.WorldX, this.WorldY, true);
                    if (this.m_forceMarineSurvey && z < 0.0f) {
                        z = 0.0f;
                    }
                    this.m_surfaceElevation[ix][iy] = z;
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public TomoProfileV2_VNS createNewProfileV2(int subSample) throws Exception {
        try {
            return new TomoProfileV2_VNS(this.m_binSizeHorz, this.m_nodeDepth, subSample);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public synchronized boolean populateProfileV2(TomoProfileV2_VNS profile, double x1, double y1, double x2, double y2, boolean getWeightAndCount) throws Exception {
        try {
            profile.VTI_Constant_Apply = this.m_vti_constant_apply;
            profile.VTI_Constant_Delta = this.m_vti_constant_delta;
            profile.VTI_Constant_Epsilon = this.m_vti_constant_epsilon;
            profile.setEndpoints(x1, y1, x2, y2);
            if (profile.MaxValidX < 1) {
                return false;
            }
            profile.ForceMarineSurvey = this.forceMarineSurvey();
            profile.WaterVelocity = this.m_waterVelocity;
            for (int n = 0; n <= profile.MaxValidX; ++n) {
                this.setWorldLocation(profile.WorldX[n], profile.WorldY[n], true, true, getWeightAndCount, getWeightAndCount);
                profile.WaterBottomZ[n] = -((float)this.InterpolatedWaterBottom);
                profile.Elevation[n] = (float)this.InterpolatedElevation;
                for (int iz = 0; iz < this.m_numZ; ++iz) {
                    profile.Blend_Model[n][iz] = this.InterpolatedBlend[iz];
                    profile.Slowness_Model[n][iz] = this.InterpolatedSlowness[iz];
                    if (!getWeightAndCount) continue;
                    profile.Weight_Model[n][iz] = this.InterpolatedWeight[iz];
                    profile.Count_Model[n][iz] = this.InterpolatedCount[iz];
                }
                profile.LowerIndexValidX[n] = this.LowerIndexValidX;
                profile.LowerIndexValidY[n] = this.LowerIndexValidY;
                profile.UpperIndexValidX[n] = this.UpperIndexValidX;
                profile.UpperIndexValidY[n] = this.UpperIndexValidY;
                profile.LowerWeightX[n] = (float)this.LowerWeightX;
                profile.LowerWeightY[n] = (float)this.LowerWeightY;
                profile.UpperWeightX[n] = (float)this.UpperWeightX;
                profile.UpperWeightY[n] = (float)this.UpperWeightY;
                profile.LowerIndexX[n] = this.LowerIndexX;
                profile.LowerIndexY[n] = this.LowerIndexY;
                profile.UpperIndexX[n] = this.UpperIndexX;
                profile.UpperIndexY[n] = this.UpperIndexY;
                this.m_ray_coverage[this.LowerIndexX][this.LowerIndexY] = true;
                this.m_ray_coverage[this.LowerIndexX][this.UpperIndexY] = true;
                this.m_ray_coverage[this.UpperIndexX][this.LowerIndexY] = true;
                this.m_ray_coverage[this.UpperIndexX][this.UpperIndexY] = true;
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void freeInterpolator() {
        try {
            this.m_interpolator = null;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public synchronized void updateStatisticsFromStraightLine(float pick, double offsetWeight) {
        try {
            if (pick < 5.0f) {
                return;
            }
            double timeError = Math.abs((double)pick - this.StraightLineTotalTime);
            double timeWeight = (double)this.WeightTime / ((double)this.WeightTime + timeError);
            double weight = 100.0 * timeWeight * offsetWeight;
            double frac = this.StraightLineTotalTime / (double)pick;
            frac = Math.max((double)0.67f, frac);
            frac = Math.min((double)1.33f, frac);
            for (int n = 0; n < 10; ++n) {
                double wx = this.StraightLineLowerWeightX[n];
                double wy = this.StraightLineLowerWeightY[n];
                double wz = 1.0;
                int x = this.StraightLineLowerIndexX[n];
                int y = this.StraightLineLowerIndexY[n];
                int z = 0;
                double w = weight * wx * wy * wz;
                this.m_weight[x][y][z] = this.m_weight[x][y][z] + (float)w;
                this.m_error[x][y][z] = this.m_error[x][y][z] + (float)(w * frac);
                float[] fArray = this.m_count[x][y];
                int n2 = z;
                fArray[n2] = (float)((double)fArray[n2] + frac);
                wx = this.StraightLineUpperWeightX[n];
                wy = this.StraightLineLowerWeightY[n];
                wz = 1.0;
                x = this.StraightLineUpperIndexX[n];
                y = this.StraightLineLowerIndexY[n];
                z = 0;
                w = weight * wx * wy * wz;
                this.m_weight[x][y][z] = this.m_weight[x][y][z] + (float)w;
                this.m_error[x][y][z] = this.m_error[x][y][z] + (float)(w * frac);
                float[] fArray2 = this.m_count[x][y];
                int n3 = z;
                fArray2[n3] = (float)((double)fArray2[n3] + frac);
                wx = this.StraightLineLowerWeightX[n];
                wy = this.StraightLineUpperWeightY[n];
                wz = 1.0;
                x = this.StraightLineLowerIndexX[n];
                y = this.StraightLineUpperIndexY[n];
                z = 0;
                w = weight * wx * wy * wz;
                this.m_weight[x][y][z] = this.m_weight[x][y][z] + (float)w;
                this.m_error[x][y][z] = this.m_error[x][y][z] + (float)(w * frac);
                float[] fArray3 = this.m_count[x][y];
                int n4 = z;
                fArray3[n4] = (float)((double)fArray3[n4] + frac);
                wx = this.StraightLineUpperWeightX[n];
                wy = this.StraightLineUpperWeightY[n];
                wz = 1.0;
                x = this.StraightLineUpperIndexX[n];
                y = this.StraightLineUpperIndexY[n];
                z = 0;
                w = weight * wx * wy * wz;
                this.m_weight[x][y][z] = this.m_weight[x][y][z] + (float)w;
                this.m_error[x][y][z] = this.m_error[x][y][z] + (float)(w * frac);
                float[] fArray4 = this.m_count[x][y];
                int n5 = z;
                fArray4[n5] = (float)((double)fArray4[n5] + frac);
                wx = this.StraightLineLowerWeightX[n];
                wy = this.StraightLineLowerWeightY[n];
                wz = 1.0;
                x = this.StraightLineLowerIndexX[n];
                y = this.StraightLineLowerIndexY[n];
                z = 1;
                w = weight * wx * wy * wz;
                this.m_weight[x][y][z] = this.m_weight[x][y][z] + (float)w;
                this.m_error[x][y][z] = this.m_error[x][y][z] + (float)(w * frac);
                float[] fArray5 = this.m_count[x][y];
                int n6 = z;
                fArray5[n6] = (float)((double)fArray5[n6] + frac);
                wx = this.StraightLineUpperWeightX[n];
                wy = this.StraightLineLowerWeightY[n];
                wz = 1.0;
                x = this.StraightLineUpperIndexX[n];
                y = this.StraightLineLowerIndexY[n];
                z = 1;
                w = weight * wx * wy * wz;
                this.m_weight[x][y][z] = this.m_weight[x][y][z] + (float)w;
                this.m_error[x][y][z] = this.m_error[x][y][z] + (float)(w * frac);
                float[] fArray6 = this.m_count[x][y];
                int n7 = z;
                fArray6[n7] = (float)((double)fArray6[n7] + frac);
                wx = this.StraightLineLowerWeightX[n];
                wy = this.StraightLineUpperWeightY[n];
                wz = 1.0;
                x = this.StraightLineLowerIndexX[n];
                y = this.StraightLineUpperIndexY[n];
                z = 1;
                w = weight * wx * wy * wz;
                this.m_weight[x][y][z] = this.m_weight[x][y][z] + (float)w;
                this.m_error[x][y][z] = this.m_error[x][y][z] + (float)(w * frac);
                float[] fArray7 = this.m_count[x][y];
                int n8 = z;
                fArray7[n8] = (float)((double)fArray7[n8] + frac);
                wx = this.StraightLineUpperWeightX[n];
                wy = this.StraightLineUpperWeightY[n];
                wz = 1.0;
                x = this.StraightLineUpperIndexX[n];
                y = this.StraightLineUpperIndexY[n];
                z = 1;
                w = weight * wx * wy * wz;
                this.m_weight[x][y][z] = this.m_weight[x][y][z] + (float)w;
                this.m_error[x][y][z] = this.m_error[x][y][z] + (float)(w * frac);
                float[] fArray8 = this.m_count[x][y];
                int n9 = z;
                fArray8[n9] = (float)((double)fArray8[n9] + frac);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public synchronized void updateStatisticsFromProfileV2(TomoProfileV2_VNS profile, float pick, double offsetWeight, int sprayZ, float scalarSprayZ) {
        try {
            if (pick < 5.0f) {
                return;
            }
            double maxDepth = profile.MaxDepth;
            double maxModelDepth = this.m_nodeDepth[this.m_nodeDepth.length - 1];
            boolean useEntirePath = maxDepth < 0.33 * maxModelDepth;
            double depthCutoff = 0.5 * maxDepth;
            double timeError = Math.abs((double)pick - profile.ReceiverTime);
            double timeWeight = (double)this.WeightTime / ((double)this.WeightTime + timeError);
            offsetWeight = Math.max(offsetWeight, (double)0.01f);
            double weight = 100.0 * timeWeight * offsetWeight;
            double frac = profile.ReceiverTime / (double)pick;
            frac = Math.max((double)0.67f, frac);
            frac = Math.min((double)1.33f, frac);
            double w = 1.0;
            ArrayList<Integer> list_x = new ArrayList<Integer>();
            ArrayList<Integer> list_y = new ArrayList<Integer>();
            ArrayList<Float> list_wx = new ArrayList<Float>();
            ArrayList<Float> list_wy = new ArrayList<Float>();
            for (int px = 1; px <= profile.MaxReceiverIndex; ++px) {
                list_x.clear();
                list_y.clear();
                list_wx.clear();
                list_wy.clear();
                if (profile.LowerIndexValidX[px] && profile.LowerIndexValidY[px]) {
                    list_x.add(profile.LowerIndexX[px]);
                    list_y.add(profile.LowerIndexY[px]);
                    list_wx.add(Float.valueOf(profile.LowerWeightX[px]));
                    list_wy.add(Float.valueOf(profile.LowerWeightY[px]));
                }
                if (profile.LowerIndexValidX[px] && profile.UpperIndexValidY[px]) {
                    list_x.add(profile.LowerIndexX[px]);
                    list_y.add(profile.UpperIndexY[px]);
                    list_wx.add(Float.valueOf(profile.LowerWeightX[px]));
                    list_wy.add(Float.valueOf(profile.UpperWeightY[px]));
                }
                if (profile.UpperIndexValidX[px] && profile.UpperIndexValidY[px]) {
                    list_x.add(profile.UpperIndexX[px]);
                    list_y.add(profile.UpperIndexY[px]);
                    list_wx.add(Float.valueOf(profile.UpperWeightX[px]));
                    list_wy.add(Float.valueOf(profile.UpperWeightY[px]));
                }
                if (profile.UpperIndexValidX[px] && profile.LowerIndexValidY[px]) {
                    list_x.add(profile.UpperIndexX[px]);
                    list_y.add(profile.LowerIndexY[px]);
                    list_wx.add(Float.valueOf(profile.UpperWeightX[px]));
                    list_wy.add(Float.valueOf(profile.LowerWeightY[px]));
                }
                int depthIndexSample = profile.Path[px];
                int z1 = profile.Conn_LowerIndex[depthIndexSample];
                double w1 = profile.Conn_LowerWeight[depthIndexSample];
                int z2 = profile.Conn_UpperIndex[depthIndexSample];
                double w2 = profile.Conn_UpperWeight[depthIndexSample];
                for (int k = 0; k < list_x.size(); ++k) {
                    int x = (Integer)list_x.get(k);
                    int y = (Integer)list_y.get(k);
                    double wx = ((Float)list_wx.get(k)).floatValue();
                    double wy = ((Float)list_wy.get(k)).floatValue();
                    if (useEntirePath || (double)this.m_nodeDepth[z1] > depthCutoff) {
                        w = wx * wy * weight * w1;
                        this.m_weight[x][y][z1] = this.m_weight[x][y][z1] + (float)w;
                        this.m_error[x][y][z1] = this.m_error[x][y][z1] + (float)(w * frac);
                        float[] fArray = this.m_count[x][y];
                        int n = z1;
                        fArray[n] = (float)((double)fArray[n] + w1 * frac);
                    }
                    if (!useEntirePath && !((double)this.m_nodeDepth[z2] > depthCutoff)) continue;
                    w = wx * wy * weight * w2;
                    this.m_weight[x][y][z2] = this.m_weight[x][y][z2] + (float)w;
                    this.m_error[x][y][z2] = this.m_error[x][y][z2] + (float)(w * frac);
                    float[] fArray = this.m_count[x][y];
                    int n = z2;
                    fArray[n] = (float)((double)fArray[n] + w2 * frac);
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public synchronized void updateStatisticsFromProfileV2(TomoProfileV2_VNS profile, float pick, boolean RaypathDepthWeight, boolean RaypathDepthWeightSq, int sprayZ, float scalarSprayZ) {
        try {
            if (pick < 5.0f) {
                return;
            }
            double maxDepth = profile.MaxDepth;
            double maxModelDepth = this.m_nodeDepth[this.m_nodeDepth.length - 1];
            boolean useEntirePath = maxDepth < 0.33 * maxModelDepth;
            double depthCutoff = 0.5 * maxDepth;
            double timeError = Math.abs((double)pick - profile.ReceiverTime);
            double timeWeight = (double)this.WeightTime / ((double)this.WeightTime + timeError);
            double frac = profile.ReceiverTime / (double)pick;
            frac = Math.max((double)0.67f, frac);
            frac = Math.min((double)1.33f, frac);
            double w = 1.0;
            ArrayList<Integer> list_x = new ArrayList<Integer>();
            ArrayList<Integer> list_y = new ArrayList<Integer>();
            ArrayList<Float> list_wx = new ArrayList<Float>();
            ArrayList<Float> list_wy = new ArrayList<Float>();
            for (int px = 1; px <= profile.MaxReceiverIndex; ++px) {
                list_x.clear();
                list_y.clear();
                list_wx.clear();
                list_wy.clear();
                if (profile.LowerIndexValidX[px] && profile.LowerIndexValidY[px]) {
                    list_x.add(profile.LowerIndexX[px]);
                    list_y.add(profile.LowerIndexY[px]);
                    list_wx.add(Float.valueOf(profile.LowerWeightX[px]));
                    list_wy.add(Float.valueOf(profile.LowerWeightY[px]));
                }
                if (profile.LowerIndexValidX[px] && profile.UpperIndexValidY[px]) {
                    list_x.add(profile.LowerIndexX[px]);
                    list_y.add(profile.UpperIndexY[px]);
                    list_wx.add(Float.valueOf(profile.LowerWeightX[px]));
                    list_wy.add(Float.valueOf(profile.UpperWeightY[px]));
                }
                if (profile.UpperIndexValidX[px] && profile.UpperIndexValidY[px]) {
                    list_x.add(profile.UpperIndexX[px]);
                    list_y.add(profile.UpperIndexY[px]);
                    list_wx.add(Float.valueOf(profile.UpperWeightX[px]));
                    list_wy.add(Float.valueOf(profile.UpperWeightY[px]));
                }
                if (profile.UpperIndexValidX[px] && profile.LowerIndexValidY[px]) {
                    list_x.add(profile.UpperIndexX[px]);
                    list_y.add(profile.LowerIndexY[px]);
                    list_wx.add(Float.valueOf(profile.UpperWeightX[px]));
                    list_wy.add(Float.valueOf(profile.LowerWeightY[px]));
                }
                int depthIndexSample = profile.Path[px];
                int depthIndexDiff = Math.abs(profile.MaxPathIndex - depthIndexSample);
                double depthWeight = 1.0 / (1.0 + (double)depthIndexDiff);
                if (RaypathDepthWeightSq) {
                    depthWeight *= depthWeight;
                }
                depthWeight = Math.max(depthWeight, 0.005);
                double weight = 10.0 * timeWeight * depthWeight;
                int z1 = profile.Conn_LowerIndex[depthIndexSample];
                double w1 = profile.Conn_LowerWeight[depthIndexSample];
                int z2 = profile.Conn_UpperIndex[depthIndexSample];
                double w2 = profile.Conn_UpperWeight[depthIndexSample];
                for (int k = 0; k < list_x.size(); ++k) {
                    int x = (Integer)list_x.get(k);
                    int y = (Integer)list_y.get(k);
                    double wx = ((Float)list_wx.get(k)).floatValue();
                    double wy = ((Float)list_wy.get(k)).floatValue();
                    if (useEntirePath || (double)this.m_nodeDepth[z1] > depthCutoff) {
                        w = wx * wy * weight * w1;
                        this.m_weight[x][y][z1] = this.m_weight[x][y][z1] + (float)w;
                        this.m_error[x][y][z1] = this.m_error[x][y][z1] + (float)(w * frac);
                        float[] fArray = this.m_count[x][y];
                        int n = z1;
                        fArray[n] = (float)((double)fArray[n] + w1 * frac);
                    }
                    if (!useEntirePath && !((double)this.m_nodeDepth[z2] > depthCutoff)) continue;
                    w = wx * wy * weight * w2;
                    this.m_weight[x][y][z2] = this.m_weight[x][y][z2] + (float)w;
                    this.m_error[x][y][z2] = this.m_error[x][y][z2] + (float)(w * frac);
                    float[] fArray = this.m_count[x][y];
                    int n = z2;
                    fArray[n] = (float)((double)fArray[n] + w2 * frac);
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public synchronized void printAverages() {
        try {
            double sums = 0.0;
            double sumw = 0.0;
            double sumc = 0.0;
            for (int x = 0; x < this.m_numX; ++x) {
                for (int y = 0; y < this.m_numY; ++y) {
                    for (int z = 0; z < this.m_numZ; ++z) {
                        sums += (double)this.m_slowness[x][y][z];
                        sumw += (double)this.m_weight[x][y][z];
                        sumc += (double)this.m_count[x][y][z];
                    }
                }
            }
            double avgs = sums / (double)(this.m_numX * this.m_numY * this.m_numZ);
            double avgw = sumw / (double)(this.m_numX * this.m_numY * this.m_numZ);
            double avgc = sumc / (double)(this.m_numX * this.m_numY * this.m_numZ);
            String s = String.format("printAverages:   Average s = %f  w = %f  c = %f", avgs, avgw, avgc);
            System.out.println(s);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void clipVelocity(double minV, double maxV) {
        try {
            for (int x = 0; x < this.m_numX; ++x) {
                for (int y = 0; y < this.m_numY; ++y) {
                    for (int z = 0; z < this.m_numZ; ++z) {
                        double v = 1000.0 / (double)this.m_slowness[x][y][z];
                        if (v < minV) {
                            v = minV;
                        }
                        if (v > maxV) {
                            v = maxV;
                        }
                        this.m_slowness[x][y][z] = (float)(1000.0 / v);
                    }
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void finishUpdate(IProgressMonitor pm, int smoothH, double smoothDecay, int smoothZ, float extrapolateDown, float extrapolateUp, float fractionCoarse, int totalIterations, int currentIteration, float maxPercentChange, boolean forceIncrease, boolean useNewSmooth) {
        try {
            if (this.SlownessChange_m0 == null) {
                this.SlownessChange_m0 = new float[this.m_numX][this.m_numY][this.m_numZ];
                this.SlownessChange_m1 = new float[this.m_numX][this.m_numY][this.m_numZ];
                this.SlownessChange_m2 = new float[this.m_numX][this.m_numY][this.m_numZ];
            }
            float[][][] slownessChange = null;
            if ((currentIteration - 1) % 3 == 0) {
                slownessChange = this.SlownessChange_m2;
            }
            if ((currentIteration - 1) % 3 == 1) {
                slownessChange = this.SlownessChange_m1;
            }
            if ((currentIteration - 1) % 3 == 2) {
                slownessChange = this.SlownessChange_m0;
            }
            double maxFracChange = 1.0f + maxPercentChange / 100.0f;
            double minFracChange = 1.0 / maxFracChange;
            double weightSum = 0.0;
            double countMax = 0.0;
            double countSum = 0.0;
            double changeFraction = 0.8f;
            double sumCount = 0.01;
            double sumSlow = 0.0;
            for (int x = 0; x < this.m_numX; ++x) {
                for (int y = 0; y < this.m_numY; ++y) {
                    float[] slowness = this.m_slowness[x][y];
                    float[] weight = this.m_weight[x][y];
                    float[] error = this.m_error[x][y];
                    float[] count = this.m_count[x][y];
                    for (int z = 0; z < this.m_numZ; ++z) {
                        sumSlow += (double)slowness[z];
                        sumCount += 1.0;
                        slownessChange[x][y][z] = 0.0f;
                        countMax = Math.max(countMax, (double)count[z]);
                        countSum += (double)count[z];
                        double frac = 1.0;
                        if ((double)weight[z] > (double)1.0E-4f) {
                            frac = error[z] / weight[z];
                            frac = Math.max(minFracChange, frac);
                            frac = Math.min(maxFracChange, frac);
                            weightSum += (double)weight[z];
                            double newSlowness = (double)slowness[z] / frac;
                            double change = newSlowness - (double)slowness[z];
                            slownessChange[x][y][z] = (float)(changeFraction * change);
                        }
                        error[z] = (float)frac;
                    }
                }
            }
            double averageSlow = sumSlow / sumCount;
            double posCut = 0.001f * (float)averageSlow;
            double negCut = -posCut;
            if (this.AllowUpdateAcceleration && currentIteration >= 6 && currentIteration <= totalIterations - 4 && (currentIteration - 1) % 3 == 2) {
                double numAccel = 0.0;
                for (int x = 0; x < this.m_numX; ++x) {
                    for (int y = 0; y < this.m_numY; ++y) {
                        float[] slowness = this.m_slowness[x][y];
                        float[] change0 = this.SlownessChange_m0[x][y];
                        float[] change1 = this.SlownessChange_m1[x][y];
                        float[] change2 = this.SlownessChange_m2[x][y];
                        for (int z = 0; z < this.m_numZ; ++z) {
                            double maxChange;
                            double errm;
                            double err2;
                            double err1;
                            double err0;
                            double average;
                            float c0 = change0[z];
                            float c1 = change1[z];
                            float c2 = change2[z];
                            double change = change0[z];
                            if ((double)c0 < negCut && (double)c1 < negCut && (double)c2 < negCut) {
                                average = (c0 + c1 + c2) / 3.0f;
                                err0 = Math.abs(average - (double)c0);
                                err1 = Math.abs(average - (double)c1);
                                err2 = Math.abs(average - (double)c2);
                                errm = (double)0.1f * Math.abs(average);
                                if (err0 < errm && err1 < errm && err2 < errm) {
                                    numAccel += 1.0;
                                    change = average * (double)this.AccelerationIterations;
                                }
                            }
                            if ((double)c0 > posCut && (double)c1 > posCut && (double)c2 > posCut) {
                                average = (c0 + c1 + c2) / 3.0f;
                                err0 = Math.abs(average - (double)c0);
                                err1 = Math.abs(average - (double)c1);
                                err2 = Math.abs(average - (double)c2);
                                errm = (double)0.1f * Math.abs(average);
                                if (err0 < errm && err1 < errm && err2 < errm) {
                                    numAccel += 1.0;
                                    change = average * (double)this.AccelerationIterations;
                                }
                            }
                            if (change > (maxChange = (double)(0.2f * slowness[z]))) {
                                change = maxChange;
                            }
                            if (change < -maxChange) {
                                change = -maxChange;
                            }
                            slowness[z] = slowness[z] + (float)change;
                        }
                    }
                }
            } else {
                for (int x = 0; x < this.m_numX; ++x) {
                    for (int y = 0; y < this.m_numY; ++y) {
                        float[] slowness = this.m_slowness[x][y];
                        for (int z = 0; z < this.m_numZ; ++z) {
                            slowness[z] = slowness[z] + slownessChange[x][y][z];
                        }
                    }
                }
            }
            if (this.m_interpolator == null) {
                this.m_interpolator = new TomoInterpolator_VNS();
                this.m_interpolator.prepare(this, 7, totalIterations);
            }
            if (useNewSmooth) {
                this.m_interpolator.smooth_new(pm, smoothH, smoothDecay, smoothZ, fractionCoarse, currentIteration, forceIncrease, currentIteration == totalIterations - 1);
            } else {
                this.m_interpolator.smooth_old(pm, smoothH, smoothDecay, smoothZ, fractionCoarse, currentIteration, forceIncrease, currentIteration == totalIterations - 1);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void prepUpdate() {
        try {
            for (int x = 0; x < this.m_numX; ++x) {
                for (int y = 0; y < this.m_numY; ++y) {
                    for (int z = 0; z < this.m_numZ; ++z) {
                        this.m_weight[x][y][z] = 0.0f;
                        this.m_error[x][y][z] = 0.0f;
                        this.m_count[x][y][z] = 0.0f;
                    }
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public Grid3D getEmptyGrid3D() throws Exception {
        try {
            Grid3D_Conversion gc = new Grid3D_Conversion();
            gc.setBinSize(this.m_binSizeHorz, this.m_binSizeHorz);
            gc.setInlineAngle(this.m_inlineAngle);
            gc.setOrigin(this.m_originX, this.m_originY);
            gc.setBinCounts(this.m_numX, this.m_numY);
            Grid3D grid = new Grid3D(gc);
            return grid;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public Grid3D getWaterBottomGrid3D() throws Exception {
        try {
            Grid3D grid = this.getEmptyGrid3D();
            float[][] data = grid.data();
            for (int ix = 0; ix < this.m_numX; ++ix) {
                for (int iy = 0; iy < this.m_numY; ++iy) {
                    data[ix][iy] = this.m_waterBottomDepth[ix][iy];
                }
            }
            return grid;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public Grid3D getSurfaceGrid3D() throws Exception {
        try {
            Grid3D grid = this.getEmptyGrid3D();
            float[][] data = grid.data();
            for (int ix = 0; ix < this.m_numX; ++ix) {
                for (int iy = 0; iy < this.m_numY; ++iy) {
                    data[ix][iy] = this.m_surfaceElevation[ix][iy];
                }
            }
            return grid;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    protected void prepTempDepthIndices(float depth) {
        this.m_tempIndexMinDepth = 0;
        this.m_tempIndexMaxDepth = 0;
        this.m_tempFractionMinDepth = 1.0f;
        this.m_tempFractionMaxDepth = 0.0f;
        if (depth <= 0.0f) {
            return;
        }
        for (int n = 1; n < this.m_nodeDepth.length; ++n) {
            if (!(depth <= this.m_nodeDepth[n])) continue;
            this.m_tempIndexMinDepth = n - 1;
            this.m_tempIndexMaxDepth = n;
            this.m_tempFractionMaxDepth = (depth - this.m_nodeDepth[n - 1]) / (this.m_nodeDepth[n] - this.m_nodeDepth[n - 1]);
            this.m_tempFractionMinDepth = 1.0f - this.m_tempFractionMaxDepth;
            return;
        }
        this.m_tempIndexMinDepth = this.m_nodeDepth.length - 1;
        this.m_tempIndexMaxDepth = this.m_nodeDepth.length - 1;
        this.m_tempFractionMinDepth = 0.0f;
        this.m_tempFractionMaxDepth = 1.0f;
    }

    protected double errorAtDepth(float depth, int ix, int iy) {
        try {
            this.prepTempDepthIndices(depth);
            float[] error = this.m_error[ix][iy];
            double s = this.m_tempFractionMinDepth * error[this.m_tempIndexMinDepth] + this.m_tempFractionMaxDepth * error[this.m_tempIndexMaxDepth];
            return s;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return 0.0;
        }
    }

    protected double velAtDepth(float depth, int ix, int iy) {
        try {
            this.prepTempDepthIndices(depth);
            float[] slowness = this.m_slowness[ix][iy];
            double s = this.m_tempFractionMinDepth * slowness[this.m_tempIndexMinDepth] + this.m_tempFractionMaxDepth * slowness[this.m_tempIndexMaxDepth];
            double v = 1000.0 / s;
            return v;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return 0.0;
        }
    }

    protected double countAtDepth(float depth, int ix, int iy) {
        try {
            this.prepTempDepthIndices(depth);
            float[] count = this.m_count[ix][iy];
            return this.m_tempFractionMinDepth * count[this.m_tempIndexMinDepth] + this.m_tempFractionMaxDepth * count[this.m_tempIndexMaxDepth];
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return 0.0;
        }
    }

    public void computeWeatheringVelocity(float depth, boolean updateZ) throws Exception {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            int numDead = 0;
            numDead += this.computeWeatheringVelocity(p.shotTable(), depth);
            if ((numDead += this.computeWeatheringVelocity(p.receiverTable(), depth)) > 0) {
                Tools_RefractionStaticsProject tools = new Tools_RefractionStaticsProject();
                tools.interpolateBadValuesUsingInverseFourth(Pecos.getColNameVel(0), 100.0, 20000.0);
            }
            p.geometryDatabase().writeColumnContentsToDatabase(p.receiverTable(), Pecos.getColNameVel(0));
            p.geometryDatabase().writeColumnContentsToDatabase(p.shotTable(), Pecos.getColNameVel(0));
            RefractionStaticsProject.delayTimeData().getHistory().addWithTime("Set weathering velocity using tomo model");
            RefractionStaticsProject.delayTimeData().getHistory().save();
            if (updateZ) {
                DelayTimeModel.singleton().computeRefractorElevations(p.receiverTable());
                DelayTimeModel.singleton().computeRefractorElevations(p.shotTable());
                RefractionStaticsProject.delayTimeData().getHistory().addWithTime("Recompute refractor elevations");
                RefractionStaticsProject.delayTimeData().getHistory().save();
            }
            try {
                this.getHistory().addWithTime("Computed weathering velocity:");
                this.getHistory().add("Depth = " + Double.toString(depth));
                this.getHistory().add("Update refractor elevation = " + Boolean.toString(updateZ));
                this.getHistory().save();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public int computeWeatheringVelocity(Table_Abstract table, float depth) {
        try {
            int indexDead = table.column_indexOfColumn("Killed");
            int indexV0 = table.column_indexOfColumn(Pecos.getColNameVel(0));
            int indexV1 = table.column_indexOfColumn(Pecos.getColNameVel(1));
            int indexX = table.column_indexOfColumn("Easting");
            int indexY = table.column_indexOfColumn("Northing");
            int indexZ = table.column_indexOfColumn("Elevation");
            int numDead = 0;
            for (int n = 0; n < table.row_count(); ++n) {
                if (table.getBool(n, indexDead)) {
                    table.putDouble(n, indexV0, -9999.0);
                    ++numDead;
                    continue;
                }
                double x = table.getDouble(n, indexX);
                double y = table.getDouble(n, indexY);
                double z = table.getDouble(n, indexZ);
                this.setWorldLocation(x, y, z - (double)depth, true, true);
                double v0 = 1000.0 / Math.max(this.SlownessAtWorld, (double)1.0E-4f);
                double v1 = table.getDouble(n, indexV1);
                v0 = Math.min(v0, 0.95 * v1);
                v0 = Math.max(v0, 0.15 * v1);
                table.putDouble(n, indexV0, v0);
            }
            return numDead;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return 0;
        }
    }

    public Grid3D getMinValidElevationGrid3D() throws Exception {
        try {
            Grid3D grid = this.getEmptyGrid3D();
            float[][] data = grid.data();
            for (int ix = 0; ix < this.m_numX; ++ix) {
                for (int iy = 0; iy < this.m_numY; ++iy) {
                    data[ix][iy] = 0.0f;
                    for (int iz = this.m_numZ - 1; iz >= 0; --iz) {
                        if (!(this.m_count[ix][iy][iz] > 0.5f)) continue;
                        data[ix][iy] = this.m_surfaceElevation[ix][iy] - this.m_nodeDepth[iz];
                        iz = -9999;
                    }
                }
            }
            return grid;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public Grid3D getValidDepthGrid3D() throws Exception {
        try {
            Grid3D grid = this.getEmptyGrid3D();
            float[][] data = grid.data();
            for (int ix = 0; ix < this.m_numX; ++ix) {
                for (int iy = 0; iy < this.m_numY; ++iy) {
                    data[ix][iy] = 0.0f;
                    for (int iz = this.m_numZ - 1; iz >= 0; --iz) {
                        if (!(this.m_count[ix][iy][iz] > 0.5f)) continue;
                        data[ix][iy] = this.m_nodeDepth[iz];
                        iz = -9999;
                    }
                }
            }
            return grid;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public Grid3D getCountAtDepthGrid3D(float depth) throws Exception {
        try {
            Grid3D grid = this.getEmptyGrid3D();
            float[][] data = grid.data();
            for (int ix = 0; ix < this.m_numX; ++ix) {
                for (int iy = 0; iy < this.m_numY; ++iy) {
                    data[ix][iy] = (float)this.countAtDepth(depth, ix, iy);
                }
            }
            grid.smooth(2);
            return grid;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public Grid3D getVelocityAtElevationGrid3D(double z) throws Exception {
        try {
            Grid3D grid = this.getEmptyGrid3D();
            float[][] data = grid.data();
            for (int ix = 0; ix < this.m_numX; ++ix) {
                for (int iy = 0; iy < this.m_numY; ++iy) {
                    float depth = (float)((double)this.m_surfaceElevation[ix][iy] - z);
                    data[ix][iy] = (float)this.velAtDepth(depth, ix, iy);
                }
            }
            return grid;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public Grid3D getErrorAtDepthGrid3D(float depth) throws Exception {
        try {
            Grid3D grid = this.getEmptyGrid3D();
            float[][] data = grid.data();
            for (int ix = 0; ix < this.m_numX; ++ix) {
                for (int iy = 0; iy < this.m_numY; ++iy) {
                    data[ix][iy] = (float)this.errorAtDepth(depth, ix, iy);
                }
            }
            grid.smooth(2);
            return grid;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public Grid3D getVelocityAtDepthGrid3D(float depth) throws Exception {
        try {
            Grid3D grid = this.getEmptyGrid3D();
            float[][] data = grid.data();
            for (int ix = 0; ix < this.m_numX; ++ix) {
                for (int iy = 0; iy < this.m_numY; ++iy) {
                    data[ix][iy] = (float)this.velAtDepth(depth, ix, iy);
                }
            }
            grid.smooth(2);
            return grid;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void writeResidualsToDatabase() {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            this.writeResidualsToDatabase(this.SourceHash, p.shotTable(), "ShotID");
            this.writeResidualsToDatabase(this.ReceiverHash, p.receiverTable(), "ReceiverID");
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void writeResidualsToDatabase(HashMap_Integers<Element> hash, Table_Abstract table, String idname) {
        try {
            int indexID = table.column_indexOfColumn(idname);
            int indexError = table.column_append("TomoVNS_TotalError", DataType.Double);
            int indexResidual = table.column_append("TomoVNS_ResidualError", DataType.Double);
            int numBad = 0;
            for (int n = 0; n < table.row_count(); ++n) {
                table.putDouble(n, indexError, 0.0);
                table.putDouble(n, indexResidual, 0.0);
                int id = table.getInt(n, indexID);
                if (hash.containsKey(id)) {
                    Element e = hash.get(id);
                    table.putDouble(n, indexError, e.Error);
                    table.putDouble(n, indexResidual, e.Residual);
                    continue;
                }
                ++numBad;
            }
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            p.geometryDatabase().writeColumnContentsToDatabase(table, "TomoVNS_TotalError");
            p.geometryDatabase().writeColumnContentsToDatabase(table, "TomoVNS_ResidualError");
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void read(String modelName) {
        try {
            this.m_name = modelName;
            String tomoPath = RefractionStaticsProject.singleton().tomoVNSProjectsPath();
            String fullPath = tomoPath + "/" + modelName;
            this.m_gridFileName = fullPath + "/Model.slowness";
            this.m_surfaceFileName = fullPath + "/Model.surface";
            this.m_waterBottomFileName = fullPath + "/WaterBottom.surface";
            this.m_rayCoverFileName = fullPath + "/Ray.cover";
            RandomAccessFile raf = new RandomAccessFile(this.m_gridFileName, "rw");
            int magic = raf.readInt();
            int version = raf.readInt();
            if (magic != 8300129) {
                raf.close();
                return;
            }
            if (version == 1000) {
                this.m_forceMarineSurvey = raf.readBoolean();
                this.m_waterVelocity = raf.readDouble();
                this.m_originX = raf.readDouble();
                this.m_originY = raf.readDouble();
                this.m_minElevation = raf.readDouble();
                this.m_maxElevation = raf.readDouble();
                this.m_binSizeHorz = raf.readDouble();
                this.m_binSizeVertTop = raf.readDouble();
                this.m_binSizeVertBottom = raf.readDouble();
                this.m_inlineAngle = raf.readDouble();
                this.m_numX = raf.readInt();
                this.m_numY = raf.readInt();
                this.m_numZ = raf.readInt();
                this.computeInternals();
                this.m_nodeDepth = Tools_FileSystem.readArray_Float(raf);
                this.m_slowness = Tools_FileSystem.readArray_Float3D(raf);
                this.m_weight = Tools_FileSystem.readArray_Float3D(raf);
                this.m_error = Tools_FileSystem.readArray_Float3D(raf);
                this.m_count = Tools_FileSystem.readArray_Float3D(raf);
                this.m_blend = new float[this.m_numX][this.m_numY][this.m_numZ];
            }
            if (version == 1001) {
                this.m_vti_constant_apply = raf.readBoolean();
                this.m_vti_constant_delta = raf.readDouble();
                this.m_vti_constant_epsilon = raf.readDouble();
                this.m_forceMarineSurvey = raf.readBoolean();
                this.m_waterVelocity = raf.readDouble();
                this.m_originX = raf.readDouble();
                this.m_originY = raf.readDouble();
                this.m_minElevation = raf.readDouble();
                this.m_maxElevation = raf.readDouble();
                this.m_binSizeHorz = raf.readDouble();
                this.m_binSizeVertTop = raf.readDouble();
                this.m_binSizeVertBottom = raf.readDouble();
                this.m_inlineAngle = raf.readDouble();
                this.m_numX = raf.readInt();
                this.m_numY = raf.readInt();
                this.m_numZ = raf.readInt();
                this.computeInternals();
                this.m_nodeDepth = Tools_FileSystem.readArray_Float(raf);
                this.m_slowness = Tools_FileSystem.readArray_Float3D(raf);
                this.m_weight = Tools_FileSystem.readArray_Float3D(raf);
                this.m_error = Tools_FileSystem.readArray_Float3D(raf);
                this.m_count = Tools_FileSystem.readArray_Float3D(raf);
                this.m_blend = new float[this.m_numX][this.m_numY][this.m_numZ];
            }
            if (version == 1002) {
                System.out.println("raf.getFilePointer() " + raf.getFilePointer());
                this.m_vti_constant_apply = raf.readBoolean();
                System.out.println("raf.getFilePointer() " + raf.getFilePointer());
                this.m_vti_constant_delta = raf.readDouble();
                System.out.println("raf.getFilePointer() " + raf.getFilePointer());
                this.m_vti_constant_epsilon = raf.readDouble();
                this.m_forceMarineSurvey = raf.readBoolean();
                this.m_waterVelocity = raf.readDouble();
                this.m_originX = raf.readDouble();
                this.m_originY = raf.readDouble();
                this.m_minElevation = raf.readDouble();
                this.m_maxElevation = raf.readDouble();
                this.m_binSizeHorz = raf.readDouble();
                this.m_binSizeVertTop = raf.readDouble();
                this.m_binSizeVertBottom = raf.readDouble();
                this.m_inlineAngle = raf.readDouble();
                this.m_numX = raf.readInt();
                this.m_numY = raf.readInt();
                this.m_numZ = raf.readInt();
                this.computeInternals();
                this.m_nodeDepth = Tools_FileSystem.readArray_Float(raf);
                this.m_slowness = Tools_FileSystem.readArray_Float3D(raf);
                this.m_weight = Tools_FileSystem.readArray_Float3D(raf);
                this.m_error = Tools_FileSystem.readArray_Float3D(raf);
                this.m_count = Tools_FileSystem.readArray_Float3D(raf);
                this.m_blend = Tools_FileSystem.readArray_Float3D(raf);
            }
            raf.close();
            if (Tools_FileSystem.exists_file(this.m_rayCoverFileName)) {
                this.m_ray_coverage = Tools_FileSystem.readArray_Bool2D(this.m_rayCoverFileName, this.m_numX, this.m_numY);
            } else {
                this.ray_cover_clear(true);
                Tools_FileSystem.saveArray_Bool2D(this.m_rayCoverFileName, this.m_ray_coverage);
            }
            if (Tools_FileSystem.exists_file(this.m_waterBottomFileName)) {
                this.m_waterBottomDepth = Tools_FileSystem.readArray_Float2D(this.m_waterBottomFileName, this.m_numX, this.m_numY);
            }
            this.m_surfaceElevation = Tools_FileSystem.readArray_Float2D(this.m_surfaceFileName, this.m_numX, this.m_numY);
            this.allocExtraMem();
            this.m_srcFileName = fullPath + "/Model.shots";
            this.m_recFileName = fullPath + "/Model.receivers";
            this.readElement(this.ReceiverHash, this.m_recFileName);
            this.readElement(this.SourceHash, this.m_srcFileName);
            this.writeResidualsToDatabase();
            this.m_historyFileName = fullPath + "/History.txt";
            this.m_history = new History(this.m_historyFileName);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void save(String modelName) {
        try {
            this.m_name = modelName;
            String tomoPath = RefractionStaticsProject.singleton().tomoVNSProjectsPath();
            Object fullPath = tomoPath + "/" + modelName;
            Tools_FileSystem.deletePathIfExists((String)fullPath);
            fullPath = Tools_FileSystem.confirmSubDirectoryExists(tomoPath, modelName);
            this.m_gridFileName = (String)fullPath + "/Model.slowness";
            this.m_surfaceFileName = (String)fullPath + "/Model.surface";
            this.m_waterBottomFileName = (String)fullPath + "/WaterBottom.surface";
            this.m_rayCoverFileName = (String)fullPath + "/Ray.cover";
            RandomAccessFile raf = new RandomAccessFile(this.m_gridFileName, "rw");
            int magic = 8300129;
            int version = 1002;
            raf.writeInt(magic);
            raf.writeInt(version);
            if (version == 1000) {
                raf.writeBoolean(this.m_forceMarineSurvey);
                raf.writeDouble(this.m_waterVelocity);
                raf.writeDouble(this.m_originX);
                raf.writeDouble(this.m_originY);
                raf.writeDouble(this.m_minElevation);
                raf.writeDouble(this.m_maxElevation);
                raf.writeDouble(this.m_binSizeHorz);
                raf.writeDouble(this.m_binSizeVertTop);
                raf.writeDouble(this.m_binSizeVertBottom);
                raf.writeDouble(this.m_inlineAngle);
                raf.writeInt(this.m_numX);
                raf.writeInt(this.m_numY);
                raf.writeInt(this.m_numZ);
                Tools_FileSystem.saveArray_Float(raf, this.m_nodeDepth, this.m_numZ);
                Tools_FileSystem.saveArray_Float3D(raf, this.m_slowness);
                Tools_FileSystem.saveArray_Float3D(raf, this.m_weight);
                Tools_FileSystem.saveArray_Float3D(raf, this.m_error);
                Tools_FileSystem.saveArray_Float3D(raf, this.m_count);
            }
            if (version == 1001) {
                raf.writeBoolean(this.m_vti_constant_apply);
                raf.writeDouble(this.m_vti_constant_delta);
                raf.writeDouble(this.m_vti_constant_epsilon);
                raf.writeBoolean(this.m_forceMarineSurvey);
                raf.writeDouble(this.m_waterVelocity);
                raf.writeDouble(this.m_originX);
                raf.writeDouble(this.m_originY);
                raf.writeDouble(this.m_minElevation);
                raf.writeDouble(this.m_maxElevation);
                raf.writeDouble(this.m_binSizeHorz);
                raf.writeDouble(this.m_binSizeVertTop);
                raf.writeDouble(this.m_binSizeVertBottom);
                raf.writeDouble(this.m_inlineAngle);
                raf.writeInt(this.m_numX);
                raf.writeInt(this.m_numY);
                raf.writeInt(this.m_numZ);
                Tools_FileSystem.saveArray_Float(raf, this.m_nodeDepth, this.m_numZ);
                Tools_FileSystem.saveArray_Float3D(raf, this.m_slowness);
                Tools_FileSystem.saveArray_Float3D(raf, this.m_weight);
                Tools_FileSystem.saveArray_Float3D(raf, this.m_error);
                Tools_FileSystem.saveArray_Float3D(raf, this.m_count);
            }
            if (version == 1002) {
                raf.writeBoolean(this.m_vti_constant_apply);
                raf.writeDouble(this.m_vti_constant_delta);
                raf.writeDouble(this.m_vti_constant_epsilon);
                raf.writeBoolean(this.m_forceMarineSurvey);
                raf.writeDouble(this.m_waterVelocity);
                raf.writeDouble(this.m_originX);
                raf.writeDouble(this.m_originY);
                raf.writeDouble(this.m_minElevation);
                raf.writeDouble(this.m_maxElevation);
                raf.writeDouble(this.m_binSizeHorz);
                raf.writeDouble(this.m_binSizeVertTop);
                raf.writeDouble(this.m_binSizeVertBottom);
                raf.writeDouble(this.m_inlineAngle);
                raf.writeInt(this.m_numX);
                raf.writeInt(this.m_numY);
                raf.writeInt(this.m_numZ);
                Tools_FileSystem.saveArray_Float(raf, this.m_nodeDepth, this.m_numZ);
                Tools_FileSystem.saveArray_Float3D(raf, this.m_slowness);
                Tools_FileSystem.saveArray_Float3D(raf, this.m_weight);
                Tools_FileSystem.saveArray_Float3D(raf, this.m_error);
                Tools_FileSystem.saveArray_Float3D(raf, this.m_count);
                if (this.m_blend == null) {
                    this.m_blend = new float[this.m_numX][this.m_numY][this.m_numZ];
                }
                Tools_FileSystem.saveArray_Float3D(raf, this.m_blend);
            }
            raf.close();
            Tools_FileSystem.saveArray_Bool2D(this.m_rayCoverFileName, this.ray_coverage());
            Tools_FileSystem.saveArray_Float2D(this.m_waterBottomFileName, this.m_waterBottomDepth);
            Tools_FileSystem.saveArray_Float2D(this.m_surfaceFileName, this.m_surfaceElevation);
            this.m_srcFileName = (String)fullPath + "/Model.shots";
            this.m_recFileName = (String)fullPath + "/Model.receivers";
            this.saveElement(this.ReceiverHash, this.m_recFileName);
            this.saveElement(this.SourceHash, this.m_srcFileName);
            this.m_historyFileName = (String)fullPath + "/History.txt";
            if (this.getHistory() == null) {
                this.m_history = new History(this.m_historyFileName);
                this.getHistory().addWithTime("Model created");
                this.getHistory().add("Origin X: " + this.m_originX);
                this.getHistory().add("Origin Y: " + this.m_originY);
                this.getHistory().add("Minimum elevation: " + this.m_minElevation);
                this.getHistory().add("Maximum elevation: " + this.m_maxElevation);
                this.getHistory().add("Horizontal bin spacing: " + this.m_binSizeHorz);
                this.getHistory().add("Vertical bin spacing at surface: " + this.m_binSizeVertTop);
                this.getHistory().add("Vertical bin spacing at bottom: " + this.m_binSizeVertBottom);
                this.getHistory().add("Inline angle: " + this.m_inlineAngle);
                this.getHistory().add("Node count X: " + this.m_numX);
                this.getHistory().add("Node count Y: " + this.m_numY);
                this.getHistory().add("Node count Z: " + this.m_numZ);
                this.getHistory().save();
            } else {
                this.getHistory().save();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void readElement(HashMap_Integers<Element> hash, String fileName) {
        try {
            hash.clear();
            if (!Tools_FileSystem.exists_file(fileName)) {
                return;
            }
            RandomAccessFile raf = new RandomAccessFile(fileName, "rw");
            int magic = raf.readInt();
            if (magic != 244) {
                return;
            }
            int version = raf.readInt();
            int count = raf.readInt();
            for (int n = 0; n < count; ++n) {
                Element e = new Element(raf, version);
                hash.put(e, e.ID);
            }
            raf.close();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void saveElement(HashMap_Integers<Element> hash, String fileName) {
        try {
            RandomAccessFile raf = new RandomAccessFile(fileName, "rw");
            int magic = 244;
            int version = 1000;
            raf.writeInt(magic);
            raf.writeInt(version);
            raf.writeInt(hash.size());
            for (Element e : hash.getValues()) {
                e.save(raf, version);
            }
            raf.close();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void checkMem() {
        try {
            if (this.m_slowness == null) {
                this.m_slowness = new float[this.m_numX][this.m_numY][this.m_numZ];
                this.m_weight = new float[this.m_numX][this.m_numY][this.m_numZ];
                this.m_blend = new float[this.m_numX][this.m_numY][this.m_numZ];
                this.m_error = new float[this.m_numX][this.m_numY][this.m_numZ];
                this.m_count = new float[this.m_numX][this.m_numY][this.m_numZ];
                this.m_blend = new float[this.m_numX][this.m_numY][this.m_numZ];
                this.m_waterBottomDepth = new float[this.m_numX][this.m_numY];
                this.m_surfaceElevation = new float[this.m_numX][this.m_numY];
            }
            this.allocExtraMem();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void allocExtraMem() {
        try {
            this.InterpolatedSlowness = new float[this.m_numZ];
            this.InterpolatedBlend = new float[this.m_numZ];
            this.InterpolatedNodeZ = new float[this.m_numZ];
            this.InterpolatedWeight = new float[this.m_numZ];
            this.InterpolatedCount = new float[this.m_numZ];
            this.m_tempPlane1 = new float[this.m_numX][this.m_numY];
            this.m_tempPlane2 = new float[this.m_numX][this.m_numY];
            this.m_tempPlane3 = new float[this.m_numX][this.m_numY];
            this.m_numCoarseX = 1 + this.m_numX / 4;
            this.m_numCoarseY = 1 + this.m_numY / 4;
            this.m_slownessCoarse = new float[this.m_numCoarseX][this.m_numCoarseY][this.m_numZ];
            this.m_countCoarse = new float[this.m_numCoarseX][this.m_numCoarseY][this.m_numZ];
            this.m_temp1Coarse = new float[this.m_numCoarseX][this.m_numCoarseY][this.m_numZ];
            this.m_temp2Coarse = new float[this.m_numCoarseX][this.m_numCoarseY][this.m_numZ];
            this.m_tempCoarse1 = new float[this.m_numCoarseX][this.m_numCoarseY];
            this.m_tempCoarse2 = new float[this.m_numCoarseX][this.m_numCoarseY];
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void forceIncreasingVelocity(double frac) {
        try {
            for (int x = 0; x < this.m_numX; ++x) {
                for (int y = 0; y < this.m_numY; ++y) {
                    for (int z = 1; z < this.m_numZ; ++z) {
                        double currentVelocity = 1000.0f / this.m_slowness[x][y][z];
                        double minimumPreferredVelocity = frac * 1000.0 / (double)this.m_slowness[x][y][z - 1];
                        if (!(currentVelocity < minimumPreferredVelocity)) continue;
                        this.m_slowness[x][y][z] = (float)(1000.0 / minimumPreferredVelocity);
                    }
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setVelocityGradientZ(double v1, double v2, double maxz, double minz) throws Exception {
        try {
            this.checkMem();
            if (this.m_forceMarineSurvey) {
                v1 = Math.max(v1, 1.2 * this.m_waterVelocity);
            }
            v2 = Math.max(v2, 1.2 * v1);
            double alpha = (v2 - v1) / (minz - maxz);
            double beta = v1 - alpha * maxz;
            for (int x = 0; x < this.m_numX; ++x) {
                for (int y = 0; y < this.m_numY; ++y) {
                    for (int z = 0; z < this.m_numZ; ++z) {
                        double elev = this.m_surfaceElevation[x][y] - this.m_nodeDepth[z];
                        double v = alpha * elev + beta;
                        v = Math.max(v, v1);
                        v = Math.min(v, v2);
                        this.m_slowness[x][y][z] = (float)(1000.0 / v);
                    }
                }
            }
            this.prepWaterVelocity();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public double getElevationAtVelocity(double x, double y, double v) throws Exception {
        try {
            this.setLowerIndices(x, y);
            float[] slow = this.m_slowness[this.LowerIndexX][this.LowerIndexY];
            float surface = this.m_surfaceElevation[this.LowerIndexX][this.LowerIndexY];
            double vt = 1000.0 / (double)slow[0];
            if (v <= vt) {
                return surface;
            }
            vt = 1000.0 / (double)slow[this.m_numZ - 1];
            if (v >= vt) {
                return surface - this.m_nodeDepth[this.m_numZ - 1];
            }
            for (int iz = this.m_numZ - 1; iz >= 1; --iz) {
                double v2 = 1000.0 / (double)slow[iz];
                double v1 = 1000.0 / (double)slow[iz - 1];
                if (!(v <= v2) || !(v >= v1)) continue;
                double alpha = (v - v1) / (v2 - v1 + 1.0E-20);
                double z2 = surface - this.m_nodeDepth[iz];
                double z1 = surface - this.m_nodeDepth[iz - 1];
                return z1 + alpha * (z2 - z1);
            }
            return surface;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void setVelocityGradient(double v1, double v2) throws Exception {
        try {
            this.checkMem();
            if (this.m_forceMarineSurvey) {
                v1 = Math.max(v1, 1.2 * this.m_waterVelocity);
            }
            v2 = Math.max(v2, 1.2 * v1);
            double alpha = (v2 - v1) / (double)this.m_nodeDepth[this.m_numZ - 1];
            for (int x = 0; x < this.m_numX; ++x) {
                for (int y = 0; y < this.m_numY; ++y) {
                    for (int z = 0; z < this.m_numZ; ++z) {
                        double v = alpha * (double)this.m_nodeDepth[z] + v1;
                        this.m_slowness[x][y][z] = (float)(1000.0 / v);
                    }
                }
            }
            this.prepWaterVelocity();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void computeInternals() {
        try {
            this.m_cosineInlineAngle = Math.cos(this.m_inlineAngle);
            this.m_sineInlineAngle = Math.sin(this.m_inlineAngle);
            this.m_binSizeHorz = Math.max(1.0, this.m_binSizeHorz);
            this.m_inverseBinSizeHorz = 1.0 / this.m_binSizeHorz;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public Java2D_PaintablePointArray createPointArray() {
        try {
            int num = this.m_numX * this.m_numY;
            Java2D_PaintablePointArray pa = new Java2D_PaintablePointArray();
            pa.setLength(num);
            int n = 0;
            for (int x = 0; x < this.m_numX; ++x) {
                for (int y = 0; y < this.m_numY; ++y) {
                    this.setGridLocation(x, y);
                    pa.setX(n, this.WorldX);
                    pa.setY(n, this.WorldY);
                    ++n;
                }
            }
            pa.UseColorScale = false;
            pa.SymbolColor = new Color(255, 111, 111, 128);
            pa.SymbolSize = 3;
            return pa;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    public void addChunk(Java2D_Polygon poly, double minDepth, double maxDepth, double vel) {
        try {
            for (int x = 0; x < this.m_numX; ++x) {
                for (int y = 0; y < this.m_numY; ++y) {
                    this.setGridLocation(x, y);
                    if (!poly.contains(this.WorldX, this.WorldY)) continue;
                    for (int z = 0; z < this.m_numZ; ++z) {
                        double depth = this.m_nodeDepth[z];
                        if (!(depth >= minDepth) || !(depth <= maxDepth)) continue;
                        this.m_slowness[x][y][z] = 1000.0f / (float)vel;
                    }
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setGridLocation(int indexX, int indexY) {
        try {
            this.GridX = (double)indexX * this.m_binSizeHorz;
            this.GridY = (double)indexY * this.m_binSizeHorz;
            this.WorldX = this.m_originX + this.m_cosineInlineAngle * this.GridX - this.m_sineInlineAngle * this.GridY;
            this.WorldY = this.m_originY + this.m_cosineInlineAngle * this.GridY + this.m_sineInlineAngle * this.GridX;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void computeStaticsV2(double x, double y, double z, double intDatum1, double finalDatum1, double repVel) {
        try {
            int n;
            this.IntermediateDatum = intDatum1;
            this.FinalDatum = finalDatum1;
            this.TimeToFinalDatum = 1000.0 * (this.FinalDatum - this.IntermediateDatum) / repVel;
            this.setWorldLocation(x, y, true, true, true, true);
            if (this.IntermediateDatum >= z) {
                double vel = 1000.0 / this.SlownessAtWorld;
                this.TimeToIntermediateDatum = 1000.0 * (z - this.IntermediateDatum) / vel;
                this.Statics = this.TimeToFinalDatum - this.TimeToIntermediateDatum;
                return;
            }
            if (this.m_tempStaticsSlowness == null) {
                this.m_tempStaticsSlowness = new double[this.m_tempStaticsCount];
            }
            double deltaZ = (z - this.IntermediateDatum) / (double)(this.m_tempStaticsCount - 1);
            for (n = 0; n < this.m_tempStaticsCount; ++n) {
                double zt = z - (double)n * deltaZ;
                boolean found = false;
                if (zt >= (double)this.InterpolatedNodeZ[0]) {
                    found = true;
                    this.m_tempStaticsSlowness[n] = this.InterpolatedSlowness[0];
                }
                if (zt <= (double)this.InterpolatedNodeZ[this.m_numZ - 1]) {
                    found = true;
                    this.m_tempStaticsSlowness[n] = this.InterpolatedSlowness[this.m_nodeDepth.length - 1];
                }
                for (int m = 1; m < this.m_nodeDepth.length && !found; ++m) {
                    if (!(zt >= (double)this.InterpolatedNodeZ[m])) continue;
                    found = true;
                    double w = ((double)this.InterpolatedNodeZ[m - 1] - zt) / (double)(this.InterpolatedNodeZ[m - 1] - this.InterpolatedNodeZ[m]);
                    this.m_tempStaticsSlowness[n] = w * (double)this.InterpolatedSlowness[m] + (1.0 - w) * (double)this.InterpolatedSlowness[m - 1];
                }
            }
            this.TimeToIntermediateDatum = 0.0;
            for (n = 0; n < this.m_tempStaticsCount - 1; ++n) {
                double avg = 0.5 * (this.m_tempStaticsSlowness[n] + this.m_tempStaticsSlowness[n + 1]);
                this.TimeToIntermediateDatum += avg * deltaZ;
            }
            this.Statics = this.TimeToFinalDatum - this.TimeToIntermediateDatum;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public synchronized void setWorldLocation(double worldX, double worldY, double worldZ, boolean fixEdgeIndices, boolean interpolateGrids) throws Exception {
        try {
            this.setWorldLocation(worldX, worldY, fixEdgeIndices, interpolateGrids, interpolateGrids, interpolateGrids);
            if (worldZ >= (double)this.InterpolatedNodeZ[0]) {
                return;
            }
            if (worldZ <= (double)this.InterpolatedNodeZ[this.InterpolatedNodeZ.length - 1]) {
                return;
            }
            for (int n = 0; n < this.InterpolatedNodeZ.length - 1; ++n) {
                if (!(worldZ <= (double)this.InterpolatedNodeZ[n]) || !(worldZ >= (double)this.InterpolatedNodeZ[n + 1])) continue;
                double w = (worldZ - (double)this.InterpolatedNodeZ[n + 1]) / (double)(this.InterpolatedNodeZ[n] - this.InterpolatedNodeZ[n + 1]);
                this.SlownessAtWorld = (double)this.InterpolatedSlowness[n] * w + (double)this.InterpolatedSlowness[n + 1] * (1.0 - w);
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public synchronized void setLowerIndices(double worldX, double worldY) throws Exception {
        try {
            this.WorldX = worldX;
            this.WorldY = worldY;
            double dx = worldX - this.m_originX;
            double dy = worldY - this.m_originY;
            this.GridY = this.m_cosineInlineAngle * dy - this.m_sineInlineAngle * dx;
            this.GridX = this.m_cosineInlineAngle * dx + this.m_sineInlineAngle * dy;
            this.FloatIndexX = this.GridX * this.m_inverseBinSizeHorz;
            this.FloatIndexY = this.GridY * this.m_inverseBinSizeHorz;
            this.LowerIndexX = (int)this.FloatIndexX;
            this.LowerIndexY = (int)this.FloatIndexY;
            while (this.LowerIndexX > (int)this.FloatIndexX) {
                --this.LowerIndexX;
            }
            while (this.LowerIndexY > (int)this.FloatIndexY) {
                --this.LowerIndexY;
            }
            if (this.LowerIndexX < 0 || this.LowerIndexY < 0) {
                boolean bl = false;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public synchronized void setWorldLocation(double worldX, double worldY, boolean fixEdgeIndices, boolean interpolateSlowness, boolean interpolateWeight, boolean interpolateCount) throws Exception {
        try {
            this.setLowerIndices(worldX, worldY);
            this.UpperWeightX = this.FloatIndexX - (double)this.LowerIndexX;
            this.UpperWeightY = this.FloatIndexY - (double)this.LowerIndexY;
            this.LowerWeightX = 1.0 - this.UpperWeightX;
            this.LowerWeightY = 1.0 - this.UpperWeightY;
            this.UpperIndexValidX = this.LowerIndexX + 1 < this.m_numX;
            this.UpperIndexValidY = this.LowerIndexY + 1 < this.m_numY;
            this.LowerIndexValidX = this.LowerIndexX >= 0;
            boolean bl = this.LowerIndexValidY = this.LowerIndexY >= 0;
            if (this.LowerIndexValidX && this.LowerIndexValidY && this.UpperIndexValidX && this.UpperIndexValidY) {
                this.OnEdge = false;
                this.UpperIndexX = this.LowerIndexX + 1;
                this.UpperIndexY = this.LowerIndexY + 1;
            } else {
                this.OnEdge = true;
                this.EdgeIndexX = this.LowerIndexX;
                this.EdgeIndexX = Math.max(this.EdgeIndexX, 0);
                this.EdgeIndexX = Math.min(this.EdgeIndexX, this.m_numX - 1);
                this.EdgeIndexY = this.LowerIndexY;
                this.EdgeIndexY = Math.max(this.EdgeIndexY, 0);
                this.EdgeIndexY = Math.min(this.EdgeIndexY, this.m_numY - 1);
                if (fixEdgeIndices) {
                    this.UpperIndexX = this.LowerIndexX = this.EdgeIndexX;
                    this.UpperIndexY = this.LowerIndexY = this.EdgeIndexY;
                    this.LowerWeightX = 1.0;
                    this.LowerWeightY = 1.0;
                    this.UpperWeightX = 0.0;
                    this.UpperWeightY = 0.0;
                }
            }
            if (this.OnEdge && !fixEdgeIndices) {
                throw new Exception("fixEdgeIndices == false");
            }
            if (this.m_waterBottomDepth != null) {
                this.InterpolatedWaterBottom = this.LowerWeightX * this.LowerWeightY * (double)this.m_waterBottomDepth[this.LowerIndexX][this.LowerIndexY] + this.UpperWeightX * this.LowerWeightY * (double)this.m_waterBottomDepth[this.UpperIndexX][this.LowerIndexY] + this.UpperWeightX * this.UpperWeightY * (double)this.m_waterBottomDepth[this.UpperIndexX][this.UpperIndexY] + this.LowerWeightX * this.UpperWeightY * (double)this.m_waterBottomDepth[this.LowerIndexX][this.UpperIndexY];
            }
            if (this.m_surfaceElevation != null) {
                this.InterpolatedElevation = this.LowerWeightX * this.LowerWeightY * (double)this.m_surfaceElevation[this.LowerIndexX][this.LowerIndexY] + this.UpperWeightX * this.LowerWeightY * (double)this.m_surfaceElevation[this.UpperIndexX][this.LowerIndexY] + this.UpperWeightX * this.UpperWeightY * (double)this.m_surfaceElevation[this.UpperIndexX][this.UpperIndexY] + this.LowerWeightX * this.UpperWeightY * (double)this.m_surfaceElevation[this.LowerIndexX][this.UpperIndexY];
            }
            this.SlownessAtWorld = this.LowerWeightX * this.LowerWeightY * (double)this.m_slowness[this.LowerIndexX][this.LowerIndexY][0] + this.UpperWeightX * this.LowerWeightY * (double)this.m_slowness[this.UpperIndexX][this.LowerIndexY][0] + this.UpperWeightX * this.UpperWeightY * (double)this.m_slowness[this.UpperIndexX][this.UpperIndexY][0] + this.LowerWeightX * this.UpperWeightY * (double)this.m_slowness[this.LowerIndexX][this.UpperIndexY][0];
            for (int n = 0; n < this.m_numZ; ++n) {
                this.InterpolatedNodeZ[n] = (float)this.InterpolatedElevation - this.m_nodeDepth[n];
                if (interpolateSlowness) {
                    this.InterpolatedSlowness[n] = (float)(this.LowerWeightX * this.LowerWeightY * (double)this.m_slowness[this.LowerIndexX][this.LowerIndexY][n]) + (float)(this.UpperWeightX * this.LowerWeightY * (double)this.m_slowness[this.UpperIndexX][this.LowerIndexY][n]) + (float)(this.UpperWeightX * this.UpperWeightY * (double)this.m_slowness[this.UpperIndexX][this.UpperIndexY][n]) + (float)(this.LowerWeightX * this.UpperWeightY * (double)this.m_slowness[this.LowerIndexX][this.UpperIndexY][n]);
                    this.InterpolatedBlend[n] = (float)(this.LowerWeightX * this.LowerWeightY * (double)this.m_blend[this.LowerIndexX][this.LowerIndexY][n]) + (float)(this.UpperWeightX * this.LowerWeightY * (double)this.m_blend[this.UpperIndexX][this.LowerIndexY][n]) + (float)(this.UpperWeightX * this.UpperWeightY * (double)this.m_blend[this.UpperIndexX][this.UpperIndexY][n]) + (float)(this.LowerWeightX * this.UpperWeightY * (double)this.m_blend[this.LowerIndexX][this.UpperIndexY][n]);
                }
                if (interpolateWeight) {
                    this.InterpolatedWeight[n] = (float)(this.LowerWeightX * this.LowerWeightY * (double)this.m_weight[this.LowerIndexX][this.LowerIndexY][n]) + (float)(this.UpperWeightX * this.LowerWeightY * (double)this.m_weight[this.UpperIndexX][this.LowerIndexY][n]) + (float)(this.UpperWeightX * this.UpperWeightY * (double)this.m_weight[this.UpperIndexX][this.UpperIndexY][n]) + (float)(this.LowerWeightX * this.UpperWeightY * (double)this.m_weight[this.LowerIndexX][this.UpperIndexY][n]);
                }
                if (!interpolateCount) continue;
                this.InterpolatedCount[n] = (float)(this.LowerWeightX * this.LowerWeightY * (double)this.m_count[this.LowerIndexX][this.LowerIndexY][n]) + (float)(this.UpperWeightX * this.LowerWeightY * (double)this.m_count[this.UpperIndexX][this.LowerIndexY][n]) + (float)(this.UpperWeightX * this.UpperWeightY * (double)this.m_count[this.UpperIndexX][this.UpperIndexY][n]) + (float)(this.LowerWeightX * this.UpperWeightY * (double)this.m_count[this.LowerIndexX][this.UpperIndexY][n]);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    protected Tomo_VNS() throws Exception {
    }

    public static Tomo_VNS createTomoVnsForStandaloneTesting(String fullPath) throws Exception {
        Tomo_VNS tomoVNS = new Tomo_VNS();
        tomoVNS.readFromPathForForStandaloneTesting(fullPath);
        return tomoVNS;
    }

    public void readFromPathForForStandaloneTesting(String fullPath) throws Exception {
        try {
            File file = new File(fullPath);
            this.m_name = file.getName();
            this.m_gridFileName = fullPath + "/Model.slowness";
            this.m_surfaceFileName = fullPath + "/Model.surface";
            this.m_waterBottomFileName = fullPath + "/WaterBottom.surface";
            RandomAccessFile raf = new RandomAccessFile(this.m_gridFileName, "rw");
            int magic = raf.readInt();
            int version = raf.readInt();
            if (magic != 8300129) {
                raf.close();
                return;
            }
            if (version == 1000) {
                this.m_forceMarineSurvey = raf.readBoolean();
                this.m_waterVelocity = raf.readDouble();
                this.m_originX = raf.readDouble();
                this.m_originY = raf.readDouble();
                this.m_minElevation = raf.readDouble();
                this.m_maxElevation = raf.readDouble();
                this.m_binSizeHorz = raf.readDouble();
                this.m_binSizeVertTop = raf.readDouble();
                this.m_binSizeVertBottom = raf.readDouble();
                this.m_inlineAngle = raf.readDouble();
                this.m_numX = raf.readInt();
                this.m_numY = raf.readInt();
                this.m_numZ = raf.readInt();
                this.computeInternals();
                this.m_nodeDepth = Tools_FileSystem.readArray_Float(raf);
                this.m_slowness = Tools_FileSystem.readArray_Float3D(raf);
                this.m_weight = Tools_FileSystem.readArray_Float3D(raf);
                this.m_error = Tools_FileSystem.readArray_Float3D(raf);
                this.m_count = Tools_FileSystem.readArray_Float3D(raf);
            }
            raf.close();
            if (Tools_FileSystem.exists_file(this.m_waterBottomFileName)) {
                this.m_waterBottomDepth = Tools_FileSystem.readArray_Float2D(this.m_waterBottomFileName, this.m_numX, this.m_numY);
            }
            this.m_surfaceElevation = Tools_FileSystem.readArray_Float2D(this.m_surfaceFileName, this.m_numX, this.m_numY);
            this.allocExtraMem();
            this.m_srcFileName = fullPath + "/Model.shots";
            this.m_recFileName = fullPath + "/Model.receivers";
            this.readElement(this.ReceiverHash, this.m_recFileName);
            this.readElement(this.SourceHash, this.m_srcFileName);
            this.m_historyFileName = fullPath + "/History.txt";
            this.m_history = new History(this.m_historyFileName);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void saveToPathForTesting(String fullPath) throws Exception {
        try {
            Tools_FileSystem.deletePathIfExists(fullPath);
            File dir = new File(fullPath);
            boolean bOk = dir.mkdir();
            if (!bOk) {
                throw new Exception("failed to create directory : " + fullPath);
            }
            this.m_gridFileName = fullPath + "/Model.slowness";
            this.m_surfaceFileName = fullPath + "/Model.surface";
            this.m_waterBottomFileName = fullPath + "/WaterBottom.surface";
            RandomAccessFile raf = new RandomAccessFile(this.m_gridFileName, "rw");
            int magic = 8300129;
            int version = 1000;
            raf.writeInt(magic);
            raf.writeInt(version);
            if (version == 1000) {
                raf.writeBoolean(this.m_forceMarineSurvey);
                raf.writeDouble(this.m_waterVelocity);
                raf.writeDouble(this.m_originX);
                raf.writeDouble(this.m_originY);
                raf.writeDouble(this.m_minElevation);
                raf.writeDouble(this.m_maxElevation);
                raf.writeDouble(this.m_binSizeHorz);
                raf.writeDouble(this.m_binSizeVertTop);
                raf.writeDouble(this.m_binSizeVertBottom);
                raf.writeDouble(this.m_inlineAngle);
                raf.writeInt(this.m_numX);
                raf.writeInt(this.m_numY);
                raf.writeInt(this.m_numZ);
                Tools_FileSystem.saveArray_Float(raf, this.m_nodeDepth, this.m_numZ);
                Tools_FileSystem.saveArray_Float3D(raf, this.m_slowness);
                Tools_FileSystem.saveArray_Float3D(raf, this.m_weight);
                Tools_FileSystem.saveArray_Float3D(raf, this.m_error);
                Tools_FileSystem.saveArray_Float3D(raf, this.m_count);
            }
            raf.close();
            Tools_FileSystem.saveArray_Float2D(this.m_waterBottomFileName, this.m_waterBottomDepth);
            Tools_FileSystem.saveArray_Float2D(this.m_surfaceFileName, this.m_surfaceElevation);
            this.m_srcFileName = fullPath + "/Model.shots";
            this.m_recFileName = fullPath + "/Model.receivers";
            this.saveElement(this.ReceiverHash, this.m_recFileName);
            this.saveElement(this.SourceHash, this.m_srcFileName);
            this.m_historyFileName = fullPath + "/History.txt";
            if (this.getHistory() == null) {
                this.m_history = new History(this.m_historyFileName);
                this.getHistory().addWithTime("Model created");
                this.getHistory().add("Origin X: " + this.m_originX);
                this.getHistory().add("Origin Y: " + this.m_originY);
                this.getHistory().add("Minimum elevation: " + this.m_minElevation);
                this.getHistory().add("Maximum elevation: " + this.m_maxElevation);
                this.getHistory().add("Horizontal bin spacing: " + this.m_binSizeHorz);
                this.getHistory().add("Vertical bin spacing at surface: " + this.m_binSizeVertTop);
                this.getHistory().add("Vertical bin spacing at bottom: " + this.m_binSizeVertBottom);
                this.getHistory().add("Inline angle: " + this.m_inlineAngle);
                this.getHistory().add("Node count X: " + this.m_numX);
                this.getHistory().add("Node count Y: " + this.m_numY);
                this.getHistory().add("Node count Z: " + this.m_numZ);
                this.getHistory().save();
            } else {
                this.getHistory().save();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public float[][][] getSlowness() {
        return this.m_slowness;
    }

    public float[][][] getWeight() {
        return this.m_weight;
    }

    public float[][][] getCount() {
        return this.m_count;
    }

    public float[][][] getError() {
        return this.m_error;
    }

    public Grid3D_Conversion getGridConversion() {
        Grid3D_Conversion gc = new Grid3D_Conversion();
        gc.setBinSize(this.m_binSizeHorz, this.m_binSizeHorz);
        gc.setInlineAngle(this.m_inlineAngle);
        gc.setOrigin(this.m_originX, this.m_originY);
        gc.setBinCounts(this.m_numX, this.m_numY);
        return gc;
    }

    public static class Element {
        public int ID;
        public double Count = 1.0E-5;
        public double Error = 0.0;
        public double Residual = 0.0;
        public double ComputedResidual = 0.0;

        public Element(int id) {
            this.ID = id;
        }

        public Element(RandomAccessFile raf, int version) {
            try {
                if (version == 1000) {
                    this.ID = raf.readInt();
                    this.Count = raf.readDouble();
                    this.Error = raf.readDouble();
                    this.Residual = raf.readDouble();
                    this.ComputedResidual = raf.readDouble();
                }
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        public void save(RandomAccessFile raf, int version) {
            try {
                if (version == 1000) {
                    raf.writeInt(this.ID);
                    raf.writeDouble(this.Count);
                    raf.writeDouble(this.Error);
                    raf.writeDouble(this.Residual);
                    raf.writeDouble(this.ComputedResidual);
                }
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        public void addError(float error) {
            this.Count += 1.0;
            this.Error += (double)Math.abs(error);
            this.Residual += (double)error;
        }
    }

    protected class CrapElement {
        public int X = 0;
        public int Count = 0;
        public float[] Elevation;
        public float[] Slowness;

        protected CrapElement() {
        }
    }
}

