/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Refraction.Tomography.VNS;

import com.PecosCore.Windows.Shared.IProgressMonitor;
import com.PecosLibrary.Math.EmptyGridInterpolator;
import com.PecosLibrary.Refraction.Tomography.VNS.Tomo_VNS;

public class TomoInterpolator_VNS {
    protected int m_numX = 0;
    protected int m_numY = 0;
    protected int m_numZ = 0;
    protected float[][][] m_slowness;
    protected float[][][] m_weight;
    protected float[][][] m_tempArray;
    protected float[][][] m_count;
    protected float[][] m_surfaceElevation;
    protected float[][][] m_slownessCoarse;
    protected float[][][] m_countCoarse;
    protected float[][][] m_temp1Coarse;
    protected float[][][] m_temp2Coarse;
    protected boolean[][] m_ray_cover;
    protected int m_coarseRadius;
    protected int m_numValidCoarseX;
    protected int m_numValidCoarseY;
    protected float m_minValidCount = 10.0f;
    protected float m_maxCoarseCount = 0.0f;
    protected float m_averageCoarseCount = 1.0f;
    protected float m_averageCount = 9.0f;
    protected int m_totalIterations = 1;
    protected int m_currentIteration = 1;
    protected float[] m_weightH;
    protected int m_minValidZ = 0;
    protected int m_maxValidZ = 0;
    protected IProgressMonitor m_pm;

    public void prepare(Tomo_VNS tomo, int coarseRadius, int totalIterations) {
        try {
            this.m_totalIterations = totalIterations;
            this.m_coarseRadius = Math.max(3, coarseRadius);
            this.m_numX = tomo.numX();
            this.m_numY = tomo.numY();
            this.m_numZ = tomo.numZ();
            this.m_ray_cover = tomo.ray_coverage();
            this.m_surfaceElevation = tomo.surfaceElevation();
            this.m_slowness = tomo.slowness();
            this.m_weight = tomo.weight();
            this.m_tempArray = new float[tomo.numX()][tomo.numY()][tomo.numZ()];
            this.m_count = tomo.count();
            this.m_numValidCoarseX = 1 + this.m_numX / this.m_coarseRadius;
            this.m_numValidCoarseY = 1 + this.m_numY / this.m_coarseRadius;
            this.m_slownessCoarse = new float[this.m_numValidCoarseX][this.m_numValidCoarseY][this.m_numZ];
            this.m_countCoarse = new float[this.m_numValidCoarseX][this.m_numValidCoarseY][this.m_numZ];
            this.m_temp1Coarse = new float[this.m_numValidCoarseX][this.m_numValidCoarseY][this.m_numZ];
            this.m_temp2Coarse = new float[this.m_numValidCoarseX][this.m_numValidCoarseY][this.m_numZ];
            int maxH = Math.max(this.m_numValidCoarseX + 1, this.m_numValidCoarseY + 1);
            this.m_weightH = new float[maxH];
            for (int h = 0; h < maxH; ++h) {
                this.m_weightH[h] = 10.0f / (2.0f + (float)h);
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public void prepare(int numX, int numY, int numZ, float[][] surfaceElevation, float[][][] slowness, float[][][] weight, float[][][] count, int coarseRadius, int totalIterations) {
        try {
            this.m_totalIterations = totalIterations;
            this.m_coarseRadius = Math.max(3, coarseRadius);
            this.m_numX = numX;
            this.m_numY = numY;
            this.m_numZ = numZ;
            this.m_surfaceElevation = surfaceElevation;
            this.m_slowness = slowness;
            this.m_weight = weight;
            this.m_tempArray = new float[numX][numY][numZ];
            this.m_count = count;
            this.m_numValidCoarseX = 1 + this.m_numX / this.m_coarseRadius;
            this.m_numValidCoarseY = 1 + this.m_numY / this.m_coarseRadius;
            this.m_slownessCoarse = new float[this.m_numValidCoarseX][this.m_numValidCoarseY][this.m_numZ];
            this.m_countCoarse = new float[this.m_numValidCoarseX][this.m_numValidCoarseY][this.m_numZ];
            this.m_temp1Coarse = new float[this.m_numValidCoarseX][this.m_numValidCoarseY][this.m_numZ];
            this.m_temp2Coarse = new float[this.m_numValidCoarseX][this.m_numValidCoarseY][this.m_numZ];
            int maxH = Math.max(this.m_numValidCoarseX + 1, this.m_numValidCoarseY + 1);
            this.m_weightH = new float[maxH];
            for (int h = 0; h < maxH; ++h) {
                this.m_weightH[h] = 10.0f / (2.0f + (float)h);
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    protected void setPM(String s) {
        try {
            if (this.m_pm != null) {
                this.m_pm.setMessage_Level2(s);
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public void smooth_new(IProgressMonitor pm, int radiusX, double smoothDecay, int radiusZ, float fractionCoarse, int currentIteration, boolean forceIncrease, boolean always_smooth) {
        try {
            this.m_pm = pm;
            System.out.println("iter " + currentIteration + " of " + this.m_totalIterations);
            System.out.println("always_smooth " + always_smooth);
            this.m_currentIteration = currentIteration;
            EmptyGridInterpolator grid = new EmptyGridInterpolator(this.m_numX, this.m_numY);
            for (int z = 0; z < this.m_numZ; ++z) {
                grid.clear();
                for (int x = 0; x < this.m_numX; ++x) {
                    for (int y = 0; y < this.m_numY; ++y) {
                        if (!((double)this.m_count[x][y][z] > 0.1)) continue;
                        grid.add(x, y, this.m_slowness[x][y][z], this.m_count[x][y][z]);
                    }
                }
                if (grid.Count < 1L) continue;
                double[][] s = grid.finish(10, true);
                s = grid.smooth(radiusX, smoothDecay, true);
                for (int x = 0; x < this.m_numX; ++x) {
                    for (int y = 0; y < this.m_numY; ++y) {
                        this.m_slowness[x][y][z] = (float)s[x][y];
                        this.m_weight[x][y][z] = this.m_count[x][y][z];
                    }
                }
            }
            if (forceIncrease) {
                this.setPM("Smoothing results - force increasing velocity");
                for (int x = 0; x < this.m_numX; ++x) {
                    for (int y = 0; y < this.m_numY; ++y) {
                        for (int z = 1; z < this.m_numZ; ++z) {
                            if (!(this.m_slowness[x][y][z] > this.m_slowness[x][y][z - 1])) continue;
                            this.m_slowness[x][y][z] = this.m_slowness[x][y][z - 1];
                        }
                    }
                }
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public void smooth_old(IProgressMonitor pm, int radiusX, double smoothDecay, int radiusZ, float fractionCoarse, int currentIteration, boolean forceIncrease, boolean always_smooth) {
        try {
            int x;
            this.m_pm = pm;
            System.out.println("iter " + currentIteration + " of " + this.m_totalIterations);
            System.out.println("always_smooth " + always_smooth);
            this.m_currentIteration = currentIteration;
            this.setPM("Smoothing results - initialize coarse model");
            this.initCoarse();
            this.printCoarseInfo("After initCoarse");
            if (this.m_maxCoarseCount < 1.5f) {
                return;
            }
            this.m_minValidCount = Math.min(this.m_maxCoarseCount / 5.0f, 10.0f);
            this.m_minValidCount = Math.max(5.0f, this.m_minValidCount);
            this.setPM("Smoothing results - horizontal extrapolation");
            if (!this.horizontal()) {
                return;
            }
            this.printCoarseInfo("After horizontal");
            this.setPM("Smoothing results - smooth coarse model");
            this.smoothCoarse(radiusX, radiusZ);
            this.printCoarseInfo("After smoothCoarse");
            double sumCount = 0.0;
            for (int x2 = 0; x2 < this.m_numX; ++x2) {
                for (int y = 0; y < this.m_numY; ++y) {
                    for (int z = 0; z < this.m_numZ; ++z) {
                        sumCount += (double)this.m_count[x2][y][z];
                    }
                }
            }
            this.m_averageCount = (float)(sumCount / (double)(this.m_numX * this.m_numY * this.m_numZ));
            float scalar = this.m_coarseRadius * this.m_coarseRadius;
            int numFunky = 0;
            this.setPM("Smoothing results - make sure each node valid...");
            int numBadSum = 0;
            for (int x3 = 0; x3 < this.m_numX; ++x3) {
                for (int y = 0; y < this.m_numY; ++y) {
                    for (int z = 0; z < this.m_numZ; ++z) {
                        float slow;
                        int cx = x3 / this.m_coarseRadius;
                        int cy = y / this.m_coarseRadius;
                        float coarseCount = this.m_countCoarse[cx][cy][z];
                        float coarseSlow = this.m_slownessCoarse[cx][cy][z];
                        float fineCount = scalar * this.m_count[x3][y][z];
                        float fineSlow = this.m_slowness[x3][y][z];
                        if (fineCount < 1.0f) {
                            ++numFunky;
                        }
                        if (Math.abs(slow = ((coarseCount = fractionCoarse * coarseCount) * coarseSlow + (fineCount = (1.0f - fractionCoarse) * fineCount) * fineSlow) / (coarseCount + fineCount)) < 1.0E-5f) {
                            ++numFunky;
                        }
                        if (Float.isNaN(slow) || Float.isInfinite(slow)) {
                            ++numFunky;
                        }
                        this.m_tempArray[x3][y][z] = slow;
                        this.m_weight[x3][y][z] = coarseCount + fineCount;
                    }
                }
            }
            double[] maxPlaneWeight = new double[this.m_numZ];
            double[] maxPlaneCount = new double[this.m_numZ];
            for (int x4 = 0; x4 < this.m_numX; ++x4) {
                for (int y = 0; y < this.m_numY; ++y) {
                    for (int z = 0; z < this.m_numZ; ++z) {
                        maxPlaneWeight[z] = Math.max(maxPlaneWeight[z], (double)this.m_weight[x4][y][z]);
                        maxPlaneCount[z] = Math.max(maxPlaneCount[z], (double)this.m_count[x4][y][z]);
                    }
                }
            }
            this.setPM("Smoothing results - planar smoothing");
            radiusX = Math.max(radiusX, 1);
            radiusX = Math.min(radiusX, 10);
            int maxRadius = 120;
            double[] decay = new double[maxRadius];
            double alpha = -Math.log(smoothDecay) / (double)radiusX;
            for (int n = 0; n < decay.length; ++n) {
                decay[n] = Math.exp(-alpha * (double)n);
            }
            for (x = 0; x < this.m_numX; ++x) {
                int percent = (int)(100.0 * (double)x / (double)this.m_numX);
                String str = String.format("Smoothing results - planar smoothing (%d percent)", percent);
                this.setPM(str);
                for (int y = 0; y < this.m_numY; ++y) {
                    if (!always_smooth && !this.m_ray_cover[x][y]) continue;
                    for (int z = 0; z < this.m_numZ; ++z) {
                        int radX = Math.max(4, 2 + 2 * radiusX);
                        radX = Math.min(radX, 12);
                        int minx = Math.max(x - radX, 0);
                        int maxx = Math.min(x + radX, this.m_numX - 1);
                        int miny = Math.max(y - radX, 0);
                        int maxy = Math.min(y + radX, this.m_numY - 1);
                        int minz = Math.max(z - radiusZ, 0);
                        int maxz = Math.min(z + radiusZ, this.m_numZ - 1);
                        double sum1 = 0.0;
                        double sum2 = 1.0E-20f;
                        for (int ix = minx; ix <= maxx; ++ix) {
                            for (int iy = miny; iy <= maxy; ++iy) {
                                float wx = (float)decay[Math.abs(ix - x)];
                                float wy = (float)decay[Math.abs(iy - y)];
                                float w = wx * wy * this.m_weight[ix][iy][z];
                                w = Math.max(w, 1.0E-6f);
                                float s = this.m_tempArray[ix][iy][z];
                                sum1 += (double)(s * w);
                                sum2 += (double)w;
                            }
                        }
                        if (sum2 > 1.0) {
                            this.m_slowness[x][y][z] = (float)(sum1 / sum2);
                        } else {
                            ++numBadSum;
                        }
                        if (Math.abs(this.m_slowness[x][y][z]) < 1.0E-5f) {
                            ++numFunky;
                        }
                        if (!Float.isNaN(this.m_slowness[x][y][z]) && !Float.isInfinite(this.m_slowness[x][y][z])) continue;
                        ++numFunky;
                    }
                }
            }
            if (forceIncrease) {
                this.setPM("Smoothing results - force increasing velocity");
                for (x = 0; x < this.m_numX; ++x) {
                    for (int y = 0; y < this.m_numY; ++y) {
                        for (int z = 1; z < this.m_numZ; ++z) {
                            if (!(this.m_slowness[x][y][z] > this.m_slowness[x][y][z - 1])) continue;
                            this.m_slowness[x][y][z] = this.m_slowness[x][y][z - 1];
                        }
                    }
                }
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    protected void printCoarseInfo(String msg) {
        try {
            for (int cz = 0; cz < this.m_numZ; ++cz) {
                double minSlow = Double.MAX_VALUE;
                double maxSlow = Double.MIN_VALUE;
                double minCount = Double.MAX_VALUE;
                double maxCount = Double.MIN_VALUE;
                for (int cx = 0; cx < this.m_numValidCoarseX; ++cx) {
                    for (int cy = 0; cy < this.m_numValidCoarseY; ++cy) {
                        minCount = Math.min((double)this.m_countCoarse[cx][cy][cz], minCount);
                        maxCount = Math.max((double)this.m_countCoarse[cx][cy][cz], maxCount);
                        minSlow = Math.min((double)this.m_slownessCoarse[cx][cy][cz], minSlow);
                        maxSlow = Math.max((double)this.m_slownessCoarse[cx][cy][cz], maxSlow);
                    }
                }
                double maxVel = 1000.0 / minSlow;
                double d = 1000.0 / maxSlow;
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public void smoothCoarse(int radiusX, int radiusZ) {
        try {
            for (int cz = 0; cz < this.m_numZ; ++cz) {
                int cy;
                int cx;
                double sumPlaneCount = 0.0;
                double maxPlaneCount = 0.0;
                for (cx = 0; cx < this.m_numValidCoarseX; ++cx) {
                    for (cy = 0; cy < this.m_numValidCoarseY; ++cy) {
                        sumPlaneCount += (double)this.m_countCoarse[cx][cy][cz];
                        maxPlaneCount = Math.max(maxPlaneCount, (double)this.m_countCoarse[cx][cy][cz]);
                    }
                }
                for (cx = 0; cx < this.m_numValidCoarseX; ++cx) {
                    for (cy = 0; cy < this.m_numValidCoarseY; ++cy) {
                        int extraRadiusX = (int)(maxPlaneCount / (0.01 + (double)this.m_countCoarse[cx][cy][cz]));
                        extraRadiusX = Math.min(extraRadiusX, 30);
                        extraRadiusX = Math.max(extraRadiusX, 0);
                        int radX = radiusX + extraRadiusX;
                        int minx = Math.max(cx - radX, 0);
                        int maxx = Math.min(cx + radX, this.m_numValidCoarseX - 1);
                        int miny = Math.max(cy - radX, 0);
                        int maxy = Math.min(cy + radX, this.m_numValidCoarseY - 1);
                        int minz = Math.max(cz - radiusZ, 0);
                        int maxz = Math.min(cz + radiusZ, this.m_numZ - 1);
                        float sumCount = 1.0E-20f;
                        float sumSlow = 0.0f;
                        for (int x = minx; x <= maxx; ++x) {
                            float wx = this.m_weightH[Math.abs(x - cx)];
                            for (int y = miny; y <= maxy; ++y) {
                                float wy = this.m_weightH[Math.abs(y - cy)];
                                for (int z = minz; z <= maxz; ++z) {
                                    float wz = 0.1f / (0.1f + (float)Math.abs(z - cz));
                                    float w = wx * wy * wz * this.m_countCoarse[x][y][z];
                                    float slow = this.m_slownessCoarse[x][y][z];
                                    sumSlow += w * slow;
                                    sumCount += w;
                                }
                            }
                        }
                        this.m_temp1Coarse[cx][cy][cz] = sumSlow / sumCount;
                    }
                }
            }
            double sumCount = 0.0;
            for (int cz = 0; cz < this.m_numZ; ++cz) {
                for (int cx = 0; cx < this.m_numValidCoarseX; ++cx) {
                    for (int cy = 0; cy < this.m_numValidCoarseY; ++cy) {
                        this.m_slownessCoarse[cx][cy][cz] = this.m_temp1Coarse[cx][cy][cz];
                        sumCount += (double)this.m_countCoarse[cx][cy][cz];
                    }
                }
            }
            this.m_averageCoarseCount = (float)(sumCount / (double)(this.m_numZ * this.m_numValidCoarseX * this.m_numValidCoarseY));
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    protected boolean horizontal() {
        try {
            int cx;
            this.minValidZ();
            if (this.m_minValidZ > this.m_maxValidZ) {
                return false;
            }
            boolean keepGoing = true;
            int radH = 25;
            int radZ = 0;
            int loopCount = 0;
            while (keepGoing) {
                if (++loopCount >= 10) {
                    return false;
                }
                keepGoing = false;
                this.copyToTemp();
                for (int cz = this.m_minValidZ; cz <= this.m_maxValidZ; ++cz) {
                    for (cx = 0; cx < this.m_numValidCoarseX; ++cx) {
                        for (int cy = 0; cy < this.m_numValidCoarseY; ++cy) {
                            boolean ok;
                            if (!(this.m_temp2Coarse[cx][cy][cz] < this.m_minValidCount) || (ok = this.compute(cx, cy, cz, radH, radZ))) continue;
                            keepGoing = true;
                        }
                    }
                }
                radH += 42;
                ++radZ;
            }
            this.copyToTemp();
            this.setPM("Now extrapolate vertically");
            for (int cy = 0; cy < this.m_numValidCoarseY; ++cy) {
                for (cx = 0; cx < this.m_numValidCoarseX; ++cx) {
                    float slow = this.m_temp1Coarse[cx][cy][this.m_maxValidZ];
                    float downExtrapolation = 0.995f;
                    if (this.m_currentIteration == 1) {
                        downExtrapolation = 0.98f;
                    }
                    int numExtrap = 0;
                    for (int cz = this.m_maxValidZ + 1; cz < this.m_numZ; ++cz) {
                        if (numExtrap >= 4) {
                            downExtrapolation = 1.0f;
                        }
                        this.m_slownessCoarse[cx][cy][cz] = slow *= downExtrapolation;
                        ++numExtrap;
                    }
                    slow = this.m_temp1Coarse[cx][cy][this.m_minValidZ];
                    float upExtrapolation = 1.005f;
                    if (this.m_currentIteration == 1) {
                        upExtrapolation = 1.02f;
                    }
                    numExtrap = 0;
                    for (int cz = this.m_minValidZ - 1; cz >= 0; --cz) {
                        if (numExtrap >= 4) {
                            upExtrapolation = 1.0f;
                        }
                        this.m_slownessCoarse[cx][cy][cz] = slow *= upExtrapolation;
                        ++numExtrap;
                    }
                }
            }
            return true;
        }
        catch (Exception error) {
            error.printStackTrace();
            return false;
        }
    }

    protected boolean compute(int cx, int cy, int cz, int radH, int radZ) {
        try {
            if (this.m_temp2Coarse[cx][cy][cz] >= this.m_minValidCount) {
                return true;
            }
            float sumCount = 1.0E-10f;
            float sumSlow = 0.0f;
            int minx = Math.max(cx - radH, 0);
            int maxx = Math.min(cx + radH, this.m_numValidCoarseX - 1);
            int miny = Math.max(cy - radH, 0);
            int maxy = Math.min(cy + radH, this.m_numValidCoarseY - 1);
            int minz = Math.max(cz - radZ, 0);
            int maxz = Math.min(cz + radZ, this.m_numZ - 1);
            for (int x = minx; x <= maxx; ++x) {
                for (int y = miny; y <= maxy; ++y) {
                    for (int z = minz; z <= maxz; ++z) {
                        if (!(this.m_temp2Coarse[x][y][z] >= this.m_minValidCount)) continue;
                        float w = this.m_temp2Coarse[x][y][z];
                        float slow = this.m_temp1Coarse[x][y][z];
                        sumSlow += w * slow;
                        sumCount += w;
                    }
                }
            }
            if (sumCount <= this.m_minValidCount) {
                return false;
            }
            this.m_slownessCoarse[cx][cy][cz] = sumSlow / sumCount;
            this.m_countCoarse[cx][cy][cz] = 1.01f * this.m_minValidCount;
            return true;
        }
        catch (Exception error) {
            error.printStackTrace();
            return false;
        }
    }

    protected void vertical() {
        try {
            this.copyToTemp();
            for (int cx = 0; cx < this.m_numValidCoarseX; ++cx) {
                for (int cy = 0; cy < this.m_numValidCoarseY; ++cy) {
                    for (int cz = 0; cz < this.m_numZ; ++cz) {
                        if (!(this.m_temp2Coarse[cx][cy][cz] < this.m_minValidCount)) continue;
                        float sumCount = 1.0E-10f;
                        float sum = 0.0f;
                        int minx = Math.max(cx - 2, 0);
                        int maxx = Math.min(cx + 2, this.m_numValidCoarseX - 1);
                        int miny = Math.max(cy - 2, 0);
                        int maxy = Math.min(cy + 2, this.m_numValidCoarseY - 1);
                        for (int x = minx; x <= maxx; ++x) {
                            float wx = 0.5f / (0.5f + (float)Math.abs(x - cx));
                            for (int y = miny; y <= maxy; ++y) {
                                float wy = 0.5f / (0.5f + (float)Math.abs(y - cy));
                                for (int z = 0; z < this.m_numZ; ++z) {
                                    if (!(this.m_temp2Coarse[x][y][z] > this.m_minValidCount)) continue;
                                    float f = 0.5f / (0.5f + (float)Math.abs(z - cz));
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    protected void minValidZ() {
        try {
            this.m_minValidZ = 10000;
            this.m_maxValidZ = 0;
            for (int cx = 0; cx < this.m_numValidCoarseX; ++cx) {
                for (int cy = 0; cy < this.m_numValidCoarseY; ++cy) {
                    for (int cz = 0; cz < this.m_numZ; ++cz) {
                        if (!(this.m_countCoarse[cx][cy][cz] >= 1.0f)) continue;
                        this.m_minValidZ = Math.min(this.m_minValidZ, cz);
                        this.m_maxValidZ = Math.max(this.m_maxValidZ, cz);
                    }
                }
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    protected void copyToTemp() {
        try {
            for (int cx = 0; cx < this.m_numValidCoarseX; ++cx) {
                for (int cy = 0; cy < this.m_numValidCoarseY; ++cy) {
                    for (int cz = 0; cz < this.m_numZ; ++cz) {
                        this.m_temp1Coarse[cx][cy][cz] = this.m_slownessCoarse[cx][cy][cz];
                        this.m_temp2Coarse[cx][cy][cz] = this.m_countCoarse[cx][cy][cz];
                    }
                }
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    protected void initCoarse() {
        try {
            this.m_maxCoarseCount = 0.0f;
            for (int cx = 0; cx < this.m_numValidCoarseX; ++cx) {
                for (int cy = 0; cy < this.m_numValidCoarseY; ++cy) {
                    for (int cz = 0; cz < this.m_numZ; ++cz) {
                        float sumCount = 1.0E-20f;
                        float sumSlowness = 0.0f;
                        this.m_slownessCoarse[cx][cy][cz] = 0.0f;
                        this.m_countCoarse[cx][cy][cz] = 1.0E-20f;
                        int minx = cx * this.m_coarseRadius;
                        int maxx = Math.min(minx + this.m_coarseRadius - 1, this.m_numX - 1);
                        int miny = cy * this.m_coarseRadius;
                        int maxy = Math.min(miny + this.m_coarseRadius - 1, this.m_numY - 1);
                        for (int x = minx; x <= maxx; ++x) {
                            for (int y = miny; y <= maxy; ++y) {
                                if (!this.m_ray_cover[x][y]) continue;
                                float count = this.m_count[x][y][cz];
                                float slowness = this.m_slowness[x][y][cz];
                                sumSlowness += slowness * count;
                                sumCount += count;
                            }
                        }
                        this.m_slownessCoarse[cx][cy][cz] = sumSlowness / sumCount;
                        this.m_countCoarse[cx][cy][cz] = sumCount;
                        this.m_maxCoarseCount = Math.max(this.m_maxCoarseCount, sumCount);
                    }
                }
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }
}

