/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Refraction.Tomography;

import com.PecosCore.Shared.Pecos;
import com.PecosLibrary.Math.Grid3D;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Tomography.TomoEikonal3D;
import com.PecosLibrary.Refraction.Tools_RefractionStaticsProject;

public class TomoEikonal3D_Tools {
    public static void initializeWithDelayTimeModel(TomoEikonal3D model) {
        try {
            double binSize = model.binSizeHorz();
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            int maxBranch = project.getDelayTimeData().branchAssignment().maxBranch();
            int num = maxBranch + 1;
            Grid3D[] gridZ = new Grid3D[num];
            Grid3D[] gridV = new Grid3D[num];
            double[] elev = new double[20];
            double[] vel = new double[20];
            for (int k = 0; k <= maxBranch; ++k) {
                gridZ[k] = Tools_RefractionStaticsProject.getInterpolatedGrid(binSize, binSize, Pecos.getColNameElev(k), false);
                gridV[k] = Tools_RefractionStaticsProject.getInterpolatedGrid(binSize, binSize, Pecos.getColNameVel(k), false);
            }
            int nx = model.numX();
            int ny = model.numY();
            int nz = model.numZ();
            float[][][] slow = model.slowness();
            for (int ix = 0; ix < nx; ++ix) {
                for (int iy = 0; iy < ny; ++iy) {
                    int m;
                    model.setGridLocation(ix, iy, 0);
                    for (m = 0; m < num; ++m) {
                        vel[m] = gridV[m].getNearestValue(model.WorldX, model.WorldY);
                    }
                    for (m = 0; m < num; ++m) {
                        elev[m] = gridZ[m].getNearestValue(model.WorldX, model.WorldY);
                    }
                    for (int iz = 0; iz < nz; ++iz) {
                        model.setGridLocation(ix, iy, iz);
                        boolean found = false;
                        if (model.WorldZ <= elev[num - 1]) {
                            slow[ix][iy][iz] = (float)(1000.0 / vel[num - 1]);
                            found = true;
                        }
                        if (model.WorldZ >= elev[0]) {
                            slow[ix][iy][iz] = 0.9f * (float)(1000.0 / vel[0]);
                            found = true;
                        }
                        if (!found) {
                            for (int m2 = 0; m2 < num - 1; ++m2) {
                                if (!(model.WorldZ >= elev[m2 + 1]) || !(model.WorldZ <= elev[m2])) continue;
                                slow[ix][iy][iz] = (float)(1000.0 / vel[m2]);
                                found = true;
                            }
                        }
                        if (found) continue;
                        slow[ix][iy][iz] = (float)(1000.0 / vel[num - 1]);
                    }
                }
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }
}

