/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Refraction.Tomography;

import com.PecosLibrary.Refraction.Tomography.TomoEikonal3D;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Polygon;

public class TomoEikonal3D_Polygon {
    protected int m_numX = 0;
    protected int m_numY = 0;
    protected int m_numZ = 0;
    protected float[][][] m_slowness;
    protected float[][][] m_countTemp;
    protected float[][][] m_slownessTemp;
    protected float[][][] m_count;
    protected float[][] m_surfaceElevation;
    protected float[][] m_surfaceGridZ;
    protected int m_coarseRadius;
    protected int m_numValidCoarseX;
    protected int m_numValidCoarseY;
    protected float m_minValidCount = 10.0f;
    protected float m_averageCoarseCount = 1.0f;
    protected float m_averageCount = 9.0f;
    protected int m_totalIterations = 1;
    protected int m_currentIteration = 1;
    protected boolean[][] m_insidePolygon;
    protected int m_numNotSet = -9999;
    protected boolean m_bTrackSurface = true;
    protected int m_radiusZ = 0;

    public void work(Java2D_Polygon p, TomoEikonal3D tomo) {
        try {
            this.prepare(p, tomo, 2, 2);
            this.m_bTrackSurface = true;
            this.m_radiusZ = 0;
            boolean keepGoing = true;
            while (keepGoing) {
                keepGoing = this.update(7);
            }
            this.smooth(4);
            this.smooth(4);
            this.finishedPolygon(tomo);
            tomo.initializeSurface();
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public void smooth(int radius) {
        try {
            boolean keepGoing = false;
            for (int ix = 0; ix < this.m_numX; ++ix) {
                for (int iy = 0; iy < this.m_numY; ++iy) {
                    if (!this.m_insidePolygon[ix][iy]) continue;
                    int minx = Math.max(ix - radius, 0);
                    int maxx = Math.min(ix + radius, this.m_numX - 1);
                    int miny = Math.max(iy - radius, 0);
                    int maxy = Math.min(iy + radius, this.m_numY - 1);
                    int iz = 0;
                    while ((float)iz < this.m_surfaceGridZ[ix][iy]) {
                        double sum1 = 0.0;
                        double sum2 = 1.0E-5;
                        for (int x = minx; x <= maxx; ++x) {
                            double wx = 1.0f / (1.0f + (float)Math.abs(ix - x));
                            for (int y = miny; y <= maxy; ++y) {
                                double wy = 1.0f / (1.0f + (float)Math.abs(iy - y));
                                float dz = this.m_surfaceGridZ[x][y] - this.m_surfaceGridZ[ix][iy];
                                int z = iz + (int)dz;
                                if (z < 0 || !((float)z <= this.m_surfaceGridZ[x][y])) continue;
                                double weight = (double)this.m_count[x][y][z] * wx * wy;
                                sum1 += weight * (double)this.m_slowness[x][y][z];
                                sum2 += weight;
                            }
                        }
                        this.m_slowness[ix][iy][iz] = (float)(sum1 / sum2);
                        this.m_count[ix][iy][iz] = 10.0f;
                        ++iz;
                    }
                }
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public boolean update(int radius) {
        try {
            boolean keepGoing = false;
            for (int ix = 0; ix < this.m_numX; ++ix) {
                for (int iy = 0; iy < this.m_numY; ++iy) {
                    for (int iz = 0; iz < this.m_numZ; ++iz) {
                        this.m_slownessTemp[ix][iy][iz] = this.m_slowness[ix][iy][iz];
                        this.m_countTemp[ix][iy][iz] = this.m_count[ix][iy][iz];
                    }
                }
            }
            int numNotSet = 0;
            System.out.println("start update m_bTrackSurface = " + this.m_bTrackSurface);
            if (!this.m_bTrackSurface) {
                ++this.m_radiusZ;
            }
            for (int ix = 0; ix < this.m_numX; ++ix) {
                for (int iy = 0; iy < this.m_numY; ++iy) {
                    if (!this.m_insidePolygon[ix][iy]) continue;
                    int minx = Math.max(ix - radius, 0);
                    int maxx = Math.min(ix + radius, this.m_numX - 1);
                    int miny = Math.max(iy - radius, 0);
                    int maxy = Math.min(iy + radius, this.m_numY - 1);
                    int iz = 0;
                    while ((float)iz < this.m_surfaceGridZ[ix][iy]) {
                        if (this.m_count[ix][iy][iz] < 5.0f) {
                            double sum1 = 0.0;
                            double sum2 = 1.0E-5;
                            if (!this.m_bTrackSurface) {
                                sum1 = 1.0E-10f;
                            }
                            for (int x = minx; x <= maxx; ++x) {
                                float wx = 1.0f / (1.0f + (float)Math.abs(ix - x));
                                for (int y = miny; y <= maxy; ++y) {
                                    float wy = 1.0f / (1.0f + (float)Math.abs(iy - y));
                                    float dz = this.m_surfaceGridZ[x][y] - this.m_surfaceGridZ[ix][iy];
                                    if (!this.m_bTrackSurface) {
                                        dz = 0.0f;
                                    }
                                    int minz = Math.max(iz + (int)dz - this.m_radiusZ, 0);
                                    int maxz = Math.min(iz + (int)dz + this.m_radiusZ, this.m_numZ - 1);
                                    for (int z = minz; z <= maxz; ++z) {
                                        if (z < 0 || !((float)z <= this.m_surfaceGridZ[x][y]) || !(this.m_countTemp[x][y][z] >= 5.0f)) continue;
                                        double weight = this.m_countTemp[x][y][z] * wx * wy;
                                        sum1 += weight * (double)this.m_slownessTemp[x][y][z];
                                        sum2 += weight;
                                    }
                                }
                            }
                            if (sum2 > 20.0) {
                                this.m_slowness[ix][iy][iz] = (float)(sum1 / sum2);
                                this.m_count[ix][iy][iz] = 10.0f;
                            } else {
                                ++numNotSet;
                                keepGoing = true;
                            }
                        }
                        ++iz;
                    }
                }
            }
            if (this.m_bTrackSurface) {
                this.m_bTrackSurface = numNotSet != this.m_numNotSet;
            }
            System.out.println("end of update, numNotSet = " + numNotSet);
            this.m_numNotSet = numNotSet;
            return keepGoing;
        }
        catch (Exception error) {
            error.printStackTrace();
            return true;
        }
    }

    public void prepare(Java2D_Polygon p, TomoEikonal3D tomo, int coarseRadius, int totalIterations) {
        try {
            int iy;
            int ix;
            this.m_totalIterations = totalIterations;
            this.m_coarseRadius = Math.max(3, coarseRadius);
            this.m_numX = tomo.numX();
            this.m_numY = tomo.numY();
            this.m_numZ = tomo.numZ();
            this.m_insidePolygon = new boolean[this.m_numX][this.m_numY];
            for (ix = 0; ix < this.m_numX; ++ix) {
                for (iy = 0; iy < this.m_numY; ++iy) {
                    tomo.setGridLocation(ix, iy, 0);
                    this.m_insidePolygon[ix][iy] = p.contains(tomo.WorldX, tomo.WorldY);
                }
            }
            this.m_surfaceElevation = tomo.surfaceElevation();
            this.m_surfaceGridZ = tomo.surfaceGridZ();
            this.m_slowness = this.clone3(tomo.slowness());
            this.m_countTemp = this.clone3(tomo.weight());
            this.m_slownessTemp = this.clone3(tomo.error());
            this.m_count = this.clone3(tomo.count());
            for (ix = 0; ix < this.m_numX; ++ix) {
                for (iy = 0; iy < this.m_numY; ++iy) {
                    int iz;
                    if (this.m_insidePolygon[ix][iy]) {
                        for (iz = 0; iz < this.m_numZ; ++iz) {
                            this.m_slownessTemp[ix][iy][iz] = 0.0f;
                            this.m_count[ix][iy][iz] = 0.0f;
                            this.m_countTemp[ix][iy][iz] = 0.0f;
                        }
                        continue;
                    }
                    for (iz = 0; iz < this.m_numZ; ++iz) {
                        this.m_slownessTemp[ix][iy][iz] = 20.0f;
                        this.m_count[ix][iy][iz] = 20.0f;
                        this.m_countTemp[ix][iy][iz] = 20.0f;
                    }
                }
            }
            this.m_numValidCoarseX = 1 + this.m_numX / this.m_coarseRadius;
            this.m_numValidCoarseY = 1 + this.m_numY / this.m_coarseRadius;
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public void finishedPolygon(TomoEikonal3D tomo) {
        try {
            this.m_numX = tomo.numX();
            this.m_numY = tomo.numY();
            this.m_numZ = tomo.numZ();
            float[][][] slowness = tomo.slowness();
            for (int ix = 0; ix < this.m_numX; ++ix) {
                for (int iy = 0; iy < this.m_numY; ++iy) {
                    if (!this.m_insidePolygon[ix][iy]) continue;
                    for (int iz = 0; iz < this.m_numZ; ++iz) {
                        slowness[ix][iy][iz] = this.m_slowness[ix][iy][iz];
                    }
                }
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    protected float[][] clone2(float[][] arr) {
        try {
            int nx = arr.length;
            int ny = arr[0].length;
            float[][] c = new float[nx][ny];
            for (int x = 0; x < nx; ++x) {
                for (int y = 0; y < ny; ++y) {
                    c[x][y] = arr[x][y];
                }
            }
            return arr;
        }
        catch (Exception error) {
            error.printStackTrace();
            return null;
        }
    }

    protected float[][][] clone3(float[][][] arr) {
        try {
            int nx = arr.length;
            int ny = arr[0].length;
            int nz = arr[0][0].length;
            float[][][] c = new float[nx][ny][nz];
            for (int x = 0; x < nx; ++x) {
                for (int y = 0; y < ny; ++y) {
                    for (int z = 0; z < nz; ++z) {
                        c[x][y][z] = arr[x][y][z];
                    }
                }
            }
            return c;
        }
        catch (Exception error) {
            error.printStackTrace();
            return null;
        }
    }

    protected double[][][] clone3(double[][][] arr) {
        try {
            int nx = arr.length;
            int ny = arr[0].length;
            int nz = arr[0][0].length;
            double[][][] c = new double[nx][ny][nz];
            for (int x = 0; x < nx; ++x) {
                for (int y = 0; y < ny; ++y) {
                    for (int z = 0; z < nz; ++z) {
                        c[x][y][z] = arr[x][y][z];
                    }
                }
            }
            return c;
        }
        catch (Exception error) {
            error.printStackTrace();
            return null;
        }
    }
}

