/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Refraction;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.TraceTable.Huge.TraceTable_Huge;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Map.HashMap_Integer;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Refraction.RefractionStaticsProject;

public class RefractionTraceTableScanner {
    Ensemble m_ensemble = new Ensemble();
    protected TraceTable_Huge m_traceTable;
    protected long m_nextRow = 0L;
    protected Table_Abstract m_shotTable;
    protected HashMap_Integer m_shotMap;
    protected Table_Abstract m_receiverTable;
    protected HashMap_Integer m_receiverMap;

    public Table_Abstract shotTable() {
        return this.m_shotTable;
    }

    public HashMap_Integer shotMap() {
        return this.m_shotMap;
    }

    public Table_Abstract receiverTable() {
        return this.m_receiverTable;
    }

    public HashMap_Integer receiverMap() {
        return this.m_receiverMap;
    }

    public RefractionTraceTableScanner(TraceTable_Huge traceTable) {
        this.m_traceTable = traceTable;
    }

    public void prepare() throws Exception {
        try {
            this.m_ensemble = new Ensemble();
            this.m_receiverTable = RefractionStaticsProject.singleton().receiverTable();
            this.m_receiverMap = RefractionStaticsProject.singleton().receiverMap();
            this.m_shotTable = RefractionStaticsProject.singleton().shotTable();
            this.m_shotMap = RefractionStaticsProject.singleton().shotMap();
            this.m_nextRow = 0L;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public double percent() {
        return 100.0 * (double)this.m_nextRow / (double)(1L + this.m_traceTable.rowCount());
    }

    public boolean next(boolean assignBranches, boolean computeTravelTimes) throws Exception {
        try {
            if (this.m_nextRow >= this.m_traceTable.rowCount()) {
                return false;
            }
            int sectionCount = this.m_traceTable.sectionRowCount();
            this.m_ensemble.clearTraces(false);
            this.m_traceTable.populateEnsemble(this.m_ensemble, this.m_nextRow, sectionCount);
            RefractionStaticsProject.singleton().prepareRefractionEnsemble(this.m_ensemble, assignBranches, computeTravelTimes);
            this.m_nextRow += (long)this.m_ensemble.traceCount();
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public Ensemble ensemble() {
        return this.m_ensemble;
    }
}

