/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Refraction;

import com.PecosCore.Data.Column_Abstract;
import com.PecosCore.Data.DataType;
import com.PecosCore.Data.FloatArrayWrapper;
import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Data.ResetableIterator;
import com.PecosCore.Data.Seismic.CubicTraceInterpolator;
import com.PecosCore.Data.Seismic.SparseCmpGatherManager;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.Table_Memory;
import com.PecosCore.Data.TraceTable.Huge.ITraceTable;
import com.PecosCore.Data.TraceTable.Huge.TraceTable_Huge;
import com.PecosCore.Data.TraceTable.Huge.TraceTable_Huge_Wrapper;
import com.PecosCore.Data.TraceTable.ITraceTable_Wrapper;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Ensemble.Tools_Ensemble;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Sequence;
import com.PecosCore.Geometry.TableParser;
import com.PecosCore.Geometry.TableParserConflict;
import com.PecosCore.Map.HashMap_Integer;
import com.PecosCore.Map.HashMap_Integers;
import com.PecosCore.Math.AzimuthSelector;
import com.PecosCore.Math.Grid3D_Conversion;
import com.PecosCore.Plugins.IPlugin;
import com.PecosCore.Plugins.PluginManager;
import com.PecosCore.Project.ISeismicProject;
import com.PecosCore.Refraction.BranchAssignmentEntry;
import com.PecosCore.Refraction.BranchAssignmentLocation;
import com.PecosCore.Refraction.IMoveoutTrendData;
import com.PecosCore.Refraction.IRefractionStaticsProject;
import com.PecosCore.Seismic.CompressedSeismicFile;
import com.PecosCore.Seismic.ISeismicFile;
import com.PecosCore.Seismic.Segy.Segy;
import com.PecosCore.Seismic.SeismicFileType;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Shared.Pecos;
import com.PecosCore.Shared.Range_Double;
import com.PecosCore.Shared.SharedApplicationData;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosCore.Tools.Tools_XML;
import com.PecosCore.Windows.Shared.IComponentManager;
import com.PecosLibrary.Action.Action_Base;
import com.PecosLibrary.Action.Action_Sequence;
import com.PecosLibrary.Action.Export.Action_ExportTraceTableToCSV;
import com.PecosLibrary.Action.Import.Action_ImportTraceTableFromCSV;
import com.PecosLibrary.Data.Sort.SortManager;
import com.PecosLibrary.Echos.XtEchos;
import com.PecosLibrary.Echos.XtParadigmTraceFileTools;
import com.PecosLibrary.Ensemble.Worker.Tools_EnsembleWorker;
import com.PecosLibrary.Geometry.PromaxGrid;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.JDBC.Tools_JDBC;
import com.PecosLibrary.Math.Grid2D_Conversion_Line;
import com.PecosLibrary.Math.Grid3D;
import com.PecosLibrary.Math.IGrid2D_Conversion;
import com.PecosLibrary.Refraction.DelayTime.BranchAssignment;
import com.PecosLibrary.Refraction.DelayTime.DelayTimeData;
import com.PecosLibrary.Refraction.DelayTime.Tools_DelayTime_Geometry;
import com.PecosLibrary.Refraction.DelayTime.UpholeCorrection;
import com.PecosLibrary.Refraction.DelayTime.WaterBottomCorrection;
import com.PecosLibrary.Refraction.DelayTime.WeatherVelocityProfiler;
import com.PecosLibrary.Refraction.FWI.FwiModel;
import com.PecosLibrary.Refraction.GLI.GliInteractiveModel_PickCollection;
import com.PecosLibrary.Refraction.GLI.GliModel;
import com.PecosLibrary.Refraction.HybridGLI.HybridGliData;
import com.PecosLibrary.Refraction.InteractiveMoveoutTrend;
import com.PecosLibrary.Refraction.MoveoutTrendData;
import com.PecosLibrary.Refraction.PickEvent;
import com.PecosLibrary.Refraction.PickHistogram;
import com.PecosLibrary.Refraction.PickerGizmo;
import com.PecosLibrary.Refraction.ShotEnsembleIterator;
import com.PecosLibrary.Refraction.ShotLabel;
import com.PecosLibrary.Refraction.Tomography.InteractiveModel.TomoInteractiveModel_PickCollection;
import com.PecosLibrary.Refraction.Tomography.TomoEikonal3D;
import com.PecosLibrary.Refraction.Tomography.VNS.Tomo_VNS;
import com.PecosLibrary.Refraction.Tools_Ensemble_RefractionProject;
import com.PecosLibrary.Refraction.Tools_RefractionStaticsProject;
import com.PecosLibrary.Refraction.Uphole.UpholeModel;
import com.PecosLibrary.Refraction.Uphole.UpholeSimple;
import com.PecosLibrary.Seismic.Echos.Echos_Dictionary;
import com.PecosLibrary.Stack.ProfileManager;
import com.PecosLibrary.Stack.VelocityManager;
import com.PecosLibrary.Windows.Action.ActionSequence_InternalWidget;
import com.PecosLibrary.Windows.Action.Dialog_ActionSequence;
import com.PecosLibrary.Windows.Echos.IShotRecTableModelProvider;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_BranchPickCollections;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Polygon;
import com.PecosLibrary.Windows.Refraction.Database.DraggerDialog_V2;
import com.PecosLibrary.Windows.Refraction.Database.SeismicFileManagerDialog;
import com.PecosLibrary.Windows.Shared.MultiTextDialog;
import java.awt.Color;
import java.awt.Cursor;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RefractionStaticsProject
implements ISeismicProject,
IShotRecTableModelProvider,
IRefractionStaticsProject {
    protected UpholeSimple m_uphole_simple = new UpholeSimple();
    protected ISeismicProject.ProjectType m_projectType = ISeismicProject.ProjectType.Refraction;
    protected Table_Abstract m_fileTable;
    protected ArrayList<FileInfo> m_fileList = new ArrayList();
    protected boolean m_batchState = false;
    protected static RefractionStaticsProject m_singleton = null;
    public boolean ColorScaleRangeValid = false;
    public double ColorScaleRangeMin = 0.0;
    public double ColorScaleRangeMax = 110.0;
    public boolean UpdateBranchDuringGeomCorr = false;
    protected String m_jobXmlFileName;
    protected Document m_jobDocument;
    protected Element m_jobRootNode;
    protected int m_recentMouseMoveShotID = -9999;
    protected int m_recentMouseMoveReceiverID = -9999;
    protected DraggerDialog_V2 m_draggerDialog;
    protected Java2D_Paintable_BranchPickCollections m_preselectedPickLocations;
    protected PickHistogram m_pickHistogram = new PickHistogram();
    protected String m_pickHistogramFileName = "";
    protected HashMap_Integers<TableParserConflict> m_shotConflicts;
    protected HashMap_Integers<TableParserConflict> m_receiverConflicts;
    protected SparseCmpGatherManager m_sparseCmpGathers;
    protected SortManager m_receiverSortManager;
    protected SortManager m_inlineCrosslineSortManager;
    protected WeatherVelocityProfiler m_weatherVelocityProfiler;
    protected PromaxGrid m_promaxGrid = new PromaxGrid();
    protected String m_promaxGridFileName;
    protected ProfileManager m_profileManager;
    protected String m_profilePath;
    protected VelocityManager m_velocityManager;
    protected Java2D_Polygon m_polygon = new Java2D_Polygon();
    protected String m_polygonFileName = "";
    protected Grid2D_Conversion_Line m_bestFitLine;
    protected Action_Sequence m_actionSequence = new Action_Sequence();
    protected String m_interactiveTomoPath = "";
    protected String m_interactiveTomoPickFileName = "";
    protected TomoInteractiveModel_PickCollection m_tomoInteractiveModel_PickCollection;
    protected String m_name = null;
    protected String m_projectPath;
    protected String m_versionContainerPath;
    protected String m_currentVersionPath;
    protected String m_currentVersionName;
    protected String m_guiOptionsPath;
    protected IDatabaseConnection m_geometryConn;
    protected String m_interactiveGliPath = "";
    protected String m_interactiveGliPickFileName = "";
    protected GliInteractiveModel_PickCollection m_gliInteractiveModel_PickCollection;
    protected String m_fwi3DLayerProjectsPath;
    protected FwiModel m_fwi3D;
    protected String m_tomoVNSProjectsPath;
    protected Tomo_VNS m_tomoVNS;
    protected String m_upholeProjectsPath;
    protected UpholeModel m_uphole;
    protected String m_eikonal3DLayerProjectsPath;
    protected TomoEikonal3D m_eikonal3D;
    protected String m_gliProjectsPath;
    protected int m_gliNewModelLayerCount;
    protected GliModel m_gliModel;
    protected String m_hybridProjectsPath;
    protected String m_importPath;
    protected String m_importFileName;
    protected IDatabaseConnection m_importConn;
    protected InteractiveMoveoutTrend m_interactiveTrendData = new InteractiveMoveoutTrend(6000.0, 30000.0, 1000.0);
    protected MoveoutTrendData m_moveoutTrendData = new MoveoutTrendData();
    protected String m_moveoutTrendFileName;
    protected String m_grid2DFileName;
    protected IGrid2D_Conversion m_grid2D = new Grid2D_Conversion_Line();
    public double TempGrid2DOriginX = 0.0;
    public double TempGrid2DOriginY = 0.0;
    public double TempGrid2DAngle = 0.0;
    public double TempGrid2DBinSize = 0.0;
    public int TempGrid2DCount = 0;
    protected String m_grid3DFileName;
    protected Grid3D_Conversion m_grid3D = new Grid3D_Conversion();
    protected Grid3D m_smootherGrid;
    protected String m_delayTimePath;
    protected DelayTimeData m_delayTimeData;
    protected boolean m_dim3D = true;
    protected UpholeCorrection.Method m_upholeCorrectionMethod = UpholeCorrection.Method.SoftwareDeterminesBest;
    protected double m_waterVelocity = 5000.0;
    protected WaterBottomCorrection.Method m_waterBottomCorrectionMethod = WaterBottomCorrection.Method.None;
    protected TraceTable_Huge_Wrapper m_traceTableWrapper;
    protected Table_Abstract m_shotTable;
    protected HashMap_Integer m_shotMap;
    protected Table_Abstract m_receiverTable;
    protected HashMap_Integer m_receiverMap;
    protected Range_Double m_rangeX = new Range_Double();
    protected Range_Double m_rangeY = new Range_Double();
    protected ParameterTree m_information;
    protected String m_paramFileName;
    protected int TotalTraces = 0;
    protected int[] m_headerIndex = new int[50];
    protected DataType[] m_headerType = new DataType[50];
    protected boolean[] m_doubleType = new boolean[50];
    protected int m_runCount = 0;
    protected HybridGliData m_hybridGliData;
    public boolean SubstituteSyntheticGather = false;
    List<ShotLabel> m_shotLabels = null;
    protected Table_Abstract m_mergeProjectTable = null;
    protected HashMap_Integers<String> m_mergeProjectHash;
    protected EnsembleWorker_Sequence m_inputDataSequence = new EnsembleWorker_Sequence(EnsembleWorker_Sequence.SequenceType.Interactive);
    protected String m_inputDataSequenceFileName;
    protected boolean m_inputDataSequenceOn = false;
    protected double m_inputDataSequence_MinOffset = 0.0;
    protected double m_inputDataSequence_MaxOffset = 0.0;
    protected boolean m_inputDataSequence_ApplyOffsetLimits = false;
    protected double m_inputDataSequence_AzDir = 0.0;
    protected double m_inputDataSequence_AzAngle = 0.0;
    protected boolean m_inputDataSequence_ApplyAzimuthLimits = false;
    protected CubicTraceInterpolator m_cti = new CubicTraceInterpolator();
    protected float[] m_inputSequenceArray = new float[200];
    protected AzimuthSelector m_inputAzimuthSelector = new AzimuthSelector();
    public String ParentProjectPath = SharedApplicationData.staticsProjectPath();

    public UpholeSimple uphole_simple_get() {
        return this.m_uphole_simple;
    }

    public String uphole_simple_file_xyzdt() {
        String path = this.projectPath();
        return path + "/uphole_X_Y_Z_Depth_Time.csv";
    }

    public String uphole_simple_file_xydt() {
        String path = this.projectPath();
        return path + "/uphole_X_Y_Depth_Time.csv";
    }

    public void uphole_save_xyzdt() {
        try {
            this.m_uphole_simple.save_xyzdt(this.uphole_simple_file_xyzdt());
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void uphole_read_xyzdt(String fileName) {
        try {
            this.m_uphole_simple.read_xyzdt(fileName);
            this.uphole_save_xyzdt();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public int getModelCount() {
        return 1;
    }

    @Override
    public String getModelName(int i) {
        return "Geometry";
    }

    @Override
    public Table_Abstract getShotModel(int i) {
        return this.shotTable();
    }

    @Override
    public Table_Abstract getRecModel(int i) {
        return this.receiverTable();
    }

    @Override
    public int getModelIndex(String sModel) {
        return 0;
    }

    @Override
    public Table_Abstract getShotTable() {
        return this.shotTable();
    }

    @Override
    public Table_Abstract getRecTable() {
        return this.receiverTable();
    }

    @Override
    public ITraceTable getTraceTable() {
        return this.m_traceTableWrapper.traceTable();
    }

    @Override
    public ResetableIterator<Ensemble> getShotEnsembleIterator(boolean bUseFlow, EnsembleWorker_Sequence sequence, String sMainWorker) {
        return new ShotEnsembleIterator(this, bUseFlow, sequence, sMainWorker);
    }

    @Override
    public ArrayList<BranchAssignmentLocation> getBranchAssignment() {
        ArrayList<BranchAssignmentLocation> locations = new ArrayList<BranchAssignmentLocation>();
        try {
            BranchAssignment branch = RefractionStaticsProject.delayTimeData().branchAssignment();
            for (BranchAssignment.Location location : branch.LocationList) {
                BranchAssignmentLocation loc = new BranchAssignmentLocation(location.X, location.Y);
                for (BranchAssignment.Entry entry : location.EntryList) {
                    loc.addBranchAssignmentEntry(new BranchAssignmentEntry(entry.Refractor, entry.MinimumOffset, entry.MaximumOffset, entry.TimeAtMinimumOffset, entry.TimeAtMaximumOffset));
                }
                locations.add(loc);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
        return locations;
    }

    @Override
    public String getProjectSubDirectory(String sSubDirName) {
        String sPath = "";
        try {
            sPath = Tools_FileSystem.confirmSubDirectoryExists(this.projectPath(), sSubDirName);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
        return sPath;
    }

    @Override
    public int createModel(String sModelName) throws Exception {
        return 0;
    }

    @Override
    public void saveModelTable(Table_Abstract table, String sModelName, List<String> sColumnNames) throws Exception {
        try {
            boolean bShot = table == this.shotTable();
            boolean bRec = table == this.receiverTable();
            String sTable = "";
            String sId = "";
            if (bShot) {
                sTable = "Shot";
                sId = "ShotID";
            } else if (bRec) {
                sTable = "Receiver";
                sId = "ReceiverID";
            } else {
                throw new Exception("Invalid table");
            }
            int nNewColumns = sColumnNames.size();
            int idColumn = table.column_indexOfColumn(sId);
            int[] columnIndexes = new int[nNewColumns];
            int nRows = table.row_count();
            for (int iCol = 0; iCol < nNewColumns; ++iCol) {
                int iColumnIndex;
                String sColumn = sColumnNames.get(iCol);
                columnIndexes[iCol] = iColumnIndex = table.column_indexOfColumn(sColumn);
                this.m_geometryConn.writeColumnContentsToDatabase(table, sColumn);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public ArrayList<FileInfo> getFileInfoList() {
        return this.m_fileList;
    }

    @Override
    public ISeismicProject.ProjectType projectType() {
        return this.m_projectType;
    }

    public String getSeismicFileName(int fileID) throws Exception {
        try {
            for (FileInfo info : this.m_fileList) {
                if (info.FileID != fileID) continue;
                return info.FullPath;
            }
            throw new Exception("File id not found: " + fileID);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public int maxSamplesPerTrace() {
        try {
            int max = 0;
            for (FileInfo file : this.m_fileList) {
                if (file.SeismicFile == null) continue;
                max = Math.max(max, file.SeismicFile.samplesPerTrace());
            }
            return max;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return 0;
        }
    }

    public RefractionStaticsProject(String name, boolean batchState) {
        try {
            this.m_batchState = batchState;
            this.m_polygon.FillColor = new Color(0, 0, 0, 128);
            this.setName(name);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public RefractionStaticsProject(String name) {
        try {
            this.m_polygon.FillColor = new Color(0, 0, 0, 128);
            this.setName(name);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected RefractionStaticsProject() {
        try {
            this.m_polygon.FillColor = new Color(0, 0, 0, 128);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public static RefractionStaticsProject singleton() {
        try {
            if (m_singleton == null) {
                m_singleton = new RefractionStaticsProject();
            }
            return m_singleton;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected void prepareJobXmlObjects() {
        try {
            this.m_jobXmlFileName = this.m_projectPath + "/Jobs.xml";
            if (Tools_FileSystem.exists_file(this.m_jobXmlFileName)) {
                this.m_jobDocument = Tools_XML.readDocument(this.m_jobXmlFileName);
                this.m_jobRootNode = (Element)this.m_jobDocument.getFirstChild();
            } else {
                this.m_jobDocument = Tools_XML.createDocument();
                this.m_jobRootNode = this.m_jobDocument.createElement("JobHistory");
                this.m_jobDocument.appendChild(this.m_jobRootNode);
                Tools_XML.writeDocumentToFile(this.m_jobDocument, this.m_jobXmlFileName);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void appendActionSequence(Action_Sequence sequence) {
        try {
            Date date = new Date();
            Element sequenceNode = this.m_jobDocument.createElement("Sequence");
            sequenceNode.setAttribute("Version", this.m_currentVersionName);
            sequenceNode.setAttribute("Date", date.toString());
            this.m_jobRootNode.appendChild(sequenceNode);
            for (int n = 0; n < sequence.size(); ++n) {
                Action_Base action = sequence.action(n);
                Element actionNode = this.m_jobDocument.createElement("Action");
                actionNode.setAttribute("Description", action.Description);
                action.writeContentsToNode(actionNode);
                sequenceNode.appendChild(actionNode);
            }
            Tools_XML.writeDocumentToFile(this.m_jobDocument, this.m_jobXmlFileName);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void selectShotOnMouseMove(Object sender, double x, double y) {
        try {
            this.shotTable().selectNearestSpatialPoint(x, y);
            if (this.m_recentMouseMoveShotID == this.shotTable().SelectedID) {
                return;
            }
            this.m_recentMouseMoveShotID = this.shotTable().SelectedID;
            Messenger.broadcastShotSelected(sender, this.m_recentMouseMoveShotID);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void selectReceiverOnMouseMove(Object sender, double x, double y) {
        try {
            this.receiverTable().selectNearestSpatialPoint(x, y);
            if (this.m_recentMouseMoveReceiverID == this.receiverTable().SelectedID) {
                return;
            }
            this.m_recentMouseMoveReceiverID = this.receiverTable().SelectedID;
            Messenger.broadcastReceiverSelected(sender, this.m_recentMouseMoveReceiverID);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void dragShot(Ensemble ensemble, int shotID) {
        try {
            if (this.m_draggerDialog == null) {
                this.m_draggerDialog = new DraggerDialog_V2();
            }
            this.m_draggerDialog.dragShot(ensemble, shotID);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void dragReceiver(Ensemble ensemble, int recID) {
        try {
            if (this.m_draggerDialog == null) {
                this.m_draggerDialog = new DraggerDialog_V2();
            }
            this.m_draggerDialog.dragReceiver(ensemble, recID);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public Java2D_Paintable_BranchPickCollections preselectedPickLocations() {
        return this.m_preselectedPickLocations;
    }

    public PickHistogram pickHistogram() {
        return this.m_pickHistogram;
    }

    public void savePickHistogram() {
        this.m_pickHistogram.save(this.m_pickHistogramFileName);
    }

    public HashMap_Integers<TableParserConflict> shotConflicts() {
        return this.m_shotConflicts;
    }

    public HashMap_Integers<TableParserConflict> receiverConflicts() {
        return this.m_receiverConflicts;
    }

    public SparseCmpGatherManager sparseCmpGathers() {
        try {
            if (this.m_sparseCmpGathers == null) {
                String sparsePath = Tools_FileSystem.confirmSubDirectoryExists(this.m_projectPath, "SparseCMP");
                this.m_sparseCmpGathers = new SparseCmpGatherManager(sparsePath);
            }
            return this.m_sparseCmpGathers;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public void killReceiverSort() {
        try {
            this.m_receiverSortManager = null;
            String prefix = this.m_projectPath + "/Sort_";
            String path = prefix + "ReceiverID";
            Tools_FileSystem.deletePathIfExists(path);
            this.reloadSortManagers();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void killBinSort() {
        try {
            this.m_inlineCrosslineSortManager = null;
            String prefix = this.m_projectPath + "/Sort_";
            String path = prefix + "Inline_Crossline";
            Tools_FileSystem.deletePathIfExists(path);
            this.reloadSortManagers();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void reloadSortManagers() {
        try {
            String prefix = this.m_projectPath + "/Sort_";
            this.m_inlineCrosslineSortManager = new SortManager(prefix + "Inline_Crossline");
            if (!this.m_inlineCrosslineSortManager.valid()) {
                this.m_inlineCrosslineSortManager = null;
            }
            this.m_receiverSortManager = new SortManager(prefix + "ReceiverID");
            if (!this.m_receiverSortManager.valid()) {
                this.m_receiverSortManager = null;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public WeatherVelocityProfiler getWeatherVelocityProfiler() {
        try {
            if (this.m_weatherVelocityProfiler == null) {
                this.m_weatherVelocityProfiler = new WeatherVelocityProfiler();
                String fileName = this.m_projectPath + "/WeatheringVelocityProfile.xml";
                this.m_weatherVelocityProfiler.setFileName(fileName);
            }
            return this.m_weatherVelocityProfiler;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public PromaxGrid getPromaxGrid() {
        return this.m_promaxGrid;
    }

    public String getPromaxGridFileName() {
        return this.m_promaxGridFileName;
    }

    public ProfileManager getProfileManager() {
        try {
            if (this.m_profileManager == null) {
                this.m_profileManager = new ProfileManager(this.m_profilePath);
            }
            return this.m_profileManager;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public VelocityManager getVelocityManager() {
        return this.m_velocityManager;
    }

    public Java2D_Polygon polygon() {
        return this.m_polygon;
    }

    public void savePolygon() {
        try {
            this.m_polygon.save(this.m_polygonFileName);
            Messenger.broadcast(Messenger.Message.ProjectPolygonModified, this, this.m_polygon);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public Action_Sequence actionSequence() {
        return this.m_actionSequence;
    }

    public void executeActionSequence() {
        try {
            if (SharedApplicationData.ProcessWizardMode) {
                Dialog_ActionSequence dialog_ActionSequence = new Dialog_ActionSequence(this.m_actionSequence);
            } else {
                IComponentManager cm = SharedApplicationData.singleton().getComponentManager();
                String className = ActionSequence_InternalWidget.class.getName();
                ActionSequence_InternalWidget w = (ActionSequence_InternalWidget)cm.showAndLockComponent(className, "Job", "Job");
                w.WhichProject = ActionSequence_InternalWidget.UseWhichProject.Refraction;
                w.startJob(null);
            }
            this.appendActionSequence(this.m_actionSequence);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void executeSingleAction(Action_Base action) {
        try {
            this.executeSingleAction(action, null);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void executeSingleAction(Action_Base action, Action_Sequence.Listener listener) {
        try {
            this.m_actionSequence.clearListeners();
            this.m_actionSequence.addListener(listener);
            this.m_actionSequence.clear();
            this.m_actionSequence.addAction(action);
            this.executeActionSequence();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void confirmShotColumn_Double(String colName, double defValue) {
        try {
            if (!this.m_shotTable.column_exists(colName)) {
                int index = this.m_shotTable.column_append(colName, DataType.Double);
                for (int n = 0; n < this.m_shotTable.row_count(); ++n) {
                    this.m_shotTable.putDouble(n, index, defValue);
                }
                this.m_geometryConn.addColumn("Shot", colName, DataType.Double);
                this.m_geometryConn.writeColumnContentsToDatabase(this.m_shotTable, colName);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void confirmReceiverColumn_Double(String colName, double defValue) {
        try {
            if (!this.m_receiverTable.column_exists(colName)) {
                int index = this.m_receiverTable.column_append(colName, DataType.Double);
                for (int n = 0; n < this.m_receiverTable.row_count(); ++n) {
                    this.m_receiverTable.putDouble(n, index, defValue);
                }
                this.m_geometryConn.addColumn("Receiver", colName, DataType.Double);
                this.m_geometryConn.writeColumnContentsToDatabase(this.m_receiverTable, colName);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void shiftPatternUp2D(int id) {
        try {
            this.shiftPattern2D(id, 1);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void shiftPatternDown2D(int id) {
        try {
            this.shiftPattern2D(id, -1);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void shiftPattern2D(int id, int pointShift) {
        try {
            int index;
            int point;
            int line;
            int n;
            Ensemble ensemble = new Ensemble();
            this.ensemble_Shot(ensemble, id, false);
            HashMap_Integers<Integer> hash = this.createReceiverHashLPI();
            int indexLine = ensemble.dictionary().getEntryIndex("Receiver", "LineNumber");
            int indexPoint = ensemble.dictionary().getEntryIndex("Receiver", "PointNumber");
            int indexIndex = ensemble.dictionary().getEntryIndex("Receiver", "PointIndex");
            int indexRecID = ensemble.dictionary().getEntryIndex("Trace", "ReceiverID");
            int indexTraceTableRow = ensemble.dictionary().getEntryIndex("Trace", "TraceIndex");
            Table_Abstract recTable = this.receiverTable();
            int colID = recTable.column_indexOfColumn("ReceiverID");
            ITraceTable traceTable = this.m_traceTableWrapper.traceTable();
            int traceColRecID = traceTable.column_indexOfColumn("ReceiverID");
            for (n = 0; n < ensemble.traceCount(); ++n) {
                line = ensemble.trace(n).header().getInt(indexLine);
                if (hash.containsKey(line, (point = ensemble.trace(n).header().getInt(indexPoint)) + pointShift, index = ensemble.trace(n).header().getInt(indexIndex))) continue;
                return;
            }
            for (n = 0; n < ensemble.traceCount(); ++n) {
                line = ensemble.trace(n).header().getInt(indexLine);
                point = ensemble.trace(n).header().getInt(indexPoint);
                index = ensemble.trace(n).header().getInt(indexIndex);
                long traceTableRow = ensemble.trace(n).header().getLong(indexTraceTableRow);
                Integer RecRowInt = hash.get(line, point + pointShift, index);
                int newRow = RecRowInt;
                int newRecID = recTable.getInt(newRow, colID);
                ensemble.trace(n).header().putInt(indexRecID, newRecID);
                traceTable.putInt(traceTableRow, traceColRecID, newRecID);
            }
            traceTable.saveCurrentSection();
            this.m_traceTableWrapper.recreateReceiverIndex();
            int shotRow = this.shotMap().get(id);
            int shotCol = this.shotTable().column_indexOfColumn("PatternShiftTotal");
            int shiftSum = pointShift + this.shotTable().getInt(shotRow, shotCol);
            this.m_geometryConn.updateSingleRow_Int("Shot", "PatternShiftTotal", id, shiftSum);
            this.shotTable().putInt(shotRow, shotCol, shiftSum);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void moveShot(int id, double x, double y) {
        try {
            this.confirmShotColumn_Double("DistanceMoved", 0.0);
            this.confirmReceiverColumn_Double("DistanceMoved", 0.0);
            this.confirmShotColumn_Double("AzimuthMoved", 0.0);
            this.confirmReceiverColumn_Double("AzimuthMoved", 0.0);
            int row = this.m_shotMap.get(id);
            int indexX = this.m_shotTable.column_indexOfColumn("Easting");
            this.m_shotTable.putDouble(row, indexX, x);
            int indexY = this.m_shotTable.column_indexOfColumn("Northing");
            this.m_shotTable.putDouble(row, indexY, y);
            this.m_geometryConn.updateSingleRow_Double("Shot", "Easting", id, x);
            this.m_geometryConn.updateSingleRow_Double("Shot", "Northing", id, y);
            int indexX0 = this.m_shotTable.column_indexOfColumn("InitialEasting");
            int indexY0 = this.m_shotTable.column_indexOfColumn("InitialNorthing");
            int indexDist = this.m_shotTable.column_indexOfColumn("DistanceMoved");
            int indexAz = this.m_shotTable.column_indexOfColumn("AzimuthMoved");
            double x0 = this.m_shotTable.getDouble(row, indexX0);
            double y0 = this.m_shotTable.getDouble(row, indexY0);
            double dx = x - x0;
            double dy = y - y0;
            double d = Math.sqrt(1.0E-20 + dx * dx + dy * dy);
            double az = 180.0 * Math.atan2(dy, dx) / Math.PI;
            this.m_shotTable.putDouble(row, indexDist, d);
            this.m_shotTable.putDouble(row, indexAz, d);
            this.m_geometryConn.updateSingleRow_Double("Shot", "DistanceMoved", id, d);
            this.m_geometryConn.updateSingleRow_Double("Shot", "AzimuthMoved", id, az);
            Ensemble ensemble = new Ensemble();
            this.ensemble_Shot(ensemble, id, false);
            this.delayTimeData().recomputeShotDelayTimes(ensemble);
            Column_Abstract firstHeader = ensemble.trace(0).header();
            for (int branch = 1; branch <= RefractionStaticsProject.delayTimeData().branchAssignment().maxBranch(); ++branch) {
                int index = ensemble.HeaderIndex_ShotDT[branch];
                double dt = firstHeader.getDouble(index);
                this.m_geometryConn.updateSingleRow_Double("Shot", Pecos.getColNameDT(branch), id, dt);
                int colIndex = this.m_shotTable.column_indexOfColumn(Pecos.getColNameDT(branch));
                this.m_shotTable.putDouble(row, colIndex, dt);
            }
            Tools_DelayTime_Geometry.singleton().computeGeometryCorrection(true, ensemble, "FBP_User");
            Messenger.broadcastShotGeometryChanged(this, id);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void moveReceiver(int id, double x, double y) {
        try {
            this.confirmShotColumn_Double("DistanceMoved", 0.0);
            this.confirmReceiverColumn_Double("DistanceMoved", 0.0);
            this.confirmShotColumn_Double("AzimuthMoved", 0.0);
            this.confirmReceiverColumn_Double("AzimuthMoved", 0.0);
            int row = this.m_receiverMap.get(id);
            int indexX = this.m_receiverTable.column_indexOfColumn("Easting");
            this.m_receiverTable.putDouble(row, indexX, x);
            int indexY = this.m_receiverTable.column_indexOfColumn("Northing");
            this.m_receiverTable.putDouble(row, indexY, y);
            this.m_geometryConn.updateSingleRow_Double("Receiver", "Easting", id, x);
            this.m_geometryConn.updateSingleRow_Double("Receiver", "Northing", id, y);
            int indexX0 = this.m_receiverTable.column_indexOfColumn("InitialEasting");
            int indexY0 = this.m_receiverTable.column_indexOfColumn("InitialNorthing");
            int indexDist = this.m_receiverTable.column_indexOfColumn("DistanceMoved");
            int indexAz = this.m_receiverTable.column_indexOfColumn("AzimuthMoved");
            double x0 = this.m_receiverTable.getDouble(row, indexX0);
            double y0 = this.m_receiverTable.getDouble(row, indexY0);
            double dx = x - x0;
            double dy = y - y0;
            double d = Math.sqrt(1.0E-20 + dx * dx + dy * dy);
            double az = 180.0 * Math.atan2(dy, dx) / Math.PI;
            this.m_receiverTable.putDouble(row, indexDist, d);
            this.m_receiverTable.putDouble(row, indexAz, az);
            this.m_geometryConn.updateSingleRow_Double("Receiver", "DistanceMoved", id, d);
            this.m_geometryConn.updateSingleRow_Double("Receiver", "AzimuthMoved", id, az);
            Messenger.broadcastReceiverGeometryChanged(this, id);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void fixGeometry(Ensemble ensemble) {
    }

    public void shuttingDown() {
        try {
            if (this.m_name == null) {
                return;
            }
            this.m_traceTableWrapper.traceTable().saveCurrentSection();
            this.m_information.save(this.m_paramFileName);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public TomoInteractiveModel_PickCollection tomoInteractiveModel_PickCollection() {
        return this.m_tomoInteractiveModel_PickCollection;
    }

    @Override
    public String projectPath() {
        return this.m_projectPath;
    }

    public String guiOptionsPath() {
        return this.m_guiOptionsPath;
    }

    public String getSubPath(String subPathName) {
        try {
            return Tools_FileSystem.confirmSubDirectoryExists(this.m_projectPath, subPathName);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return "";
        }
    }

    public GliInteractiveModel_PickCollection gliInteractiveModel_PickCollection() {
        return this.m_gliInteractiveModel_PickCollection;
    }

    public String fwi3DProjectsPath() {
        if (this.m_fwi3DLayerProjectsPath == null) {
            this.m_fwi3DLayerProjectsPath = this.getSubPath("FWI3D");
        }
        return this.m_fwi3DLayerProjectsPath;
    }

    public FwiModel getFwi3D() {
        return this.m_fwi3D;
    }

    public void setFwi3D(FwiModel g) {
        this.m_fwi3D = g;
    }

    public String tomoVNSProjectsPath() {
        if (this.m_tomoVNSProjectsPath == null) {
            this.m_tomoVNSProjectsPath = this.getSubPath("TomoVNS");
        }
        return this.m_tomoVNSProjectsPath;
    }

    public Tomo_VNS getTomo_VNS() {
        return this.m_tomoVNS;
    }

    public void setTomo_VNS(Tomo_VNS g) {
        this.m_tomoVNS = g;
    }

    public String upholeProjectsPath() {
        if (this.m_upholeProjectsPath == null) {
            this.m_upholeProjectsPath = this.getSubPath("Uphole");
        }
        return this.m_upholeProjectsPath;
    }

    public UpholeModel getUphole() {
        return this.m_uphole;
    }

    public void setUphole(UpholeModel uphole) {
        this.m_uphole = uphole;
    }

    public String eikonal3DProjectsPath() {
        if (this.m_eikonal3DLayerProjectsPath == null) {
            this.m_eikonal3DLayerProjectsPath = this.getSubPath("Eikonal3D");
        }
        return this.m_eikonal3DLayerProjectsPath;
    }

    public TomoEikonal3D getEikonal3D() {
        return this.m_eikonal3D;
    }

    public void setEikonal3D(TomoEikonal3D g) {
        this.m_eikonal3D = g;
    }

    public int gliNewModelLayerCount() {
        return this.m_gliNewModelLayerCount;
    }

    public void setGliNewModelLayerCount(int layers) {
        this.m_gliNewModelLayerCount = layers;
    }

    public String gliProjectsPath() {
        if (this.m_gliProjectsPath == null) {
            this.m_gliProjectsPath = this.getSubPath("GLI");
        }
        return this.m_gliProjectsPath;
    }

    public GliModel getGliModel() {
        return this.m_gliModel;
    }

    public void setGliModel(GliModel gli) {
        this.m_gliModel = gli;
    }

    public String hybridProjectsPath() {
        return this.m_hybridProjectsPath;
    }

    public IDatabaseConnection importDatabase() {
        return this.m_importConn;
    }

    public InteractiveMoveoutTrend getInteractiveMoveoutTrend() {
        return this.m_interactiveTrendData;
    }

    public void prepInteractiveMoveoutTrend(double grid, double max_off, double off_bin) {
        this.m_interactiveTrendData = new InteractiveMoveoutTrend(grid, max_off, off_bin);
    }

    @Override
    public IMoveoutTrendData getMoveoutTrendData() {
        return this.m_moveoutTrendData;
    }

    public MoveoutTrendData moveoutTrendData() {
        return this.m_moveoutTrendData;
    }

    public String moveoutTrendFileName() {
        return this.m_moveoutTrendFileName;
    }

    public IGrid2D_Conversion getGrid2D_Conversion() {
        return this.m_grid2D;
    }

    public void setGrid2D_Conversion(IGrid2D_Conversion grid) {
        if (grid != null) {
            this.m_grid2D = grid;
            this.saveGrid2D_Conversion();
        }
    }

    public void saveGrid2D_Conversion() {
        this.m_grid2D.save(this.m_grid2DFileName);
    }

    public void grid2DPrepDefault() {
        try {
            if (this.units_feet()) {
                this.grid2DPrepDefault(100.0);
            } else {
                this.grid2DPrepDefault(25.0);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void grid2DPrepDefault(double gridSize) {
        try {
            this.TempGrid2DBinSize = gridSize;
            this.TempGrid2DAngle = Tools_RefractionStaticsProject.findMaximumSurveyRangeAngle();
            double midX = Tools_RefractionStaticsProject.computeAverage("Easting", -1.0E30, 1.0E30);
            double midY = Tools_RefractionStaticsProject.computeAverage("Northing", -1.0E30, 1.0E30);
            double minr = 0.0;
            double maxr = 0.0;
            double cos = Math.cos(this.TempGrid2DAngle);
            double sin = Math.sin(this.TempGrid2DAngle);
            for (int iter = 0; iter <= 1; ++iter) {
                Table_Abstract table = this.receiverTable();
                if (iter == 1) {
                    table = this.shotTable();
                }
                int indexX = table.column_indexOfColumn("Easting");
                int indexY = table.column_indexOfColumn("Northing");
                int indexKilled = table.column_indexOfColumn("Killed");
                for (int n = 0; n < table.row_count(); ++n) {
                    double y;
                    if (table.getBool(n, indexKilled)) continue;
                    double x = table.getDouble(n, indexX) - midX;
                    double r = cos * x + sin * (y = table.getDouble(n, indexY) - midY);
                    if (r < 0.0) {
                        minr = Math.max(minr, -r);
                        continue;
                    }
                    maxr = Math.max(maxr, r);
                }
            }
            this.TempGrid2DOriginX = midX - cos * (minr + this.TempGrid2DBinSize);
            this.TempGrid2DOriginY = midY - sin * (minr + this.TempGrid2DBinSize);
            this.TempGrid2DCount = 3 + (int)((maxr + minr) / this.TempGrid2DBinSize);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public Grid3D_Conversion getGrid3D_Conversion() {
        return this.m_grid3D;
    }

    public void saveGrid3D_Conversion() {
        this.m_grid3D.save(this.m_grid3DFileName);
    }

    public void createDefaultGrid3D() {
        try {
            if (this.units_feet()) {
                this.m_grid3D.setBinSize(100.0, 100.0);
            } else {
                this.m_grid3D.setBinSize(25.0, 25.0);
            }
            double angle = Tools_RefractionStaticsProject.findMinimumSurveyAreaAngle(this.m_shotTable, this.m_receiverTable);
            this.m_grid3D.setInlineAngle(angle);
            Tools_RefractionStaticsProject.gridRange3D(this.m_grid3D, 100.0, this.m_shotTable, this.m_receiverTable);
            this.m_grid3D.setOrigin(this.m_grid3D.WorldCoordAtMinCornerX, this.m_grid3D.WorldCoordAtMinCornerY);
            this.saveGrid3D_Conversion();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public Grid3D getEmptyGrid3D(double buffer, double gridSizeI, double gridSizeC) throws Exception {
        try {
            Grid3D_Conversion grid = this.m_grid3D.clone();
            grid.setBinSize(gridSizeI, gridSizeC);
            Tools_RefractionStaticsProject.gridRange3D(grid, buffer);
            return new Grid3D(grid);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public Grid3D getEmptyGrid3D() throws Exception {
        try {
            return this.getEmptyGrid3D(0.0, this.m_grid3D.inlineBinSize(), this.m_grid3D.crosslineBinSize());
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void selectOffsetBinSize() {
        try {
            int bin = this.offsetBinSize();
            MultiTextDialog dlg = new MultiTextDialog(null, "Offset bin selection", "Offset bin size (ft/m)");
            dlg.setText(0, Integer.toString(bin));
            dlg.showDialog("OK");
            if (!dlg.OK) {
                return;
            }
            bin = dlg.getInt(0, 100, 1, 5000);
            this.information().int_put("OffsetBinSize", bin);
            this.saveInformation();
            Messenger.singleton().broadcastMessage(Messenger.Message.OffsetBinSizeChanged, null, null);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public int offsetBinSize() {
        try {
            int bin = this.information().int_get("OffsetBinSize", 100);
            if (bin < 1 || bin > 5000) {
                bin = 100;
                this.information().int_put("OffsetBinSize", bin);
                this.saveInformation();
            }
            return bin;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return 100;
        }
    }

    public boolean dim3D() {
        try {
            return this.m_dim3D;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return true;
        }
    }

    public boolean dim2D() {
        try {
            return !this.m_dim3D;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return true;
        }
    }

    public int getMinimumValidBranchPickFold() {
        try {
            int m = this.information().int_get("MinimumValidBranchPickFold", 4);
            m = Math.max(m, 1);
            m = Math.min(m, 11);
            return m;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return 4;
        }
    }

    public void putMinimumValidBranchPickFold(int m) {
        try {
            m = Math.max(m, 1);
            m = Math.min(m, 11);
            this.information().int_put("MinimumValidBranchPickFold", m);
            this.saveInformation();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public UpholeCorrection.Method getUpholeCorrectionMethod() {
        return this.m_upholeCorrectionMethod;
    }

    public void setUpholeCorrectionMethod(UpholeCorrection.Method method) {
        try {
            this.m_upholeCorrectionMethod = method;
            int index = UpholeCorrection.getIndexFromMethod(method);
            this.information().int_put("UpholeMethod", index);
            this.saveInformation();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public double getWaterVelocity() {
        return this.m_waterVelocity;
    }

    public void setWaterVelocity(double waterVelocity) {
        try {
            this.m_waterVelocity = Math.max(waterVelocity, 1400.0);
            this.information().double_put("WaterVelocity", this.m_waterVelocity);
            this.saveInformation();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public WaterBottomCorrection.Method getWaterDepthCorrectionMethod() {
        return this.m_waterBottomCorrectionMethod;
    }

    public void setWaterDepthCorrectionMethod(WaterBottomCorrection.Method method) {
        try {
            this.m_waterBottomCorrectionMethod = method;
            int index = WaterBottomCorrection.getIndexFromMethod(method);
            this.information().int_put("WaterBottomMethod", index);
            this.saveInformation();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public boolean units_feet() {
        try {
            String units = this.m_information.string_get("Units");
            return units.equalsIgnoreCase("Feet");
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    public void setUnitsFeet() {
        try {
            this.m_information.string_put("Units", "Feet");
            this.saveInformation();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setUnitsMeters() {
        try {
            this.m_information.string_put("Units", "Meters");
            this.saveInformation();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public ITraceTable_Wrapper traceTableWrapper() {
        return this.m_traceTableWrapper;
    }

    public void traceTableWrapper_Clear() {
        this.m_traceTableWrapper = null;
    }

    public void traceTableWrapper_Refresh() {
        try {
            String tracePath = this.m_projectPath + "/TraceTable";
            this.m_traceTableWrapper = new TraceTable_Huge_Wrapper(tracePath);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void traceTable_SaveandRead_UsingJob() {
        try {
            Action_ExportTraceTableToCSV actionSave = new Action_ExportTraceTableToCSV();
            actionSave.Hasher.string_put("Name", "Backup");
            Action_ImportTraceTableFromCSV actionRead = new Action_ImportTraceTableFromCSV();
            actionRead.Hasher.string_put("Name", "Backup");
            this.m_actionSequence.clear();
            this.m_actionSequence.addAction(actionSave);
            this.m_actionSequence.addAction(actionRead);
            this.executeActionSequence();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void traceTable_SaveandRead_MainThread() {
        try {
            ITraceTable traceTable = this.traceTableWrapper().traceTable();
            String path = Tools_FileSystem.confirmSubDirectoryExists(this.projectPath(), "TraceTable_CSV");
            String csv = path + "/temp.csv";
            BufferedWriter writer = new BufferedWriter(new FileWriter(csv));
            for (int n = 0; n < traceTable.column_count(); ++n) {
                if (n >= 1) {
                    writer.write(",");
                }
                Object colName = traceTable.column_name(n);
                if (traceTable.column_type(n) == DataType.Int) {
                    colName = (String)colName + "_I";
                }
                if (traceTable.column_type(n) == DataType.Float) {
                    colName = (String)colName + "_F";
                }
                if (traceTable.column_type(n) == DataType.Double) {
                    colName = (String)colName + "_D";
                }
                if (traceTable.column_type(n) == DataType.Long) {
                    colName = (String)colName + "_L";
                }
                writer.write((String)colName);
            }
            writer.newLine();
            for (long row = 0L; row < traceTable.rowCount(); ++row) {
                for (int n = 0; n < traceTable.column_count(); ++n) {
                    if (n >= 1) {
                        writer.write(",");
                    }
                    writer.write(traceTable.getString(row, n));
                }
                writer.newLine();
            }
            writer.close();
            long rowCount = traceTable.rowCount();
            String traceTablePath = traceTable.path();
            this.traceTableWrapper_Clear();
            Tools_FileSystem.deletePathIfExists(traceTablePath);
            traceTablePath = Tools_FileSystem.confirmSubDirectoryExists(this.projectPath(), "TraceTable");
            BufferedReader br = new BufferedReader(new FileReader(csv));
            String line = br.readLine();
            Table_Memory table = new Table_Memory();
            ((Table_Abstract)table).setName("Trace");
            ArrayList<String> originalColumnNames = Tools_Strings.tokenizer_comma(line, true);
            DataType[] colType = new DataType[originalColumnNames.size()];
            int colIndex = 0;
            for (String colNameTemp : originalColumnNames) {
                DataType type = DataType.Float;
                String colName = colNameTemp;
                if (colNameTemp.endsWith("_D")) {
                    type = DataType.Double;
                    colName = colNameTemp.substring(0, colNameTemp.length() - 2);
                }
                if (colNameTemp.endsWith("_F")) {
                    type = DataType.Float;
                    colName = colNameTemp.substring(0, colNameTemp.length() - 2);
                }
                if (colNameTemp.endsWith("_I")) {
                    type = DataType.Int;
                    colName = colNameTemp.substring(0, colNameTemp.length() - 2);
                }
                if (colNameTemp.endsWith("_L")) {
                    type = DataType.Long;
                    colName = colNameTemp.substring(0, colNameTemp.length() - 2);
                }
                ((Table_Abstract)table).column_append(colName, type);
                colType[colIndex++] = type;
            }
            traceTable = new TraceTable_Huge(traceTablePath, "Trace", table, 8);
            line = br.readLine();
            long numRead = 0L;
            while (line != null) {
                ArrayList<String> tokens = Tools_Strings.tokenizer_improved(line, ',');
                int row = ((Table_Abstract)table).row_increment();
                for (int n = 0; n < tokens.size(); ++n) {
                    ((Table_Abstract)table).putString(row, n, tokens.get(n));
                }
                line = br.readLine();
                if (((Table_Abstract)table).row_count() >= 1000) {
                    traceTable.appendTable(table);
                    ((Table_Abstract)table).row_clear(false);
                }
                ++numRead;
            }
            if (((Table_Abstract)table).row_count() >= 1) {
                traceTable.appendTable(table);
                ((Table_Abstract)table).row_clear(false);
            }
            traceTable.finishedAppending(null);
            br.close();
            this.traceTableWrapper_Refresh();
            Messenger.broadcast(Messenger.Message.TraceTableReloaded, null, null);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public Table_Abstract shotTable() {
        try {
            IPlugin plugin = PluginManager.singleton().currentPlugin();
            if (plugin != null) {
                if (plugin.overrideDataFormat()) {
                    if (plugin.getSeismicProject() != null) {
                        return plugin.getSeismicProject().getTable("Shot");
                    }
                    throw new Exception("Plugin overrides data format but does not provide a valid ISeismicProject implementation");
                }
                return this.m_shotTable;
            }
            return this.m_shotTable;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public HashMap_Integer shotMap() {
        return this.m_shotMap;
    }

    public HashMap_Integers<Integer> createShotHashLPI() {
        return this.createHashLPI(this.m_shotTable);
    }

    @Override
    public Table_Abstract receiverTable() {
        try {
            IPlugin plugin = PluginManager.singleton().currentPlugin();
            if (plugin != null) {
                if (plugin.overrideDataFormat()) {
                    if (plugin.getSeismicProject() != null) {
                        return plugin.getSeismicProject().getTable("Receiver");
                    }
                    throw new Exception("Plugin overrides data format but does not provide a valid ISeismicProject implementation");
                }
                return this.m_receiverTable;
            }
            return this.m_receiverTable;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public HashMap_Integer receiverMap() {
        return this.m_receiverMap;
    }

    public HashMap_Integers<Integer> createReceiverHashLPI() {
        return this.createHashLPI(this.m_receiverTable);
    }

    public HashMap_Integers<Integer> createHashLPI(Table_Abstract table) {
        try {
            HashMap_Integers<Integer> hash = new HashMap_Integers<Integer>();
            int indexPoint = table.column_indexOfColumn("PointNumber");
            int indexLine = table.column_indexOfColumn("LineNumber");
            int indexIndex = table.column_indexOfColumn("PointIndex");
            for (int row = 0; row < table.row_count(); ++row) {
                int point = table.getInt(row, indexPoint);
                int line = table.getInt(row, indexLine);
                int index = table.getInt(row, indexIndex);
                hash.put(new Integer(row), line, point, index);
            }
            return hash;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public Range_Double rangeX() {
        return this.m_rangeX;
    }

    public Range_Double rangeY() {
        return this.m_rangeY;
    }

    public ParameterTree information() {
        return this.m_information;
    }

    public void saveInformation() {
        try {
            this.m_information.save(this.m_paramFileName);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public IDatabaseConnection geometryDatabase() {
        return this.m_geometryConn;
    }

    @Override
    public ArrayList<String> getListOfGeomDBColumnNames(String tableName) {
        try {
            return this.m_geometryConn.listOfColumnNames(tableName);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public int runCount() {
        return this.m_runCount;
    }

    public HybridGliData hybridGliData() {
        try {
            if (this.m_hybridGliData == null) {
                this.m_hybridGliData = new HybridGliData();
                String hybridVersion = this.m_information.string_get("HybridVersion", "Default");
                this.m_hybridGliData.setModelName(hybridVersion, 2000.0);
            }
            return this.m_hybridGliData;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public static DelayTimeData delayTimeData() {
        return RefractionStaticsProject.singleton().getDelayTimeData();
    }

    public DelayTimeData getDelayTimeData() {
        return this.m_delayTimeData;
    }

    protected void prepIndexConnectors(Ensemble ensemble, Table_Abstract table) {
        try {
            if (this.m_headerIndex.length <= table.column_count()) {
                this.m_headerIndex = new int[20 + table.column_count()];
            }
            if (this.m_headerType.length <= table.column_count()) {
                this.m_headerType = new DataType[20 + table.column_count()];
            }
            if (this.m_doubleType.length <= table.column_count()) {
                this.m_doubleType = new boolean[20 + table.column_count()];
            }
            String tableName = table.name();
            for (int col = 0; col < table.column_count(); ++col) {
                String name = table.column_name(col);
                this.m_headerType[col] = table.column_type(col);
                this.m_headerIndex[col] = ensemble.dictionary().addEntry(tableName, name, this.m_headerType[col]);
                this.m_doubleType[col] = this.m_headerType[col] == DataType.Double || this.m_headerType[col] == DataType.Float;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void populateReceiverHeader(Ensemble ensemble) {
        try {
            if (!ensemble.dictionary().containsEntry("Trace", "ReceiverID")) {
                return;
            }
            int indexID = ensemble.dictionary().getEntryIndex("Trace", "ReceiverID");
            int indexRow = ensemble.dictionary().addEntry("Receiver", "ReceiverRow", DataType.Int);
            this.prepIndexConnectors(ensemble, this.m_receiverTable);
            for (int t = 0; t < ensemble.traceCount(); ++t) {
                Column_Abstract header = ensemble.trace(t).header();
                int id = header.getInt(indexID);
                if (!this.m_receiverMap.containsKey(id)) continue;
                int row = this.m_receiverMap.get(id);
                header.putInt(indexRow, row);
                for (int col = 0; col < this.m_receiverTable.column_count(); ++col) {
                    int headerIndex = this.m_headerIndex[col];
                    if (this.m_doubleType[col]) {
                        header.putDouble(headerIndex, this.m_receiverTable.getDouble(row, col));
                        continue;
                    }
                    header.putInt(headerIndex, this.m_receiverTable.getInt(row, col));
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void populateShotHeader(Ensemble ensemble) {
        try {
            if (!ensemble.dictionary().containsEntry("Trace", "ShotID")) {
                return;
            }
            int indexID = ensemble.dictionary().getEntryIndex("Trace", "ShotID");
            int indexRow = ensemble.dictionary().addEntry("Shot", "ShotRow", DataType.Int);
            boolean crap = false;
            this.prepIndexConnectors(ensemble, this.m_shotTable);
            for (int t = 0; t < ensemble.traceCount(); ++t) {
                Column_Abstract header = ensemble.trace(t).header();
                int id = header.getInt(indexID);
                if (!this.m_shotMap.containsKey(id)) {
                    crap = true;
                }
                if (!this.m_shotMap.containsKey(id)) continue;
                int row = this.m_shotMap.get(id);
                header.putInt(indexRow, row);
                for (int col = 0; col < this.m_shotTable.column_count(); ++col) {
                    int headerIndex = this.m_headerIndex[col];
                    if (this.m_doubleType[col]) {
                        header.putDouble(headerIndex, this.m_shotTable.getDouble(row, col));
                        continue;
                    }
                    header.putInt(headerIndex, this.m_shotTable.getInt(row, col));
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void prepareRefractionEnsemble(Ensemble re, boolean assignBranches, boolean computeTravelTimes) {
        try {
            this.prepGeometryHeaders(re, assignBranches, computeTravelTimes);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void prepGeometryHeaders(Ensemble ensemble, boolean assignBranches, boolean computeTravelTimes) {
        try {
            if (ensemble.traceCount() < 1) {
                return;
            }
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                ensemble.trace((int)n).Removed = false;
                ensemble.trace((int)n).PureDC = false;
                ensemble.trace((int)n).DC_Biased = false;
                ensemble.trace((int)n).TooNoisy = false;
                ensemble.trace((int)n).TraceKilled = false;
            }
            this.populateShotHeader(ensemble);
            this.populateReceiverHeader(ensemble);
            Tools_Ensemble.computeAzimuthAndOffset(ensemble);
            Tools_Ensemble_RefractionProject.computeCdpCoords(ensemble);
            Tools_Ensemble_RefractionProject.computeMidCoords(ensemble);
            Tools_Ensemble.killTraces(ensemble);
            if (assignBranches) {
                this.m_delayTimeData.branchAssignment().assignBranch(ensemble, "Branch_DelayTime");
            }
            if (computeTravelTimes) {
                this.m_delayTimeData.computeRefractorTravelTimes(ensemble);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public boolean nameStartsWith(String prefix) {
        try {
            return this.m_name.startsWith(prefix);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    public void setLoadKilledTraces(boolean loadKilledTraces) {
        try {
            this.m_traceTableWrapper.traceTable().setLoadKilledTraces(loadKilledTraces);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void ensemble_Sequence(Ensemble ensemble, long startIndex, int count, boolean getData, boolean handlePolarity) {
        try {
            IPlugin plugin = PluginManager.singleton().currentPlugin();
            if (plugin != null && plugin.overrideDataFormat()) {
                if (plugin.getSeismicProject() != null) {
                    plugin.getSeismicProject().ensemble_Sequence(ensemble, startIndex, count, getData, handlePolarity);
                    return;
                }
                throw new Exception("Plugin overrides data format but does not provide a valid ISeismicProject implementation");
            }
            long start = System.currentTimeMillis();
            ensemble.clearTraces(false);
            this.m_traceTableWrapper.traceTable().populateEnsemble(ensemble, startIndex, count);
            this.prepGeometryHeaders(ensemble, true, true);
            if (getData) {
                this.populateData(ensemble, true, false, handlePolarity);
            }
            long end = System.currentTimeMillis();
            if (this.SubstituteSyntheticGather) {
                Tools_Ensemble.createSynthetic(ensemble);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void ensemble_Sequence(Ensemble ensemble, long startIndex, int count, boolean getData) {
        try {
            this.ensemble_Sequence(ensemble, startIndex, count, getData, true);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void ensemble_Indices(Ensemble ensemble, long[] indices, int count, boolean getData) {
        try {
            IPlugin plugin = PluginManager.singleton().currentPlugin();
            if (plugin != null && plugin.overrideDataFormat()) {
                if (plugin.getSeismicProject() != null) {
                    plugin.getSeismicProject().ensemble_Indices(ensemble, indices, count, getData);
                    return;
                }
                throw new Exception("Plugin overrides data format but does not provide a valid ISeismicProject implementation");
            }
            long start = System.currentTimeMillis();
            ensemble.clearTraces(false);
            if (indices == null) {
                return;
            }
            if (indices.length < 1) {
                return;
            }
            this.m_traceTableWrapper.traceTable().populateEnsemble(ensemble, indices, count);
            this.prepGeometryHeaders(ensemble, true, true);
            if (getData) {
                this.populateData(ensemble, true, false);
            }
            long end = System.currentTimeMillis();
            if (this.SubstituteSyntheticGather) {
                Tools_Ensemble.createSynthetic(ensemble);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void ensemble_Receiver(Ensemble ensemble, int recID, boolean getData) {
        try {
            IPlugin plugin = PluginManager.singleton().currentPlugin();
            if (plugin != null && plugin.overrideDataFormat()) {
                if (plugin.getSeismicProject() != null) {
                    plugin.getSeismicProject().ensemble_Receiver(ensemble, recID, getData);
                    return;
                }
                throw new Exception("Plugin overrides data format but does not provide a valid ISeismicProject implementation");
            }
            long start = System.currentTimeMillis();
            if (this.m_receiverSortManager != null && getData) {
                ensemble.clearTraces(false);
                this.m_receiverSortManager.populateEnsemble(ensemble, recID, 0);
                this.m_traceTableWrapper.traceTable().fillEnsembleHeaders(ensemble);
                this.prepGeometryHeaders(ensemble, true, true);
                Tools_Ensemble_RefractionProject.setTracePolarity(ensemble, false);
                int testRecID = Tools_Ensemble.isReceiverEnsemble(ensemble);
                if (testRecID != recID) {
                    System.out.println("ERROR ERROR ERROR == testRecID != recID == ERROR ERROR  ERROR ERROR ERROR");
                }
            } else {
                ensemble.clearTraces(false);
                this.m_traceTableWrapper.populateEnsemble(ensemble, "ReceiverID", recID, recID);
                this.prepGeometryHeaders(ensemble, true, true);
                if (getData) {
                    this.populateData(ensemble, true, false);
                }
            }
            long end = System.currentTimeMillis();
            System.out.println("receiverEnsemble load time = " + Long.toString(end - start));
            if (this.SubstituteSyntheticGather) {
                Tools_Ensemble.createSynthetic(ensemble);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void ensemble_Shot(Ensemble ensemble, int shotID, boolean getData) {
        try {
            IPlugin plugin = PluginManager.singleton().currentPlugin();
            if (plugin != null && plugin.overrideDataFormat()) {
                if (plugin.getSeismicProject() != null) {
                    plugin.getSeismicProject().ensemble_Shot(ensemble, shotID, getData);
                    return;
                }
                throw new Exception("Plugin overrides data format but does not provide a valid ISeismicProject implementation");
            }
            ensemble.clearTraces(false);
            this.m_traceTableWrapper.populateEnsemble(ensemble, "ShotID", shotID, shotID);
            this.prepGeometryHeaders(ensemble, true, true);
            if (getData) {
                this.populateData(ensemble, false, true);
            }
            if (this.SubstituteSyntheticGather) {
                Tools_Ensemble.createSynthetic(ensemble);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public List<Integer> getNearbyShots(int shotID, int nNearbyShots) {
        ArrayList<Integer> shotList = new ArrayList<Integer>();
        try {
            if (this.m_shotLabels == null) {
                this.createSortedShotLabels();
            }
            int iSelectedIndex = -1;
            int nLabels = this.m_shotLabels.size();
            for (int i = 0; i < nLabels; ++i) {
                ShotLabel lbl = this.m_shotLabels.get(i);
                if (lbl.ID != shotID) continue;
                iSelectedIndex = i;
                break;
            }
            if (iSelectedIndex >= 0) {
                int iWindow;
                for (int i = iWindow = (nNearbyShots - 1) / 2; i > 0; --i) {
                    int index = iSelectedIndex - i;
                    if (index < 0 || index >= this.m_shotLabels.size()) continue;
                    ShotLabel lbl = this.m_shotLabels.get(index);
                    shotList.add(lbl.ID);
                }
                ShotLabel lbl2 = this.m_shotLabels.get(iSelectedIndex);
                shotList.add(lbl2.ID);
                for (int i = 1; i <= iWindow; ++i) {
                    int index = iSelectedIndex + i;
                    if (index < 0 || index >= this.m_shotLabels.size()) continue;
                    ShotLabel lbl = this.m_shotLabels.get(index);
                    shotList.add(lbl.ID);
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
        return shotList;
    }

    void createSortedShotLabels() {
        try {
            this.m_shotLabels = new ArrayList<ShotLabel>();
            int nRows = this.m_shotTable.row_count();
            int iColumnLineNumber = this.m_shotTable.column_indexOfColumn("LineNumber");
            int iColumnPointNumber = this.m_shotTable.column_indexOfColumn("PointNumber");
            int iColumnPointIndex = this.m_shotTable.column_indexOfColumn("PointIndex");
            int iColumnShotID = this.m_shotTable.column_indexOfColumn("ShotID");
            for (int iRow = 0; iRow < nRows; ++iRow) {
                int iShotID = this.m_shotTable.getInt(iRow, iColumnShotID);
                int iLineNumber = this.m_shotTable.getInt(iRow, iColumnLineNumber);
                int iPointNumber = this.m_shotTable.getInt(iRow, iColumnPointNumber);
                int iPointIndex = this.m_shotTable.getInt(iRow, iColumnPointIndex);
                ShotLabel label = new ShotLabel(iShotID, iLineNumber, iPointNumber, iPointIndex, iRow);
                this.m_shotLabels.add(label);
            }
            Collections.sort(this.m_shotLabels);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void ensemble_Shots(Ensemble ensemble, int shotID, boolean getData, int nNearbyShots) {
        try {
            IPlugin plugin = PluginManager.singleton().currentPlugin();
            if (plugin != null && plugin.overrideDataFormat()) {
                if (plugin.getSeismicProject() != null) {
                    plugin.getSeismicProject().ensemble_Shots(ensemble, shotID, getData, nNearbyShots);
                    return;
                }
                throw new Exception("Plugin overrides data format but does not provide a valid ISeismicProject implementation");
            }
            ensemble.clearTraces(false);
            List<Integer> shotList = this.getNearbyShots(shotID, nNearbyShots);
            this.m_traceTableWrapper.populateEnsemble(ensemble, "ShotID", shotList);
            this.prepGeometryHeaders(ensemble, true, true);
            if (getData) {
                this.populateData(ensemble, false, true);
            }
            if (this.SubstituteSyntheticGather) {
                Tools_Ensemble.createSynthetic(ensemble);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void ensemble_Bin2D(Ensemble ensemble, int bin, int radius, boolean getData) throws Exception {
        try {
            if (!this.dim2D()) {
                throw new Exception("3D project: Cannot get 2D ensemble");
            }
            IPlugin plugin = PluginManager.singleton().currentPlugin();
            if (plugin != null && plugin.overrideDataFormat()) {
                if (plugin.getSeismicProject() != null) {
                    plugin.getSeismicProject().ensemble_Bin2D(ensemble, bin, radius, getData);
                    return;
                }
                throw new Exception("Plugin overrides data format but does not provide a valid ISeismicProject implementation");
            }
            long start = System.currentTimeMillis();
            ensemble.clearTraces(false);
            this.m_traceTableWrapper.populateEnsemble(ensemble, "Bin2D", bin - radius, bin + radius);
            this.prepGeometryHeaders(ensemble, true, true);
            if (getData) {
                this.populateData(ensemble, false, false);
            }
            long end = System.currentTimeMillis();
            int time = (int)(end - start);
            if (this.SubstituteSyntheticGather) {
                Tools_Ensemble.createSynthetic(ensemble);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public void ensemble_Bin3D(Ensemble ensemble, int inline, int crossline, int radius, boolean getData) {
        try {
            IPlugin plugin = PluginManager.singleton().currentPlugin();
            if (plugin != null && plugin.overrideDataFormat()) {
                if (plugin.getSeismicProject() != null) {
                    plugin.getSeismicProject().ensemble_Bin3D(ensemble, inline, crossline, radius, getData);
                    return;
                }
                throw new Exception("Plugin overrides data format but does not provide a valid ISeismicProject implementation");
            }
            long start = System.currentTimeMillis();
            if (this.m_inlineCrosslineSortManager != null && getData) {
                boolean ok;
                ensemble.clearTraces(false);
                for (int x = inline - radius; x <= inline + radius; ++x) {
                    for (int y = crossline - radius; y <= crossline + radius; ++y) {
                        this.m_inlineCrosslineSortManager.populateEnsemble(ensemble, x, y);
                    }
                }
                this.m_traceTableWrapper.traceTable().fillEnsembleHeaders(ensemble);
                this.prepGeometryHeaders(ensemble, true, true);
                Tools_Ensemble_RefractionProject.setTracePolarity(ensemble, false);
                if (radius == 0 && !(ok = Tools_Ensemble.isBin3DEnsemble(ensemble, inline, crossline))) {
                    System.out.println("ERROR ERROR ERROR == isBin3DEnsemble == ERROR ERROR  ERROR ERROR ERROR");
                }
            } else {
                ensemble.clearTraces(false);
                this.m_traceTableWrapper.populateEnsemble(ensemble, "Inline", inline - radius, inline + radius, "Crossline", crossline - radius, crossline + radius);
                this.prepGeometryHeaders(ensemble, true, true);
                if (getData) {
                    this.populateData(ensemble, false, false);
                }
            }
            long end = System.currentTimeMillis();
            int time = (int)(end - start);
            if (this.SubstituteSyntheticGather) {
                Tools_Ensemble.createSynthetic(ensemble);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void prepSeismicFilesForScanning() {
        try {
            for (FileInfo info : this.m_fileList) {
                info.SeismicFile.openPecosRAF();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void finishedSeismicFileScanning() {
        try {
            for (FileInfo info : this.m_fileList) {
                info.SeismicFile.closePecosRAF();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void populateData(Ensemble ensemble, boolean rec, boolean shot, boolean handlePolarity) {
        try {
            ensemble.sortLong(0, "Trace", "FileID", "Trace", "IndexInFile");
            ensemble.traceCount();
            for (FileInfo info : this.m_fileList) {
                if (info.SeismicFile == null) continue;
                info.SeismicFile.populateEnsembleWithData(ensemble, info.FileID);
            }
            this.inputDataProcessor_Run(ensemble);
            if (handlePolarity) {
                Tools_Ensemble_RefractionProject.setTracePolarity(ensemble, true);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void populateData(Ensemble ensemble, boolean rec, boolean shot) {
        try {
            this.populateData(ensemble, rec, shot, true);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void recomputeRanges() throws Exception {
        try {
            this.m_rangeX.clearRange();
            this.m_rangeY.clearRange();
            this.m_shotTable.column_range("Easting", this.m_rangeX);
            this.m_shotTable.column_range("Northing", this.m_rangeY);
            this.m_receiverTable.column_range("Easting", this.m_rangeX);
            this.m_receiverTable.column_range("Northing", this.m_rangeY);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void reloadAllData() throws Exception {
        try {
            this.loadReceiverTableFromMemoryDatabase();
            this.loadShotTableFromMemoryDatabase();
            this.recomputeRanges();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public boolean hasSeismic() {
        try {
            return this.m_information.bool_get("HasSeismic", false);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    public boolean valid() {
        try {
            if (this.m_name == null) {
                return false;
            }
            return !this.m_name.isEmpty();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    public String name() {
        return this.m_name;
    }

    public Grid3D getSmootherGrid() throws Exception {
        try {
            if (this.m_smootherGrid == null) {
                this.m_smootherGrid = this.units_feet() ? new Grid3D(Tools_RefractionStaticsProject.getGrid3D(200.0)) : new Grid3D(Tools_RefractionStaticsProject.getGrid3D(50.0));
                this.m_smootherGrid.interp_Prep();
            }
            return this.m_smootherGrid;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void freeSmoother() {
        try {
            this.m_smootherGrid = null;
            System.gc();
            System.gc();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void copyGuiOptionsIfFirstTime() {
        try {
            ArrayList<String> files = Tools_FileSystem.files(this.m_guiOptionsPath, true);
            if (files.size() >= 1) {
                return;
            }
            if (!Tools_FileSystem.exists_path(SharedApplicationData.singleton().defaultGuiDirectory())) {
                return;
            }
            String fromPath = SharedApplicationData.singleton().homeDirectory();
            String toPath = RefractionStaticsProject.singleton().projectPath();
            if (toPath == null || fromPath == null) {
                return;
            }
            Tools_FileSystem.copySubdirectory(fromPath, toPath, "GuiOptions");
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public Table_Abstract mergeProjectTable() {
        return this.m_mergeProjectTable;
    }

    public HashMap_Integers<String> mergeProjectHash() {
        return this.m_mergeProjectHash;
    }

    public String getMergeProjectName(int id) {
        try {
            if (this.m_mergeProjectHash == null) {
                return "NULLHASH";
            }
            if (!this.m_mergeProjectHash.containsKey(id)) {
                return "INVALIDID";
            }
            return this.m_mergeProjectHash.get(id);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return "ERROR";
        }
    }

    public void prepMergeProjectTable() {
        try {
            this.m_mergeProjectHash = null;
            this.m_mergeProjectTable = Table_Memory.readTable(this.m_projectPath, "Project");
            if (this.m_mergeProjectTable == null) {
                return;
            }
            this.m_mergeProjectHash = new HashMap_Integers();
            int indexID = this.m_mergeProjectTable.column_indexOfColumn("ProjectID");
            int indexName = this.m_mergeProjectTable.column_indexOfColumn("ProjectName");
            for (int row = 0; row < this.m_mergeProjectTable.row_count(); ++row) {
                int id = this.m_mergeProjectTable.getInt(row, indexID);
                String name = this.m_mergeProjectTable.getString(row, indexName);
                this.m_mergeProjectHash.put(name, id);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            this.m_mergeProjectTable = null;
            this.m_mergeProjectHash = null;
        }
    }

    protected void createInitialDatabaseFiles(Logger logger) throws Exception {
        try {
            if (logger == null) {
                logger = Logger.getLogger("test");
            }
            this.m_versionContainerPath = Tools_FileSystem.confirmSubDirectoryExists(this.m_projectPath, "Versions");
            String currentPath = Tools_FileSystem.confirmSubDirectoryExists(this.m_versionContainerPath, "Default");
            String driverName = this.m_information.string_get("DriverName", "HSQLDB");
            SharedApplicationData.singleton().setDatabaseDriver(driverName);
            Table_Abstract shotTable = null;
            Table_Abstract receiverTable = null;
            Table_Abstract fileTable = null;
            String importTablePath = Tools_FileSystem.confirmSubDirectoryExists(this.m_projectPath, "ImportedTables");
            if (Tools_FileSystem.exists_file(importTablePath + "/Shot.bin")) {
                System.out.println("createInitialDatabaseFiles:  reading binary geometry files");
                logger.info("Read binary geometry tables - start");
                shotTable = new Table_Memory();
                shotTable.setName("Shot");
                shotTable.readBinary(importTablePath + "/Shot.bin");
                receiverTable = new Table_Memory();
                receiverTable.setName("Receiver");
                receiverTable.readBinary(importTablePath + "/Receiver.bin");
                fileTable = new Table_Memory();
                fileTable.setName("FileList");
                fileTable.readBinary(importTablePath + "/FileList.bin");
                logger.info("Read binary geometry tables - done");
            }
            if (shotTable == null) {
                shotTable = Table_Memory.readTable(importTablePath, "Shot");
                receiverTable = Table_Memory.readTable(importTablePath, "Receiver");
                fileTable = Table_Memory.readTable(importTablePath, "FileList");
            }
            System.out.println("createInitialDatabaseFiles:  create db");
            String fileNameDB = currentPath + "/geometry.db";
            IDatabaseConnection db = Tools_JDBC.getConnection(driverName, false, fileNameDB);
            logger.info("fileNameDB = " + fileNameDB);
            long start = System.currentTimeMillis();
            logger.info("Create shot database table...");
            db.createDatabaseTable(shotTable);
            db.appendTable(shotTable, 0);
            long end = System.currentTimeMillis();
            System.out.println("db.createDatabaseTable(shotTable); = " + Long.toString(end - start));
            start = System.currentTimeMillis();
            logger.info("Create receiver database table...");
            db.createDatabaseTable(receiverTable);
            db.appendTable(receiverTable, 0);
            end = System.currentTimeMillis();
            System.out.println("db.createDatabaseTable(receiverTable); = " + Long.toString(end - start));
            start = System.currentTimeMillis();
            logger.info("Create file database table...");
            db.createDatabaseTable(fileTable);
            db.appendTable(fileTable, 0);
            logger.info("Add default database tables");
            db.addColumn("Shot", "Killed", DataType.Bool);
            db.executeUpdateStatement(String.format("UPDATE Shot Set %s = FALSE", "Killed"));
            db.addColumn("Receiver", "Killed", DataType.Bool);
            db.executeUpdateStatement(String.format("UPDATE Receiver Set %s = FALSE", "Killed"));
            db.addColumn("Shot", "InitialEasting", DataType.Double);
            db.executeUpdateStatement(String.format("UPDATE Shot Set %s = %s", "InitialEasting", "Easting"));
            db.addColumn("Shot", "InitialNorthing", DataType.Double);
            db.executeUpdateStatement(String.format("UPDATE Shot Set %s = %s", "InitialNorthing", "Northing"));
            db.addColumn("Receiver", "InitialEasting", DataType.Double);
            db.executeUpdateStatement(String.format("UPDATE Receiver Set %s = %s", "InitialEasting", "Easting"));
            db.addColumn("Receiver", "InitialNorthing", DataType.Double);
            db.executeUpdateStatement(String.format("UPDATE Receiver Set %s = %s", "InitialNorthing", "Northing"));
            db.closeConnection();
            logger.info("finished initialization");
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public EnsembleWorker_Sequence inputDataSequence() {
        return this.m_inputDataSequence;
    }

    public boolean inputDataSequenceOn() {
        return this.m_inputDataSequenceOn;
    }

    public void inputDataSequenceOn_Set(boolean on) {
        this.m_inputDataSequenceOn = on;
    }

    public void inputDataSequence_Save() {
        try {
            this.m_inputDataSequence.getParametersFromWidgets();
            Tools_EnsembleWorker.save(this.m_inputDataSequence, this.m_inputDataSequenceFileName);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public double inputDataSequence_MinOffset() {
        return this.m_inputDataSequence_MinOffset;
    }

    public void setInputDataSequence_MinOffset(double inputDataSequence_MinOffset) {
        this.m_inputDataSequence_MinOffset = inputDataSequence_MinOffset;
    }

    public double inputDataSequence_MaxOffset() {
        return this.m_inputDataSequence_MaxOffset;
    }

    public void setInputDataSequence_MaxOffset(double inputDataSequence_MaxOffset) {
        this.m_inputDataSequence_MaxOffset = inputDataSequence_MaxOffset;
    }

    public boolean inputDataSequence_ApplyOffsetLimits() {
        return this.m_inputDataSequence_ApplyOffsetLimits;
    }

    public void setInputDataSequence_ApplyOffsetLimits(boolean inputDataSequence_ApplyOffsetLimits) {
        this.m_inputDataSequence_ApplyOffsetLimits = inputDataSequence_ApplyOffsetLimits;
    }

    public double inputDataSequence_AzDir() {
        return this.m_inputDataSequence_AzDir;
    }

    public void setInputDataSequence_AzDir(double inputDataSequence_AzDir) {
        this.m_inputDataSequence_AzDir = inputDataSequence_AzDir;
    }

    public double inputDataSequence_AzAngle() {
        return this.m_inputDataSequence_AzAngle;
    }

    public void setInputDataSequence_AzAngle(double inputDataSequence_AzAngle) {
        this.m_inputDataSequence_AzAngle = inputDataSequence_AzAngle;
    }

    public boolean inputDataSequence_ApplyAzimuthLimits() {
        return this.m_inputDataSequence_ApplyAzimuthLimits;
    }

    public void setInputDataSequence_ApplyAzimuthLimits(boolean inputDataSequence_ApplyAzimuthLimits) {
        this.m_inputDataSequence_ApplyAzimuthLimits = inputDataSequence_ApplyAzimuthLimits;
    }

    public void inputDataProcessor_Run(Ensemble input) throws Exception {
        try {
            if (!this.m_inputDataSequenceOn) {
                return;
            }
            if (this.m_inputDataSequence_ApplyAzimuthLimits) {
                this.m_inputAzimuthSelector.setLimits(this.m_inputDataSequence_AzDir, this.m_inputDataSequence_AzAngle, true);
                input.filterAzimuth(this.m_inputAzimuthSelector);
            }
            if (this.m_inputDataSequence_ApplyOffsetLimits) {
                input.filter("Trace", "Offset", this.m_inputDataSequence_MinOffset, this.m_inputDataSequence_MaxOffset);
            }
            this.m_inputDataSequence.workInPlace(input);
            for (int n = 0; n < input.traceCount(); ++n) {
                EnsembleTrace trace = input.trace(n);
                if (!trace.hasData()) continue;
                FloatArrayWrapper data = trace.data();
                float dt = Math.abs(data.getFirstSampleCoord_WithShifts());
                float digi = data.getSampleInterval();
                int len = data.length();
                if (!(dt > 0.1f)) continue;
                if (this.m_inputSequenceArray.length < len) {
                    this.m_inputSequenceArray = new float[len + 20];
                }
                this.m_cti.prepareInput(trace);
                this.m_cti.interpolate(this.m_inputSequenceArray, 0.0f, digi);
                data.insertArray(this.m_inputSequenceArray, len);
                data.setFirstSampleCoord(0.0f);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    protected void inputDataProcessor_Read() {
        try {
            this.m_inputDataSequenceFileName = this.m_projectPath + "/InputData.SequenceXML";
            Tools_EnsembleWorker.read(this.m_inputDataSequence, this.m_inputDataSequenceFileName);
            this.m_inputDataSequence.setIsInputSequence(true);
            this.m_inputDataSequenceOn = this.m_information.bool_get("InputDataSequenceOn", false);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void inputDataProcessor_Save() {
        try {
            this.m_inputDataSequence.getParametersFromWidgets();
            this.m_inputDataSequence.removeAllListeners();
            Tools_EnsembleWorker.save(this.m_inputDataSequence, this.m_inputDataSequenceFileName);
            this.m_information.bool_put("InputDataSequenceOn", this.m_inputDataSequenceOn);
            this.m_information.save(this.m_paramFileName);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setName(String name) throws Exception {
        try {
            this.setName(name, false);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void setName(String name, boolean fromOpenProject) throws Exception {
        try {
            int index;
            if (this.m_name != null && !fromOpenProject) {
                return;
            }
            this.m_name = name;
            System.out.println("setName,  " + this.m_name);
            if (this.m_name == null) {
                return;
            }
            if (this.m_name.endsWith(".xtref")) {
                int endChar = this.m_name.length() - ".xtref".length();
                this.m_name = this.m_name.substring(0, endChar);
            } else {
                this.appendProjectFilenameExtension();
            }
            String parentPath = this.ParentProjectPath;
            this.m_projectPath = parentPath + "/" + this.m_name;
            System.out.println("Checking m_projectPath = " + this.m_projectPath);
            if (!Tools_FileSystem.exists_path(this.m_projectPath)) {
                System.out.println("Does not exist");
                this.m_projectPath = this.m_projectPath + ".xtref";
                System.out.println("Checking m_projectPath = " + this.m_projectPath);
                if (!Tools_FileSystem.exists_path(this.m_projectPath)) {
                    throw new Exception("Path does not exist");
                }
            }
            System.out.println("setName,  m_projectPath " + this.m_projectPath);
            this.m_fwi3DLayerProjectsPath = null;
            this.m_fwi3D = null;
            this.m_tomoVNSProjectsPath = null;
            this.m_tomoVNS = null;
            this.m_eikonal3DLayerProjectsPath = null;
            this.m_eikonal3D = null;
            this.m_paramFileName = this.m_projectPath + "/ProjectDescription.xml";
            this.m_information = new ParameterTree();
            System.out.println("setName,  m_paramFileName " + this.m_paramFileName);
            this.m_information.read(this.m_paramFileName);
            System.out.println("RefractionStaticsProject setName, m_information:");
            this.m_information.print(0);
            this.m_runCount = this.m_information.int_get("RunCount", 1);
            this.m_information.int_put("RunCount", this.m_runCount + 1);
            try {
                Date date = new Date();
                String dateAccessed = date.toString();
                this.m_information.string_put("DateLastOpened", dateAccessed);
            }
            catch (Exception date) {
                // empty catch block
            }
            Table_Abstract fileTable = Table_Memory.readTable(this.m_projectPath, "FileList");
            Table_Abstract segyTable = Table_Memory.readTable(this.m_projectPath, "SegyList");
            String origin = "OMEGA";
            if (this.m_information.string_exists("Origin")) {
                origin = this.m_information.string_get("Origin");
            }
            boolean isSegy = origin.equalsIgnoreCase("SEGY");
            System.out.println("RefractionStaticsProject setName - origin = " + origin);
            System.out.println("RefractionStaticsProject setName - isSegy = " + isSegy);
            if (isSegy && segyTable != null && !segyTable.column_exists("Directory")) {
                boolean compressed = this.m_information.string_get("HasCompressed", "False").equalsIgnoreCase("True");
                if (compressed) {
                    indexFileName = fileTable.column_indexOfColumn("Name");
                    indexFilePath = fileTable.column_indexOfColumn("Directory");
                    indexSegyName = segyTable.column_indexOfColumn("Name");
                    indexSegyPath = segyTable.column_append("Directory", DataType.Text);
                    for (s = 0; s < segyTable.row_count(); ++s) {
                        String fullSegyName = segyTable.getString(s, indexSegyName);
                        String segyName = fullSegyName.substring(fullSegyName.lastIndexOf("/") + 1, fullSegyName.length());
                        if (segyName.length() < 1) {
                            String tempSegyPath = segyName.substring(0, segyName.length() - 1);
                            segyName = tempSegyPath.substring(segyName.lastIndexOf("/"), tempSegyPath.length());
                        }
                        String filePath = fullSegyName.substring(0, fullSegyName.lastIndexOf("/"));
                        segyTable.putString(s, indexSegyName, segyName);
                        segyTable.putString(s, indexSegyPath, filePath);
                    }
                } else {
                    indexFileName = fileTable.column_indexOfColumn("Name");
                    indexFilePath = fileTable.column_indexOfColumn("Directory");
                    indexSegyName = segyTable.column_indexOfColumn("Name");
                    indexSegyPath = segyTable.column_append("Directory", DataType.Text);
                    for (s = 0; s < segyTable.row_count(); ++s) {
                        String segyName = segyTable.getString(s, indexSegyName);
                        for (int f = 0; f < fileTable.row_count(); ++f) {
                            String fileName = fileTable.getString(f, indexFileName);
                            if (!fileName.equalsIgnoreCase(segyName)) continue;
                            String filePath = fileTable.getString(f, indexFilePath);
                            segyTable.putString(s, indexSegyName, segyName);
                            segyTable.putString(s, indexSegyPath, filePath);
                        }
                    }
                }
                segyTable.saveToPath(this.m_projectPath);
            }
            this.inputDataProcessor_Read();
            String units = this.m_information.string_get("Units");
            try {
                int defIndex = UpholeCorrection.getIndexFromMethod(UpholeCorrection.Method.SoftwareDeterminesBest);
                index = this.m_information.int_get("UpholeMethod", defIndex);
                this.m_upholeCorrectionMethod = UpholeCorrection.getMethodFromIndex(index);
            }
            catch (Exception defIndex) {
                // empty catch block
            }
            try {
                this.m_interactiveTomoPath = this.getSubPath("InteractiveTomography");
                this.m_interactiveTomoPickFileName = this.m_interactiveTomoPath + "/Picks.data";
                this.m_tomoInteractiveModel_PickCollection = new TomoInteractiveModel_PickCollection(this.m_interactiveTomoPickFileName);
            }
            catch (Exception errorit) {
                errorit.printStackTrace();
            }
            try {
                this.m_interactiveGliPath = this.getSubPath("InteractiveGLI");
                this.m_interactiveGliPickFileName = this.m_interactiveGliPath + "/Picks.data";
                this.m_gliInteractiveModel_PickCollection = new GliInteractiveModel_PickCollection(this.m_interactiveGliPickFileName);
                this.m_gliNewModelLayerCount = this.m_gliInteractiveModel_PickCollection.getLayerCount();
            }
            catch (Exception errorit) {
                errorit.printStackTrace();
            }
            try {
                int defIndex = WaterBottomCorrection.getIndexFromMethod(WaterBottomCorrection.Method.VerticalTime);
                index = this.m_information.int_get("WaterBottomMethod", defIndex);
                this.m_waterBottomCorrectionMethod = WaterBottomCorrection.getMethodFromIndex(index);
            }
            catch (Exception defIndex) {
                // empty catch block
            }
            try {
                double defVel = 5000.0;
                if (units.equalsIgnoreCase("Meters")) {
                    defVel = 1500.0;
                }
                this.m_waterVelocity = this.m_information.double_get("WaterVelocity", defVel);
            }
            catch (Exception defVel) {
                // empty catch block
            }
            this.m_versionContainerPath = this.m_projectPath + "/Versions";
            Logger logger = null;
            try {
                if (this.m_runCount == 1 && !Tools_FileSystem.exists_path(this.m_versionContainerPath)) {
                    String parent_path = this.ParentProjectPath;
                    String canon_home = Tools_FileSystem.parentPath(parent_path);
                    String prefix = "initial_open_project_" + this.name();
                    logger = Pecos.create_logger(canon_home, prefix);
                }
            }
            catch (Exception logex) {
                logger = null;
                logex.printStackTrace();
            }
            if (this.m_runCount == 1 && !Tools_FileSystem.exists_path(this.m_versionContainerPath)) {
                this.createInitialDatabaseFiles(logger);
            }
            String driverName = this.m_information.string_get("DriverName", "HSQLDB");
            SharedApplicationData.singleton().setDatabaseDriver(driverName);
            this.prepMergeProjectTable();
            String sparsePath = Tools_FileSystem.confirmSubDirectoryExists(this.m_projectPath, "SparseCMP");
            this.m_sparseCmpGathers = new SparseCmpGatherManager(sparsePath);
            String preselectedPickLocationsFileName = this.m_projectPath + "/PreselectedPicks.data";
            this.m_preselectedPickLocations = new Java2D_Paintable_BranchPickCollections(preselectedPickLocationsFileName);
            this.m_guiOptionsPath = Tools_FileSystem.confirmSubDirectoryExists(this.m_projectPath, "GuiOptions");
            this.copyGuiOptionsIfFirstTime();
            this.m_currentVersionPath = this.m_versionContainerPath + "/Default";
            this.m_hybridProjectsPath = Tools_FileSystem.confirmSubDirectoryExists(this.m_projectPath, "HybridGLI");
            String dim = this.m_information.string_get("Dimension", "3D");
            this.m_dim3D = dim.equalsIgnoreCase("3D");
            String pickEvent = this.m_information.string_get("PickEvent", PickEvent.Peak.name());
            try {
                PickerGizmo.singleton().setPickEvent(PickEvent.valueOf(pickEvent));
            }
            catch (Exception errpe) {
                errpe.printStackTrace();
                PickerGizmo.singleton().setPickEvent(PickEvent.Peak);
            }
            this.reloadFileInfo(true);
            this.m_grid2DFileName = this.m_projectPath + "/GridDefinition2D.xml";
            this.m_grid2D.read(this.m_grid2DFileName);
            this.m_grid3DFileName = this.m_projectPath + "/GridDefinition3D.xml";
            this.m_grid3D.read(this.m_grid3DFileName);
            this.m_polygonFileName = this.m_projectPath + "/polygon.pt";
            this.m_polygon.read(this.m_polygonFileName);
            String tracePath = this.m_projectPath + "/TraceTable";
            this.m_traceTableWrapper = new TraceTable_Huge_Wrapper(tracePath);
            this.m_profilePath = Tools_FileSystem.confirmSubDirectoryExists(this.m_projectPath, "Profiles");
            this.m_profileManager = null;
            this.m_pickHistogramFileName = this.m_projectPath + "/PickHistogram.phd";
            this.m_pickHistogram.read(this.m_pickHistogramFileName);
            String version = this.m_information.string_get("Version", "Default");
            this.versionSelect(version);
            System.out.println("After versionSelect");
            this.m_moveoutTrendFileName = this.m_projectPath + "/MoveoutTrend.data";
            this.m_moveoutTrendData.read(this.m_moveoutTrendFileName);
            this.m_velocityManager = new VelocityManager(this);
            this.m_importPath = Tools_FileSystem.confirmSubDirectoryExists(this.m_projectPath, "Import");
            this.m_importFileName = this.m_projectPath + "/import.db";
            System.out.println("before m_importConn");
            this.m_importConn = Tools_JDBC.getConnection(false, this.m_importFileName);
            System.out.println("After m_importConn");
            this.reloadSortManagers();
            this.m_promaxGridFileName = this.m_projectPath + "/promaxgrid.txt";
            this.m_promaxGrid.readFourCorner(this.m_promaxGridFileName);
            this.prepareJobXmlObjects();
            String recConName = this.m_projectPath + "/ReceiverConflicts.xml";
            this.m_receiverConflicts = TableParser.readConflicts(recConName);
            String shotConName = this.m_projectPath + "/ShotConflicts.xml";
            this.m_shotConflicts = TableParser.readConflicts(shotConName);
            try {
                this.confirmShotColumn_Double("TomoVNS_StackPickTime", 0.0);
                this.confirmReceiverColumn_Double("TomoVNS_StackPickTime", 0.0);
                this.confirmShotColumn_Double("TomoVNS_ResidualError", 0.0);
                this.confirmReceiverColumn_Double("TomoVNS_ResidualError", 0.0);
                this.confirmShotColumn_Double("TomoVNS_TotalError", 0.0);
                this.confirmReceiverColumn_Double("TomoVNS_TotalError", 0.0);
            }
            catch (Exception extomo) {
                extomo.printStackTrace();
            }
            try {
                this.confirmShotColumn_Double("Tomo3D_StackPickTime", 0.0);
                this.confirmReceiverColumn_Double("Tomo3D_StackPickTime", 0.0);
                this.confirmShotColumn_Double("Tomo3D_ResidualError", 0.0);
                this.confirmReceiverColumn_Double("Tomo3D_ResidualError", 0.0);
                this.confirmShotColumn_Double("Tomo3D_TotalError", 0.0);
                this.confirmReceiverColumn_Double("Tomo3D_TotalError", 0.0);
            }
            catch (Exception extomo) {
                extomo.printStackTrace();
            }
            this.uphole_read_xyzdt(this.uphole_simple_file_xyzdt());
            this.uphole_simple_get().save_xydt(this.uphole_simple_file_xydt());
            ParameterTree tree = this.information().ParameterTree_get("simple_uphole");
            double vert_scalar = tree.double_get("vert_scalar", 20.0);
            this.m_uphole_simple.compute_vint_interp_arrays(200, vert_scalar);
            try {
                this.saveInformation();
            }
            catch (Exception exception) {}
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void trace_table_create_backup() {
        try {
            String tracePath = this.m_projectPath + "/TraceTable";
            String tracePathBack = this.m_projectPath + "/TraceTable_BinaryBackup";
            Tools_FileSystem.copyDirectoryRecursive(tracePath, tracePathBack);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public boolean trace_table_restore_backup() {
        try {
            String tracePath = this.m_projectPath + "/TraceTable";
            String tracePathBack = this.m_projectPath + "/TraceTable_BinaryBackup";
            if (!Tools_FileSystem.exists_path(tracePathBack)) {
                return false;
            }
            Tools_FileSystem.copyDirectoryRecursive(tracePathBack, tracePath);
            this.m_traceTableWrapper = new TraceTable_Huge_Wrapper(tracePath);
            return true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    public void repairBadID() {
        try {
            try {
                if (SharedApplicationData.singleton().appFrame() != null) {
                    SharedApplicationData.singleton().appFrame().setCursor(Cursor.getPredefinedCursor(3));
                }
            }
            catch (Exception error) {
                error.printStackTrace();
            }
            int numFixed = 0;
            ITraceTable table = this.m_traceTableWrapper.traceTable();
            int indexShotID = table.column_indexOfColumn("ShotID");
            int indexRecID = table.column_indexOfColumn("ReceiverID");
            int indexKilled = table.column_indexOfColumn("Killed");
            HashMap_Integer recMap = this.receiverMap();
            HashMap_Integer shotMap = this.shotMap();
            int currentShotID = 1000;
            int currentRecID = 1000;
            int r = 0;
            while ((long)r < table.rowCount()) {
                boolean bad = false;
                int id = table.getInt(r, indexShotID);
                if (shotMap.containsKey(id)) {
                    currentShotID = id;
                } else {
                    table.putInt(r, indexShotID, currentShotID);
                    ++numFixed;
                    bad = true;
                }
                id = table.getInt(r, indexRecID);
                if (recMap.containsKey(id)) {
                    currentRecID = id;
                } else {
                    table.putInt(r, indexRecID, currentRecID);
                    ++numFixed;
                    bad = true;
                }
                if (bad) {
                    table.putInt(r, indexKilled, 1);
                }
                ++r;
            }
            table.saveCurrentSection();
            System.out.println("repairBadID numFixed =  " + numFixed);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
        try {
            if (SharedApplicationData.singleton().appFrame() != null) {
                SharedApplicationData.singleton().appFrame().setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    protected void setBadValues() {
        try {
            ITraceTable table = this.m_traceTableWrapper.traceTable();
            int indexShotID = table.column_indexOfColumn("ShotID");
            int indexRecID = table.column_indexOfColumn("ReceiverID");
            int r = 0;
            while ((long)r < table.rowCount()) {
                if (r % 10000 == 0) {
                    table.putInt(r, indexShotID, 888);
                    table.putInt(r, indexRecID, 888);
                }
                ++r;
            }
            table.saveCurrentSection();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void savePickEvent() {
        try {
            PickEvent event = PickerGizmo.singleton().pickEvent();
            if (this.m_information != null) {
                this.m_information.string_put("PickEvent", event.name());
                this.m_information.save(this.m_paramFileName);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public boolean isOrigin(String type) {
        try {
            if (this.m_information.string_exists("Origin")) {
                String origin = this.m_information.string_get("Origin");
                return origin.equalsIgnoreCase(type);
            }
            return false;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    public FileInfo getFileInfo(int fileID) {
        try {
            for (FileInfo info : this.m_fileList) {
                if (fileID != info.FileID) continue;
                return info;
            }
            return null;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public void reloadFileInfo(boolean openDialog) throws Exception {
        block31: {
            try {
                this.m_fileList.clear();
                String origin = this.m_information.string_get("Origin");
                boolean hasCompressed = this.m_information.bool_get("HasCompressed", false);
                boolean isSegy = origin.equalsIgnoreCase("SEGY");
                boolean isSeisspace = origin.equalsIgnoreCase("SEISSPACE");
                boolean isGLI = origin.equalsIgnoreCase("GLI");
                boolean isMerge = origin.equalsIgnoreCase("MERGE");
                boolean isEchos = origin.equalsIgnoreCase("ECHOS");
                boolean isOmega = origin.equalsIgnoreCase("OMEGA");
                boolean hasSeismic = isSegy || isSeisspace || isMerge || isEchos || isOmega;
                this.m_fileTable = Table_Memory.readTable(this.m_projectPath, "FileList");
                if (!hasSeismic || this.m_fileTable == null) break block31;
                int indexID = this.m_fileTable.column_indexOfColumn("FileID");
                int indexName = this.m_fileTable.column_indexOfColumn("Name");
                int indexPath = this.m_fileTable.column_indexOfColumn("Directory");
                int indexFileType = -1;
                if (this.m_fileTable.column_exists("FileType")) {
                    indexFileType = this.m_fileTable.column_indexOfColumn("FileType");
                }
                boolean fileNotFound = false;
                boolean tableModified = false;
                for (int n = 0; n < this.m_fileTable.row_count(); ++n) {
                    FileInfo info = new FileInfo();
                    info.FileID = this.m_fileTable.getInt(n, indexID);
                    info.Name = this.m_fileTable.getString(n, indexName);
                    info.Path = this.m_fileTable.getString(n, indexPath);
                    SeismicFileType fileType = SeismicFileType.Unknown;
                    int iFileType = -1;
                    if (indexFileType >= 0) {
                        iFileType = this.m_fileTable.getInt(n, indexFileType);
                        fileType = SeismicFileType.fromInt(iFileType);
                    }
                    String baseName = "";
                    if (fileType != SeismicFileType.Echos) {
                        baseName = this.cleanupSeismicFileName(info.Name, info.Path, n);
                    }
                    try {
                        String fullTestWCF;
                        String testPath;
                        if ((isSegy || isSeisspace || isEchos || isOmega) && !isMerge && hasCompressed && this.m_fileTable.row_count() == 1 && Tools_FileSystem.exists_path(testPath = this.m_projectPath + "/Data") && !testPath.equalsIgnoreCase(info.Path) && Tools_FileSystem.exists_file(fullTestWCF = testPath + "/" + baseName + "_wcf")) {
                            tableModified = true;
                            info.Path = testPath;
                            this.m_fileTable.putString(n, indexPath, testPath);
                        }
                    }
                    catch (Exception errorCheckWCF) {
                        errorCheckWCF.printStackTrace();
                    }
                    if (fileType == SeismicFileType.Echos) {
                        boolean bEchosSetupOK = XtEchos.initializeAndShowErrorDialog();
                        if (bEchosSetupOK) {
                            Echos_Dictionary echosDict = new Echos_Dictionary("Flatirons", true);
                            info.SeismicFile = XtParadigmTraceFileTools.createNewSeismicTraceFile(info.Name, echosDict);
                        }
                    } else {
                        String fullPath = info.Path + "/" + baseName;
                        String fullPathwcf = fullPath + "_wcf";
                        if (Tools_FileSystem.exists_file(fullPath)) {
                            if (isSegy || isMerge) {
                                info.FullPath = fullPath;
                                Segy segy = new Segy();
                                segy.setFileName(info.FullPath);
                                if (segy.isFileOK()) {
                                    info.SeismicFile = segy;
                                }
                            }
                        } else if (Tools_FileSystem.exists_file(fullPathwcf)) {
                            info.FullPath = fullPathwcf;
                            CompressedSeismicFile seisfile = new CompressedSeismicFile();
                            seisfile.setFileName(info.FullPath);
                            if (seisfile.isFileOK()) {
                                info.SeismicFile = seisfile;
                            }
                        }
                        if (hasCompressed && info.SeismicFile == null) {
                            String path = this.m_projectPath + "/Data";
                            fullPathwcf = path + "/" + baseName + "_wcf";
                            if (Tools_FileSystem.exists_file(fullPathwcf)) {
                                info.Path = path;
                                info.FullPath = fullPathwcf;
                                this.m_fileTable.putString(n, indexPath, path);
                                tableModified = true;
                                CompressedSeismicFile seisfile = new CompressedSeismicFile();
                                seisfile.setFileName(info.FullPath);
                                if (seisfile.isFileOK()) {
                                    info.SeismicFile = seisfile;
                                }
                            }
                        } else if (!hasCompressed && info.SeismicFile == null) {
                            info.FullPath = fullPath;
                            if (!isSegy && !isEchos) {
                                ISeismicFile pluginSeisFile;
                                IPlugin plugin;
                                this.m_fileTable.putString(n, indexPath, info.Path);
                                tableModified = true;
                                if (isOmega) {
                                    PluginManager.singleton().setCurrentPlugin("Flatirons_Omega");
                                    PluginManager.singleton().loadCurrentPlugin();
                                    plugin = PluginManager.singleton().currentPlugin();
                                    pluginSeisFile = plugin.getSeismicFile(fullPath);
                                    if (pluginSeisFile != null && pluginSeisFile.isFileOK()) {
                                        info.SeismicFile = pluginSeisFile;
                                    }
                                }
                                if (isSeisspace) {
                                    PluginManager.singleton().setCurrentPlugin("Flatirons_Seisspace");
                                    PluginManager.singleton().loadCurrentPlugin();
                                    plugin = PluginManager.singleton().currentPlugin();
                                    pluginSeisFile = plugin.getSeismicFile(fullPath);
                                    if (pluginSeisFile != null && pluginSeisFile.isFileOK()) {
                                        info.SeismicFile = pluginSeisFile;
                                    }
                                }
                            }
                        }
                    }
                    fileNotFound = fileNotFound || info.SeismicFile == null;
                    this.m_fileList.add(info);
                }
                if (fileNotFound && openDialog && !this.m_batchState) {
                    JOptionPane.showMessageDialog(null, "Seismic file(s) not found", "", 0);
                    if (openDialog) {
                        SeismicFileManagerDialog dlg = new SeismicFileManagerDialog();
                        this.reloadFileInfo(false);
                    }
                }
                if (tableModified) {
                    this.m_fileTable.saveToPath(this.m_projectPath);
                }
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
                throw ex;
            }
        }
    }

    public boolean setTableValue(String tableName, int id, String column, double val) {
        try {
            int row;
            int index;
            boolean coord;
            boolean bl = coord = column.equalsIgnoreCase("Easting") || column.equalsIgnoreCase("Northing");
            if (tableName.equalsIgnoreCase("Receiver")) {
                if (!this.m_receiverMap.containsKey(id)) {
                    return false;
                }
                if (!this.m_receiverTable.column_exists(column)) {
                    return false;
                }
                index = this.m_receiverTable.column_indexOfColumn(column);
                row = this.m_receiverMap.get(id);
                if (coord) {
                    int indexX = this.m_receiverTable.column_indexOfColumn("Easting");
                    int indexY = this.m_receiverTable.column_indexOfColumn("Northing");
                    double x = this.m_receiverTable.getDouble(row, indexX);
                    double y = this.m_receiverTable.getDouble(row, indexY);
                    if (column.equalsIgnoreCase("Easting")) {
                        this.moveReceiver(id, val, y);
                    } else {
                        this.moveReceiver(id, x, val);
                    }
                    return true;
                }
                this.m_geometryConn.updateSingleRow_Double(tableName, column, id, val);
                this.m_receiverTable.putDouble(row, index, val);
                if (column.equalsIgnoreCase("Polarity")) {
                    Messenger.broadcastReceiverPolarityFlipped(this, id);
                }
            }
            if (tableName.equalsIgnoreCase("Shot")) {
                if (!this.m_shotMap.containsKey(id)) {
                    return false;
                }
                if (!this.m_shotTable.column_exists(column)) {
                    return false;
                }
                index = this.m_shotTable.column_indexOfColumn(column);
                row = this.m_shotMap.get(id);
                if (coord) {
                    int indexX = this.m_shotTable.column_indexOfColumn("Easting");
                    int indexY = this.m_shotTable.column_indexOfColumn("Northing");
                    double x = this.m_shotTable.getDouble(row, indexX);
                    double y = this.m_shotTable.getDouble(row, indexY);
                    if (column.equalsIgnoreCase("Easting")) {
                        this.moveShot(id, val, y);
                    } else {
                        this.moveShot(id, x, val);
                    }
                    return true;
                }
                this.m_geometryConn.updateSingleRow_Double(tableName, column, id, val);
                this.m_shotTable.putDouble(row, index, val);
                if (column.equalsIgnoreCase("Polarity")) {
                    Messenger.broadcastShotPolarityFlipped(this, id);
                }
            }
            return true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    public boolean setTableValue_Int(String tableName, int id, String column, int val) {
        try {
            int row;
            int index;
            boolean coord;
            boolean bl = coord = column.equalsIgnoreCase("Easting") || column.equalsIgnoreCase("Northing");
            if (tableName.equalsIgnoreCase("Receiver")) {
                if (!this.m_receiverMap.containsKey(id)) {
                    return false;
                }
                if (!this.m_receiverTable.column_exists(column)) {
                    return false;
                }
                index = this.m_receiverTable.column_indexOfColumn(column);
                row = this.m_receiverMap.get(id);
                if (coord) {
                    int indexX = this.m_receiverTable.column_indexOfColumn("Easting");
                    int indexY = this.m_receiverTable.column_indexOfColumn("Northing");
                    double x = this.m_receiverTable.getDouble(row, indexX);
                    double y = this.m_receiverTable.getDouble(row, indexY);
                    if (column.equalsIgnoreCase("Easting")) {
                        this.moveReceiver(id, val, y);
                    } else {
                        this.moveReceiver(id, x, val);
                    }
                    return true;
                }
                this.m_geometryConn.updateSingleRow_Int(tableName, column, id, val);
                this.m_receiverTable.putInt(row, index, val);
                if (column.equalsIgnoreCase("Polarity")) {
                    Messenger.broadcastReceiverPolarityFlipped(this, id);
                }
            }
            if (tableName.equalsIgnoreCase("Shot")) {
                if (!this.m_shotMap.containsKey(id)) {
                    return false;
                }
                if (!this.m_shotTable.column_exists(column)) {
                    return false;
                }
                index = this.m_shotTable.column_indexOfColumn(column);
                row = this.m_shotMap.get(id);
                if (coord) {
                    int indexX = this.m_shotTable.column_indexOfColumn("Easting");
                    int indexY = this.m_shotTable.column_indexOfColumn("Northing");
                    double x = this.m_shotTable.getDouble(row, indexX);
                    double y = this.m_shotTable.getDouble(row, indexY);
                    if (column.equalsIgnoreCase("Easting")) {
                        this.moveShot(id, val, y);
                    } else {
                        this.moveShot(id, x, val);
                    }
                    return true;
                }
                this.m_geometryConn.updateSingleRow_Int(tableName, column, id, val);
                this.m_shotTable.putInt(row, index, val);
                if (column.equalsIgnoreCase("Polarity")) {
                    Messenger.broadcastShotPolarityFlipped(this, id);
                }
            }
            return true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    public String versionPath() {
        return this.m_currentVersionPath;
    }

    public String versionName() {
        return this.m_currentVersionName;
    }

    public String versionContainerPath() {
        return this.m_versionContainerPath;
    }

    public ArrayList<String> versionList() {
        try {
            return Tools_FileSystem.subdirectories(this.versionContainerPath(), false);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public IDatabaseConnection getVersionDatabase(String name) throws Exception {
        try {
            if (name.equalsIgnoreCase(this.m_currentVersionName)) {
                return this.m_geometryConn;
            }
            String versionPath = this.m_versionContainerPath + "/" + name;
            String fileNameDB = versionPath + "/geometry.db";
            return Tools_JDBC.getConnection(false, fileNameDB);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public ArrayList<String> getVersionColumnNames_Rec(String name) throws Exception {
        try {
            IDatabaseConnection database = RefractionStaticsProject.singleton().getVersionDatabase(name);
            ArrayList<String> recColList = database.listOfColumnNames("Receiver");
            database = null;
            System.gc();
            Collections.sort(recColList);
            return recColList;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public ArrayList<String> getVersionColumnNames_Shot(String name) throws Exception {
        try {
            IDatabaseConnection database = RefractionStaticsProject.singleton().getVersionDatabase(name);
            ArrayList<String> shotColList = database.listOfColumnNames("Shot");
            database = null;
            System.gc();
            Collections.sort(shotColList);
            return shotColList;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public ArrayList<String> getVersionColumnNames(String name, boolean intersection) throws Exception {
        try {
            IDatabaseConnection database = RefractionStaticsProject.singleton().getVersionDatabase(name);
            ArrayList<String> recColList = database.listOfColumnNames("Receiver");
            ArrayList<String> shotColList = database.listOfColumnNames("Shot");
            database = null;
            System.gc();
            ArrayList<String> list = new ArrayList<String>();
            if (intersection) {
                for (String rec : recColList) {
                    boolean ok = false;
                    for (String shot : shotColList) {
                        if (!rec.equalsIgnoreCase(shot)) continue;
                        ok = true;
                    }
                    if (!ok) continue;
                    list.add(rec);
                }
            } else {
                for (String rec : recColList) {
                    boolean ok = true;
                    for (String s : list) {
                        if (!rec.equalsIgnoreCase(s)) continue;
                        ok = false;
                    }
                    if (!ok) continue;
                    list.add(rec);
                }
            }
            Collections.sort(list);
            return list;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void versionSelect(String versionName) throws Exception {
        try {
            String path_csv;
            IComponentManager cm = SharedApplicationData.singleton().getComponentManager();
            if (cm != null) {
                cm.closeAllComponents();
            }
            this.m_information.string_put("Version", versionName);
            this.m_information.save(this.m_paramFileName);
            this.m_currentVersionName = versionName;
            this.m_currentVersionPath = this.m_versionContainerPath + "/" + versionName;
            String fileNameDB = this.m_currentVersionPath + "/geometry.db";
            this.m_geometryConn = Tools_JDBC.getConnection(false, fileNameDB);
            this.loadReceiverTableFromMemoryDatabase();
            this.loadShotTableFromMemoryDatabase();
            this.recomputeRanges();
            if (Tools_FileSystem.exists_path(this.m_currentVersionPath) && Tools_FileSystem.exists_path(path_csv = Tools_FileSystem.confirmSubDirectoryExists(this.m_currentVersionPath, "CSV"))) {
                String file = path_csv + "/RECEIVER.csv";
                if (!Tools_FileSystem.exists_file(file)) {
                    this.receiverTable().exportCSV(file);
                }
                if (!Tools_FileSystem.exists_file(file = path_csv + "/SHOT.csv")) {
                    this.shotTable().exportCSV(file);
                }
            }
            this.backup_version_csv(false);
            this.m_delayTimePath = Tools_FileSystem.confirmSubDirectoryExists(this.m_currentVersionPath, "DelayTime");
            this.m_delayTimeData = new DelayTimeData(this.m_delayTimePath, this);
            Messenger.broadcast(Messenger.Message.ProjectVersionChanged, this, null);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void backup_version_csv(boolean overwrite) {
        try {
            String path_csv = Tools_FileSystem.confirmSubDirectoryExists(this.m_currentVersionPath, "CSV");
            String fileNameDB = this.m_currentVersionPath + "/geometry.db";
            Tools_JDBC.convert_hsqldb_to_csv(fileNameDB, path_csv, overwrite);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setShotKilled(int id, boolean killed) {
        try {
            int row = this.m_shotMap.get(id);
            int index = this.m_shotTable.column_indexOfColumn("Killed");
            this.m_shotTable.putBool(row, index, killed);
            Object sql = "";
            sql = killed ? "UPDATE Shot SET KILLED = TRUE WHERE ShotID = " + Integer.toString(id) : "UPDATE Shot SET KILLED = FALSE WHERE ShotID = " + Integer.toString(id);
            this.m_geometryConn.executeUpdateStatement((String)sql);
            Messenger.broadcastShotKilled(this, id);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void flipShotKilled(int id) {
        try {
            int row = this.m_shotMap.get(id);
            int index = this.m_shotTable.column_indexOfColumn("Killed");
            boolean killed = this.m_shotTable.getBool(row, index);
            this.setShotKilled(id, !killed);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void flipShotPolarity(int id) {
        try {
            int row = this.m_shotMap.get(id);
            int index = this.m_shotTable.column_indexOfColumn("Polarity");
            double polarity = this.m_shotTable.getDouble(row, index);
            if (polarity > 0.0) {
                this.setTableValue("Shot", id, "Polarity", -1.0);
            } else {
                this.setTableValue("Shot", id, "Polarity", 1.0);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setReceiverFlag(int id, int flag) {
        try {
            int row = this.m_receiverMap.get(id);
            int index = this.m_receiverTable.column_indexOfColumn("Flag");
            this.m_receiverTable.putInt(row, index, flag);
            this.geometryDatabase().updateSingleRow_Int("Receiver", "Flag", id, flag);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setShotFlag(int id, int flag) {
        try {
            int row = this.m_shotMap.get(id);
            int index = this.m_shotTable.column_indexOfColumn("Flag");
            this.m_shotTable.putInt(row, index, flag);
            this.geometryDatabase().updateSingleRow_Int("Shot", "Flag", id, flag);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void unkillTraces_Rec(int recID) {
        try {
            this.m_traceTableWrapper.prepareIndexColumn("ReceiverID", recID, recID);
            this.m_traceTableWrapper.setIntValueUsingPreparedIndices("Killed", 0);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void unkillTraces_Shot(int shotID) {
        try {
            this.m_traceTableWrapper.prepareIndexColumn("ShotID", shotID, shotID);
            this.m_traceTableWrapper.setIntValueUsingPreparedIndices("Killed", 0);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void killTraces(long[] indices) {
        try {
            ITraceTable tt = this.m_traceTableWrapper.traceTable();
            if (!tt.column_exists("Killed")) {
                return;
            }
            int colIndex = tt.column_indexOfColumn("Killed");
            for (int n = 0; n < indices.length; ++n) {
                tt.putInt(indices[n], colIndex, 1);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void flipTracePolarity(long[] indices) {
        try {
            ITraceTable tt = this.m_traceTableWrapper.traceTable();
            if (!tt.column_exists("Flags")) {
                return;
            }
            int colIndex = tt.column_indexOfColumn("Flags");
            Messenger.resetSelectedTraceCount();
            for (int n = 0; n < indices.length; ++n) {
                long index = indices[n];
                boolean polarity = tt.toggleFlag(index, colIndex, 1);
                Messenger.addSelectedTraceWithPolarity(index, polarity);
            }
            Messenger.broadcastTracePolarityFlipped(this);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void resetReceiverCoords(int id) {
        try {
            int row = this.m_receiverMap.get(id);
            int indexInitX = this.m_receiverTable.column_indexOfColumn("InitialEasting");
            int indexInitY = this.m_receiverTable.column_indexOfColumn("InitialNorthing");
            int indexX = this.m_receiverTable.column_indexOfColumn("Easting");
            int indexY = this.m_receiverTable.column_indexOfColumn("Northing");
            int indexDistMoved = -9999;
            if (this.m_receiverTable.column_exists("DistanceMoved")) {
                indexDistMoved = this.m_receiverTable.column_indexOfColumn("DistanceMoved");
            }
            int indexAzMoved = -9999;
            if (this.m_receiverTable.column_exists("AzimuthMoved")) {
                indexAzMoved = this.m_receiverTable.column_indexOfColumn("DistanceMoved");
            }
            double x = this.m_receiverTable.getDouble(row, indexInitX);
            double y = this.m_receiverTable.getDouble(row, indexInitY);
            this.m_receiverTable.putDouble(row, indexX, x);
            this.m_receiverTable.putDouble(row, indexY, y);
            if (indexDistMoved >= 0) {
                this.m_receiverTable.putDouble(row, indexDistMoved, 0.0);
            }
            if (indexAzMoved >= 0) {
                this.m_receiverTable.putDouble(row, indexAzMoved, 0.0);
            }
            this.m_geometryConn.updateSingleRow_Double("Receiver", "Easting", id, x);
            this.m_geometryConn.updateSingleRow_Double("Receiver", "Northing", id, y);
            if (indexDistMoved >= 0) {
                this.m_geometryConn.updateSingleRow_Double("Receiver", "DistanceMoved", id, 0.0);
            }
            if (indexAzMoved >= 0) {
                this.m_geometryConn.updateSingleRow_Double("Receiver", "AzimuthMoved", id, 0.0);
            }
            Messenger.broadcastReceiverGeometryChanged(this, id);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void resetShotCoords(int id) {
        try {
            int row = this.m_shotMap.get(id);
            int indexInitX = this.m_shotTable.column_indexOfColumn("InitialEasting");
            int indexInitY = this.m_shotTable.column_indexOfColumn("InitialNorthing");
            int indexX = this.m_shotTable.column_indexOfColumn("Easting");
            int indexY = this.m_shotTable.column_indexOfColumn("Northing");
            int indexDistMoved = -9999;
            if (this.m_shotTable.column_exists("DistanceMoved")) {
                indexDistMoved = this.m_shotTable.column_indexOfColumn("DistanceMoved");
            }
            int indexAzMoved = -9999;
            if (this.m_shotTable.column_exists("AzimuthMoved")) {
                indexAzMoved = this.m_shotTable.column_indexOfColumn("DistanceMoved");
            }
            double x = this.m_shotTable.getDouble(row, indexInitX);
            double y = this.m_shotTable.getDouble(row, indexInitY);
            this.m_shotTable.putDouble(row, indexX, x);
            this.m_shotTable.putDouble(row, indexY, y);
            if (indexDistMoved >= 0) {
                this.m_shotTable.putDouble(row, indexDistMoved, 0.0);
            }
            if (indexAzMoved >= 0) {
                this.m_shotTable.putDouble(row, indexAzMoved, 0.0);
            }
            this.m_geometryConn.updateSingleRow_Double("Shot", "Easting", id, x);
            this.m_geometryConn.updateSingleRow_Double("Shot", "Northing", id, y);
            if (indexDistMoved >= 0) {
                this.m_geometryConn.updateSingleRow_Double("Shot", "DistanceMoved", id, 0.0);
            }
            if (indexAzMoved >= 0) {
                this.m_geometryConn.updateSingleRow_Double("Shot", "AzimuthMoved", id, 0.0);
            }
            Messenger.broadcastShotGeometryChanged(this, id);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setReceiverKilled(int id, boolean killed) {
        try {
            int row = this.m_receiverMap.get(id);
            int index = this.m_receiverTable.column_indexOfColumn("Killed");
            this.m_receiverTable.putBool(row, index, killed);
            Object sql = "";
            sql = killed ? "UPDATE Receiver SET KILLED = TRUE WHERE ReceiverID = " + Integer.toString(id) : "UPDATE Receiver SET KILLED = FALSE WHERE ReceiverID = " + Integer.toString(id);
            this.m_geometryConn.executeUpdateStatement((String)sql);
            Messenger.broadcastReceiverKilled(this, id);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void flipReceiverKilled(int id) {
        try {
            int row = this.m_receiverMap.get(id);
            int index = this.m_receiverTable.column_indexOfColumn("Killed");
            boolean killed = this.m_receiverTable.getBool(row, index);
            this.setReceiverKilled(id, !killed);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void flipReceiverPolarity(int id) {
        try {
            int row = this.m_receiverMap.get(id);
            int index = this.m_receiverTable.column_indexOfColumn("Polarity");
            double polarity = this.m_receiverTable.getDouble(row, index);
            if (polarity > 0.0) {
                this.setTableValue("Receiver", id, "Polarity", -1.0);
            } else {
                this.setTableValue("Receiver", id, "Polarity", 1.0);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void loadReceiverTableFromMemoryDatabase() {
        try {
            this.m_geometryConn.confirmColumn_Bool("Receiver", "Killed", false);
            this.m_geometryConn.confirmColumn_Double("Receiver", "Polarity", 1.0);
            this.m_geometryConn.confirmColumn_Double("Receiver", "TimeShift", 0.0);
            this.m_geometryConn.confirmColumn_Int("Receiver", "Flag", 0);
            this.m_receiverTable = this.m_geometryConn.extractTableDataUsingQuery("Receiver", "SELECT * FROM Receiver", 0);
            this.m_receiverMap = this.m_receiverTable.createMapID();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void loadShotTableFromMemoryDatabase() {
        try {
            this.m_geometryConn.confirmColumn_Bool("Shot", "Killed", false);
            this.m_geometryConn.confirmColumn_Double("Shot", "Polarity", 1.0);
            this.m_geometryConn.confirmColumn_Double("Shot", "TimeShift", 0.0);
            this.m_geometryConn.confirmColumn_Int("Shot", "PatternShiftTotal", 0);
            this.m_geometryConn.confirmColumn_Int("Shot", "Flag", 0);
            this.m_shotTable = this.m_geometryConn.extractTableDataUsingQuery("Shot", "SELECT * FROM Shot", 0);
            this.m_shotMap = this.m_shotTable.createMapID();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void appendProjectFilenameExtension() {
        try {
            File dir;
            String tempProjectPath = this.ParentProjectPath + "/" + this.m_name;
            String newProjectPath = this.ParentProjectPath + "/" + this.m_name + ".xtref";
            if (Tools_FileSystem.exists_path(tempProjectPath) && (dir = new File(tempProjectPath)).isDirectory()) {
                if (Tools_FileSystem.exists_path(newProjectPath)) {
                    System.out.println("Unable to append .xtref extension to project filename");
                } else {
                    File newDir = new File(newProjectPath);
                    dir.renameTo(newDir);
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public String cleanupSeismicFileName(String fileName, String filePath, int row) {
        try {
            String suffix = "_data.sgy";
            if (!fileName.endsWith(suffix)) {
                return fileName;
            }
            int endChar = fileName.length() - suffix.length();
            String baseName = fileName.substring(0, endChar);
            if (baseName.endsWith(".xtref")) {
                int endChar2 = baseName.length() - ".xtref".length();
                String newProjectName = baseName.substring(0, endChar2);
                String newFileName = newProjectName + suffix;
                String oldPath = filePath + "/" + fileName + "_wcf";
                String newPath = filePath + "/" + newFileName + "_wcf";
                File oldFile = new File(oldPath);
                if (Tools_FileSystem.exists_file(oldPath) && oldFile.isFile()) {
                    File newFile = new File(newPath);
                    oldFile.renameTo(newFile);
                }
                int fileNameIndex = this.m_fileTable.column_indexOfColumn("Name");
                this.m_fileTable.putString(row, fileNameIndex, newFileName);
                this.m_fileTable.saveToPath(this.m_projectPath);
                String importTablePath = Tools_FileSystem.confirmSubDirectoryExists(this.m_projectPath, "ImportedTables");
                this.m_fileTable.saveToPath(importTablePath);
                return newFileName;
            }
            return fileName;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return fileName;
        }
    }

    @Override
    public String projectName() {
        return this.m_name;
    }

    public double findAverageValue_Double(String field) throws Exception {
        try {
            int index;
            double value = 0.0;
            int count = 0;
            if (this.m_shotTable.column_exists(field)) {
                index = this.m_shotTable.column_indexOfColumn(field);
                for (int s = 0; s < this.m_shotTable.row_count(); ++s) {
                    value += this.m_shotTable.getDouble(s, index);
                    ++count;
                }
            }
            if (this.m_receiverTable.column_exists(field)) {
                index = this.m_receiverTable.column_indexOfColumn(field);
                for (int r = 0; r < this.m_receiverTable.row_count(); ++r) {
                    value += this.m_receiverTable.getDouble(r, index);
                    ++count;
                }
            }
            double average = value / (double)count;
            return average;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public float findAverageValue_Float(String field) throws Exception {
        try {
            int index;
            float value = 0.0f;
            int count = 0;
            if (this.m_shotTable.column_exists(field)) {
                index = this.m_shotTable.column_indexOfColumn(field);
                for (int s = 0; s < this.m_shotTable.row_count(); ++s) {
                    value += this.m_shotTable.getFloat(s, index);
                    ++count;
                }
            }
            if (this.m_receiverTable.column_exists(field)) {
                index = this.m_receiverTable.column_indexOfColumn(field);
                for (int r = 0; r < this.m_receiverTable.row_count(); ++r) {
                    value += this.m_receiverTable.getFloat(r, index);
                    ++count;
                }
            }
            float average = value / (float)count;
            return average;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public int findAverageValue_Int(String field) throws Exception {
        try {
            int index;
            float value = 0.0f;
            int count = 0;
            if (this.m_shotTable.column_exists(field)) {
                index = this.m_shotTable.column_indexOfColumn(field);
                for (int s = 0; s < this.m_shotTable.row_count(); ++s) {
                    value += (float)this.m_shotTable.getInt(s, index);
                    ++count;
                }
            }
            if (this.m_receiverTable.column_exists(field)) {
                index = this.m_receiverTable.column_indexOfColumn(field);
                for (int r = 0; r < this.m_receiverTable.row_count(); ++r) {
                    value += (float)this.m_receiverTable.getInt(r, index);
                    ++count;
                }
            }
            float average = value / (float)count;
            return (int)average;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public Table_Abstract getTable(String name) {
        if (name.equalsIgnoreCase("Shot")) {
            return this.shotTable();
        }
        if (name.equalsIgnoreCase("Receiver")) {
            return this.receiverTable();
        }
        return null;
    }

    public ArrayList<String> getListOfUpholeSurveys() {
        try {
            String projectPath = RefractionStaticsProject.singleton().projectPath();
            String upholePath = Tools_FileSystem.confirmSubDirectoryExists(projectPath, "Uphole");
            String fileNameDB = upholePath + "/uphole.db";
            IDatabaseConnection db = Tools_JDBC.getConnection(false, fileNameDB);
            ArrayList<String> list = db.getTableNames();
            return list;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public UpholeModel getUpholeSurveyModel(String name) throws Exception {
        UpholeModel model = new UpholeModel();
        model.load(name);
        return model;
    }

    public void scanPicks() {
        try {
            int indexPickT = this.m_traceTableWrapper.traceTable().column_indexOfColumn("FBP_PickT");
            int indexUser = this.m_traceTableWrapper.traceTable().column_indexOfColumn("FBP_User");
            long tracker = 0L;
            for (long n = 0L; n < this.m_traceTableWrapper.traceTable().rowCount(); ++n) {
                int user;
                int pickT = this.m_traceTableWrapper.traceTable().getInt(n, indexPickT);
                if (pickT == (user = this.m_traceTableWrapper.traceTable().getInt(n, indexUser))) continue;
                ++tracker;
                System.out.println("PickT != User: Trace " + n);
            }
            System.out.println("Number of mismatches: " + tracker);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public static class FileInfo {
        public String Name;
        public String Path;
        public String FullPath;
        public int FileID;
        public ISeismicFile SeismicFile;
    }
}

