/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Refraction;

import com.PecosCore.Data.FloatArrayWrapper;
import com.PecosCore.Data.TraceTable.Huge.ITraceTable;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Ensemble.Tools_Ensemble;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Base;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Sequence;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Shared.SharedApplicationData;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Tools.Tools_XML;
import com.PecosLibrary.Ensemble.Tools_Picking;
import com.PecosLibrary.Ensemble.Worker.Geometry.EnsembleWorker_PositionPredictor;
import com.PecosLibrary.Refraction.DelayTime.Tools_DelayTime_Geometry;
import com.PecosLibrary.Refraction.PickEvent;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_ButtonPressed;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_KeyPressed;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_MultiLineSegments;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_PenMode;
import com.PecosLibrary.Windows.Refraction.Picking.SelectedTraceOperationsDialog;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PickerGizmo
extends AbstractTableModel {
    protected GenericObjectListener m_listener = new GenericObjectListener();
    protected static PickerGizmo m_singleton = null;
    public String PickName = "FBP_User";
    protected PickEvent m_pickEvent = PickEvent.Peak;
    public boolean PickEventJustChanged = false;
    protected ArrayList<KeyWrapper> m_keyList = new ArrayList();
    public LeftClickActionEnum LeftClickAction = LeftClickActionEnum.AddRight;
    public boolean ControlPointSnap = true;
    public boolean PickLocalEvents = false;
    public boolean PickHiddenTraces = false;
    protected boolean m_bSnapToEvent = false;
    protected Ensemble m_inputEnsemble = null;
    protected Ensemble m_parentEnsemble = null;
    protected int m_inputPickHeaderIndex;
    protected int[] m_sortIndex = new int[1000];
    protected int m_traceCount;
    protected int m_inputPixelX;
    protected int m_inputPixelY;
    protected double m_inputWorldX;
    protected double m_inputWorldY;
    protected int[] m_inputTraceIndex = new int[1000];
    protected int m_numInputPicksModified = 0;
    protected int[] m_parentTraceIndex = new int[4000];
    protected int m_numParentPicksModified = 0;
    protected float[] m_traceData = new float[2000];
    protected double m_currentStartTime = 0.0;
    protected boolean m_startTimeLocked = false;
    public double Viewport_MinX = 0.0;
    public double Viewport_MaxX = 0.0;
    public double Viewport_MinY = 0.0;
    public double Viewport_MaxY = 0.0;
    protected int m_firstTraceToLeftSortIndex;
    public boolean m_leftTraceOkay = false;
    protected int m_firstTraceToRightSortIndex;
    public boolean m_rightTraceOkay = false;
    protected int m_nearestEnsembleIndex;
    protected int m_nearestSortIndex;
    protected EnsembleWorker_PositionPredictor m_crudeMover = null;
    protected boolean m_plotUEC;
    protected SelectedTraceOperationsDialog m_selectedTraceOperationsDialog;
    protected float[] m_pickArray = new float[200];
    protected long[] m_indexArray = new long[200];
    public boolean BranchPicksModified = false;
    public int[] m_numModifiedInBranch = new int[20];
    public boolean PolarityFlipped = false;
    public int PolarityShotID = -9999;
    public int PolarityRecID = -9999;
    protected int m_numExtraRows = 0;

    public GenericObjectListener listener() {
        return this.m_listener;
    }

    public void read() {
        try {
            String action;
            String path = SharedApplicationData.singleton().homeDirectory();
            String fileName = path + "/picker.xml";
            if (!Tools_FileSystem.exists_file(fileName)) {
                return;
            }
            Document doc = Tools_XML.readDocument(fileName);
            Element root = (Element)doc.getFirstChild();
            Element subNode = Tools_XML.getChildWithTagName(root, "LeftClick", false);
            if (subNode != null) {
                action = subNode.getAttribute("Action");
                try {
                    this.LeftClickAction = LeftClickActionEnum.valueOf(action);
                }
                catch (Exception error) {
                    error.printStackTrace();
                }
            }
            if ((subNode = Tools_XML.getChildWithTagName(root, "ControlPointSnap", false)) != null) {
                action = subNode.getAttribute("Snap");
                try {
                    this.ControlPointSnap = Boolean.parseBoolean(action);
                }
                catch (Exception error) {
                    error.printStackTrace();
                }
            }
            if ((subNode = Tools_XML.getChildWithTagName(root, "PickHiddenTraces", false)) != null) {
                action = subNode.getAttribute("PickHidden");
                try {
                    this.PickHiddenTraces = Boolean.parseBoolean(action);
                }
                catch (Exception error) {
                    error.printStackTrace();
                }
            }
            subNode = Tools_XML.getChildWithTagName(root, "Keys", false);
            ArrayList<Element> nodes = Tools_XML.getChildListWithTagName(subNode, "Key");
            for (Element element : nodes) {
                String name = element.getAttribute("Name");
                String shift = element.getAttribute("Shift");
                String main = element.getAttribute("Main");
                String control = element.getAttribute("Control");
                KeyWrapper kw = this.getKeyWrapper(name);
                if (kw == null) continue;
                try {
                    kw.MainAction = KeyActionEnum.valueOf(main);
                    kw.ShiftAction = KeyActionEnum.valueOf(shift);
                    kw.ControlAction = KeyActionEnum.valueOf(control);
                }
                catch (Exception error) {
                    error.printStackTrace();
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void save() {
        try {
            String path = SharedApplicationData.singleton().homeDirectory();
            String fileName = path + "/picker.xml";
            Document document = Tools_XML.createDocument();
            Element root = document.createElement("ParameterTree");
            document.appendChild(root);
            Element leftNode = root.getOwnerDocument().createElement("LeftClick");
            root.appendChild(leftNode);
            leftNode.setAttribute("Action", this.LeftClickAction.name());
            Element snapNode = root.getOwnerDocument().createElement("ControlPointSnap");
            root.appendChild(snapNode);
            snapNode.setAttribute("Snap", Boolean.toString(this.ControlPointSnap));
            Element pickHiddenNode = root.getOwnerDocument().createElement("PickHiddenTraces");
            root.appendChild(pickHiddenNode);
            pickHiddenNode.setAttribute("PickHidden", Boolean.toString(this.PickHiddenTraces));
            Element keysNode = root.getOwnerDocument().createElement("Keys");
            root.appendChild(keysNode);
            for (KeyWrapper kw : this.m_keyList) {
                Element keyNode = root.getOwnerDocument().createElement("Key");
                keyNode.setAttribute("Name", kw.KeyText);
                keyNode.setAttribute("Main", kw.MainAction.name());
                keyNode.setAttribute("Shift", kw.ShiftAction.name());
                keyNode.setAttribute("Control", kw.ControlAction.name());
                keysNode.appendChild(keyNode);
            }
            Tools_XML.writeDocumentToFile(document, fileName);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void stuffChanged() {
        try {
            this.save();
            this.listener().broadcast(this, null);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected PickerGizmo() {
        try {
            this.addKeyWrapper(32, "Space");
            for (int keyCode = 65; keyCode <= 90; ++keyCode) {
                this.addKeyWrapper(keyCode, null);
            }
            this.addKeyWrapper(37, null);
            this.addKeyWrapper(39, null);
            this.addKeyWrapper(38, null);
            this.addKeyWrapper(40, null);
            this.addKeyWrapper(44, null);
            this.addKeyWrapper(46, null);
            this.addKeyWrapper(59, null);
            this.addKeyWrapper(47, null);
            this.setKeyAction_Main(39, KeyActionEnum.NextGroup);
            this.setKeyAction_Main(37, KeyActionEnum.PriorGroup);
            this.setKeyAction_Main(32, KeyActionEnum.NextGroup);
            this.setKeyAction_Main(65, KeyActionEnum.PriorGroup);
            this.setKeyAction_Main(68, KeyActionEnum.AddRight);
            this.setKeyAction_Main(83, KeyActionEnum.KillRight);
            this.read();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public static PickerGizmo singleton() {
        try {
            if (m_singleton == null) {
                m_singleton = new PickerGizmo();
            }
            return m_singleton;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public PickEvent pickEvent() {
        return this.m_pickEvent;
    }

    public void setPickEvent(PickEvent event) {
        try {
            this.m_pickEvent = event;
            this.PickEventJustChanged = true;
            this.stuffChanged();
            RefractionStaticsProject.singleton().savePickEvent();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.PickEventJustChanged = false;
    }

    public void setKeyAction_Main(int keyCode, KeyActionEnum action) {
        try {
            for (KeyWrapper kw : this.m_keyList) {
                if (kw.KeyCode != keyCode) continue;
                kw.MainAction = action;
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void addKeyWrapper(int keyCode, String txt) {
        try {
            this.m_keyList.add(new KeyWrapper(keyCode, txt, KeyActionEnum.Off, KeyActionEnum.Off, KeyActionEnum.Off));
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void findTraceToLeft() {
        try {
            this.m_leftTraceOkay = false;
            for (int n = this.m_traceCount - 1; n >= 0; --n) {
                int index = this.m_sortIndex[n];
                EnsembleTrace t1 = this.m_inputEnsemble.trace(index);
                if (t1.PlotData.PixelX > this.m_inputPixelX) continue;
                this.m_leftTraceOkay = true;
                this.m_firstTraceToLeftSortIndex = n;
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void findTraceToRight() {
        try {
            this.m_rightTraceOkay = false;
            for (int n = 0; n < this.m_traceCount; ++n) {
                int index = this.m_sortIndex[n];
                EnsembleTrace t1 = this.m_inputEnsemble.trace(index);
                if (t1.PlotData.PixelX < this.m_inputPixelX) continue;
                this.m_rightTraceOkay = true;
                this.m_firstTraceToRightSortIndex = n;
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public static void broadcastReceiverSelected(Object sender, Ensemble ensemble, int pixelX) {
        try {
            int nearest = -1;
            int minDist = 10000000;
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace t = ensemble.trace(n);
                int dist = Math.abs(pixelX - t.PlotData.PixelX);
                if (dist >= minDist || !t.PlotData.Visible) continue;
                nearest = n;
                minDist = dist;
            }
            if (nearest < 0) {
                return;
            }
            int indexRecID = ensemble.dictionary().getEntryIndex("Receiver", "ReceiverID");
            int recID = ensemble.trace(nearest).header().getInt(indexRecID);
            Messenger.broadcastReceiverSelected(sender, recID);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public static void broadcastControlClick(Object sender, Ensemble ensemble, int pixelX) {
        try {
            int nearest = -1;
            int minDist = 10000000;
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace t = ensemble.trace(n);
                int dist = Math.abs(pixelX - t.PlotData.PixelX);
                if (dist >= minDist || !t.PlotData.Visible) continue;
                nearest = n;
                minDist = dist;
            }
            if (nearest < 0) {
                return;
            }
            int indexShotID = ensemble.dictionary().getEntryIndex("Shot", "ShotID");
            int indexRecID = ensemble.dictionary().getEntryIndex("Receiver", "ReceiverID");
            int indexInline = ensemble.dictionary().getEntryIndex("Trace", "Inline");
            int indexCrossline = ensemble.dictionary().getEntryIndex("Trace", "Crossline");
            int shotID = ensemble.trace(nearest).header().getInt(indexShotID);
            int recID = ensemble.trace(nearest).header().getInt(indexRecID);
            int inline = ensemble.trace(nearest).header().getInt(indexInline);
            int crossline = ensemble.trace(nearest).header().getInt(indexCrossline);
            Messenger.broadcastTraceSelected(sender, shotID, recID, inline, crossline);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void findNearestTrace() {
        try {
            int min = 100000;
            this.m_nearestEnsembleIndex = 0;
            this.m_nearestSortIndex = 0;
            for (int n = 0; n < this.m_traceCount; ++n) {
                int index = this.m_sortIndex[n];
                EnsembleTrace t1 = this.m_inputEnsemble.trace(index);
                int pixel = t1.PlotData.PixelX;
                int diff = Math.abs(pixel - this.m_inputPixelX);
                if (diff >= min) continue;
                min = diff;
                this.m_nearestSortIndex = n;
                this.m_nearestEnsembleIndex = index;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected boolean prepareInputEnsemble() {
        try {
            if (this.m_inputEnsemble.traceCount() < 1) {
                return false;
            }
            if (!this.m_inputEnsemble.dictionary().containsEntry("Trace", this.PickName)) {
                return false;
            }
            this.m_inputPickHeaderIndex = this.m_inputEnsemble.dictionary().getEntryIndex("Trace", this.PickName);
            if (this.m_inputEnsemble.traceCount() > this.m_sortIndex.length) {
                this.m_sortIndex = new int[this.m_inputEnsemble.traceCount() + 200];
            }
            if (this.m_inputEnsemble.traceCount() > this.m_inputTraceIndex.length) {
                this.m_inputTraceIndex = new int[this.m_inputEnsemble.traceCount() + 200];
            }
            this.m_traceCount = 0;
            this.m_numInputPicksModified = 0;
            for (int n = 0; n < this.m_inputEnsemble.traceCount(); ++n) {
                boolean traceOkay;
                EnsembleTrace t1 = this.m_inputEnsemble.trace(n);
                boolean bl = traceOkay = t1.PlotData.Visible || this.PickHiddenTraces && t1.PlotData.IsInBranch;
                if (!traceOkay || !t1.PlotData.InsideViewport) continue;
                this.m_sortIndex[this.m_traceCount] = n;
                ++this.m_traceCount;
            }
            if (this.m_traceCount < 1) {
                return false;
            }
            boolean done = false;
            while (!done) {
                done = true;
                for (int n = 0; n < this.m_traceCount - 1; ++n) {
                    int index1 = this.m_sortIndex[n];
                    int index2 = this.m_sortIndex[n + 1];
                    EnsembleTrace t1 = this.m_inputEnsemble.trace(index1);
                    EnsembleTrace t2 = this.m_inputEnsemble.trace(index2);
                    if (t1.PlotData.PixelX <= t2.PlotData.PixelX) continue;
                    this.m_sortIndex[n] = index2;
                    this.m_sortIndex[n + 1] = index1;
                    done = false;
                }
            }
            this.findNearestTrace();
            this.findTraceToLeft();
            this.findTraceToRight();
            return true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    public KeyActionEnum getKeyActionEnum(Java2D_UserEventConsumer_KeyPressed uec) {
        try {
            for (KeyWrapper kw : this.m_keyList) {
                if (kw.KeyCode != uec.KeyCode) continue;
                if (uec.ControlDown) {
                    return kw.ControlAction;
                }
                if (uec.ShiftDown) {
                    return kw.ShiftAction;
                }
                return kw.MainAction;
            }
            return KeyActionEnum.Off;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return KeyActionEnum.Off;
        }
    }

    protected KeyWrapper getKeyWrapper(String name) {
        try {
            for (KeyWrapper kw : this.m_keyList) {
                if (!kw.KeyText.equalsIgnoreCase(name)) continue;
                return kw;
            }
            return null;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected KeyWrapper getKeyWrapper(Java2D_UserEventConsumer_KeyPressed uec) {
        try {
            for (KeyWrapper kw : this.m_keyList) {
                if (kw.KeyCode != uec.KeyCode) continue;
                return kw;
            }
            return null;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public boolean isKeyCodeThisAction(int keyCode, KeyActionEnum action) {
        try {
            for (KeyWrapper kw : this.m_keyList) {
                if (kw.MainAction != action || keyCode != kw.KeyCode) continue;
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    public boolean isKeyAction(Java2D_UserEventConsumer_KeyPressed uec, KeyActionEnum action) {
        try {
            KeyActionEnum actionUEC = this.getKeyActionEnum(uec);
            return action == actionUEC;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    public boolean keyViewTraceSamples(Java2D_UserEventConsumer_KeyPressed uec) {
        try {
            return this.isKeyAction(uec, KeyActionEnum.ViewTraceSamples);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return true;
        }
    }

    public boolean keyViewTraceHeaders(Java2D_UserEventConsumer_KeyPressed uec) {
        try {
            return this.isKeyAction(uec, KeyActionEnum.ViewTraceHeaders);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return true;
        }
    }

    public boolean keyKillCurrentShotOrReceiver(Java2D_UserEventConsumer_KeyPressed uec) {
        try {
            return this.isKeyAction(uec, KeyActionEnum.KillCurrentShotOrReceiver);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return true;
        }
    }

    public boolean zoomIn(Java2D_UserEventConsumer_KeyPressed uec) {
        try {
            return this.isKeyAction(uec, KeyActionEnum.ZoomIn);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return true;
        }
    }

    public boolean zoomOut(Java2D_UserEventConsumer_KeyPressed uec) {
        try {
            return this.isKeyAction(uec, KeyActionEnum.ZoomOut);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return true;
        }
    }

    public boolean scrollLeft(Java2D_UserEventConsumer_KeyPressed uec) {
        try {
            return this.isKeyAction(uec, KeyActionEnum.ScrollLeft);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return true;
        }
    }

    public boolean scrollRight(Java2D_UserEventConsumer_KeyPressed uec) {
        try {
            return this.isKeyAction(uec, KeyActionEnum.ScrollRight);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return true;
        }
    }

    public boolean keyToggleActiveProcess(Java2D_UserEventConsumer_KeyPressed uec) {
        try {
            return this.isKeyAction(uec, KeyActionEnum.ToggleActiveProcess);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return true;
        }
    }

    public boolean keyToggleUnlockedProcesses(Java2D_UserEventConsumer_KeyPressed uec) {
        try {
            return this.isKeyAction(uec, KeyActionEnum.ToggleUnlockedProcesses);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return true;
        }
    }

    public boolean keyPriorCrossline(Java2D_UserEventConsumer_KeyPressed uec) {
        try {
            return this.isKeyAction(uec, KeyActionEnum.PriorCrossline);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return true;
        }
    }

    public boolean keyNextCrossline(Java2D_UserEventConsumer_KeyPressed uec) {
        try {
            return this.isKeyAction(uec, KeyActionEnum.NextCrossline);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return true;
        }
    }

    public boolean keyPriorInline(Java2D_UserEventConsumer_KeyPressed uec) {
        try {
            return this.isKeyAction(uec, KeyActionEnum.PriorInline);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return true;
        }
    }

    public boolean keyNextInline(Java2D_UserEventConsumer_KeyPressed uec) {
        try {
            return this.isKeyAction(uec, KeyActionEnum.NextInline);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return true;
        }
    }

    public boolean keyNextEnsemble(Java2D_UserEventConsumer_KeyPressed uec) {
        try {
            return this.isKeyAction(uec, KeyActionEnum.NextEnsemble);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return true;
        }
    }

    public boolean keyPriorEnsemble(Java2D_UserEventConsumer_KeyPressed uec) {
        try {
            return this.isKeyAction(uec, KeyActionEnum.PriorEnsemble);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return true;
        }
    }

    public boolean keyNextGroup(Java2D_UserEventConsumer_KeyPressed uec) {
        try {
            return this.isKeyAction(uec, KeyActionEnum.NextGroup);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return true;
        }
    }

    public boolean keyGeomCorrection(Java2D_UserEventConsumer_KeyPressed uec) {
        try {
            return this.isKeyAction(uec, KeyActionEnum.GeomCorrection);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return true;
        }
    }

    public boolean keyPriorGroup(Java2D_UserEventConsumer_KeyPressed uec) {
        try {
            return this.isKeyAction(uec, KeyActionEnum.PriorGroup);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return true;
        }
    }

    public boolean keyOff(Java2D_UserEventConsumer_KeyPressed uec) {
        try {
            return this.isKeyAction(uec, KeyActionEnum.Off);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return true;
        }
    }

    public boolean killPicksUsingDelayTimeSolution(Java2D_UserEventConsumer_KeyPressed uec) {
        try {
            return this.isKeyAction(uec, KeyActionEnum.KillPicksUsingDelayTimeSolution);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return true;
        }
    }

    public boolean isShiftPatternUp(Java2D_UserEventConsumer_KeyPressed uec) {
        try {
            return this.isKeyAction(uec, KeyActionEnum.ShiftPatternUp);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return true;
        }
    }

    public boolean isShiftPatternDown(Java2D_UserEventConsumer_KeyPressed uec) {
        try {
            return this.isKeyAction(uec, KeyActionEnum.ShiftPatternDown);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return true;
        }
    }

    public boolean handleKey(Java2D_UserEventConsumer_KeyPressed uec, Ensemble childEnsemble, Ensemble parentEnsemble, Java2D_Transform transform, boolean stack) {
        return this.handleKey(uec, childEnsemble, parentEnsemble, null, true, transform, stack);
    }

    public boolean handleKey(Java2D_UserEventConsumer_KeyPressed uec, Ensemble childEnsemble, Ensemble parentEnsemble, EnsembleWorker_Sequence sequence, boolean plotUEC, Java2D_Transform transform, boolean stack) {
        try {
            int recID;
            int shotID;
            this.PolarityFlipped = false;
            this.PolarityRecID = -9999;
            this.PolarityShotID = -9999;
            this.Viewport_MinX = uec.Viewport_MinX;
            this.Viewport_MaxX = uec.Viewport_MaxX;
            this.Viewport_MinY = uec.Viewport_MinY;
            this.Viewport_MaxY = uec.Viewport_MaxY;
            this.m_plotUEC = plotUEC;
            this.m_bSnapToEvent = true;
            this.BranchPicksModified = false;
            this.m_inputEnsemble = childEnsemble;
            this.m_parentEnsemble = parentEnsemble;
            if (this.m_inputEnsemble == null || uec == null) {
                return false;
            }
            this.checkMemory();
            this.m_inputPixelX = uec.PixelX;
            this.m_inputPixelY = uec.PixelY;
            this.m_inputWorldX = uec.WorldX;
            this.m_inputWorldY = uec.WorldY;
            if (!this.prepareInputEnsemble()) {
                return false;
            }
            KeyActionEnum action = this.getKeyActionEnum(uec);
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            this.m_startTimeLocked = false;
            if (action == KeyActionEnum.CopyAutoPickToUserOverwrite) {
                return this.copyAutoToUser(sequence, true);
            }
            if (action == KeyActionEnum.CopyAutoPickToUser) {
                return this.copyAutoToUser(sequence, false);
            }
            if (action == KeyActionEnum.PickCursorTime) {
                if (this.m_plotUEC) {
                    this.m_startTimeLocked = true;
                    this.m_inputWorldY = uec.WorldY;
                    boolean right = this.addRight();
                    boolean left = this.addLeft();
                    return left || right;
                }
                return false;
            }
            if (action == KeyActionEnum.PickZeroTime) {
                this.m_startTimeLocked = true;
                this.m_inputWorldY = 0.0;
                boolean right = this.addRight();
                boolean left = this.addLeft();
                return left || right;
            }
            if (action == KeyActionEnum.CrudeGeometryUpdate) {
                if (this.m_crudeMover == null) {
                    this.m_crudeMover = new EnsembleWorker_PositionPredictor();
                }
                if (!this.m_crudeMover.doWork(this.m_inputEnsemble)) {
                    return false;
                }
                if (!this.m_inputEnsemble.CrudePositionEstimateValid) {
                    return false;
                }
                shotID = Tools_Ensemble.isShotEnsemble(this.m_inputEnsemble);
                recID = Tools_Ensemble.isReceiverEnsemble(this.m_inputEnsemble);
                if (shotID < 0 && recID < 0) {
                    return false;
                }
                double newX = this.m_inputEnsemble.CrudePositionEstimateX;
                double newY = this.m_inputEnsemble.CrudePositionEstimateY;
                if (shotID >= 1) {
                    project.moveShot(shotID, newX, newY);
                    this.BranchPicksModified = true;
                    return true;
                }
                if (recID >= 1) {
                    project.moveReceiver(recID, newX, newY);
                    this.BranchPicksModified = true;
                    return true;
                }
            }
            if (action == KeyActionEnum.GeomCorrection) {
                shotID = Tools_Ensemble.isShotEnsemble(this.m_inputEnsemble);
                recID = Tools_Ensemble.isReceiverEnsemble(this.m_inputEnsemble);
                if (shotID < 0 && recID < 0) {
                    return false;
                }
                Tools_DelayTime_Geometry.singleton().computeGeometryCorrection(false, this.m_inputEnsemble, "FBP_User");
                Ensemble.PredictedCoordinates pred = this.m_inputEnsemble.predictedCoordinates();
                if (!pred.Valid) {
                    return false;
                }
                double newX = pred.CurrentX + pred.ShiftX;
                double newY = pred.CurrentY + pred.ShiftY;
                if (shotID >= 1) {
                    project.moveShot(shotID, newX, newY);
                    this.BranchPicksModified = true;
                    return true;
                }
                if (recID >= 1) {
                    project.moveReceiver(recID, newX, newY);
                    this.BranchPicksModified = true;
                    return true;
                }
            }
            if (this.m_plotUEC) {
                boolean left;
                boolean right;
                if (action == KeyActionEnum.AddBoth) {
                    right = this.addRight();
                    left = this.addLeft();
                    return left || right;
                }
                if (action == KeyActionEnum.KillBoth) {
                    right = this.killRight(stack);
                    left = this.killLeft(stack);
                    return left || right;
                }
                if (action == KeyActionEnum.AddRight) {
                    return this.addRight();
                }
                if (action == KeyActionEnum.KillRight) {
                    return this.killRight(stack);
                }
                if (action == KeyActionEnum.AddLeft) {
                    return this.addLeft();
                }
                if (action == KeyActionEnum.KillLeft) {
                    return this.killLeft(stack);
                }
                if (action == KeyActionEnum.AddSinglePick) {
                    return this.addSingle(true);
                }
                if (action == KeyActionEnum.AddSinglePickNoSnap) {
                    return this.addSingle(false);
                }
                if (action == KeyActionEnum.KillSinglePick) {
                    return this.killSingle();
                }
                if (action == KeyActionEnum.KillTrace) {
                    return this.killTrace();
                }
                if (action == KeyActionEnum.FlipPolarity) {
                    return this.flipPolarity();
                }
                if (action == KeyActionEnum.FlipTracePolarity) {
                    return this.flipTracePolarity();
                }
                if (action == KeyActionEnum.KillPicksInZoom) {
                    return this.killPicksInZoom(true, stack);
                }
                if (action == KeyActionEnum.KillPicksOutsideZoom) {
                    return this.killPicksInZoom(false, stack);
                }
            }
            return false;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    protected boolean handleControlPoint_TraceSelect(Java2D_UserEventConsumer_MultiLineSegments uec) {
        try {
            for (int k = 0; k < this.m_inputEnsemble.traceCount(); ++k) {
                this.m_inputEnsemble.trace((int)k).SelectedUsingControlPoints = false;
            }
            for (int n = 0; n < uec.numPoints() - 1; ++n) {
                double x2;
                double t1 = uec.getY(n);
                double t2 = uec.getY(n + 1);
                double x1 = uec.getX(n);
                if (x1 > (x2 = uec.getX(n + 1))) {
                    t1 = uec.getY(n + 1);
                    t2 = uec.getY(n);
                    x1 = uec.getX(n + 1);
                    x2 = uec.getX(n);
                }
                for (int k = 0; k < this.m_inputEnsemble.traceCount(); ++k) {
                    EnsembleTrace trace = this.m_inputEnsemble.trace(k);
                    boolean selected = trace.PlotData.WorldX > x1 && trace.PlotData.WorldX < x2;
                    trace.SelectedUsingControlPoints = trace.SelectedUsingControlPoints || selected;
                }
            }
            int numSelected = 0;
            int numVisible = 0;
            for (int k = 0; k < this.m_inputEnsemble.traceCount(); ++k) {
                if (!this.m_inputEnsemble.trace((int)k).SelectedUsingControlPoints) continue;
                ++numSelected;
                if (!this.m_inputEnsemble.trace((int)k).PlotData.Visible) continue;
                ++numVisible;
            }
            if (numSelected < 1) {
                return false;
            }
            if (this.m_selectedTraceOperationsDialog == null) {
                this.m_selectedTraceOperationsDialog = new SelectedTraceOperationsDialog();
            }
            this.m_selectedTraceOperationsDialog.showDialog(this.m_inputEnsemble);
            this.m_numInputPicksModified = this.m_selectedTraceOperationsDialog.NumModified;
            for (int n = 0; n < this.m_selectedTraceOperationsDialog.NumModified; ++n) {
                this.m_inputTraceIndex[n] = this.m_selectedTraceOperationsDialog.ModifiedIndex[n];
            }
            this.finish_Parent(true, false);
            this.finish_UpdateDelayTime();
            return this.m_selectedTraceOperationsDialog.NumModified > 0;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    public boolean handleRubberBand(Java2D_UserEventConsumer_MultiLineSegments uec, Ensemble childEnsemble, Ensemble parentEnsemble) {
        try {
            this.m_bSnapToEvent = true;
            this.BranchPicksModified = false;
            this.m_inputEnsemble = childEnsemble;
            this.m_parentEnsemble = parentEnsemble;
            if (this.m_inputEnsemble == null || uec == null) {
                return false;
            }
            this.checkMemory();
            if (!this.prepareInputEnsemble()) {
                return false;
            }
            for (int n = 0; n < this.m_inputEnsemble.traceCount(); ++n) {
                this.m_sortIndex[n] = n;
            }
            if (uec.Dragging) {
                return false;
            }
            if (!uec.Finished) {
                return false;
            }
            if (uec.numPoints() < 2) {
                return false;
            }
            this.m_numInputPicksModified = 0;
            boolean addPicks = uec.AddPicks_PenMode || uec.AddPicks_SnapToEvent;
            boolean killTraces = uec.KillTraces;
            int numKilled = 0;
            for (int n = 0; n < uec.numPoints() - 1; ++n) {
                double x2;
                double t1 = uec.getY(n);
                double t2 = uec.getY(n + 1);
                double x1 = uec.getX(n);
                if (x1 > (x2 = uec.getX(n + 1))) {
                    t1 = uec.getY(n + 1);
                    t2 = uec.getY(n);
                    x1 = uec.getX(n + 1);
                    x2 = uec.getX(n);
                }
                for (int k = 0; k < this.m_inputEnsemble.traceCount(); ++k) {
                    boolean pick;
                    EnsembleTrace trace = this.m_inputEnsemble.trace(k);
                    boolean bl = pick = trace.PlotData.Visible || this.PickHiddenTraces && trace.PlotData.IsInBranch;
                    if (!pick || !(trace.PlotData.WorldX > x1) || !(trace.PlotData.WorldX < x2)) continue;
                    if (uec.KillTraces) {
                        ++numKilled;
                        this.m_inputTraceIndex[this.m_numInputPicksModified] = k;
                        ++this.m_numInputPicksModified;
                        this.killTrace(k, false);
                    }
                    if (addPicks) {
                        double s = (trace.PlotData.WorldX - x1) / (x2 - x1);
                        this.m_currentStartTime = t1 + (t2 - t1) * s;
                        if (uec.AddPicks_SnapToEvent) {
                            this.pickTrace(k);
                        }
                        if (uec.AddPicks_PenMode) {
                            double time = this.m_currentStartTime - (double)trace.data().getTotalFirstSampleShifts();
                            trace.header().putDouble(this.m_inputPickHeaderIndex, time);
                            this.m_inputTraceIndex[this.m_numInputPicksModified] = k;
                            ++this.m_numInputPicksModified;
                        }
                    }
                    if (uec.KillPicks) {
                        trace.header().putFloat(this.m_inputPickHeaderIndex, -9999.0f);
                        this.m_inputTraceIndex[this.m_numInputPicksModified] = k;
                        ++this.m_numInputPicksModified;
                    }
                    if (!uec.FlipPolarity) continue;
                    this.m_inputTraceIndex[this.m_numInputPicksModified] = k;
                    ++this.m_numInputPicksModified;
                }
            }
            if (uec.KillTraces) {
                if (numKilled > 0) {
                    this.finishedKillingTraces();
                }
                return numKilled > 0;
            }
            if (uec.FlipPolarity) {
                long[] traceTableIndices = new long[this.m_numInputPicksModified];
                int indexTraceIndex = this.m_inputEnsemble.dictionary().getEntryIndex("Trace", "TraceIndex");
                for (int i = 0; i < this.m_numInputPicksModified; ++i) {
                    traceTableIndices[i] = this.m_inputEnsemble.trace(this.m_inputTraceIndex[i]).header().getLong(indexTraceIndex);
                }
                RefractionStaticsProject.singleton().flipTracePolarity(traceTableIndices);
                this.finish();
                return this.m_numInputPicksModified > 0;
            }
            this.finish();
            return this.m_numInputPicksModified > 0;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    public boolean handleControlPoint(Java2D_UserEventConsumer_MultiLineSegments uec, Ensemble childEnsemble, Ensemble parentEnsemble) {
        try {
            int n;
            this.m_bSnapToEvent = true;
            this.BranchPicksModified = false;
            this.m_inputEnsemble = childEnsemble;
            this.m_parentEnsemble = parentEnsemble;
            if (this.m_inputEnsemble == null || uec == null) {
                return false;
            }
            this.checkMemory();
            if (!this.prepareInputEnsemble()) {
                return false;
            }
            for (n = 0; n < this.m_inputEnsemble.traceCount(); ++n) {
                this.m_sortIndex[n] = n;
            }
            if (uec.Dragging) {
                return false;
            }
            if (!uec.Finished) {
                return false;
            }
            if (uec.numPoints() < 2) {
                return false;
            }
            this.m_numInputPicksModified = 0;
            if (this.LeftClickAction == LeftClickActionEnum.ControlPointSelect) {
                return this.handleControlPoint_TraceSelect(uec);
            }
            for (n = 0; n < uec.numPoints() - 1; ++n) {
                double x2;
                double t1 = uec.getY(n);
                double t2 = uec.getY(n + 1);
                double x1 = uec.getX(n);
                if (x1 > (x2 = uec.getX(n + 1))) {
                    t1 = uec.getY(n + 1);
                    t2 = uec.getY(n);
                    x1 = uec.getX(n + 1);
                    x2 = uec.getX(n);
                }
                for (int k = 0; k < this.m_inputEnsemble.traceCount(); ++k) {
                    boolean pick;
                    EnsembleTrace trace = this.m_inputEnsemble.trace(k);
                    boolean bl = pick = trace.PlotData.Visible || this.PickHiddenTraces && trace.PlotData.IsInBranch;
                    if (!pick || !(trace.PlotData.WorldX > x1) || !(trace.PlotData.WorldX < x2)) continue;
                    if (this.LeftClickAction == LeftClickActionEnum.ControlPointAdd) {
                        double s = (trace.PlotData.WorldX - x1) / (x2 - x1);
                        this.m_currentStartTime = t1 + (t2 - t1) * s;
                        if (this.ControlPointSnap) {
                            this.pickTrace(k);
                        } else {
                            double time = this.m_currentStartTime - (double)trace.data().getTotalFirstSampleShifts();
                            trace.header().putDouble(this.m_inputPickHeaderIndex, time);
                            this.m_inputTraceIndex[this.m_numInputPicksModified] = k;
                            ++this.m_numInputPicksModified;
                        }
                    }
                    if (this.LeftClickAction != LeftClickActionEnum.ControlPointKill) continue;
                    trace.header().putFloat(this.m_inputPickHeaderIndex, -9999.0f);
                    this.m_inputTraceIndex[this.m_numInputPicksModified] = k;
                    ++this.m_numInputPicksModified;
                }
            }
            this.finish();
            return this.m_numInputPicksModified > 0;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    protected void checkMemory() {
        try {
            if (this.m_parentEnsemble != null && this.m_parentEnsemble.traceCount() >= this.m_parentTraceIndex.length) {
                this.m_parentTraceIndex = new int[1000 + this.m_parentEnsemble.traceCount()];
            }
            if (this.m_inputEnsemble != null && this.m_inputEnsemble.traceCount() >= this.m_parentTraceIndex.length) {
                this.m_parentTraceIndex = new int[1000 + this.m_inputEnsemble.traceCount()];
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public boolean handleButtonPressed(Java2D_UserEventConsumer_ButtonPressed uec, Ensemble childEnsemble, Ensemble parentEnsemble, boolean stack) {
        try {
            this.m_bSnapToEvent = true;
            this.m_inputEnsemble = childEnsemble;
            this.m_parentEnsemble = parentEnsemble;
            if (this.m_inputEnsemble == null || uec == null) {
                return false;
            }
            this.checkMemory();
            this.m_inputPixelX = uec.PixelX;
            this.m_inputPixelY = uec.PixelY;
            this.m_inputWorldX = uec.WorldX;
            this.m_inputWorldY = uec.WorldY;
            if (uec.ControlDown) {
                return false;
            }
            if (!this.prepareInputEnsemble()) {
                return false;
            }
            if (uec.MouseButton == 1) {
                if (this.LeftClickAction == LeftClickActionEnum.AddRight) {
                    return this.addRight();
                }
                if (this.LeftClickAction == LeftClickActionEnum.KillRight) {
                    return this.killRight(stack);
                }
                if (this.LeftClickAction == LeftClickActionEnum.AddLeft) {
                    return this.addLeft();
                }
                if (this.LeftClickAction == LeftClickActionEnum.KillLeft) {
                    return this.killLeft(stack);
                }
                if (this.LeftClickAction == LeftClickActionEnum.KillSinglePick) {
                    return this.killSingle();
                }
                if (this.LeftClickAction == LeftClickActionEnum.AddSinglePick) {
                    return this.addSingle(true);
                }
                if (this.LeftClickAction == LeftClickActionEnum.KillTrace) {
                    return this.killTrace();
                }
                if (this.LeftClickAction == LeftClickActionEnum.FlipPolarity) {
                    return this.flipPolarity();
                }
                if (this.LeftClickAction == LeftClickActionEnum.AddBoth) {
                    boolean right = this.addRight();
                    boolean left = this.addLeft();
                    return left || right;
                }
                if (this.LeftClickAction == LeftClickActionEnum.KillBoth) {
                    boolean right = this.killRight(stack);
                    boolean left = this.killLeft(stack);
                    return left || right;
                }
            }
            return false;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    public boolean handlePenMode(Java2D_UserEventConsumer_PenMode uec, Ensemble childEnsemble, Ensemble parentEnsemble) {
        try {
            if (this.LeftClickAction != LeftClickActionEnum.PenMode) {
                return false;
            }
            if (!uec.Dragging) {
                return false;
            }
            this.m_inputEnsemble = childEnsemble;
            this.m_parentEnsemble = parentEnsemble;
            if (this.m_inputEnsemble == null || uec == null) {
                return false;
            }
            this.checkMemory();
            this.m_inputPixelX = uec.PixelX;
            this.m_inputPixelY = uec.PixelY;
            this.m_inputWorldX = uec.WorldX;
            this.m_inputWorldY = uec.WorldY;
            if (!this.prepareInputEnsemble()) {
                return false;
            }
            if (uec.MouseButton != 1) {
                return false;
            }
            this.m_currentStartTime = this.m_inputWorldY;
            if (uec.ControlDown) {
                this.killSinglePick(this.m_nearestSortIndex);
            } else {
                this.pickTrace(this.m_nearestSortIndex);
            }
            this.finish();
            return this.m_numInputPicksModified > 0;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    protected void finish_TraceTable() {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            if (!project.valid()) {
                return;
            }
            ITraceTable table = project.traceTableWrapper().traceTable();
            if (!table.column_exists(this.PickName)) {
                return;
            }
            if (!this.m_inputEnsemble.dictionary().containsEntry("Trace", "TraceIndex")) {
                return;
            }
            int tableIndex = table.column_indexOfColumn(this.PickName);
            int headerIndex = this.m_inputEnsemble.dictionary().getEntryIndex("Trace", "TraceIndex");
            if (this.m_pickArray.length < this.m_numInputPicksModified) {
                this.m_pickArray = new float[this.m_numInputPicksModified + 100];
            }
            if (this.m_indexArray.length < this.m_numInputPicksModified) {
                this.m_indexArray = new long[this.m_numInputPicksModified + 100];
            }
            for (int n = 0; n < this.m_numInputPicksModified; ++n) {
                EnsembleTrace trace = this.m_inputEnsemble.trace(this.m_inputTraceIndex[n]);
                this.m_pickArray[n] = trace.header().getFloat(this.m_inputPickHeaderIndex);
                this.m_indexArray[n] = trace.header().getLong(headerIndex);
            }
            boolean swaps = true;
            while (swaps) {
                swaps = false;
                for (int n = 0; n < this.m_numInputPicksModified - 1; ++n) {
                    long index1 = this.m_indexArray[n];
                    long index2 = this.m_indexArray[n + 1];
                    float pick1 = this.m_pickArray[n];
                    float pick2 = this.m_pickArray[n + 1];
                    if (index1 <= index2) continue;
                    this.m_indexArray[n] = index2;
                    this.m_indexArray[n + 1] = index1;
                    this.m_pickArray[n] = pick2;
                    this.m_pickArray[n + 1] = pick1;
                    swaps = true;
                }
            }
            for (int n = 0; n < this.m_numInputPicksModified; ++n) {
                table.putFloat(this.m_indexArray[n], tableIndex, this.m_pickArray[n]);
            }
            table.saveCurrentSection();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void finish_UpdateDelayTime() {
        try {
            this.BranchPicksModified = false;
            for (int b = 1; b < this.m_numModifiedInBranch.length; ++b) {
                this.m_numModifiedInBranch[b] = 0;
            }
            if (this.m_numParentPicksModified < 1) {
                return;
            }
            if (this.m_parentEnsemble == null) {
                return;
            }
            if (!this.m_parentEnsemble.dictionary().containsEntry("Trace", this.PickName)) {
                return;
            }
            if (!this.m_parentEnsemble.dictionary().containsEntry("Trace", "Branch_DelayTime")) {
                return;
            }
            int indexBranch = this.m_parentEnsemble.dictionary().getEntryIndex("Trace", "Branch_DelayTime");
            for (int n = 0; n < this.m_numParentPicksModified; ++n) {
                EnsembleTrace parentTrace = this.m_parentEnsemble.trace(this.m_parentTraceIndex[n]);
                int branch = parentTrace.header().getInt(indexBranch);
                if (branch < 1) continue;
                int n2 = branch;
                this.m_numModifiedInBranch[n2] = this.m_numModifiedInBranch[n2] + 1;
            }
            for (int b = 1; b < this.m_numModifiedInBranch.length; ++b) {
                if (this.m_numModifiedInBranch[b] < 1) continue;
                this.BranchPicksModified = true;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void finish_Parent() {
        try {
            this.finish_Parent(false, true);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void finish_Parent(boolean copyKilled, boolean copyPicks) {
        try {
            if (this.m_parentEnsemble == null) {
                return;
            }
            if (!this.m_parentEnsemble.dictionary().containsEntry("Trace", this.PickName)) {
                return;
            }
            if (!this.m_parentEnsemble.dictionary().containsEntry("Trace", "TraceIndex")) {
                return;
            }
            if (!this.m_inputEnsemble.dictionary().containsEntry("Trace", "TraceIndex")) {
                return;
            }
            int parentPickHeaderIndex = this.m_parentEnsemble.dictionary().getEntryIndex("Trace", this.PickName);
            int parentTraceIndex = this.m_parentEnsemble.dictionary().getEntryIndex("Trace", "TraceIndex");
            int parentKilledIndex = -9999;
            if (this.m_parentEnsemble.dictionary().containsEntry("Trace", "Killed")) {
                parentKilledIndex = this.m_parentEnsemble.dictionary().getEntryIndex("Trace", "Killed");
            }
            int inputTraceIndex = this.m_inputEnsemble.dictionary().getEntryIndex("Trace", "TraceIndex");
            int inputKilledIndex = -9999;
            if (this.m_inputEnsemble.dictionary().containsEntry("Trace", "Killed")) {
                inputKilledIndex = this.m_inputEnsemble.dictionary().getEntryIndex("Trace", "Killed");
            }
            this.m_numParentPicksModified = 0;
            for (int n = 0; n < this.m_numInputPicksModified; ++n) {
                EnsembleTrace inputTrace = this.m_inputEnsemble.trace(this.m_inputTraceIndex[n]);
                int inputTID = inputTrace.header().getInt(inputTraceIndex);
                for (int k = 0; k < this.m_parentEnsemble.traceCount(); ++k) {
                    EnsembleTrace parentTrace = this.m_parentEnsemble.trace(k);
                    int parentTID = parentTrace.header().getInt(parentTraceIndex);
                    if (parentTID != inputTID) continue;
                    this.m_parentTraceIndex[this.m_numParentPicksModified] = k;
                    ++this.m_numParentPicksModified;
                    if (copyPicks) {
                        float pick = inputTrace.header().getFloat(this.m_inputPickHeaderIndex);
                        parentTrace.header().putFloat(parentPickHeaderIndex, pick);
                    }
                    if (copyKilled && parentKilledIndex >= 0 && inputKilledIndex >= 0) {
                        int killed = inputTrace.header().getInt(inputKilledIndex);
                        parentTrace.header().putInt(parentKilledIndex, killed);
                        parentTrace.TraceKilled = inputTrace.TraceKilled;
                    }
                    k = 10000000;
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void finish() {
        try {
            this.BranchPicksModified = false;
            if (this.m_numInputPicksModified < 1) {
                return;
            }
            this.finish_Parent();
            this.finish_UpdateDelayTime();
            this.finish_TraceTable();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void killSinglePick(int index) {
        try {
            int traceIndex = this.m_sortIndex[index];
            EnsembleTrace trace = this.m_inputEnsemble.trace(traceIndex);
            trace.header().putDouble(this.m_inputPickHeaderIndex, -9999.0);
            this.m_inputTraceIndex[this.m_numInputPicksModified] = traceIndex;
            ++this.m_numInputPicksModified;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void pickTrace_External(EnsembleTrace trace, int headerIndex, float nominalPick) {
        try {
            FloatArrayWrapper data = trace.data();
            if (data.length() < 1) {
                return;
            }
            if (this.m_traceData.length < data.length()) {
                this.m_traceData = new float[data.length()];
            }
            data.copyToArray(this.m_traceData);
            double time0 = data.getFirstSampleCoord_WithShifts();
            int startSample = (int)(((double)nominalPick - time0) / (double)data.getSampleInterval());
            double nearestSample = Tools_Picking.getNearestEvent(this.m_traceData, data.length(), this.m_pickEvent, startSample, false);
            if (nearestSample < 0.0) {
                return;
            }
            double pickTime = nearestSample * (double)data.getSampleInterval() + (double)data.getFirstSampleCoord_Initial();
            if (!this.m_startTimeLocked) {
                this.m_currentStartTime = pickTime + (double)data.getTotalFirstSampleShifts();
            }
            trace.header().putDouble(headerIndex, pickTime);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void pickTrace(int index) {
        try {
            int traceIndex = this.m_sortIndex[index];
            EnsembleTrace trace = this.m_inputEnsemble.trace(traceIndex);
            FloatArrayWrapper data = trace.data();
            if (data.length() < 1) {
                return;
            }
            if (this.m_bSnapToEvent) {
                if (this.m_traceData.length < data.length()) {
                    this.m_traceData = new float[data.length()];
                }
                data.copyToArray(this.m_traceData);
                double time0 = data.getFirstSampleCoord_WithShifts();
                int startSample = (int)((this.m_currentStartTime - time0) / (double)data.getSampleInterval());
                double startTime = this.m_currentStartTime - time0;
                double nearestSample = Tools_Picking.getNearestEvent(this.m_traceData, data.length(), this.m_pickEvent, startSample, this.PickLocalEvents);
                if (nearestSample < 0.0) {
                    return;
                }
                double pickTime = nearestSample * (double)data.getSampleInterval() + (double)data.getFirstSampleCoord_Initial();
                if (!this.m_startTimeLocked) {
                    this.m_currentStartTime = pickTime + (double)data.getTotalFirstSampleShifts();
                }
                trace.header().putDouble(this.m_inputPickHeaderIndex, pickTime);
            } else {
                double time0 = data.getFirstSampleCoord_WithShifts();
                double pickTime = this.m_currentStartTime - time0 + (double)data.getFirstSampleCoord_Initial();
                trace.header().putDouble(this.m_inputPickHeaderIndex, pickTime);
            }
            if (this.m_numInputPicksModified >= 0 && this.m_numInputPicksModified < this.m_inputTraceIndex.length) {
                this.m_inputTraceIndex[this.m_numInputPicksModified] = traceIndex;
                ++this.m_numInputPicksModified;
            } else {
                System.out.println(String.format("PcikerGizmo, bad m_numInputPicksModified = %d", this.m_numInputPicksModified));
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public boolean isPickVisible(int index, boolean stack) {
        try {
            int traceIndex = this.m_sortIndex[index];
            EnsembleTrace trace = this.m_inputEnsemble.trace(traceIndex);
            FloatArrayWrapper data = trace.data();
            double time0 = data.getFirstSampleCoord_WithShifts();
            if (stack) {
                time0 = 0.0;
            }
            double pickTime = trace.header().getDouble(this.m_inputPickHeaderIndex);
            double windowStartTime = this.Viewport_MinY - time0;
            double windowStopTime = this.Viewport_MaxY - time0;
            return pickTime > windowStartTime && pickTime < windowStopTime;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    public boolean killRight(boolean stack) {
        try {
            if (!this.m_rightTraceOkay) {
                return false;
            }
            for (int index = this.m_firstTraceToRightSortIndex; index < this.m_traceCount; ++index) {
                if (!this.isPickVisible(index, stack)) continue;
                this.killSinglePick(index);
            }
            this.finish();
            return this.m_numInputPicksModified > 0;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    public boolean addRight() {
        try {
            if (!this.m_rightTraceOkay) {
                return false;
            }
            this.m_currentStartTime = this.m_inputWorldY;
            for (int index = this.m_firstTraceToRightSortIndex; index < this.m_traceCount; ++index) {
                this.pickTrace(index);
            }
            this.finish();
            return this.m_numInputPicksModified > 0;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    public boolean addSingle(boolean snap) {
        try {
            this.m_bSnapToEvent = snap;
            this.m_currentStartTime = this.m_inputWorldY;
            this.pickTrace(this.m_nearestSortIndex);
            this.finish();
            return this.m_numInputPicksModified > 0;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    public boolean flipTracePolarity() {
        try {
            if (!RefractionStaticsProject.singleton().valid()) {
                return false;
            }
            int traceIndex = this.m_sortIndex[this.m_nearestSortIndex];
            EnsembleTrace trace = this.m_inputEnsemble.trace(traceIndex);
            if (!this.m_inputEnsemble.dictionary().containsEntry("Trace", "TraceIndex")) {
                return false;
            }
            int headerIndex = this.m_inputEnsemble.dictionary().getEntryIndex("Trace", "TraceIndex");
            long indexinTraceTable = trace.header().getLong(headerIndex);
            long[] indices = new long[]{indexinTraceTable};
            RefractionStaticsProject.singleton().flipTracePolarity(indices);
            return false;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    public boolean flipPolarity() {
        try {
            this.PolarityFlipped = false;
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            if (!project.valid()) {
                return false;
            }
            int traceIndex = this.m_sortIndex[this.m_nearestSortIndex];
            EnsembleTrace trace = this.m_inputEnsemble.trace(traceIndex);
            if (Tools_Ensemble.isShotEnsemble(this.m_inputEnsemble) >= 0) {
                if (!this.m_inputEnsemble.dictionary().containsEntry("Receiver", "ReceiverID")) {
                    return false;
                }
                int headerIndexID = this.m_inputEnsemble.dictionary().getEntryIndex("Receiver", "ReceiverID");
                this.PolarityRecID = trace.header().getInt(headerIndexID);
                project.flipReceiverPolarity(this.PolarityRecID);
                this.PolarityFlipped = true;
                return false;
            }
            if (Tools_Ensemble.isReceiverEnsemble(this.m_inputEnsemble) >= 0) {
                if (!this.m_inputEnsemble.dictionary().containsEntry("Shot", "ShotID")) {
                    return false;
                }
                int headerIndexID = this.m_inputEnsemble.dictionary().getEntryIndex("Shot", "ShotID");
                this.PolarityShotID = trace.header().getInt(headerIndexID);
                project.flipShotPolarity(this.PolarityShotID);
                this.PolarityFlipped = true;
                return false;
            }
            return false;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    public boolean killTrace() {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            if (!project.valid()) {
                return false;
            }
            ITraceTable table = project.traceTableWrapper().traceTable();
            if (!table.column_exists("Killed")) {
                return false;
            }
            int traceTableKilledColumn = table.column_indexOfColumn("Killed");
            if (!this.m_inputEnsemble.dictionary().containsEntry("Trace", "TraceIndex")) {
                return false;
            }
            if (!this.m_inputEnsemble.dictionary().containsEntry("Trace", "Killed")) {
                return false;
            }
            int traceTableHeaderIndex = this.m_inputEnsemble.dictionary().getEntryIndex("Trace", "TraceIndex");
            int killedHeaderIndex = this.m_inputEnsemble.dictionary().getEntryIndex("Trace", "Killed");
            int traceIndex = this.m_sortIndex[this.m_nearestSortIndex];
            return this.killTrace(traceIndex, true);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    protected boolean killTrace(int traceIndex, boolean callFinish) {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            if (!project.valid()) {
                return false;
            }
            ITraceTable table = project.traceTableWrapper().traceTable();
            if (!table.column_exists("Killed")) {
                return false;
            }
            int traceTableKilledColumn = table.column_indexOfColumn("Killed");
            if (!this.m_inputEnsemble.dictionary().containsEntry("Trace", "TraceIndex")) {
                return false;
            }
            if (!this.m_inputEnsemble.dictionary().containsEntry("Trace", "Killed")) {
                return false;
            }
            int traceTableHeaderIndex = this.m_inputEnsemble.dictionary().getEntryIndex("Trace", "TraceIndex");
            int killedHeaderIndex = this.m_inputEnsemble.dictionary().getEntryIndex("Trace", "Killed");
            EnsembleTrace trace = this.m_inputEnsemble.trace(traceIndex);
            trace.header().putInt(killedHeaderIndex, 1);
            trace.TraceKilled = true;
            long traceTableIndex = trace.header().getLong(traceTableHeaderIndex);
            table.putInt(traceTableIndex, traceTableKilledColumn, 1);
            if (callFinish) {
                this.m_inputTraceIndex[this.m_numInputPicksModified] = traceIndex;
                ++this.m_numInputPicksModified;
                this.finishedKillingTraces();
            }
            return true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    protected void finishedKillingTraces() {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            if (!project.valid()) {
                return;
            }
            ITraceTable table = project.traceTableWrapper().traceTable();
            table.saveCurrentSection();
            this.finish_Parent(true, false);
            this.finish_UpdateDelayTime();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public boolean killSingle() {
        try {
            this.m_currentStartTime = this.m_inputWorldY;
            this.killSinglePick(this.m_nearestSortIndex);
            this.finish();
            return this.m_numInputPicksModified > 0;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    public boolean killLeft(boolean stack) {
        try {
            if (!this.m_leftTraceOkay) {
                return false;
            }
            for (int index = this.m_firstTraceToLeftSortIndex; index >= 0; --index) {
                if (!this.isPickVisible(index, stack)) continue;
                this.killSinglePick(index);
            }
            this.finish();
            return this.m_numInputPicksModified > 0;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    public boolean killPicksInZoom(boolean inside, boolean stack) {
        try {
            if (inside) {
                this.killLeft(stack);
                this.killRight(stack);
                this.finish();
                return true;
            }
            boolean killIt = true;
            for (int index = 0; index < this.m_traceCount; ++index) {
                if ((double)index < this.Viewport_MinX || (double)index > this.Viewport_MaxX) {
                    this.killSinglePick(index);
                    continue;
                }
                if (this.isPickVisible(index, stack)) continue;
                this.killSinglePick(index);
            }
            this.finish();
            return true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    protected boolean copyAutoToUser(EnsembleWorker_Sequence sequence, boolean overwrite) {
        try {
            if (sequence == null) {
                return false;
            }
            this.m_numInputPicksModified = 0;
            this.m_currentStartTime = this.m_inputWorldY;
            double windowStartTime = this.Viewport_MinY;
            double windowStopTime = this.Viewport_MaxY;
            for (int w = sequence.size() - 1; w >= 0; --w) {
                EnsembleWorker_Base worker = sequence.worker(w);
                if (!worker.IasAutopicker || !worker.WorkerTurnedOn || !this.m_inputEnsemble.dictionary().containsEntry("Trace", worker.AutopickerColumnName)) continue;
                int indexUser = this.m_inputEnsemble.dictionary().getEntryIndex("Trace", "FBP_User");
                int indexAuto = this.m_inputEnsemble.dictionary().getEntryIndex("Trace", worker.AutopickerColumnName);
                for (int n = 0; n < this.m_inputEnsemble.traceCount(); ++n) {
                    EnsembleTrace trace = this.m_inputEnsemble.trace(n);
                    float user = trace.header().getFloat(indexUser);
                    float auto = trace.header().getFloat(indexAuto);
                    double time0 = trace.data().getFirstSampleCoord_WithShifts();
                    if (!(auto > 0.0f) || !(user < 0.0f) && !overwrite) continue;
                    int traceIndex = this.m_sortIndex[n];
                    if (!trace.PlotData.Visible || !trace.PlotData.InsideViewport) continue;
                    windowStartTime = this.Viewport_MinY - time0;
                    windowStopTime = this.Viewport_MaxY - time0;
                    if (!((double)auto > windowStartTime) || !((double)auto < windowStopTime)) continue;
                    this.m_inputTraceIndex[this.m_numInputPicksModified] = n;
                    ++this.m_numInputPicksModified;
                    trace.header().putFloat(indexUser, auto);
                }
                if (this.m_numInputPicksModified < 1) continue;
                this.finish();
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    public double traceCoordUsingSortIndex(int index) {
        try {
            int n = this.m_sortIndex[index];
            EnsembleTrace trace = this.m_inputEnsemble.trace(n);
            return trace.PlotData.WorldX;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return 0.0;
        }
    }

    public boolean addLeft() {
        try {
            if (!this.m_leftTraceOkay) {
                return false;
            }
            this.m_currentStartTime = this.m_inputWorldY;
            for (int index = this.m_firstTraceToLeftSortIndex; index >= 0; --index) {
                this.pickTrace(index);
            }
            this.finish();
            return this.m_numInputPicksModified > 0;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column != 0;
    }

    @Override
    public String getColumnName(int column) {
        try {
            if (column == 0) {
                return "Key";
            }
            if (column == 1) {
                return "Action";
            }
            if (column == 2) {
                return "Shift";
            }
            return "Error";
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return "Error";
        }
    }

    @Override
    public int getRowCount() {
        return this.m_numExtraRows + this.m_keyList.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        try {
            if (value == null) {
                return;
            }
            KeyWrapper e = this.m_keyList.get(row - this.m_numExtraRows);
            if (column == 1) {
                e.MainAction = KeyActionEnum.valueOf((String)value);
            }
            if (column == 2) {
                e.ShiftAction = KeyActionEnum.valueOf((String)value);
            }
            this.save();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public Object getValueAt(int row, int column) {
        try {
            KeyWrapper e = this.m_keyList.get(row - this.m_numExtraRows);
            if (column == 0) {
                return e.KeyText;
            }
            if (column == 1) {
                if (e.MainAction == KeyActionEnum.Off) {
                    return "";
                }
                return e.MainAction.name();
            }
            if (column == 2) {
                if (e.ShiftAction == KeyActionEnum.Off) {
                    return "";
                }
                return e.ShiftAction.name();
            }
            return "error";
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return "error";
        }
    }

    public static enum LeftClickActionEnum {
        ControlPointAdd,
        ControlPointKill,
        ControlPointSelect,
        AddRight,
        KillRight,
        AddLeft,
        KillLeft,
        AddBoth,
        KillBoth,
        AddSinglePick,
        KillSinglePick,
        KillTrace,
        FlipPolarity,
        PenMode;

    }

    public class KeyWrapper {
        public int KeyCode = 48;
        public String KeyText = "";
        public KeyActionEnum MainAction = KeyActionEnum.Off;
        public KeyActionEnum ControlAction = KeyActionEnum.Off;
        public KeyActionEnum ShiftAction = KeyActionEnum.Off;

        public KeyWrapper(int keyCode, String txt, KeyActionEnum main, KeyActionEnum ctrl, KeyActionEnum sft) {
            try {
                this.KeyCode = keyCode;
                this.KeyText = txt;
                if (txt == null) {
                    this.KeyText = KeyEvent.getKeyText(keyCode);
                }
                if (keyCode == 44) {
                    this.KeyText = "Comma";
                }
                if (keyCode == 46) {
                    this.KeyText = "Period";
                }
                if (keyCode == 59) {
                    this.KeyText = ";";
                }
                if (keyCode == 47) {
                    this.KeyText = "/";
                }
                this.MainAction = main;
                this.ControlAction = ctrl;
                this.ShiftAction = sft;
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }
    }

    public static enum KeyActionEnum {
        Off,
        ViewTraceSamples,
        NextGroup,
        PriorGroup,
        NextEnsemble,
        PriorEnsemble,
        AddSinglePick,
        AddSinglePickNoSnap,
        KillSinglePick,
        AddRight,
        KillRight,
        AddLeft,
        KillLeft,
        AddBoth,
        KillBoth,
        ScrollLeft,
        ScrollRight,
        ZoomIn,
        ZoomOut,
        GeomCorrection,
        CrudeGeometryUpdate,
        PickZeroTime,
        PickCursorTime,
        KillTrace,
        FlipPolarity,
        FlipTracePolarity,
        NextInline,
        PriorInline,
        NextCrossline,
        PriorCrossline,
        ShiftPatternUp,
        ShiftPatternDown,
        CopyAutoPickToUser,
        CopyAutoPickToUserOverwrite,
        RubberBandStart,
        RubberBandAddPoint,
        RubberBandCancel,
        RubberBandAddPicksSnapToEvent,
        RubberBandAddPicksAtLine,
        RubberBandKillPicks,
        RubberBandKillTraces,
        RubberBandFlipPolarity,
        SetFlag0,
        SetFlag1,
        SetFlag2,
        SetFlag3,
        SetFlag4,
        KillCurrentShotOrReceiver,
        KillPicksInZoom,
        KillPicksOutsideZoom,
        RestackShotRec,
        KillPicksUsingDelayTimeSolution,
        ViewTraceHeaders,
        ToggleActiveProcess,
        ToggleUnlockedProcesses;

    }

    public class ColumnIndex {
        public static final int Key = 0;
        public static final int Main = 1;
        public static final int Shift = 2;
        public static final int Count = 2;
    }
}

