/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Refraction.GLI;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Refraction.RefractionStaticsProject;

public class GliProfile {
    public double ShotWorldX;
    public double ShotWorldY;
    public double ShotWorldZ;
    public double ReceiverWorldX;
    public double ReceiverWorldY;
    public double ReceiverWorldZ;
    public double[][] Elevation;
    public double[][] Velocity;
    public double Offset;
    public double Azimuth;
    public int NodeCount;
    public double NodeSpacing;
    public int TotalNodeCount;
    protected double[] m_weatheringTimeShot;
    protected double[] m_weatheringTimeReceiver;
    protected int m_layerCount;
    protected Table_Abstract m_shotTable = RefractionStaticsProject.singleton().shotTable();
    protected Table_Abstract m_receiverTable = RefractionStaticsProject.singleton().receiverTable();
    protected double[] m_masterTraveltime;
    protected int[] m_masterShotNode;
    protected int[] m_masterReceiverNode;

    public GliProfile(int shotRow, int receiverRow) {
        try {
            this.m_layerCount = RefractionStaticsProject.singleton().getGliModel().LayerCount();
            int indexShotX = this.m_shotTable.column_indexOfColumn("Easting");
            int indexShotY = this.m_shotTable.column_indexOfColumn("Northing");
            int indexShotZ = this.m_shotTable.column_indexOfColumn("Elevation");
            int indexReceiverX = this.m_receiverTable.column_indexOfColumn("Easting");
            int indexReceiverY = this.m_receiverTable.column_indexOfColumn("Northing");
            int indexReceiverZ = this.m_receiverTable.column_indexOfColumn("Elevation");
            this.ShotWorldX = this.m_shotTable.getDouble(shotRow, indexShotX);
            this.ShotWorldY = this.m_shotTable.getDouble(shotRow, indexShotY);
            this.ShotWorldZ = this.m_shotTable.getDouble(shotRow, indexShotZ);
            this.ReceiverWorldX = this.m_receiverTable.getDouble(receiverRow, indexReceiverX);
            this.ReceiverWorldY = this.m_receiverTable.getDouble(receiverRow, indexReceiverY);
            this.ReceiverWorldZ = this.m_receiverTable.getDouble(receiverRow, indexReceiverZ);
            this.Offset = Math.sqrt((this.ReceiverWorldX - this.ShotWorldX) * (this.ReceiverWorldX - this.ShotWorldX) + (this.ReceiverWorldY - this.ShotWorldY) * (this.ReceiverWorldY - this.ShotWorldY));
            this.Azimuth = Math.atan2(this.ReceiverWorldY - this.ShotWorldY, this.ReceiverWorldX - this.ShotWorldX);
            this.NodeCount = (int)(this.Offset / 40.0);
            this.NodeSpacing = this.Offset / (double)(2 * this.NodeCount);
            this.TotalNodeCount = 2 * this.NodeCount + 1;
            this.m_weatheringTimeShot = new double[this.NodeCount + 1];
            this.m_weatheringTimeReceiver = new double[this.NodeCount + 1];
            this.Elevation = new double[this.m_layerCount + 1][this.TotalNodeCount];
            this.Velocity = new double[this.m_layerCount + 1][this.TotalNodeCount];
            this.m_masterTraveltime = new double[this.m_layerCount + 1];
            this.m_masterShotNode = new int[this.m_layerCount + 1];
            this.m_masterReceiverNode = new int[this.m_layerCount + 1];
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void resetProfile(int shotRow, int receiverRow) {
        try {
            this.m_layerCount = RefractionStaticsProject.singleton().getGliModel().LayerCount();
            int indexShotX = this.m_shotTable.column_indexOfColumn("Easting");
            int indexShotY = this.m_shotTable.column_indexOfColumn("Northing");
            int indexShotZ = this.m_shotTable.column_indexOfColumn("Elevation");
            int indexReceiverX = this.m_receiverTable.column_indexOfColumn("Easting");
            int indexReceiverY = this.m_receiverTable.column_indexOfColumn("Northing");
            int indexReceiverZ = this.m_receiverTable.column_indexOfColumn("Elevation");
            this.ShotWorldX = this.m_shotTable.getDouble(shotRow, indexShotX);
            this.ShotWorldY = this.m_shotTable.getDouble(shotRow, indexShotY);
            this.ShotWorldZ = this.m_shotTable.getDouble(shotRow, indexShotZ);
            this.ReceiverWorldX = this.m_receiverTable.getDouble(receiverRow, indexReceiverX);
            this.ReceiverWorldY = this.m_receiverTable.getDouble(receiverRow, indexReceiverY);
            this.ReceiverWorldZ = this.m_receiverTable.getDouble(receiverRow, indexReceiverZ);
            this.Offset = Math.sqrt((this.ReceiverWorldX - this.ShotWorldX) * (this.ReceiverWorldX - this.ShotWorldX) + (this.ReceiverWorldY - this.ShotWorldY) * (this.ReceiverWorldY - this.ShotWorldY));
            this.Azimuth = Math.atan2(this.ReceiverWorldY - this.ShotWorldY, this.ReceiverWorldX - this.ShotWorldX);
            this.NodeCount = (int)(this.Offset / 40.0);
            this.NodeSpacing = this.Offset / (double)(2 * this.NodeCount);
            this.TotalNodeCount = 2 * this.NodeCount + 1;
            this.m_weatheringTimeShot = new double[this.NodeCount + 1];
            this.m_weatheringTimeReceiver = new double[this.NodeCount + 1];
            this.Elevation = new double[this.m_layerCount + 1][this.TotalNodeCount];
            this.Velocity = new double[this.m_layerCount + 1][this.TotalNodeCount];
            this.m_masterTraveltime = new double[this.m_layerCount + 1];
            this.m_masterShotNode = new int[this.m_layerCount + 1];
            this.m_masterReceiverNode = new int[this.m_layerCount + 1];
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void computeWeatheringTimes() {
        try {
            for (int i = 0; i <= this.NodeCount; ++i) {
                double timeR;
                double timeS;
                double distH = this.NodeSpacing * (double)i;
                double distSV = this.Elevation[0][0] - this.Elevation[1][i];
                double distS = Math.sqrt(distH * distH + distSV * distSV);
                double avgVelS = (this.Velocity[0][0] + this.Velocity[0][i]) / 2.0;
                this.m_weatheringTimeShot[i] = timeS = distS / avgVelS;
                double distRV = this.Elevation[0][this.TotalNodeCount + 1] - this.Elevation[1][this.TotalNodeCount + 1 - i];
                double distR = Math.sqrt(distH * distH + distRV * distRV);
                double avgVelR = (this.Velocity[0][this.TotalNodeCount + 1] - this.Velocity[0][this.TotalNodeCount + 1 - i]) / 2.0;
                this.m_weatheringTimeReceiver[i] = timeR = distR / avgVelR;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void findShortestPath(int targetLayer) {
        try {
            if (targetLayer == 0) {
                this.findDirectArrival();
                return;
            }
            if (targetLayer == 1) {
                this.findShortestPath_Weathering();
                return;
            }
            int currentLayer = 0;
            for (int node1 = 0; node1 <= this.NodeCount; ++node1) {
                while (currentLayer <= this.m_layerCount) {
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void findDirectArrival() {
        try {
            double time = 0.0;
            for (int n = 0; n < this.TotalNodeCount; ++n) {
                double z1 = this.Elevation[0][n];
                double z2 = this.Elevation[0][n + 1];
                double v1 = this.Velocity[0][n];
                double v2 = this.Velocity[0][n + 1];
                double distH = this.NodeSpacing;
                double distV = z2 - z1;
                double segDist = Math.sqrt(distH * distH + distV * distV);
                double avgVel = (v1 + v2) / 2.0;
                double segTime = segDist / avgVel;
                time += segTime;
            }
            this.m_masterTraveltime[0] = time;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void findShortestPath_Weathering() {
        try {
            double bestShot = 1.0E24;
            double bestReceiver = 1.0E24;
            int shotNode = -1;
            int receiverNode = -1;
            for (int i = 0; i < this.NodeCount; ++i) {
                double travelTimeR;
                double refractTimeS = 0.0;
                double refractTimeR = 0.0;
                for (int n = i; n < this.NodeCount; ++n) {
                    double zS1 = this.Elevation[1][n];
                    double zS2 = this.Elevation[1][n + 1];
                    double vS1 = this.Velocity[1][n];
                    double vS2 = this.Velocity[1][n + 1];
                    double distH = this.NodeSpacing;
                    double distSV = zS2 - zS1;
                    double segDistS = Math.sqrt(distH * distH + distSV * distSV);
                    double avgVelS = (vS1 + vS2) / 2.0;
                    double segTimeS = segDistS / avgVelS;
                    double zR1 = this.Elevation[1][this.TotalNodeCount + 1 - n];
                    double zR2 = this.Elevation[1][this.TotalNodeCount - n];
                    double vR1 = this.Velocity[1][this.TotalNodeCount + 1 - n];
                    double vR2 = this.Velocity[1][this.TotalNodeCount - n];
                    double distRV = zR2 - zR1;
                    double segDistR = Math.sqrt(distH * distH + distRV * distRV);
                    double avgVelR = (vR1 + vR2) / 2.0;
                    double segTimeR = segDistR / avgVelR;
                    refractTimeS += segTimeS;
                    refractTimeR += segTimeR;
                }
                double travelTimeS = refractTimeS + this.m_weatheringTimeShot[i];
                if (travelTimeS < bestShot) {
                    bestShot = travelTimeS;
                    shotNode = i;
                }
                if (!((travelTimeR = refractTimeR + this.m_weatheringTimeReceiver[i]) < bestReceiver)) continue;
                bestReceiver = travelTimeR;
                receiverNode = i;
            }
            if (this.m_weatheringTimeShot[this.NodeCount] < bestShot) {
                bestShot = this.m_weatheringTimeShot[this.NodeCount];
                shotNode = this.NodeCount;
            }
            if (this.m_weatheringTimeReceiver[this.NodeCount] < bestReceiver) {
                bestReceiver = this.m_weatheringTimeReceiver[this.NodeCount];
                receiverNode = this.NodeCount;
            }
            this.m_masterTraveltime[1] = bestShot + bestReceiver;
            this.m_masterShotNode[1] = shotNode;
            this.m_masterReceiverNode[1] = receiverNode;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

