/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Refraction.FWI;

import com.PecosCore.Data.ByteBuffer_Shared;
import com.PecosCore.Data.History;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Map.HashMap_Integers;
import com.PecosCore.Math.Grid3D_Conversion;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Pecos;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosLibrary.Math.Grid3D;
import com.PecosLibrary.Refraction.DelayTime.DelayTimeModel;
import com.PecosLibrary.Refraction.FWI.FwiModelProfile;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Tomography.InteractiveModel.TomoInteractiveModel_PickCollection;
import com.PecosLibrary.Refraction.Tools_RefractionStaticsProject;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_PaintablePointArray;
import java.awt.Color;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;

public class FwiModel {
    public HashMap_Integers<Element> SourceHash = new HashMap_Integers();
    public HashMap_Integers<Element> ReceiverHash = new HashMap_Integers();
    protected String m_srcFileName;
    protected String m_recFileName;
    protected double m_originX = 0.0;
    protected double m_originY = 0.0;
    protected double m_originZ = 0.0;
    protected double m_binSizeHorz = 25.0;
    protected double m_binSizeVert = 25.0;
    protected double m_inlineAngle = 0.0;
    protected int m_numX = 0;
    protected int m_numY = 0;
    protected int m_numZ = 0;
    protected double m_cosineInlineAngle = 0.0;
    protected double m_sineInlineAngle = 0.0;
    protected double m_inverseBinSizeHorz = 1.0;
    protected double m_inverseBinSizeVert = 1.0;
    protected boolean m_forceMarineSurvey;
    protected double m_waterVelocity;
    protected float[][] m_waterBottomElevation;
    protected String m_name = "";
    protected String m_gridFileName;
    protected String m_surfaceFileName;
    protected String m_waterBottomFileName;
    public static final String ModelFileName = "Model.slowness";
    public static final String SurfaceFileName = "Model.surface";
    public static final String WaterBottomFileName = "WaterBottom.surface";
    public static final String ReceiverFileName = "Model.receivers";
    public static final String ShotFileName = "Model.shots";
    public static final String AnisotropyFileName = "Model.anisotropy";
    protected float[][][] m_slowness;
    protected float[][][] m_weight;
    protected float[][][] m_error;
    protected float[][] m_tempPlane1;
    protected float[][] m_tempPlane2;
    protected float[][] m_tempPlane3;
    protected float[][] m_surfaceElevation;
    protected float[][] m_surfaceGridZ;
    protected float[][][] m_slownessCoarse;
    protected float[][][] m_weightCoarse;
    protected float[][][] m_temp1Coarse;
    protected float[][][] m_temp2Coarse;
    protected boolean[][][] m_inAirCoarse;
    protected float[][] m_tempCoarse1;
    protected float[][] m_tempCoarse2;
    protected int m_numCoarseX;
    protected int m_numCoarseY;
    protected String m_historyFileName;
    protected History m_history;
    public double WorldX;
    public double WorldY;
    public double WorldZ;
    public double GridX;
    public double GridY;
    public double GridZ;
    public double FloatIndexX;
    public double FloatIndexY;
    public double FloatIndexZ;
    public int LowerIndexX;
    public int LowerIndexY;
    public int LowerIndexZ;
    public float LowerWeightX;
    public float LowerWeightY;
    public float LowerWeightZ;
    public float UpperWeightX;
    public float UpperWeightY;
    public float UpperWeightZ;
    public boolean LowerIndexValidX;
    public boolean LowerIndexValidY;
    public boolean LowerIndexValidZ;
    public boolean UpperIndexValidX;
    public boolean UpperIndexValidY;
    public boolean UpperIndexValidZ;
    public float InterpolatedGridZ;
    public float InterpolatedElevation;
    public float InterpolatedWaterBottom;
    public float[] InterpolatedSlowness = new float[20];
    public float[] InterpolatedWeight = new float[20];
    public float SlownessAtWorld;
    public boolean OnEdge = false;
    public int EdgeIndexX;
    public int EdgeIndexY;
    public int UpperIndexX;
    public int UpperIndexY;
    public int UpperIndexZ = 0;
    protected int m_coarseRadius;
    protected int m_numValidCoarseX;
    protected int m_numValidCoarseY;
    public boolean PrintCoarseCorner = false;
    public boolean PrintBottomLayer = false;
    protected float m_averageCoarseWeight;
    protected float m_averageWeight;
    public float WeightTime = 1.0f;
    public float MinimumValidTotalWeight = 0.1f;
    protected double[] m_tempVertSlowness = new double[50];
    public double TimeToIntermediateDatum = 0.0;
    public double TimeToFinalDatum = 0.0;
    public double Statics;

    public Element getShotElement(int id) {
        try {
            if (!this.SourceHash.containsKey(id)) {
                this.SourceHash.put(new Element(id), id);
            }
            return this.SourceHash.get(id);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public Element getReceiverElement(int id) {
        try {
            if (!this.ReceiverHash.containsKey(id)) {
                this.ReceiverHash.put(new Element(id), id);
            }
            return this.ReceiverHash.get(id);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public void saveReceiverHash() {
        try {
            this.saveElement(this.ReceiverHash, this.m_recFileName);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void saveSourceHash() {
        try {
            this.saveElement(this.SourceHash, this.m_srcFileName);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public double originZ() {
        return this.m_originZ;
    }

    public double originX() {
        return this.m_originX;
    }

    public double originY() {
        return this.m_originY;
    }

    public double binSizeHorz() {
        return this.m_binSizeHorz;
    }

    public double binSizeVert() {
        return this.m_binSizeVert;
    }

    public double inlineAngle() {
        return this.m_inlineAngle;
    }

    public int numX() {
        return this.m_numX;
    }

    public int numY() {
        return this.m_numY;
    }

    public int numZ() {
        return this.m_numZ;
    }

    public boolean forceMarineSurvey() {
        return this.m_forceMarineSurvey;
    }

    public double waterVelocity() {
        return this.m_waterVelocity;
    }

    public float[][] waterBottomElevation() {
        return this.m_waterBottomElevation;
    }

    public String name() {
        return this.m_name;
    }

    public float[][][] slowness() {
        return this.m_slowness;
    }

    public float[][][] weight() {
        return this.m_weight;
    }

    public float[][][] error() {
        return this.m_error;
    }

    public float[][] surfaceElevation() {
        return this.m_surfaceElevation;
    }

    public float[][] surfaceGridZ() {
        return this.m_surfaceGridZ;
    }

    public FwiModel(String name) throws Exception {
        try {
            this.read(name);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public FwiModel(FwiModel parentModel) throws Exception {
        try {
            this.m_binSizeHorz = parentModel.binSizeHorz();
            this.m_binSizeVert = parentModel.binSizeVert();
            this.m_inlineAngle = parentModel.inlineAngle();
            this.computeInternals();
            this.m_originX = parentModel.originX();
            this.m_originY = parentModel.originY();
            this.m_originZ = parentModel.originZ();
            this.m_numX = parentModel.numX();
            this.m_numY = parentModel.numY();
            this.m_numZ = parentModel.numZ();
            this.m_forceMarineSurvey = parentModel.forceMarineSurvey();
            this.m_waterVelocity = parentModel.waterVelocity();
            this.checkMem();
            float[][] parentElevation = parentModel.surfaceElevation();
            float[][] parentGridZ = parentModel.surfaceGridZ();
            float[][] parentWaterBottom = parentModel.waterBottomElevation();
            for (int x = 0; x < this.m_numX; ++x) {
                for (int y = 0; y < this.m_numY; ++y) {
                    this.m_surfaceElevation[x][y] = parentElevation[x][y];
                    this.m_surfaceGridZ[x][y] = parentGridZ[x][y];
                    this.m_waterBottomElevation[x][y] = parentWaterBottom[x][y];
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void copySlownessFromParent(FwiModel parentModel) throws Exception {
        try {
            float[][][] slowness = parentModel.slowness();
            for (int x = 0; x < this.m_numX; ++x) {
                for (int y = 0; y < this.m_numY; ++y) {
                    for (int z = 0; z < this.m_numZ; ++z) {
                        this.m_slowness[x][y][z] = slowness[x][y][z];
                    }
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void updateParentWeightAndError(FwiModel parentModel) throws Exception {
        try {
            float[][][] weight = parentModel.weight();
            float[][][] error = parentModel.error();
            for (int x = 0; x < this.m_numX; ++x) {
                for (int y = 0; y < this.m_numY; ++y) {
                    for (int z = 0; z < this.m_numZ; ++z) {
                        weight[x][y][z] = weight[x][y][z] + this.m_weight[x][y][z];
                        error[x][y][z] = error[x][y][z] + this.m_error[x][y][z];
                    }
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public FwiModel(double inlineAngle, double maxDepth, double binSizeHorz, double binSizeVert, boolean allocateMemory, boolean forceMarineSurvey, double waterVelocity) throws Exception {
        try {
            this.m_forceMarineSurvey = forceMarineSurvey;
            this.m_waterVelocity = waterVelocity;
            this.m_binSizeHorz = binSizeHorz;
            this.m_binSizeVert = binSizeVert;
            this.m_inlineAngle = inlineAngle;
            this.computeInternals();
            double minGridX = Double.MAX_VALUE;
            double minGridY = Double.MAX_VALUE;
            double minWorldZ = Double.MAX_VALUE;
            double maxWaterDepth = Double.MIN_VALUE;
            for (int loop = 0; loop <= 1; ++loop) {
                Table_Abstract table = RefractionStaticsProject.singleton().receiverTable();
                if (loop == 1) {
                    table = RefractionStaticsProject.singleton().shotTable();
                }
                int indexX = table.column_indexOfColumn("Easting");
                int indexY = table.column_indexOfColumn("Northing");
                int indexZ = table.column_indexOfColumn("Elevation");
                int indexDead = table.column_indexOfColumn("Killed");
                int indexWaterDepth = -9999;
                if (this.m_forceMarineSurvey) {
                    indexWaterDepth = table.column_indexOfColumn("WaterDepth");
                }
                for (int n = 0; n < table.row_count(); ++n) {
                    if (table.getBool(n, indexDead)) continue;
                    double x = table.getDouble(n, indexX);
                    double y = table.getDouble(n, indexY);
                    double z = table.getDouble(n, indexZ);
                    double waterDepth = 0.0;
                    if (this.m_forceMarineSurvey) {
                        z = 0.0;
                        waterDepth = table.getDouble(n, indexWaterDepth);
                        maxWaterDepth = Math.max(maxWaterDepth, waterDepth);
                    } else {
                        z -= 10.0;
                    }
                    this.setWorldLocation(x, y, z, false, false);
                    minGridX = Math.min(minGridX, this.GridX - 10.0);
                    minGridY = Math.min(minGridY, this.GridY - 10.0);
                    minWorldZ = Math.min(minWorldZ, z);
                }
            }
            this.m_originX = this.m_cosineInlineAngle * minGridX - this.m_sineInlineAngle * minGridY;
            this.m_originY = this.m_cosineInlineAngle * minGridY + this.m_sineInlineAngle * minGridX;
            int numMarinesNodes = 0;
            if (this.m_forceMarineSurvey) {
                this.m_originZ = -maxWaterDepth - maxDepth;
                numMarinesNodes = (int)(Math.abs(this.m_originZ) / binSizeVert) + 1;
                this.m_originZ = 0.0 - binSizeVert * (double)(numMarinesNodes - 1);
            } else {
                this.m_originZ = minWorldZ - maxDepth;
                int tempZ = (int)(this.m_originZ / binSizeVert) - 2;
                this.m_originZ = (double)tempZ * binSizeVert;
            }
            int minIndexX = Integer.MAX_VALUE;
            int minIndexY = Integer.MAX_VALUE;
            int maxIndexX = Integer.MIN_VALUE;
            int maxIndexY = Integer.MIN_VALUE;
            int maxIndexZ = Integer.MIN_VALUE;
            for (int loop = 0; loop <= 1; ++loop) {
                Table_Abstract table = RefractionStaticsProject.singleton().receiverTable();
                if (loop == 1) {
                    table = RefractionStaticsProject.singleton().shotTable();
                }
                int indexX = table.column_indexOfColumn("Easting");
                int indexY = table.column_indexOfColumn("Northing");
                int indexZ = table.column_indexOfColumn("Elevation");
                int indexDead = table.column_indexOfColumn("Killed");
                int indexWaterDepth = -9999;
                if (this.m_forceMarineSurvey) {
                    indexWaterDepth = table.column_indexOfColumn("WaterDepth");
                }
                for (int n = 0; n < table.row_count(); ++n) {
                    if (table.getBool(n, indexDead)) continue;
                    double x = table.getDouble(n, indexX);
                    double y = table.getDouble(n, indexY);
                    double z = table.getDouble(n, indexZ);
                    this.setWorldLocation(x, y, false, false);
                    if (!this.LowerIndexValidX) {
                        throw new Exception("LowerIndexValidX == false");
                    }
                    if (!this.LowerIndexValidY) {
                        throw new Exception("LowerIndexValidY == false");
                    }
                    minIndexX = Math.min(minIndexX, this.LowerIndexX);
                    minIndexY = Math.min(minIndexY, this.LowerIndexY);
                    maxIndexX = Math.max(maxIndexX, this.LowerIndexX + 2);
                    maxIndexY = Math.max(maxIndexY, this.LowerIndexY + 1);
                    int nodeZ = (int)((z - this.m_originZ) / this.m_binSizeVert);
                    maxIndexZ = Math.max(maxIndexZ, nodeZ + 1);
                }
            }
            this.m_numX = 1 + maxIndexX - minIndexX;
            this.m_numY = 1 + maxIndexY - minIndexY;
            this.m_numZ = 1 + maxIndexZ;
            if (this.m_forceMarineSurvey) {
                this.m_numZ = numMarinesNodes;
            }
            if (allocateMemory) {
                this.checkMem();
                this.initializeSurface();
                if (this.m_forceMarineSurvey) {
                    this.initializeWaterBottom();
                }
                this.setVelocityGradient(3000.0, 9000.0);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public History getHistory() {
        return this.m_history;
    }

    public void prepWaterVelocity() throws Exception {
        try {
            if (!this.forceMarineSurvey()) {
                return;
            }
            for (int ix = 0; ix < this.m_numX; ++ix) {
                for (int iy = 0; iy < this.m_numY; ++iy) {
                    float depth = this.m_waterBottomElevation[ix][iy];
                    float heightAboveOrigin = (float)((double)(-depth) - this.m_originZ);
                    int index = (int)((double)heightAboveOrigin / this.m_binSizeVert);
                    if (index < 1) {
                        index = 1;
                    }
                    for (int iz = index + 1; iz < this.m_numZ; ++iz) {
                        this.m_slowness[ix][iy][iz] = 1000.0f / (float)this.m_waterVelocity;
                    }
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void initializeWaterBottom() throws Exception {
        try {
            Grid3D grid = Tools_RefractionStaticsProject.getInterpolatedGrid(this.m_binSizeHorz, this.m_binSizeHorz, "WaterDepth", true);
            for (int ix = 0; ix < this.m_numX; ++ix) {
                for (int iy = 0; iy < this.m_numY; ++iy) {
                    float z;
                    this.setGridLocation(ix, iy, 0);
                    this.m_waterBottomElevation[ix][iy] = z = grid.getNearestValue(this.WorldX, this.WorldY, true);
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void initializeSurface() throws Exception {
        try {
            Grid3D surfGrid = Tools_RefractionStaticsProject.getInterpolatedGrid(this.m_binSizeHorz, this.m_binSizeHorz, "Elevation", true);
            for (int ix = 0; ix < this.m_numX; ++ix) {
                for (int iy = 0; iy < this.m_numY; ++iy) {
                    this.setGridLocation(ix, iy, 0);
                    float z = surfGrid.getNearestValue(this.WorldX, this.WorldY, true);
                    if (this.m_forceMarineSurvey) {
                        z = 0.0f;
                    }
                    float gridz = (z - (float)this.m_originZ) * (float)this.m_inverseBinSizeVert;
                    this.m_surfaceElevation[ix][iy] = z;
                    this.m_surfaceGridZ[ix][iy] = gridz;
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public FwiModelProfile createNewProfile() throws Exception {
        try {
            return new FwiModelProfile(this.m_binSizeVert, this.m_originZ, this.m_numZ);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public boolean populateProfile(FwiModelProfile profile, double x1, double y1, double x2, double y2) throws Exception {
        try {
            profile.setEndpoints(x1, y1, x2, y2);
            if (profile.MaxValidX < 1) {
                return false;
            }
            profile.ForceMarineSurvey = this.forceMarineSurvey();
            for (int n = 0; n <= profile.MaxValidX; ++n) {
                this.setWorldLocation(profile.WorldX[n], profile.WorldY[n], true, true);
                profile.WaterBottomZ[n] = -this.InterpolatedWaterBottom;
                profile.GridZ[n] = this.InterpolatedGridZ;
                profile.Elevation[n] = this.InterpolatedElevation;
                for (int iz = 0; iz < this.m_numZ; ++iz) {
                    profile.Slowness[n][iz] = this.InterpolatedSlowness[iz];
                    profile.Weight[n][iz] = this.InterpolatedWeight[iz];
                }
                profile.LowerIndexValidX[n] = this.LowerIndexValidX;
                profile.LowerIndexValidY[n] = this.LowerIndexValidY;
                profile.UpperIndexValidX[n] = this.UpperIndexValidX;
                profile.UpperIndexValidY[n] = this.UpperIndexValidY;
                profile.LowerWeightX[n] = this.LowerWeightX;
                profile.LowerWeightY[n] = this.LowerWeightY;
                profile.UpperWeightX[n] = this.UpperWeightX;
                profile.UpperWeightY[n] = this.UpperWeightY;
                profile.LowerIndexX[n] = this.LowerIndexX;
                profile.LowerIndexY[n] = this.LowerIndexY;
                profile.UpperIndexX[n] = this.UpperIndexX;
                profile.UpperIndexY[n] = this.UpperIndexY;
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void prepCoarse(int radiusX, int radiusZ, boolean useweight, boolean usedistance) {
        try {
            float sumSlow;
            int maxz;
            int minz;
            int maxy;
            int miny;
            int maxx;
            int minx;
            int cx;
            int cz;
            int cy;
            int cx2;
            int cy2;
            int cx3;
            this.m_coarseRadius = Math.max(5, radiusX);
            this.m_numValidCoarseX = this.m_numX / this.m_coarseRadius;
            if (this.m_numX % this.m_coarseRadius != 0) {
                ++this.m_numValidCoarseX;
            }
            this.m_numValidCoarseY = this.m_numY / this.m_coarseRadius;
            if (this.m_numY % this.m_coarseRadius != 0) {
                ++this.m_numValidCoarseY;
            }
            float[] maxWeightZ = new float[this.m_numZ];
            for (int cz2 = 0; cz2 < this.m_numZ; ++cz2) {
                maxWeightZ[cz2] = 0.0f;
            }
            float maxWeight = 0.0f;
            for (cx3 = 0; cx3 < this.m_numValidCoarseX; ++cx3) {
                for (cy2 = 0; cy2 < this.m_numValidCoarseY; ++cy2) {
                    for (int cz3 = 0; cz3 < this.m_numZ; ++cz3) {
                        float sumWeight = 1.0E-20f;
                        float sumSlowness = 0.0f;
                        int numNotInAir = 0;
                        if (cx3 == this.m_numValidCoarseX - 1 && cy2 == this.m_numValidCoarseY / 2) {
                            numNotInAir = 0;
                        }
                        this.m_slownessCoarse[cx3][cy2][cz3] = 0.0f;
                        this.m_weightCoarse[cx3][cy2][cz3] = 1.0E-20f;
                        int minx2 = cx3 * this.m_coarseRadius;
                        int maxx2 = Math.min(minx2 + this.m_coarseRadius - 1, this.m_numX - 1);
                        int miny2 = cy2 * this.m_coarseRadius;
                        int maxy2 = Math.min(miny2 + this.m_coarseRadius - 1, this.m_numY - 1);
                        int minz2 = Math.max(cz3 - radiusZ, 0);
                        int maxz2 = Math.min(cz3 + radiusZ, this.m_numZ - 1);
                        for (int x = minx2; x <= maxx2; ++x) {
                            for (int y = miny2; y <= maxy2; ++y) {
                                for (int z = minz2; z <= maxz2; ++z) {
                                    if (!((float)z <= this.m_surfaceGridZ[x][y])) continue;
                                    ++numNotInAir;
                                    float weight = this.m_weight[x][y][z];
                                    weight = weight * 0.5f / (0.5f + (float)Math.abs(z - cz3));
                                    float slowness = this.m_slowness[x][y][z];
                                    sumSlowness += slowness * weight;
                                    sumWeight += weight;
                                }
                            }
                        }
                        this.m_inAirCoarse[cx3][cy2][cz3] = numNotInAir == 0;
                        this.m_slownessCoarse[cx3][cy2][cz3] = sumSlowness / sumWeight;
                        this.m_weightCoarse[cx3][cy2][cz3] = sumWeight;
                        maxWeightZ[cz3] = Math.max(maxWeightZ[cz3], sumWeight);
                        maxWeight = Math.max(maxWeight, sumWeight);
                    }
                }
            }
            if (this.PrintBottomLayer) {
                System.out.println("===========================================================");
                System.out.println("================    initial           =====================");
                for (cx3 = 0; cx3 < 4; ++cx3) {
                    for (cy2 = 0; cy2 < 4; ++cy2) {
                        String s = String.format("%d  %d   %f   %f", cx3, cy2, Float.valueOf(1.0f / this.m_slownessCoarse[cx3][cy2][0]), Float.valueOf(this.m_weightCoarse[cx3][cy2][0]));
                        System.out.println(s);
                    }
                }
            }
            float minValidWeight = 0.001f * maxWeight;
            boolean keepGoing = true;
            int radH = 5;
            int radZ = 0;
            int maxRadH = Math.max(this.m_numValidCoarseX, this.m_numValidCoarseY);
            while (keepGoing) {
                keepGoing = false;
                for (cx2 = 0; cx2 < this.m_numValidCoarseX; ++cx2) {
                    for (cy = 0; cy < this.m_numValidCoarseY; ++cy) {
                        for (int cz4 = 0; cz4 < this.m_numZ; ++cz4) {
                            this.m_temp1Coarse[cx2][cy][cz4] = this.m_slownessCoarse[cx2][cy][cz4];
                            this.m_temp2Coarse[cx2][cy][cz4] = this.m_weightCoarse[cx2][cy][cz4];
                        }
                    }
                }
                for (cz = 0; cz < this.m_numZ; ++cz) {
                    for (cx = 0; cx < this.m_numValidCoarseX; ++cx) {
                        for (int cy3 = 0; cy3 < this.m_numValidCoarseY; ++cy3) {
                            if (this.m_inAirCoarse[cx][cy3][cz] || !(this.m_weightCoarse[cx][cy3][cz] < minValidWeight)) continue;
                            keepGoing = true;
                            minx = Math.max(cx - radH, 0);
                            maxx = Math.min(cx + radH, this.m_numValidCoarseX - 1);
                            miny = Math.max(cy3 - radH, 0);
                            maxy = Math.min(cy3 + radH, this.m_numValidCoarseY - 1);
                            minz = Math.max(cz - radZ, 0);
                            maxz = Math.min(cz + radZ, this.m_numZ - 1);
                            float sumWeight = 1.0E-20f;
                            sumSlow = 0.0f;
                            int numOkay = 0;
                            for (int x = minx; x <= maxx; ++x) {
                                float wx = 1.5f / (0.5f + (float)Math.abs(x - cx));
                                for (int y = miny; y <= maxy; ++y) {
                                    float wy = 1.5f / (0.5f + (float)Math.abs(y - cy3));
                                    for (int z = minz; z <= maxz; ++z) {
                                        float wz = 1.5f / (0.5f + (float)Math.abs(z - cz));
                                        if (this.m_inAirCoarse[x][y][z] || !(this.m_temp2Coarse[x][y][z] > 0.5f * minValidWeight)) continue;
                                        float w = wx * wy * wz * this.m_temp2Coarse[x][y][z];
                                        float slow = this.m_temp1Coarse[x][y][z];
                                        sumSlow += w * slow;
                                        sumWeight += w;
                                        ++numOkay;
                                    }
                                }
                            }
                            if (numOkay >= 1) {
                                this.m_slownessCoarse[cx][cy3][cz] = sumSlow / sumWeight;
                                this.m_weightCoarse[cx][cy3][cz] = 1.01f * minValidWeight;
                                continue;
                            }
                            this.m_weightCoarse[cx][cy3][cz] = 0.0f;
                        }
                    }
                }
                if ((radH += 5) < maxRadH) continue;
                radH = 10;
                ++radZ;
            }
            if (this.PrintBottomLayer) {
                System.out.println("===========================================================");
                System.out.println("================    after filling dead    =================");
                for (cx2 = 0; cx2 < 4; ++cx2) {
                    for (cy = 0; cy < 4; ++cy) {
                        String s = String.format("%d  %d   %f   %f", cx2, cy, Float.valueOf(1.0f / this.m_slownessCoarse[cx2][cy][0]), Float.valueOf(this.m_weightCoarse[cx2][cy][0]));
                        System.out.println(s);
                    }
                }
            }
            for (cz = 0; cz < this.m_numZ; ++cz) {
                for (cx = 0; cx < this.m_numValidCoarseX; ++cx) {
                    for (int cy4 = 0; cy4 < this.m_numValidCoarseY; ++cy4) {
                        if (this.m_inAirCoarse[cx][cy4][cz]) continue;
                        minx = Math.max(cx - 2, 0);
                        maxx = Math.min(cx + 2, this.m_numValidCoarseX - 1);
                        miny = Math.max(cy4 - 2, 0);
                        maxy = Math.min(cy4 + 2, this.m_numValidCoarseY - 1);
                        minz = Math.max(cz - 0, 0);
                        maxz = Math.min(cz + 0, this.m_numZ - 1);
                        float sumWeight = 1.0E-20f;
                        sumSlow = 0.0f;
                        for (int x = minx; x <= maxx; ++x) {
                            float wx = 0.5f / (0.5f + (float)Math.abs(x - cx));
                            for (int y = miny; y <= maxy; ++y) {
                                float wy = 0.5f / (0.5f + (float)Math.abs(y - cy4));
                                for (int z = minz; z <= maxz; ++z) {
                                    float wz = 0.5f / (0.5f + (float)Math.abs(z - cz));
                                    if (this.m_inAirCoarse[x][y][z]) continue;
                                    float w = wx * wy * wz * this.m_weightCoarse[x][y][z];
                                    float slow = this.m_slownessCoarse[x][y][z];
                                    sumSlow += w * slow;
                                    sumWeight += w;
                                }
                            }
                        }
                        this.m_temp1Coarse[cx][cy4][cz] = sumSlow / sumWeight;
                        this.m_temp2Coarse[cx][cy4][cz] = sumWeight;
                    }
                }
            }
            double sumWeight = 0.0;
            for (int cz5 = 0; cz5 < this.m_numZ; ++cz5) {
                for (int cx4 = 0; cx4 < this.m_numValidCoarseX; ++cx4) {
                    for (int cy5 = 0; cy5 < this.m_numValidCoarseY; ++cy5) {
                        float weight = (float)Math.sqrt(this.m_temp2Coarse[cx4][cy5][cz5]);
                        sumWeight += (double)weight;
                        this.m_slownessCoarse[cx4][cy5][cz5] = this.m_temp1Coarse[cx4][cy5][cz5];
                        this.m_weightCoarse[cx4][cy5][cz5] = weight;
                    }
                }
            }
            this.m_averageCoarseWeight = (float)(sumWeight / (double)(this.m_numZ * this.m_numValidCoarseX * this.m_numValidCoarseY));
            if (this.PrintBottomLayer) {
                System.out.println("===========================================================");
                System.out.println("================    after smoothing   =====================");
                for (int cx5 = 0; cx5 < 4; ++cx5) {
                    for (int cy6 = 0; cy6 < 4; ++cy6) {
                        String s = String.format("%d  %d   %f   %f", cx5, cy6, Float.valueOf(1.0f / this.m_slownessCoarse[cx5][cy6][0]), Float.valueOf(this.m_weightCoarse[cx5][cy6][0]));
                        System.out.println(s);
                    }
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void smooth(int radiusX, int radiusZ, boolean useweight, boolean usedistance) {
        try {
            int z;
            int y;
            int x;
            this.prepCoarse(radiusX, radiusZ, useweight, usedistance);
            double sumWeight = 0.0;
            for (int x2 = 0; x2 < this.m_numX; ++x2) {
                for (int y2 = 0; y2 < this.m_numY; ++y2) {
                    for (int z2 = 0; z2 < this.m_numZ; ++z2) {
                        sumWeight += (double)this.m_weight[x2][y2][z2];
                    }
                }
            }
            this.m_averageWeight = (float)(sumWeight / (double)(this.m_numX * this.m_numY * this.m_numZ));
            float scalar = this.m_averageWeight / this.m_averageCoarseWeight;
            float fractionCoarse = 0.5f;
            for (x = 0; x < this.m_numX; ++x) {
                for (y = 0; y < this.m_numY; ++y) {
                    for (z = 0; z < this.m_numZ; ++z) {
                        int cx = x / this.m_coarseRadius;
                        int cy = y / this.m_coarseRadius;
                        float coarseWeight = scalar * this.m_weightCoarse[cx][cy][z];
                        float coarseSlow = this.m_slownessCoarse[cx][cy][z];
                        float fineWeight = this.m_weight[x][y][z];
                        float fineSlow = this.m_slowness[x][y][z];
                        coarseWeight = fractionCoarse * coarseWeight;
                        fineWeight = (1.0f - fractionCoarse) * fineWeight;
                        float slow = (coarseWeight * coarseSlow + fineWeight * fineSlow) / (coarseWeight + fineWeight);
                        this.m_weight[x][y][z] = coarseWeight + fineWeight;
                        this.m_error[x][y][z] = slow;
                    }
                }
            }
            for (x = 0; x < this.m_numX; ++x) {
                for (y = 0; y < this.m_numY; ++y) {
                    for (z = 0; z < this.m_numZ; ++z) {
                        float sum1 = 0.0f;
                        float sum2 = 1.0E-20f;
                        int minx = Math.max(x - radiusX, 0);
                        int maxx = Math.min(x + radiusX, this.m_numX - 1);
                        int miny = Math.max(y - radiusX, 0);
                        int maxy = Math.min(y + radiusX, this.m_numY - 1);
                        int minz = Math.max(z - 0, 0);
                        int maxz = Math.min(z + 0, this.m_numZ - 1);
                        for (int ix = minx; ix <= maxx; ++ix) {
                            float wx = 0.5f / (0.5f + (float)Math.abs(ix - x));
                            for (int iy = miny; iy <= maxy; ++iy) {
                                float wy = 0.5f / (0.5f + (float)Math.abs(iy - y));
                                for (int iz = minz; iz <= maxz; ++iz) {
                                    float wz = 0.5f / (0.5f + (float)Math.abs(iz - z));
                                    float w = wx * wy * wz * this.m_weight[ix][iy][iz];
                                    float s = this.m_error[ix][iy][iz];
                                    sum1 += s * w;
                                    sum2 += w;
                                }
                            }
                        }
                        this.m_slowness[x][y][z] = sum1 / sum2;
                    }
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void smoothPlane(int z, int radius, boolean useweight, boolean usedistance) {
        try {
            for (int x = 0; x < this.m_numX; ++x) {
                for (int y = 0; y < this.m_numY; ++y) {
                    this.m_tempPlane1[x][y] = this.m_slowness[x][y][z];
                    this.m_tempPlane2[x][y] = 1.0E-7f + this.m_weight[x][y][z];
                }
            }
            boolean test = false;
            for (int x = 0; x < this.m_numX; ++x) {
                for (int y = 0; y < this.m_numY; ++y) {
                    int minx = Math.max(x - radius, 0);
                    int maxx = Math.min(x + radius, this.m_numX - 1);
                    int miny = Math.max(y - radius, 0);
                    int maxy = Math.min(y + radius, this.m_numY - 1);
                    if (x == 30 && y == 30) {
                        test = true;
                    }
                    double s1 = 0.0;
                    double s2 = 1.0E-10;
                    for (int ix = minx; ix <= maxx; ++ix) {
                        for (int iy = miny; iy <= maxy; ++iy) {
                            double w = 1.0;
                            if (useweight) {
                                w = this.m_tempPlane2[ix][iy];
                            }
                            if (usedistance) {
                                float dx = Math.abs(x - ix);
                                float dy = Math.abs(y - iy);
                                w /= (double)(1.0f + dx + dy);
                            }
                            s1 += w * (double)this.m_tempPlane1[ix][iy];
                            s2 += w;
                        }
                    }
                    this.m_slowness[x][y][z] = (float)(s1 / s2);
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public Grid3D getEmptyGrid3D() throws Exception {
        try {
            Grid3D_Conversion gc = new Grid3D_Conversion();
            gc.setBinSize(this.m_binSizeHorz, this.m_binSizeHorz);
            gc.setInlineAngle(this.m_inlineAngle);
            gc.setOrigin(this.m_originX, this.m_originY);
            gc.setBinCounts(this.m_numX, this.m_numY);
            Grid3D grid = new Grid3D(gc);
            return grid;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public Grid3D getWaterBottomGrid3D() throws Exception {
        try {
            Grid3D grid = this.getEmptyGrid3D();
            float[][] data = grid.data();
            for (int ix = 0; ix < this.m_numX; ++ix) {
                for (int iy = 0; iy < this.m_numY; ++iy) {
                    data[ix][iy] = this.m_waterBottomElevation[ix][iy];
                }
            }
            return grid;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public Grid3D getSurfaceGrid3D() throws Exception {
        try {
            Grid3D grid = this.getEmptyGrid3D();
            float[][] data = grid.data();
            for (int ix = 0; ix < this.m_numX; ++ix) {
                for (int iy = 0; iy < this.m_numY; ++iy) {
                    data[ix][iy] = this.m_surfaceElevation[ix][iy];
                }
            }
            return grid;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    protected float velAtDepth(float depth, int ix, int iy) {
        try {
            int maxIndex = (int)this.m_surfaceGridZ[ix][iy];
            float z = this.m_surfaceElevation[ix][iy] - depth;
            float indexFloat = (z -= (float)this.m_originZ) * (float)this.m_inverseBinSizeVert;
            int index = (int)indexFloat;
            float[] slowness = this.m_slowness[ix][iy];
            if (index >= maxIndex) {
                return 1000.0f / slowness[maxIndex];
            }
            if (indexFloat <= 0.0f) {
                return 1000.0f / slowness[0];
            }
            if (index >= 0 && index < maxIndex) {
                float frac = indexFloat - (float)index;
                float v1 = 1000.0f / slowness[index];
                float v2 = 1000.0f / slowness[index + 1];
                float v = frac * v2 + (1.0f - frac) * v1;
                return v;
            }
            return -9999.0f;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return 0.0f;
        }
    }

    public void computeWeatheringVelocity(float depth, boolean updateZ) throws Exception {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            int numDead = 0;
            numDead += this.computeWeatheringVelocity(p.shotTable(), depth);
            if ((numDead += this.computeWeatheringVelocity(p.receiverTable(), depth)) > 0) {
                Tools_RefractionStaticsProject tools = new Tools_RefractionStaticsProject();
                tools.interpolateBadValuesUsingInverseFourth(Pecos.getColNameVel(0), 100.0, 20000.0);
            }
            p.geometryDatabase().writeColumnContentsToDatabase(p.receiverTable(), Pecos.getColNameVel(0));
            p.geometryDatabase().writeColumnContentsToDatabase(p.shotTable(), Pecos.getColNameVel(0));
            RefractionStaticsProject.delayTimeData().getHistory().addWithTime("Set weathering velocity using tomo model");
            RefractionStaticsProject.delayTimeData().getHistory().save();
            if (updateZ) {
                DelayTimeModel.singleton().computeRefractorElevations(p.receiverTable());
                DelayTimeModel.singleton().computeRefractorElevations(p.shotTable());
                RefractionStaticsProject.delayTimeData().getHistory().addWithTime("Recompute refractor elevations");
                RefractionStaticsProject.delayTimeData().getHistory().save();
            }
            try {
                this.getHistory().addWithTime("Computed weathering velocity:");
                this.getHistory().add("Depth = " + Double.toString(depth));
                this.getHistory().add("Update refractor elevation = " + Boolean.toString(updateZ));
                this.getHistory().save();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public int computeWeatheringVelocity(Table_Abstract table, float depth) {
        try {
            int indexDead = table.column_indexOfColumn("Killed");
            int indexV0 = table.column_indexOfColumn(Pecos.getColNameVel(0));
            int indexV1 = table.column_indexOfColumn(Pecos.getColNameVel(1));
            int indexX = table.column_indexOfColumn("Easting");
            int indexY = table.column_indexOfColumn("Northing");
            int indexZ = table.column_indexOfColumn("Elevation");
            int numDead = 0;
            for (int n = 0; n < table.row_count(); ++n) {
                if (table.getBool(n, indexDead)) {
                    table.putDouble(n, indexV0, -9999.0);
                    ++numDead;
                    continue;
                }
                double x = table.getDouble(n, indexX);
                double y = table.getDouble(n, indexY);
                double z = table.getDouble(n, indexZ);
                this.setWorldLocation(x, y, z - (double)depth, true, true);
                double v0 = 1000.0 / (double)Math.max(this.SlownessAtWorld, 1.0E-4f);
                double v1 = table.getDouble(n, indexV1);
                v0 = Math.min(v0, 0.8 * v1);
                v0 = Math.max(v0, 0.15 * v1);
                table.putDouble(n, indexV0, v0);
            }
            return numDead;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return 0;
        }
    }

    public Grid3D getVelocityAtDepthGrid3D(float depth) throws Exception {
        try {
            Grid3D grid = this.getEmptyGrid3D();
            float[][] data = grid.data();
            for (int ix = 0; ix < this.m_numX; ++ix) {
                for (int iy = 0; iy < this.m_numY; ++iy) {
                    data[ix][iy] = this.velAtDepth(depth, ix, iy);
                }
            }
            grid.smooth(2);
            return grid;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public Grid3D getVelocityAtElevationGrid3D(int z) throws Exception {
        try {
            Grid3D grid = this.getEmptyGrid3D();
            float[][] data = grid.data();
            z = Math.max(z, 0);
            z = Math.min(z, this.m_numZ - 1);
            for (int ix = 0; ix < this.m_numX; ++ix) {
                for (int iy = 0; iy < this.m_numY; ++iy) {
                    data[ix][iy] = 1000.0f / this.m_slowness[ix][iy][z];
                }
            }
            grid.smooth(2);
            return grid;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public Grid3D getWeightAtElevationGrid3D(int z) throws Exception {
        try {
            Grid3D grid = this.getEmptyGrid3D();
            float[][] data = grid.data();
            z = Math.max(z, 0);
            z = Math.min(z, this.m_numZ - 1);
            for (int ix = 0; ix < this.m_numX; ++ix) {
                for (int iy = 0; iy < this.m_numY; ++iy) {
                    data[ix][iy] = this.m_weight[ix][iy][z];
                }
            }
            grid.smooth(2);
            return grid;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void read(String modelName) {
        try {
            this.m_name = modelName;
            String fwiPath = RefractionStaticsProject.singleton().fwi3DProjectsPath();
            String fullPath = fwiPath + "/" + modelName;
            this.m_gridFileName = fullPath + "/Model.slowness";
            this.m_surfaceFileName = fullPath + "/Model.surface";
            this.m_waterBottomFileName = fullPath + "/WaterBottom.surface";
            RandomAccessFile raf = new RandomAccessFile(this.m_gridFileName, "rw");
            int magic = raf.readInt();
            int version = raf.readInt();
            if (magic != 8300129) {
                raf.close();
                return;
            }
            if (version == 1001) {
                this.m_forceMarineSurvey = raf.readBoolean();
                this.m_waterVelocity = raf.readDouble();
            }
            if (version == 1000 || version == 1001) {
                int y;
                int x;
                int n;
                int z;
                this.m_originX = raf.readDouble();
                this.m_originY = raf.readDouble();
                this.m_originZ = raf.readDouble();
                this.m_binSizeHorz = raf.readDouble();
                this.m_binSizeVert = raf.readDouble();
                this.m_inlineAngle = raf.readDouble();
                this.m_numX = raf.readInt();
                this.m_numY = raf.readInt();
                this.m_numZ = raf.readInt();
                this.checkMem();
                this.computeInternals();
                int num = 4 * this.m_numX * this.m_numY;
                ByteBuffer ba = ByteBuffer_Shared.buffer(0, num);
                for (z = 0; z < this.m_numZ; ++z) {
                    raf.read(ba.array(), 0, num);
                    n = 0;
                    for (x = 0; x < this.m_numX; ++x) {
                        for (y = 0; y < this.m_numY; ++y) {
                            this.m_slowness[x][y][z] = ba.getFloat(n);
                            n += 4;
                        }
                    }
                }
                for (z = 0; z < this.m_numZ; ++z) {
                    raf.read(ba.array(), 0, num);
                    n = 0;
                    for (x = 0; x < this.m_numX; ++x) {
                        for (y = 0; y < this.m_numY; ++y) {
                            this.m_weight[x][y][z] = ba.getFloat(n);
                            n += 4;
                        }
                    }
                }
                for (z = 0; z < this.m_numZ; ++z) {
                    raf.read(ba.array(), 0, num);
                    n = 0;
                    for (x = 0; x < this.m_numX; ++x) {
                        for (y = 0; y < this.m_numY; ++y) {
                            this.m_error[x][y][z] = ba.getFloat(n);
                            n += 4;
                        }
                    }
                }
            }
            raf.close();
            if (Tools_FileSystem.exists_file(this.m_waterBottomFileName)) {
                raf = new RandomAccessFile(this.m_waterBottomFileName, "rw");
                magic = raf.readInt();
                version = raf.readInt();
                if (magic != 5537222) {
                    raf.close();
                    return;
                }
                if (version == 1000) {
                    this.readGrid(raf, this.m_waterBottomElevation);
                }
                raf.close();
            }
            raf = new RandomAccessFile(this.m_surfaceFileName, "rw");
            magic = raf.readInt();
            version = raf.readInt();
            if (magic != 334534534) {
                raf.close();
                return;
            }
            if (version == 1000) {
                this.readGrid(raf, this.m_surfaceElevation);
                this.readGrid(raf, this.m_surfaceGridZ);
            }
            raf.close();
            this.m_srcFileName = fullPath + "/Model.shots";
            this.m_recFileName = fullPath + "/Model.receivers";
            this.readElement(this.ReceiverHash, this.m_recFileName);
            this.readElement(this.SourceHash, this.m_srcFileName);
            this.m_historyFileName = fullPath + "/History.txt";
            this.m_history = new History(this.m_historyFileName);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void save(String modelName) {
        try {
            this.m_name = modelName;
            String fwiPath = RefractionStaticsProject.singleton().fwi3DProjectsPath();
            Object fullPath = fwiPath + "/" + modelName;
            Tools_FileSystem.deletePathIfExists((String)fullPath);
            fullPath = Tools_FileSystem.confirmSubDirectoryExists(fwiPath, modelName);
            this.m_gridFileName = (String)fullPath + "/Model.slowness";
            this.m_surfaceFileName = (String)fullPath + "/Model.surface";
            this.m_waterBottomFileName = (String)fullPath + "/WaterBottom.surface";
            RandomAccessFile raf = new RandomAccessFile(this.m_gridFileName, "rw");
            int magic = 8300129;
            int version = 1001;
            raf.writeInt(magic);
            raf.writeInt(version);
            if (version == 1001) {
                raf.writeBoolean(this.m_forceMarineSurvey);
                raf.writeDouble(this.m_waterVelocity);
            }
            if (version == 1000 || version == 1001) {
                int y;
                int x;
                int n;
                int z;
                raf.writeDouble(this.m_originX);
                raf.writeDouble(this.m_originY);
                raf.writeDouble(this.m_originZ);
                raf.writeDouble(this.m_binSizeHorz);
                raf.writeDouble(this.m_binSizeVert);
                raf.writeDouble(this.m_inlineAngle);
                raf.writeInt(this.m_numX);
                raf.writeInt(this.m_numY);
                raf.writeInt(this.m_numZ);
                int num = 4 * this.m_numX * this.m_numY;
                ByteBuffer ba = ByteBuffer_Shared.buffer(0, num);
                for (z = 0; z < this.m_numZ; ++z) {
                    n = 0;
                    for (x = 0; x < this.m_numX; ++x) {
                        for (y = 0; y < this.m_numY; ++y) {
                            ba.putFloat(n, this.m_slowness[x][y][z]);
                            n += 4;
                        }
                    }
                    raf.write(ba.array(), 0, num);
                }
                for (z = 0; z < this.m_numZ; ++z) {
                    n = 0;
                    for (x = 0; x < this.m_numX; ++x) {
                        for (y = 0; y < this.m_numY; ++y) {
                            ba.putFloat(n, this.m_weight[x][y][z]);
                            n += 4;
                        }
                    }
                    raf.write(ba.array(), 0, num);
                }
                for (z = 0; z < this.m_numZ; ++z) {
                    n = 0;
                    for (x = 0; x < this.m_numX; ++x) {
                        for (y = 0; y < this.m_numY; ++y) {
                            ba.putFloat(n, this.m_error[x][y][z]);
                            n += 4;
                        }
                    }
                    raf.write(ba.array(), 0, num);
                }
            }
            raf.close();
            raf = new RandomAccessFile(this.m_waterBottomFileName, "rw");
            magic = 5537222;
            version = 1000;
            raf.writeInt(magic);
            raf.writeInt(version);
            if (version == 1000) {
                this.saveGrid(raf, this.m_waterBottomElevation);
            }
            raf.close();
            raf = new RandomAccessFile(this.m_surfaceFileName, "rw");
            magic = 334534534;
            version = 1000;
            raf.writeInt(magic);
            raf.writeInt(version);
            if (version == 1000) {
                this.saveGrid(raf, this.m_surfaceElevation);
                this.saveGrid(raf, this.m_surfaceGridZ);
            }
            raf.close();
            this.m_srcFileName = (String)fullPath + "/Model.shots";
            this.m_recFileName = (String)fullPath + "/Model.receivers";
            this.saveElement(this.ReceiverHash, this.m_recFileName);
            this.saveElement(this.SourceHash, this.m_srcFileName);
            this.m_historyFileName = (String)fullPath + "/History.txt";
            if (this.getHistory() == null) {
                this.m_history = new History(this.m_historyFileName);
                this.getHistory().addWithTime("Model created");
                this.getHistory().save();
            } else {
                this.getHistory().save();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void readElement(HashMap_Integers<Element> hash, String fileName) {
        try {
            hash.clear();
            if (!Tools_FileSystem.exists_file(fileName)) {
                return;
            }
            RandomAccessFile raf = new RandomAccessFile(fileName, "rw");
            int magic = raf.readInt();
            if (magic != 244) {
                return;
            }
            int version = raf.readInt();
            int count = raf.readInt();
            for (int n = 0; n < count; ++n) {
                Element e = new Element(raf, version);
                hash.put(e, e.ID);
            }
            raf.close();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void saveElement(HashMap_Integers<Element> hash, String fileName) {
        try {
            RandomAccessFile raf = new RandomAccessFile(fileName, "rw");
            int magic = 244;
            int version = 1000;
            raf.writeInt(magic);
            raf.writeInt(version);
            raf.writeInt(hash.size());
            for (Element e : hash.getValues()) {
                e.save(raf, version);
            }
            raf.close();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void saveGrid(RandomAccessFile raf, float[][] grid) {
        try {
            int num = 4 * this.m_numX * this.m_numY;
            ByteBuffer ba = ByteBuffer_Shared.buffer(0, num);
            int i = 0;
            for (int ix = 0; ix < this.m_numX; ++ix) {
                for (int iy = 0; iy < this.m_numY; ++iy) {
                    ba.putFloat(i, grid[ix][iy]);
                    i += 4;
                }
            }
            raf.write(ba.array(), 0, num);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void readGrid(RandomAccessFile raf, float[][] grid) {
        try {
            int num = 4 * this.m_numX * this.m_numY;
            ByteBuffer ba = ByteBuffer_Shared.buffer(0, num);
            raf.read(ba.array(), 0, num);
            int i = 0;
            for (int ix = 0; ix < this.m_numX; ++ix) {
                for (int iy = 0; iy < this.m_numY; ++iy) {
                    grid[ix][iy] = ba.getFloat(i);
                    i += 4;
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void checkMem() {
        try {
            if (this.m_slowness == null) {
                this.m_slowness = new float[this.m_numX][this.m_numY][this.m_numZ];
                this.m_weight = new float[this.m_numX][this.m_numY][this.m_numZ];
                this.m_error = new float[this.m_numX][this.m_numY][this.m_numZ];
                this.m_waterBottomElevation = new float[this.m_numX][this.m_numY];
                this.m_surfaceElevation = new float[this.m_numX][this.m_numY];
                this.m_surfaceGridZ = new float[this.m_numX][this.m_numY];
                this.InterpolatedSlowness = new float[this.m_numZ];
                this.InterpolatedWeight = new float[this.m_numZ];
                this.m_tempPlane1 = new float[this.m_numX][this.m_numY];
                this.m_tempPlane2 = new float[this.m_numX][this.m_numY];
                this.m_tempPlane3 = new float[this.m_numX][this.m_numY];
                this.m_numCoarseX = 1 + this.m_numX / 5;
                this.m_numCoarseY = 1 + this.m_numY / 5;
                this.m_slownessCoarse = new float[this.m_numCoarseX][this.m_numCoarseY][this.m_numZ];
                this.m_weightCoarse = new float[this.m_numCoarseX][this.m_numCoarseY][this.m_numZ];
                this.m_temp1Coarse = new float[this.m_numCoarseX][this.m_numCoarseY][this.m_numZ];
                this.m_temp2Coarse = new float[this.m_numCoarseX][this.m_numCoarseY][this.m_numZ];
                this.m_inAirCoarse = new boolean[this.m_numCoarseX][this.m_numCoarseY][this.m_numZ];
                this.m_tempCoarse1 = new float[this.m_numCoarseX][this.m_numCoarseY];
                this.m_tempCoarse2 = new float[this.m_numCoarseX][this.m_numCoarseY];
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void forceIncreasingVelocity(float frac) {
        try {
            frac = 1.0f / frac;
            for (int x = 0; x < this.m_numX; ++x) {
                for (int y = 0; y < this.m_numY; ++y) {
                    int maxIndex = (int)this.m_surfaceGridZ[x][y];
                    for (int z = maxIndex = Math.min(maxIndex, this.m_numZ - 1); z >= 1; --z) {
                        this.m_slowness[x][y][z - 1] = Math.min(this.m_slowness[x][y][z - 1], frac * this.m_slowness[x][y][z]);
                    }
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void prepareAirSlowness() {
        try {
            for (int x = 0; x < this.m_numX; ++x) {
                for (int y = 0; y < this.m_numY; ++y) {
                    int maxIndex = (int)this.m_surfaceGridZ[x][y];
                    if ((maxIndex = Math.min(maxIndex, this.m_numZ - 1)) + 1 < this.m_numZ) {
                        this.m_slowness[x][y][maxIndex + 1] = this.m_slowness[x][y][maxIndex];
                    }
                    for (int z = maxIndex + 2; z < this.m_numZ; ++z) {
                        this.m_slowness[x][y][z] = 1.1f * this.m_slowness[x][y][maxIndex];
                    }
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void computeVelocityUsingPicks(int method) throws Exception {
        try {
            this.checkMem();
            TomoInteractiveModel_PickCollection pc = RefractionStaticsProject.singleton().tomoInteractiveModel_PickCollection();
            double depth = this.m_binSizeVert * (double)(this.m_numZ - 1);
            double inc = 0.25 * this.m_binSizeVert;
            pc.prepTempData(depth, inc);
            double[] vel = new double[this.m_numZ];
            for (int ix = 0; ix < this.m_numX; ++ix) {
                for (int iy = 0; iy < this.m_numY; ++iy) {
                    this.setGridLocation(ix, iy, 0);
                    if (method == 1) {
                        float[] slowness = this.m_slowness[ix][iy];
                        pc.computeElevationProfile(this.WorldX, this.WorldY, this.m_originZ, this.m_binSizeVert, vel);
                        for (int iz = 0; iz < this.m_numZ; ++iz) {
                            slowness[iz] = (float)(1000.0 / vel[iz]);
                        }
                    }
                    if (method != 0) continue;
                    pc.computeInterpolatedProfile(this.WorldX, this.WorldY);
                    double[] v = pc.TempProfile;
                    double delta = pc.tempSize();
                    float[] slowness = this.m_slowness[ix][iy];
                    for (int iz = 0; iz < this.m_numZ; ++iz) {
                        int index;
                        double binDepth = (double)(this.m_surfaceGridZ[ix][iy] - (float)iz) * this.m_binSizeVert;
                        slowness[iz] = binDepth <= 0.0 ? (float)(1000.0 / v[0]) : ((index = (int)(binDepth / inc)) < v.length ? (float)(1000.0 / v[index]) : (float)(1000.0 / v[v.length - 1]));
                    }
                }
            }
            this.prepareAirSlowness();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setVelocityGradient(double v1, double v2) throws Exception {
        try {
            this.checkMem();
            if (this.m_forceMarineSurvey) {
                v1 = Math.max(v1, 1.2 * this.m_waterVelocity);
            }
            v2 = Math.max(v2, 1.2 * v1);
            for (int x = 0; x < this.m_numX; ++x) {
                for (int y = 0; y < this.m_numY; ++y) {
                    int maxIndex = (int)this.m_surfaceGridZ[x][y];
                    maxIndex = Math.min(maxIndex, this.m_numZ - 1);
                    double alpha = (v1 - v2) / (double)this.m_surfaceGridZ[x][y];
                    for (int z = 0; z < this.m_numZ; ++z) {
                        double v = alpha * (double)z + v2;
                        this.m_slowness[x][y][z] = (float)(1000.0 / v);
                    }
                }
            }
            for (int z = 0; z < this.m_numZ; ++z) {
                this.smoothPlane(z, 5, false, false);
            }
            this.prepareAirSlowness();
            this.prepWaterVelocity();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void computeInternals() {
        try {
            this.m_cosineInlineAngle = Math.cos(this.m_inlineAngle);
            this.m_sineInlineAngle = Math.sin(this.m_inlineAngle);
            this.m_binSizeHorz = Math.max(1.0, this.m_binSizeHorz);
            this.m_binSizeVert = Math.max(1.0, this.m_binSizeVert);
            this.m_inverseBinSizeHorz = 1.0 / this.m_binSizeHorz;
            this.m_inverseBinSizeVert = 1.0 / this.m_binSizeVert;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public Java2D_PaintablePointArray createPointArray() {
        try {
            int num = this.m_numX * this.m_numY;
            Java2D_PaintablePointArray pa = new Java2D_PaintablePointArray();
            pa.setLength(num);
            int n = 0;
            for (int x = 0; x < this.m_numX; ++x) {
                for (int y = 0; y < this.m_numY; ++y) {
                    this.setGridLocation(x, y, 0);
                    pa.setX(n, this.WorldX);
                    pa.setY(n, this.WorldY);
                    ++n;
                }
            }
            pa.UseColorScale = false;
            pa.SymbolColor = new Color(255, 111, 111, 128);
            pa.SymbolSize = 3;
            return pa;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    public void setGridLocation(int indexX, int indexY, int indexZ) {
        try {
            this.GridX = (double)indexX * this.m_binSizeHorz;
            this.GridY = (double)indexY * this.m_binSizeHorz;
            this.GridZ = (double)indexY * this.m_binSizeVert;
            this.WorldX = this.m_originX + this.m_cosineInlineAngle * this.GridX - this.m_sineInlineAngle * this.GridY;
            this.WorldY = this.m_originY + this.m_cosineInlineAngle * this.GridY + this.m_sineInlineAngle * this.GridX;
            this.WorldZ = this.m_originZ + this.GridZ;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void computeStatics(double x, double y, double z, double intDatum, double finalDatum, double repVel) {
        try {
            this.TimeToFinalDatum = 1000.0 * (finalDatum - intDatum) / repVel;
            this.setWorldLocation(x, y, true, true);
            this.TimeToIntermediateDatum = 0.0;
            if (z > intDatum) {
                int n;
                int num = this.m_tempVertSlowness.length;
                double dz = (z - intDatum) / (double)num;
                for (n = 0; n < num; ++n) {
                    double worldZ = z - dz * (double)n;
                    double gridZ = worldZ - this.m_originZ;
                    double floatIndexZ = gridZ * this.m_inverseBinSizeVert;
                    floatIndexZ = Math.max(floatIndexZ, 1.0E-6);
                    floatIndexZ = Math.min(floatIndexZ, (double)this.m_numZ - 1.0E-5);
                    int indexZ = (int)floatIndexZ;
                    double fracZ = floatIndexZ - (double)indexZ;
                    double s1 = 0.0;
                    double s2 = 1.0E-20;
                    s1 += (double)(this.m_slowness[this.LowerIndexX][this.LowerIndexY][indexZ] * this.LowerWeightX * this.LowerWeightY) * (1.0 - fracZ);
                    s1 += (double)(this.m_slowness[this.LowerIndexX][this.UpperIndexY][indexZ] * this.LowerWeightX * this.UpperWeightY) * (1.0 - fracZ);
                    s1 += (double)(this.m_slowness[this.UpperIndexX][this.UpperIndexY][indexZ] * this.UpperWeightX * this.UpperWeightY) * (1.0 - fracZ);
                    s1 += (double)(this.m_slowness[this.UpperIndexX][this.LowerIndexY][indexZ] * this.UpperWeightX * this.LowerWeightY) * (1.0 - fracZ);
                    s2 += (double)(this.LowerWeightX * this.LowerWeightY) * (1.0 - fracZ);
                    s2 += (double)(this.LowerWeightX * this.UpperWeightY) * (1.0 - fracZ);
                    s2 += (double)(this.UpperWeightX * this.UpperWeightY) * (1.0 - fracZ);
                    s2 += (double)(this.UpperWeightX * this.LowerWeightY) * (1.0 - fracZ);
                    if (indexZ < this.m_numZ - 1) {
                        s1 += (double)(this.m_slowness[this.LowerIndexX][this.LowerIndexY][indexZ + 1] * this.LowerWeightX * this.LowerWeightY) * fracZ;
                        s1 += (double)(this.m_slowness[this.LowerIndexX][this.UpperIndexY][indexZ + 1] * this.LowerWeightX * this.UpperWeightY) * fracZ;
                        s1 += (double)(this.m_slowness[this.UpperIndexX][this.UpperIndexY][indexZ + 1] * this.UpperWeightX * this.UpperWeightY) * fracZ;
                        s1 += (double)(this.m_slowness[this.UpperIndexX][this.LowerIndexY][indexZ + 1] * this.UpperWeightX * this.LowerWeightY) * fracZ;
                        s2 += (double)(this.LowerWeightX * this.LowerWeightY) * fracZ;
                        s2 += (double)(this.LowerWeightX * this.UpperWeightY) * fracZ;
                        s2 += (double)(this.UpperWeightX * this.UpperWeightY) * fracZ;
                        s2 += (double)(this.UpperWeightX * this.LowerWeightY) * fracZ;
                    }
                    this.m_tempVertSlowness[n] = s1 / s2;
                }
                for (n = 1; n < num; ++n) {
                    double avg = 0.5 * (this.m_tempVertSlowness[n - 1] + this.m_tempVertSlowness[n]);
                    this.TimeToIntermediateDatum += avg * dz;
                }
            }
            this.Statics = this.TimeToFinalDatum - this.TimeToIntermediateDatum;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setWorldLocation(double worldX, double worldY, double worldZ, boolean fixEdgeIndices, boolean interpolateGrids) throws Exception {
        try {
            double dz;
            this.setWorldLocation(worldX, worldY, fixEdgeIndices, interpolateGrids);
            this.WorldZ = worldZ;
            this.GridZ = dz = worldZ - this.m_originZ;
            this.FloatIndexZ = this.GridZ * this.m_inverseBinSizeVert;
            if (this.FloatIndexZ <= 0.0) {
                this.FloatIndexZ = 0.0;
                this.LowerIndexZ = 0;
                this.UpperIndexZ = 0;
                this.LowerWeightZ = 1.0f;
                this.UpperWeightZ = 0.0f;
            }
            if (this.FloatIndexZ >= (double)(this.m_numZ - 1)) {
                this.FloatIndexZ = this.m_numZ - 1;
                this.LowerIndexZ = this.m_numZ - 1;
                this.UpperIndexZ = this.m_numZ - 1;
                this.LowerWeightZ = 1.0f;
                this.UpperWeightZ = 0.0f;
            }
            if (this.FloatIndexZ > 0.0 && this.FloatIndexZ < (double)(this.m_numZ - 1)) {
                this.LowerIndexZ = (int)this.FloatIndexZ;
                this.UpperIndexZ = this.LowerIndexZ + 1;
                this.UpperWeightZ = (float)(this.FloatIndexZ - (double)this.LowerIndexZ);
                this.LowerWeightZ = 1.0f - this.UpperWeightZ;
            }
            this.UpperIndexValidZ = true;
            this.LowerIndexValidZ = true;
            if (interpolateGrids) {
                if (this.LowerIndexZ < 0) {
                    return;
                }
                this.SlownessAtWorld = this.LowerWeightZ * this.InterpolatedSlowness[this.LowerIndexZ] + this.UpperWeightZ * this.InterpolatedSlowness[this.UpperIndexZ];
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void setWorldLocation(double worldX, double worldY, boolean fixEdgeIndices, boolean interpolateGrids) throws Exception {
        try {
            this.WorldX = worldX;
            this.WorldY = worldY;
            double dx = worldX - this.m_originX;
            double dy = worldY - this.m_originY;
            this.GridY = this.m_cosineInlineAngle * dy - this.m_sineInlineAngle * dx;
            this.GridX = this.m_cosineInlineAngle * dx + this.m_sineInlineAngle * dy;
            this.FloatIndexX = this.GridX * this.m_inverseBinSizeHorz;
            this.FloatIndexY = this.GridY * this.m_inverseBinSizeHorz;
            this.LowerIndexX = (int)this.FloatIndexX;
            this.LowerIndexY = (int)this.FloatIndexY;
            while (this.LowerIndexX > (int)this.FloatIndexX) {
                --this.LowerIndexX;
            }
            while (this.LowerIndexY > (int)this.FloatIndexY) {
                --this.LowerIndexY;
            }
            this.UpperWeightX = (float)(this.FloatIndexX - (double)this.LowerIndexX);
            this.UpperWeightY = (float)(this.FloatIndexY - (double)this.LowerIndexY);
            this.LowerWeightX = 1.0f - this.UpperWeightX;
            this.LowerWeightY = 1.0f - this.UpperWeightY;
            this.UpperIndexValidX = this.LowerIndexX + 1 < this.m_numX;
            this.UpperIndexValidY = this.LowerIndexY + 1 < this.m_numY;
            this.LowerIndexValidX = this.LowerIndexX >= 0;
            boolean bl = this.LowerIndexValidY = this.LowerIndexY >= 0;
            if (this.LowerIndexValidX && this.LowerIndexValidY && this.UpperIndexValidX && this.UpperIndexValidY) {
                this.OnEdge = false;
                this.UpperIndexX = this.LowerIndexX + 1;
                this.UpperIndexY = this.LowerIndexY + 1;
            } else {
                this.OnEdge = true;
                this.EdgeIndexX = this.LowerIndexX;
                this.EdgeIndexX = Math.max(this.EdgeIndexX, 0);
                this.EdgeIndexX = Math.min(this.EdgeIndexX, this.m_numX - 1);
                this.EdgeIndexY = this.LowerIndexX;
                this.EdgeIndexY = Math.max(this.EdgeIndexY, 0);
                this.EdgeIndexY = Math.min(this.EdgeIndexY, this.m_numY - 1);
                if (fixEdgeIndices) {
                    this.UpperIndexX = this.LowerIndexX = this.EdgeIndexX;
                    this.UpperIndexY = this.LowerIndexY = this.EdgeIndexY;
                    this.LowerWeightX = 1.0f;
                    this.LowerWeightY = 1.0f;
                    this.UpperWeightX = 0.0f;
                    this.UpperWeightY = 0.0f;
                }
            }
            if (!interpolateGrids) {
                return;
            }
            if (this.OnEdge && !fixEdgeIndices) {
                throw new Exception("fixEdgeIndices == false");
            }
            this.InterpolatedWaterBottom = this.LowerWeightX * this.LowerWeightY * this.m_waterBottomElevation[this.LowerIndexX][this.LowerIndexY] + this.UpperWeightX * this.LowerWeightY * this.m_waterBottomElevation[this.UpperIndexX][this.LowerIndexY] + this.UpperWeightX * this.UpperWeightY * this.m_waterBottomElevation[this.UpperIndexX][this.UpperIndexY] + this.LowerWeightX * this.UpperWeightY * this.m_waterBottomElevation[this.LowerIndexX][this.UpperIndexY];
            this.InterpolatedElevation = this.LowerWeightX * this.LowerWeightY * this.m_surfaceElevation[this.LowerIndexX][this.LowerIndexY] + this.UpperWeightX * this.LowerWeightY * this.m_surfaceElevation[this.UpperIndexX][this.LowerIndexY] + this.UpperWeightX * this.UpperWeightY * this.m_surfaceElevation[this.UpperIndexX][this.UpperIndexY] + this.LowerWeightX * this.UpperWeightY * this.m_surfaceElevation[this.LowerIndexX][this.UpperIndexY];
            this.InterpolatedGridZ = this.LowerWeightX * this.LowerWeightY * this.m_surfaceGridZ[this.LowerIndexX][this.LowerIndexY] + this.UpperWeightX * this.LowerWeightY * this.m_surfaceGridZ[this.UpperIndexX][this.LowerIndexY] + this.UpperWeightX * this.UpperWeightY * this.m_surfaceGridZ[this.UpperIndexX][this.UpperIndexY] + this.LowerWeightX * this.UpperWeightY * this.m_surfaceGridZ[this.LowerIndexX][this.UpperIndexY];
            for (int n = 0; n < this.m_numZ; ++n) {
                this.InterpolatedSlowness[n] = this.LowerWeightX * this.LowerWeightY * this.m_slowness[this.LowerIndexX][this.LowerIndexY][n] + this.UpperWeightX * this.LowerWeightY * this.m_slowness[this.UpperIndexX][this.LowerIndexY][n] + this.UpperWeightX * this.UpperWeightY * this.m_slowness[this.UpperIndexX][this.UpperIndexY][n] + this.LowerWeightX * this.UpperWeightY * this.m_slowness[this.LowerIndexX][this.UpperIndexY][n];
                this.InterpolatedWeight[n] = this.LowerWeightX * this.LowerWeightY * this.m_weight[this.LowerIndexX][this.LowerIndexY][n] + this.UpperWeightX * this.LowerWeightY * this.m_weight[this.UpperIndexX][this.LowerIndexY][n] + this.UpperWeightX * this.UpperWeightY * this.m_weight[this.UpperIndexX][this.UpperIndexY][n] + this.LowerWeightX * this.UpperWeightY * this.m_weight[this.LowerIndexX][this.UpperIndexY][n];
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public static class Element {
        public int ID;
        public double Count = 1.0E-5;
        public double Error = 0.0;
        public double Residual = 0.0;
        public double ComputedResidual = 0.0;

        public Element(int id) {
            this.ID = id;
        }

        public Element(RandomAccessFile raf, int version) {
            try {
                if (version == 1000) {
                    this.ID = raf.readInt();
                    this.Count = raf.readDouble();
                    this.Error = raf.readDouble();
                    this.Residual = raf.readDouble();
                    this.ComputedResidual = raf.readDouble();
                }
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        public void save(RandomAccessFile raf, int version) {
            try {
                if (version == 1000) {
                    raf.writeInt(this.ID);
                    raf.writeDouble(this.Count);
                    raf.writeDouble(this.Error);
                    raf.writeDouble(this.Residual);
                    raf.writeDouble(this.ComputedResidual);
                }
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        public void addError(float error) {
            this.Count += 1.0;
            this.Error += (double)Math.abs(error);
            this.Residual += (double)error;
        }
    }
}

