/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Refraction.Eikonal2D;

import com.PecosCore.Data.ByteBuffer_Shared;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Map.HashMap_Integers;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Range_Double;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Tools_RefractionStaticsProject;
import com.PecosLibrary.Tools.Tools_GraphicalObjectLibrary;
import com.PecosLibrary.Windows.Java2D.Java2D_ColorArrayWrapper;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintParameter;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintableInterface;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import java.awt.Color;
import java.awt.Graphics2D;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;

public class Eikonal2DModelV3
implements Java2D_PaintableInterface {
    public static final float BigTime = Float.MAX_VALUE;
    protected boolean m_valid = false;
    protected String m_name;
    protected String m_path;
    protected String m_fileNameHeader;
    protected String m_fileNameVelocity;
    protected String m_fileNameShot;
    protected String m_fileNameReceiver;
    protected double m_node = 25.0;
    protected double m_depth = 25.0;
    protected int m_numX;
    protected int m_numZ;
    protected double m_angle = 25.0;
    protected double m_originX = 25.0;
    protected double m_originY = 25.0;
    protected double m_originZ = 25.0;
    public int[] m_maxNode;
    protected boolean m_slownessValid = false;
    protected float[][] m_velocity;
    protected float[][] m_slowness;
    protected float[][] m_time;
    protected float[][] m_sumError;
    protected float[][] m_sumWeight;
    protected float[][] m_sumHits;
    protected float[][] m_temp;
    protected int[] m_nodeStatus;
    protected HashMap_Integers<Element> m_shotHash = new HashMap_Integers();
    protected HashMap_Integers<Element> m_recHash = new HashMap_Integers();
    protected double[] m_velTemp = new double[100];
    protected double m_shotX;
    protected double m_shotZ;
    protected double m_recX;
    protected double m_recZ;
    protected int m_nodeX;
    protected int m_nodeZ;
    public float OffsetCorner = 500.0f;
    public float MinOffset = 1000.0f;
    public float MaxOffset = 10000.0f;
    public float WeightTime = 100.0f;
    protected int[][] m_fromNodeX;
    protected int[][] m_fromNodeZ;
    protected static final int ShotLocation = -12345678;
    protected Element m_currentShot = null;
    protected int m_minFiredIndexX;
    protected int m_maxFiredIndexX;
    protected int m_shotNodeX;
    protected int m_shotNodeZ;
    public double R;
    public int NodeX;
    public static final int PlotMapView = 1000;
    public static final int PlotVelocity = 2000;
    public static final int PlotWeight = 2001;
    public static final int PlotError = 2002;
    public static final int PlotHitCount = 2003;
    protected Range_Double m_velRange = new Range_Double();
    protected boolean m_velPlotDirty = true;

    public boolean valid() {
        return this.m_valid;
    }

    public String name() {
        return this.m_name;
    }

    public double node() {
        return this.m_node;
    }

    public double depth() {
        return this.m_depth;
    }

    public int numX() {
        return this.m_numX;
    }

    public int numZ() {
        return this.m_numZ;
    }

    public HashMap_Integers<Element> shotHash() {
        return this.m_shotHash;
    }

    public HashMap_Integers<Element> recHash() {
        return this.m_recHash;
    }

    protected void allocate() {
        try {
            this.m_nodeStatus = new int[this.m_numZ];
            this.m_fromNodeX = new int[this.m_numX][this.m_numZ];
            this.m_fromNodeZ = new int[this.m_numX][this.m_numZ];
            this.m_sumError = new float[this.m_numX][this.m_numZ];
            this.m_sumWeight = new float[this.m_numX][this.m_numZ];
            this.m_sumHits = new float[this.m_numX][this.m_numZ];
            this.m_temp = new float[this.m_numX][this.m_numZ];
            this.m_velocity = new float[this.m_numX][this.m_numZ];
            this.m_slowness = new float[this.m_numX][this.m_numZ];
            this.m_time = new float[this.m_numX][this.m_numZ];
            this.m_maxNode = new int[this.m_numX];
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void prepFileNames(String name) {
        try {
            this.m_name = name;
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            String path = p.getSubPath("Eikonal2D");
            this.m_path = Tools_FileSystem.confirmSubDirectoryExists(path, this.m_name);
            this.m_fileNameHeader = this.m_path + "/header.data";
            this.m_fileNameVelocity = this.m_path + "/velocity.data";
            this.m_fileNameReceiver = this.m_path + "/receiver.data";
            this.m_fileNameShot = this.m_path + "/shot.data";
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void prepUpdate() {
        try {
            this.m_shotHash.clear();
            this.m_recHash.clear();
            for (int ix = 0; ix < this.m_numX; ++ix) {
                for (int iz = 0; iz < this.m_numZ; ++iz) {
                    this.m_sumError[ix][iz] = 0.0f;
                    this.m_sumWeight[ix][iz] = 1.0E-10f;
                    this.m_sumHits[ix][iz] = 0.0f;
                }
            }
            this.computeVelocity();
            this.setAirVelocity();
            this.computeSlowness();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setAirVelocity() {
        try {
            for (int ix = 0; ix < this.m_numX; ++ix) {
                for (int iz = this.m_maxNode[ix] + 1; iz < this.m_numZ; ++iz) {
                    this.m_velocity[ix][iz] = 0.4f * this.m_velocity[ix][this.m_maxNode[ix]];
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void finishUpdateIter(float maxPercentChange) {
        try {
            int ix;
            for (Element e : this.m_shotHash.getValues()) {
                e.Error /= (double)e.Count;
                e.AbsError /= (double)e.Count;
            }
            for (Element e : this.m_recHash.getValues()) {
                e.Error /= (double)e.Count;
                e.AbsError /= (double)e.Count;
            }
            float maxFractionChange = 1.0f + maxPercentChange / 100.0f;
            float minFractionChange = 1.0f - maxPercentChange / 100.0f;
            float maxSumWeight = 0.0f;
            float maxHits = 0.0f;
            double totalHits = 0.0;
            for (int ix2 = 0; ix2 < this.m_numX; ++ix2) {
                for (int iz = 0; iz <= this.m_maxNode[ix2]; ++iz) {
                    maxSumWeight = Math.max(maxSumWeight, this.m_sumWeight[ix2][iz]);
                    maxHits = Math.max(maxHits, this.m_sumHits[ix2][iz]);
                    totalHits += (double)this.m_sumHits[ix2][iz];
                    if (!(this.m_sumHits[ix2][iz] >= 1.0f)) continue;
                    float fraction = this.m_sumError[ix2][iz] / this.m_sumWeight[ix2][iz];
                    fraction = Math.max(fraction, minFractionChange);
                    this.m_sumError[ix2][iz] = fraction = Math.min(fraction, maxFractionChange);
                    float currentSlowness = this.m_slowness[ix2][iz];
                    this.m_slowness[ix2][iz] = fraction * currentSlowness;
                }
            }
            if (totalHits < 100.0) {
                return;
            }
            int minValidX = this.m_numX;
            int maxValidX = 0;
            for (ix = 0; ix < this.m_numX; ++ix) {
                for (int iz = 0; iz <= this.m_maxNode[ix]; ++iz) {
                    if (!(this.m_sumHits[ix][iz] >= 1.0f)) continue;
                    minValidX = Math.min(minValidX, ix);
                    maxValidX = Math.max(maxValidX, ix);
                }
            }
            for (ix = 0; ix < this.m_numX; ++ix) {
                for (int iz = 0; iz <= this.m_maxNode[ix]; ++iz) {
                    float sum = 0.0f;
                    float sumWeight = 1.0E-7f;
                    float numHits = 1.0E-7f;
                    int dx = 6;
                    int dz = 0;
                    if (ix < minValidX) {
                        dx = minValidX - ix + 5;
                    }
                    if (ix > maxValidX) {
                        dx = ix - maxValidX + 5;
                    }
                    this.m_temp[ix][iz] = this.m_slowness[ix][iz];
                    while (numHits < 50.0f) {
                        numHits = 1.0E-7f;
                        sumWeight = 1.0E-7f;
                        sum = 0.0f;
                        for (int nx = ix - dx; nx <= ix + dx; ++nx) {
                            for (int nz = iz - dz; nz <= iz + dz; ++nz) {
                                if (nx < 0 || nx >= this.m_numX || nz < 0 || nz >= this.m_maxNode[nx]) continue;
                                float wz = 1.0f / (1.0f + (float)Math.abs(nz - iz));
                                float wx = 1.0f / (1.0f + (float)Math.abs(nx - ix));
                                float w = wx * wz;
                                float hitCount = this.m_sumHits[nx][nz];
                                numHits += hitCount;
                                sumWeight += w;
                                sum += w * this.m_slowness[nx][nz];
                            }
                        }
                        if (numHits > 10.0f) {
                            this.m_temp[ix][iz] = sum / sumWeight;
                        }
                        dx += 12;
                        ++dz;
                    }
                }
            }
            for (ix = 0; ix < this.m_numX; ++ix) {
                for (int iz = 0; iz <= this.m_maxNode[ix]; ++iz) {
                    this.m_slowness[ix][iz] = this.m_temp[ix][iz];
                }
            }
            this.computeVelocity();
            this.setAirVelocity();
            this.computeSlowness();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void save() {
        try {
            if (!this.m_valid) {
                Tools_FileSystem.deleteFile(this.m_fileNameHeader);
                Tools_FileSystem.deleteFile(this.m_fileNameVelocity);
                return;
            }
            RandomAccessFile file = new RandomAccessFile(this.m_fileNameHeader, "rw");
            int magic = 927333;
            int version = 1000;
            file.writeInt(magic);
            file.writeInt(version);
            if (version == 1000) {
                file.writeInt(this.m_numX);
                file.writeInt(this.m_numZ);
                file.writeDouble(this.m_node);
                file.writeDouble(this.m_angle);
                file.writeDouble(this.m_originX);
                file.writeDouble(this.m_originY);
                file.writeDouble(this.m_originZ);
            }
            file.close();
            file = new RandomAccessFile(this.m_fileNameVelocity, "rw");
            magic = 4442266;
            version = 1000;
            file.writeInt(magic);
            file.writeInt(version);
            if (version == 1000) {
                int ix;
                ByteBuffer buff = ByteBuffer_Shared.buffer(0, 4 * this.m_numX * this.m_numZ);
                int index = 0;
                for (ix = 0; ix < this.m_numX; ++ix) {
                    for (int iz = 0; iz < this.m_numZ; ++iz) {
                        buff.putFloat(index, this.m_velocity[ix][iz]);
                        index += 4;
                    }
                }
                file.write(buff.array(), 0, 4 * this.m_numX * this.m_numZ);
                index = 0;
                for (ix = 0; ix < this.m_numX; ++ix) {
                    buff.putInt(index, this.m_maxNode[ix]);
                    index += 4;
                }
                file.write(buff.array(), 0, 4 * this.m_numX);
                file.close();
            }
            this.saveHash(this.m_fileNameReceiver, this.m_recHash);
            this.saveHash(this.m_fileNameShot, this.m_shotHash);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void saveHash(String fileName, HashMap_Integers<Element> hash) {
        try {
            RandomAccessFile file = new RandomAccessFile(fileName, "rw");
            int magic = 555564;
            int version = 1000;
            file.writeInt(magic);
            file.writeInt(version);
            if (version == 1000) {
                file.writeInt(hash.size());
                for (Element e : hash.getValues()) {
                    file.writeInt(e.ID);
                    file.writeInt(e.Count);
                    file.writeDouble(e.X);
                    file.writeDouble(e.Z);
                    file.writeDouble(e.AbsError);
                    file.writeDouble(e.Error);
                }
            }
            file.close();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void readHash(String fileName, HashMap_Integers<Element> hash) {
        try {
            hash.clear();
            if (!Tools_FileSystem.exists_file(fileName)) {
                return;
            }
            RandomAccessFile file = new RandomAccessFile(fileName, "rw");
            int magic = file.readInt();
            if (magic != 555564) {
                return;
            }
            int version = file.readInt();
            if (version == 1000) {
                int num = file.readInt();
                for (int n = 0; n < num; ++n) {
                    Element e = new Element();
                    e.ID = file.readInt();
                    e.Count = file.readInt();
                    e.X = file.readDouble();
                    e.Z = file.readDouble();
                    e.AbsError = file.readDouble();
                    e.Error = file.readDouble();
                    hash.put(e, e.ID);
                }
            }
            file.close();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public Eikonal2DModelV3(String name) {
        try {
            this.m_valid = false;
            this.prepFileNames(name);
            if (!Tools_FileSystem.exists_file(this.m_fileNameHeader)) {
                return;
            }
            if (!Tools_FileSystem.exists_file(this.m_fileNameVelocity)) {
                return;
            }
            this.readHash(this.m_fileNameReceiver, this.recHash());
            this.readHash(this.m_fileNameShot, this.shotHash());
            RandomAccessFile file = new RandomAccessFile(this.m_fileNameHeader, "rw");
            int magic = file.readInt();
            int version = file.readInt();
            if (magic != 927333) {
                return;
            }
            if (version != 1000) {
                return;
            }
            this.m_numX = file.readInt();
            this.m_numZ = file.readInt();
            this.m_node = file.readDouble();
            this.m_angle = file.readDouble();
            this.m_originX = file.readDouble();
            this.m_originY = file.readDouble();
            this.m_originZ = file.readDouble();
            file.close();
            this.allocate();
            file = new RandomAccessFile(this.m_fileNameVelocity, "rw");
            magic = file.readInt();
            version = file.readInt();
            if (magic != 4442266) {
                return;
            }
            if (version == 1000) {
                int ix;
                ByteBuffer buff = ByteBuffer_Shared.buffer(0, 4 * this.m_numX * this.m_numZ);
                file.read(buff.array(), 0, 4 * this.m_numX * this.m_numZ);
                int index = 0;
                for (ix = 0; ix < this.m_numX; ++ix) {
                    for (int iz = 0; iz < this.m_numZ; ++iz) {
                        this.m_velocity[ix][iz] = buff.getFloat(index);
                        index += 4;
                    }
                }
                file.read(buff.array(), 0, 4 * this.m_numX);
                index = 0;
                for (ix = 0; ix < this.m_numX; ++ix) {
                    this.m_maxNode[ix] = buff.getInt(index);
                    index += 4;
                }
            } else {
                return;
            }
            file.close();
            this.m_valid = true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public Eikonal2DModelV3(String name, double node, double depth, double v1, double v2) {
        try {
            int n;
            this.prepFileNames(name);
            this.m_node = node;
            this.m_depth = depth;
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            p.grid2DPrepDefault(this.m_node);
            this.m_angle = p.TempGrid2DAngle;
            this.m_originX = p.TempGrid2DOriginX;
            this.m_originY = p.TempGrid2DOriginY;
            this.m_numX = p.TempGrid2DCount;
            Range_Double rz = Tools_RefractionStaticsProject.getRange("Elevation", true, true);
            this.m_originZ = rz.rangeMin() - depth - this.m_node;
            this.m_numZ = 2 + (int)((rz.rangeMax() - this.m_originZ) / this.m_node);
            this.allocate();
            for (int n2 = 0; n2 < this.m_numX; ++n2) {
                this.m_maxNode[n2] = -9999;
            }
            for (int iter = 0; iter <= 1; ++iter) {
                Table_Abstract table = RefractionStaticsProject.singleton().receiverTable();
                if (iter == 1) {
                    table = RefractionStaticsProject.singleton().shotTable();
                }
                int indexX = table.column_indexOfColumn("Easting");
                int indexY = table.column_indexOfColumn("Northing");
                int indexZ = table.column_indexOfColumn("Elevation");
                int indexKilled = table.column_indexOfColumn("Killed");
                for (int n3 = 0; n3 < table.row_count(); ++n3) {
                    if (table.getBool(n3, indexKilled)) continue;
                    this.convertCoords(table.getDouble(n3, indexX), table.getDouble(n3, indexY));
                    double z = table.getDouble(n3, indexZ) - this.m_originZ;
                    int nodeZ = 1 + (int)(z / this.m_node);
                    this.m_maxNode[this.NodeX] = Math.max(this.m_maxNode[this.NodeX], nodeZ);
                }
            }
            int minValid = this.m_numX;
            int maxValid = 0;
            for (n = 0; n < this.m_numX; ++n) {
                if (this.m_maxNode[n] <= 0) continue;
                minValid = Math.min(minValid, n);
                maxValid = Math.max(maxValid, n);
            }
            for (n = maxValid + 1; n < this.m_numX; ++n) {
                this.m_maxNode[n] = this.m_maxNode[maxValid];
            }
            for (n = 0; n < minValid; ++n) {
                this.m_maxNode[n] = this.m_maxNode[minValid];
            }
            int currValid = minValid;
            while (currValid < maxValid) {
                int next;
                for (next = currValid + 1; this.m_maxNode[next] < 0 && next < maxValid; ++next) {
                }
                double a1 = this.m_maxNode[currValid];
                double a2 = this.m_maxNode[next];
                for (int n4 = currValid + 1; n4 < next; ++n4) {
                    double inv = 1.0 / (double)(next - currValid);
                    double a = (a1 * (double)(next - n4) + a2 * (double)(n4 - currValid)) * inv;
                    this.m_maxNode[n4] = (int)(a + 0.5);
                }
                currValid = next;
            }
            for (int n5 = 0; n5 < this.m_numX; ++n5) {
                int z;
                this.m_maxNode[n5] = Math.min(this.m_maxNode[n5], this.m_numZ - 1);
                double alpha = (v1 - v2) / (double)this.m_maxNode[n5];
                for (z = 0; z <= this.m_maxNode[n5]; ++z) {
                    this.m_velocity[n5][z] = (float)(v2 + alpha * (double)z);
                }
                for (z = this.m_maxNode[n5] + 1; z < this.m_numZ; ++z) {
                    this.m_velocity[n5][z] = this.m_velocity[n5][this.m_maxNode[n5]];
                }
            }
            this.setAirVelocity();
            this.computeSlowness();
            this.m_valid = true;
            this.save();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void computeSlowness() {
        try {
            for (int ix = 0; ix < this.m_numX; ++ix) {
                for (int iz = 0; iz < this.m_numZ; ++iz) {
                    this.m_slowness[ix][iz] = 1000.0f / this.m_velocity[ix][iz];
                }
            }
            this.m_slownessValid = true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void computeVelocity() {
        try {
            for (int ix = 0; ix < this.m_numX; ++ix) {
                for (int iz = 0; iz < this.m_numZ; ++iz) {
                    this.m_velocity[ix][iz] = 1000.0f / this.m_slowness[ix][iz];
                }
            }
            this.m_velRange.clearRange();
            this.m_slownessValid = true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public float travelTime(double x, double y, double initialZ, double finalZ) {
        try {
            double r = Math.cos(this.m_angle) * (x - this.m_originX) + Math.sin(this.m_angle) * (y - this.m_originY);
            double minZ = Math.min(initialZ, finalZ);
            minZ = Math.max(minZ, this.m_originZ);
            double top = this.m_originZ + this.m_node * (double)(this.m_numZ - 1);
            double maxZ = Math.max(initialZ, finalZ);
            maxZ = Math.min(maxZ, top);
            double dz = (maxZ - minZ) / (double)(this.m_velTemp.length - 1);
            for (int n = 0; n < this.m_velTemp.length; ++n) {
                double z = minZ + dz * (double)n;
                float s = this.slowness(r, z - this.m_originZ);
                this.m_velTemp[n] = 1000.0 / (double)s;
            }
            double sum = 0.0;
            for (int n = 1; n < this.m_velTemp.length; ++n) {
                double v = 0.5 * (this.m_velTemp[n] + this.m_velTemp[n - 1]);
                sum += 1000.0 * dz / v;
            }
            if (finalZ < initialZ) {
                return (float)sum;
            }
            return -((float)sum);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return 0.0f;
        }
    }

    public float addRec(int recID, double x, double y, double z) {
        return this.addRec(recID, x, y, z, -9999.0f, -9999.0f);
    }

    public float addRec(int recID, double x, double y, double z, float pick, float offset) {
        try {
            this.m_recX = Math.cos(this.m_angle) * (x - this.m_originX) + Math.sin(this.m_angle) * (y - this.m_originY);
            this.m_recZ = z - this.m_originZ;
            Element recElement = null;
            if (recID >= 0) {
                if (!this.m_recHash.containsKey(recID)) {
                    this.m_recHash.put(new Element(), recID);
                }
                recElement = this.m_recHash.get(recID);
                recElement.ID = recID;
                recElement.X = this.m_recX;
                recElement.Z = z;
            }
            float shotSlowness = this.slowness(this.m_recX, this.m_recZ);
            int lowNodeX = Math.max(0, this.m_nodeX - 1);
            int highNodeX = Math.min(this.m_numX - 1, this.m_nodeX + 2);
            float travelTime = Float.MAX_VALUE;
            int minIndexX = 0;
            int minIndexZ = 0;
            for (int ix = lowNodeX; ix <= highNodeX; ++ix) {
                for (int iz = this.m_nodeZ - 1; iz <= this.m_nodeZ + 2; ++iz) {
                    if (iz < 0 || iz >= this.m_numZ || !(this.m_time[ix][iz] < 1.0E7f)) continue;
                    float avgSlow = 0.5f * (shotSlowness + this.m_slowness[ix][iz]);
                    double dx = (double)ix * this.m_node - this.m_recX;
                    double dz = (double)iz * this.m_node - this.m_recZ;
                    double distance = Math.sqrt(1.0E-10 + dx * dx + dz * dz);
                    double t = (double)this.m_time[ix][iz] + distance * (double)avgSlow;
                    if (!((float)t < travelTime)) continue;
                    travelTime = (float)t;
                    minIndexX = ix;
                    minIndexZ = iz;
                }
            }
            float error = travelTime - pick;
            float absError = Math.abs(error);
            if (absError > 1000.0f) {
                if (recID >= 0) {
                    return 0.0f;
                }
                return travelTime;
            }
            if (pick > 1.0f && offset > 1.0f && travelTime > 1.0f) {
                float fraction = pick / travelTime;
                float errorWeight = Math.abs(error) / this.WeightTime;
                errorWeight = 1.0f / (1.0f + errorWeight);
                float offsetWeight = this.OffsetCorner / (this.OffsetCorner + offset);
                offsetWeight = Math.max(offsetWeight, 0.1f);
                offsetWeight *= offsetWeight;
                float weight = offsetWeight * errorWeight;
                float[] fArray = this.m_sumWeight[minIndexX];
                int n = minIndexZ;
                fArray[n] = fArray[n] + weight;
                float[] fArray2 = this.m_sumHits[minIndexX];
                int n2 = minIndexZ;
                fArray2[n2] = fArray2[n2] + 1.0f;
                float[] fArray3 = this.m_sumError[minIndexX];
                int n3 = minIndexZ;
                fArray3[n3] = fArray3[n3] + weight * fraction;
                int fromX = this.m_fromNodeX[minIndexX][minIndexZ];
                int fromZ = this.m_fromNodeZ[minIndexX][minIndexZ];
                int numSegments = 0;
                boolean funk = false;
                while (fromX >= 0 && fromZ >= 0) {
                    minIndexX = fromX;
                    minIndexZ = fromZ;
                    for (int z2 = minIndexZ - 1; z2 <= minIndexZ + 1; ++z2) {
                        if (z2 < 0 || z2 >= this.m_numZ) continue;
                        float[] fArray4 = this.m_sumWeight[minIndexX];
                        int n4 = z2;
                        fArray4[n4] = fArray4[n4] + weight;
                        float[] fArray5 = this.m_sumHits[minIndexX];
                        int n5 = z2;
                        fArray5[n5] = fArray5[n5] + 1.0f;
                        float[] fArray6 = this.m_sumError[minIndexX];
                        int n6 = z2;
                        fArray6[n6] = fArray6[n6] + weight * fraction;
                    }
                    fromX = this.m_fromNodeX[minIndexX][minIndexZ];
                    fromZ = this.m_fromNodeZ[minIndexX][minIndexZ];
                    ++numSegments;
                    if (fromX == minIndexX && fromZ == minIndexZ) {
                        fromZ = -9999;
                    }
                    if (numSegments <= 2000) continue;
                    funk = true;
                }
                if (this.m_currentShot != null) {
                    ++this.m_currentShot.Count;
                    this.m_currentShot.Error += (double)error;
                    this.m_currentShot.AbsError += (double)Math.abs(error);
                }
                if (recElement != null) {
                    ++recElement.Count;
                    recElement.Error += (double)error;
                    recElement.AbsError += (double)Math.abs(error);
                }
            }
            return travelTime;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return 0.0f;
        }
    }

    public int nodeStatus(int ix, int iz, int dx) throws Exception {
        try {
            int x = ix + dx;
            if (iz == this.m_numZ - 1) {
                if (this.m_time[x][iz] <= this.m_time[x][iz - 1]) {
                    return -1;
                }
                if (this.m_time[x][iz] >= this.m_time[x][iz - 1]) {
                    return 1;
                }
                return 0;
            }
            if (iz == 0) {
                if (this.m_time[x][0] <= this.m_time[x][1]) {
                    return -1;
                }
                if (this.m_time[x][0] >= this.m_time[x][1]) {
                    return 1;
                }
                return 0;
            }
            if (this.m_time[x][iz] < this.m_time[x][iz - 1] && this.m_time[x][iz] < this.m_time[x][iz + 1]) {
                return -1;
            }
            if (this.m_time[x][iz] > this.m_time[x][iz - 1] && this.m_time[x][iz] > this.m_time[x][iz + 1]) {
                return 1;
            }
            return 0;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void fuzzify(int ix) {
        try {
            for (int iz = 1; iz < this.m_numZ; ++iz) {
                float diff;
                if (!(this.m_time[ix][iz] < 1.7014117E38f) || !((diff = Math.abs(this.m_time[ix][iz] - this.m_time[ix][iz - 1])) < 0.01f)) continue;
                this.m_time[ix][iz] = this.m_time[ix][iz - 1] + 0.01f;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void fireShot(int shotID, double x, double y, double z, double d, double maxOffset) {
        try {
            int zt;
            int ix;
            int iz;
            int z2;
            int numMin;
            int iz2;
            int ix2;
            int ix3;
            int iz3;
            int iz4;
            int ix4;
            if (!this.m_slownessValid) {
                this.computeSlowness();
            }
            d = Math.max(0.0, d);
            for (int ix5 = 0; ix5 < this.m_numX; ++ix5) {
                for (int iz5 = 0; iz5 < this.m_numZ; ++iz5) {
                    this.m_fromNodeX[ix5][iz5] = -1;
                    this.m_fromNodeZ[ix5][iz5] = -1;
                    this.m_time[ix5][iz5] = Float.MAX_VALUE;
                }
            }
            this.m_shotX = Math.cos(this.m_angle) * (x - this.m_originX) + Math.sin(this.m_angle) * (y - this.m_originY);
            this.m_shotZ = z - d - this.m_originZ;
            this.m_currentShot = null;
            if (shotID >= 0) {
                if (!this.m_shotHash.containsKey(shotID)) {
                    this.m_shotHash.put(new Element(), shotID);
                }
                this.m_currentShot = this.m_shotHash.get(shotID);
                this.m_currentShot.ID = shotID;
                this.m_currentShot.X = this.m_shotX;
                this.m_currentShot.Z = z - d;
            }
            float shotSlowness = this.slowness(this.m_shotX, this.m_shotZ);
            this.m_shotNodeX = this.m_nodeX;
            this.m_shotNodeZ = this.m_nodeZ;
            int lowNodeX = Math.max(0, this.m_nodeX - 1);
            int highNodeX = Math.min(this.m_numX - 1, this.m_nodeX + 2);
            int minZ = Math.max(0, this.m_nodeZ - 1);
            int maxZ = Math.min(this.m_numZ - 1, this.m_nodeZ + 2);
            for (ix4 = lowNodeX; ix4 <= highNodeX; ++ix4) {
                for (iz4 = minZ; iz4 <= maxZ; ++iz4) {
                    float avgSlow = 0.5f * (shotSlowness + this.m_slowness[ix4][iz4]);
                    double dx = (double)ix4 * this.m_node - this.m_shotX;
                    double dz = (double)iz4 * this.m_node - this.m_shotZ;
                    double distance = Math.sqrt(1.0E-10 + dx * dx + dz * dz);
                    double t = distance * (double)avgSlow;
                    this.m_time[ix4][iz4] = (float)t;
                    this.m_fromNodeX[ix4][iz4] = -12345678;
                    this.m_fromNodeZ[ix4][iz4] = -12345678;
                }
            }
            for (iz3 = this.m_nodeZ - 2; iz3 >= 0; --iz3) {
                for (ix3 = lowNodeX; ix3 <= highNodeX; ++ix3) {
                    if (iz3 >= this.m_numZ) continue;
                    this.m_time[ix3][iz3] = this.timeFromThreeHorz(ix3, iz3, 1);
                }
            }
            for (iz3 = this.m_nodeZ + 3; iz3 < this.m_numZ; ++iz3) {
                for (ix3 = lowNodeX; ix3 <= highNodeX; ++ix3) {
                    this.m_time[ix3][iz3] = this.timeFromThreeHorz(ix3, iz3, -1);
                }
            }
            for (ix4 = lowNodeX; ix4 <= highNodeX; ++ix4) {
                for (iz4 = 0; iz4 < this.m_numZ; ++iz4) {
                }
            }
            int numNodes = 10 + (int)(maxOffset / this.m_node);
            this.m_minFiredIndexX = Math.max(0, this.m_nodeX - numNodes - 200);
            this.m_maxFiredIndexX = Math.min(this.m_numX - 1, this.m_nodeX + numNodes + 200);
            boolean crap = false;
            for (ix2 = highNodeX + 1; ix2 <= this.m_maxFiredIndexX; ++ix2) {
                int iz6;
                int dx = -1;
                this.fuzzify(ix2 + dx);
                for (iz2 = 0; iz2 < this.m_numZ; ++iz2) {
                    this.m_nodeStatus[iz2] = this.nodeStatus(ix2, iz2, dx);
                }
                numMin = 0;
                for (iz6 = 0; iz6 < this.m_numZ; ++iz6) {
                    float time;
                    if (this.m_nodeStatus[iz6] != -1) continue;
                    ++numMin;
                    this.m_time[ix2][iz6] = this.timeFromThreeVert(ix2, iz6, dx);
                    for (z2 = iz6 - 1; z2 >= 0; --z2) {
                        if (ix2 == 3014 && iz6 == 46) {
                            crap = true;
                        }
                        if ((time = this.threePointCorner(ix2, z2, dx, 1)) < this.m_time[ix2][z2]) {
                            this.m_time[ix2][z2] = time;
                        }
                        if (this.m_nodeStatus[z2] != 1) continue;
                        z2 = -1;
                    }
                    for (z2 = iz6 + 1; z2 < this.m_numZ; ++z2) {
                        time = this.threePointCorner(ix2, z2, dx, -1);
                        if (time < this.m_time[ix2][z2]) {
                            this.m_time[ix2][z2] = time;
                        }
                        if (this.m_nodeStatus[z2] != 1) continue;
                        z2 = 1000000;
                    }
                }
                if (numMin == 0) {
                    System.out.println("nummin = 0");
                }
                for (iz6 = 1; iz6 < this.m_numZ; ++iz6) {
                    if (!(this.m_time[ix2][iz6] > 100000.0f)) continue;
                    this.m_time[ix2][iz6] = this.m_time[ix2][iz6 - 1] + (float)this.m_node * this.m_slowness[ix2][iz6];
                }
                int numBad = 0;
                for (iz = 0; iz < this.m_numZ; ++iz) {
                    if (!(this.m_time[ix2][iz] > 12000.0f)) continue;
                    ++numBad;
                }
            }
            for (ix2 = lowNodeX - 1; ix2 >= this.m_minFiredIndexX; --ix2) {
                int iz7;
                int dx = 1;
                this.fuzzify(ix2 + dx);
                for (iz2 = 0; iz2 < this.m_numZ; ++iz2) {
                    this.m_nodeStatus[iz2] = this.nodeStatus(ix2, iz2, dx);
                }
                numMin = 0;
                for (iz7 = 0; iz7 < this.m_numZ; ++iz7) {
                    float time;
                    if (this.m_nodeStatus[iz7] != -1) continue;
                    ++numMin;
                    this.m_time[ix2][iz7] = this.timeFromThreeVert(ix2, iz7, dx);
                    for (z2 = iz7 - 1; z2 >= 0; --z2) {
                        time = this.threePointCorner(ix2, z2, dx, 1);
                        if (time < this.m_time[ix2][z2]) {
                            this.m_time[ix2][z2] = time;
                        }
                        if (this.m_nodeStatus[z2] != 1) continue;
                        z2 = -1;
                    }
                    for (z2 = iz7 + 1; z2 < this.m_numZ; ++z2) {
                        time = this.threePointCorner(ix2, z2, dx, -1);
                        if (time < this.m_time[ix2][z2]) {
                            this.m_time[ix2][z2] = time;
                        }
                        if (this.m_nodeStatus[z2] != 1) continue;
                        z2 = 1000000;
                    }
                }
                if (numMin == 0) {
                    System.out.println("nummin = 0");
                }
                for (iz7 = 1; iz7 < this.m_numZ; ++iz7) {
                    if (!(this.m_time[ix2][iz7] > 100000.0f)) continue;
                    this.m_time[ix2][iz7] = this.m_time[ix2][iz7 - 1] + (float)this.m_node * this.m_slowness[ix2][iz7];
                }
                int numBad = 0;
                for (iz = 0; iz < this.m_numZ; ++iz) {
                    if (!(this.m_time[ix2][iz] > 12000.0f)) continue;
                    ++numBad;
                }
            }
            for (ix2 = this.m_minFiredIndexX; ix2 <= this.m_maxFiredIndexX; ++ix2) {
                int numBad = 0;
                for (iz2 = 0; iz2 < this.m_numZ; ++iz2) {
                    if (!(this.m_time[ix2][iz2] > 12000.0f)) continue;
                    ++numBad;
                }
                if (numBad <= 0) continue;
                System.err.println("bad column, ix " + ix2);
            }
            for (int iz8 = 0; iz8 < this.m_numZ; ++iz8) {
                if (this.m_fromNodeX[this.m_shotNodeX][iz8] == -12345678) continue;
                if (iz8 <= this.m_shotNodeZ) {
                    this.m_fromNodeX[this.m_shotNodeX][iz8] = this.m_shotNodeX;
                    this.m_fromNodeZ[this.m_shotNodeX][iz8] = iz8 + 1;
                    continue;
                }
                this.m_fromNodeX[this.m_shotNodeX][iz8] = this.m_shotNodeX;
                this.m_fromNodeZ[this.m_shotNodeX][iz8] = iz8 - 1;
            }
            int dx = 1;
            for (ix = this.m_minFiredIndexX; ix < this.m_shotNodeX; ++ix) {
                for (iz2 = 0; iz2 < this.m_numZ; ++iz2) {
                    if (this.m_fromNodeX[ix][iz2] == -12345678) continue;
                    float minTime = Float.MAX_VALUE;
                    minZ = iz2 - 2;
                    maxZ = iz2 + 2;
                    minZ = Math.max(0, minZ);
                    maxZ = Math.min(this.m_numZ - 1, maxZ);
                    for (zt = minZ; zt < maxZ; ++zt) {
                        float t = this.m_time[ix + dx][zt];
                        if (!(t < minTime)) continue;
                        minTime = t;
                        this.m_fromNodeX[ix][iz2] = ix + dx;
                        this.m_fromNodeZ[ix][iz2] = zt;
                    }
                }
            }
            dx = -1;
            for (ix = this.m_maxFiredIndexX; ix > this.m_shotNodeX; --ix) {
                for (iz2 = 0; iz2 < this.m_numZ; ++iz2) {
                    if (this.m_fromNodeX[ix][iz2] == -12345678) continue;
                    float minTime = Float.MAX_VALUE;
                    minZ = iz2 - 2;
                    maxZ = iz2 + 2;
                    minZ = Math.max(0, minZ);
                    maxZ = Math.min(this.m_numZ - 1, maxZ);
                    for (zt = minZ; zt < maxZ; ++zt) {
                        float t = this.m_time[ix + dx][zt];
                        if (!(t < minTime)) continue;
                        minTime = t;
                        this.m_fromNodeX[ix][iz2] = ix + dx;
                        this.m_fromNodeZ[ix][iz2] = zt;
                    }
                }
            }
            for (ix = this.m_minFiredIndexX; ix <= this.m_maxFiredIndexX; ++ix) {
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected float threePointCorner(int ix, int iz, int dx, int dz) throws Exception {
        try {
            int x0 = ix + dx;
            int z0 = iz + dz;
            int x1 = ix + dx;
            int z1 = iz + 0;
            int x2 = ix + 0;
            int z2 = iz + dz;
            boolean cornerOkay = this.okay(x0, z0);
            boolean okaySameZ = this.okay(x1, z1);
            boolean okaySameX = this.okay(x2, z2);
            if (!okaySameX) {
                throw new Exception("!okaySameX");
            }
            if (cornerOkay && okaySameZ) {
                double slow = 0.25 * (double)(this.m_slowness[ix][iz] + this.m_slowness[x0][z0] + this.m_slowness[x1][z1] + this.m_slowness[x2][z2]);
                double fc = slow * slow * this.m_node * this.m_node;
                double dt = this.m_time[x1][z1] - this.m_time[x2][z2];
                double temp = 2.0 * fc - dt * dt;
                if (temp <= 0.0) {
                    return this.m_time[x0][z0];
                }
                return this.m_time[x0][z0] + (float)Math.sqrt(temp);
            }
            if (cornerOkay && !okaySameZ) {
                double slow = 0.3333333 * (double)(this.m_slowness[ix][iz] + this.m_slowness[x0][z0] + this.m_slowness[x2][z2]);
                double fc = slow * slow * this.m_node * this.m_node;
                double dt = this.m_time[x0][z0] - this.m_time[x2][z2];
                double temp = fc - dt * dt;
                if (temp <= 0.0) {
                    return this.m_time[x2][z2];
                }
                return this.m_time[x2][z2] + (float)Math.sqrt(temp);
            }
            double slow = 0.5 * (double)(this.m_slowness[ix][iz] + this.m_slowness[x2][z2]);
            return (float)(this.m_node * slow + (double)this.m_time[x2][z2]);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    protected float timeFromThreeVert(int ix, int iz, int dx) {
        try {
            float slowSum = this.m_slowness[ix][iz];
            int slowCount = 1;
            boolean topValid = false;
            boolean bottomValid = false;
            boolean centerValid = false;
            if (this.okay(ix + dx, iz + 1)) {
                topValid = true;
                slowSum += this.m_slowness[ix + dx][iz + 1];
                ++slowCount;
            }
            if (this.okay(ix + dx, iz)) {
                centerValid = true;
                slowSum += this.m_slowness[ix + dx][iz];
                ++slowCount;
            }
            if (this.okay(ix + dx, iz - 1)) {
                bottomValid = true;
                slowSum += this.m_slowness[ix + dx][iz - 1];
                ++slowCount;
            }
            float slowness = slowSum / (float)slowCount;
            double fac = (double)(slowness * slowness) * this.m_node * this.m_node;
            if (!centerValid) {
                if (bottomValid) {
                    return (float)((double)this.m_time[ix + dx][iz - 1] + (double)slowness * 1.41421 * this.m_node);
                }
                if (topValid) {
                    return (float)((double)this.m_time[ix + dx][iz + 1] + (double)slowness * 1.41421 * this.m_node);
                }
                return Float.MAX_VALUE;
            }
            if (topValid && centerValid && bottomValid) {
                double dt = 0.5 * (double)(this.m_time[ix + dx][iz + 1] - this.m_time[ix + dx][iz - 1]);
                double t = (double)this.m_time[ix + dx][iz] + Math.sqrt(fac - dt * dt);
                if (Double.isNaN(t)) {
                    t = this.m_time[ix + dx][iz];
                }
                return (float)t;
            }
            if (topValid) {
                double dt = this.m_time[ix + dx][iz + 1] - this.m_time[ix + dx][iz];
                double t = (double)this.m_time[ix + dx][iz] + Math.sqrt(fac - dt * dt);
                if (Double.isNaN(t)) {
                    t = this.m_time[ix + dx][iz];
                }
                return (float)t;
            }
            if (bottomValid) {
                double dt = this.m_time[ix + dx][iz - 1] - this.m_time[ix + dx][iz];
                double t = (double)this.m_time[ix + dx][iz] + Math.sqrt(fac - dt * dt);
                if (Double.isNaN(t)) {
                    t = this.m_time[ix + dx][iz];
                }
                return (float)t;
            }
            return Float.MAX_VALUE;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return 1.0E10f;
        }
    }

    protected float timeFromThreeHorz(int ix, int iz, int dz) {
        try {
            float slowSum = this.m_slowness[ix][iz];
            int slowCount = 1;
            boolean rightValid = false;
            boolean leftValid = false;
            boolean centerValid = false;
            if (this.okay(ix - 1, iz + dz)) {
                leftValid = true;
                slowSum += this.m_slowness[ix - 1][iz + dz];
                ++slowCount;
            }
            if (this.okay(ix, iz + dz)) {
                centerValid = true;
                slowSum += this.m_slowness[ix][iz + dz];
                ++slowCount;
            }
            if (this.okay(ix + 1, iz + dz)) {
                rightValid = true;
                slowSum += this.m_slowness[ix + 1][iz + dz];
                ++slowCount;
            }
            float slowness = slowSum / (float)slowCount;
            double fac = (double)(slowness * slowness) * this.m_node * this.m_node;
            if (!centerValid) {
                float timeLeft = Float.MAX_VALUE;
                float timeRight = Float.MAX_VALUE;
                if (leftValid) {
                    timeLeft = this.m_time[ix - 1][iz + dz] + (float)(this.m_node * 1.41421 * (double)slowness);
                }
                if (rightValid) {
                    timeRight = this.m_time[ix + 1][iz + dz] + (float)(this.m_node * 1.41421 * (double)slowness);
                }
                return Math.min(timeLeft, timeRight);
            }
            if (leftValid && centerValid && rightValid) {
                double dt = 0.5 * (double)(this.m_time[ix + 1][iz + dz] - this.m_time[ix - 1][iz + dz]);
                double temp = fac - dt * dt;
                if (temp > 0.0) {
                    return (float)((double)this.m_time[ix][iz + dz] + Math.sqrt(temp));
                }
                return this.m_time[ix][iz + dz];
            }
            if (leftValid) {
                double dt = this.m_time[ix][iz + dz] - this.m_time[ix - 1][iz + dz];
                double temp = fac - dt * dt;
                if (temp > 0.0) {
                    return (float)((double)this.m_time[ix][iz + dz] + Math.sqrt(temp));
                }
                return this.m_time[ix][iz + dz];
            }
            if (rightValid) {
                double dt = this.m_time[ix + 1][iz + dz] - this.m_time[ix][iz + dz];
                double temp = fac - dt * dt;
                if (temp > 0.0) {
                    return (float)((double)this.m_time[ix][iz + dz] + Math.sqrt(temp));
                }
                return this.m_time[ix][iz + dz];
            }
            return Float.MAX_VALUE;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return 1.0E10f;
        }
    }

    protected boolean okay(int ix, int iz) {
        try {
            boolean okay;
            if (ix < 0 || ix >= this.m_numX || iz < 0) {
                return false;
            }
            if (iz >= this.m_numZ) {
                return false;
            }
            boolean bl = okay = this.m_time[ix][iz] < 1000000.0f;
            return okay;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    protected float slowness(double x, double z) {
        try {
            this.m_nodeX = (int)(x / this.m_node);
            this.m_nodeZ = (int)(z / this.m_node);
            double s1 = 0.0;
            double s2 = 1.0E-20;
            for (int ix = this.m_nodeX; ix <= this.m_nodeX + 1; ++ix) {
                for (int iz = this.m_nodeZ; iz <= this.m_nodeZ + 1; ++iz) {
                    if (ix >= this.m_numX || ix < 0 || iz < 0 || iz >= this.m_numZ) continue;
                    double dx = (double)ix * this.m_node - x;
                    double dz = (double)iz * this.m_node - z;
                    double w = 0.1 / Math.sqrt(0.1 + dx * dx + dz * dz);
                    s1 += w * (double)this.m_slowness[ix][iz];
                    s2 += w;
                }
            }
            return (float)(s1 / s2);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return 1.0f;
        }
    }

    public void convertCoords(double x, double y) {
        try {
            this.R = Math.cos(this.m_angle) * (x - this.m_originX) + Math.sin(this.m_angle) * (y - this.m_originY);
            this.NodeX = (int)(0.5 + this.R / this.m_node);
            this.NodeX = Math.max(0, this.NodeX);
            this.NodeX = Math.min(this.m_numX - 1, this.NodeX);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void paintVelocity(Java2D_PaintParameter paintParameter, int supplementalData) {
        try {
            int z1;
            int x1;
            Java2D_ColorArrayWrapper colorWrapper = paintParameter.ColorArrayWrapper;
            Java2D_Transform transform = paintParameter.Transform;
            Graphics2D g2d = paintParameter.G2D;
            g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_0);
            double scaleX = paintParameter.Transform.scaleX();
            double shiftX = paintParameter.Transform.shiftX();
            double scaleY = paintParameter.Transform.scaleY();
            double shiftY = paintParameter.Transform.shiftY();
            int sizeX = 1 + (int)(this.m_node * scaleX);
            int sizeZ = 1 + -((int)(this.m_node * scaleY));
            for (int ix = 0; ix < this.m_numX; ++ix) {
                double x = (double)ix * this.m_node;
                int x12 = (int)(scaleX * (x - 0.5 * this.m_node) + shiftX);
                double z12 = scaleY * (this.m_originZ - 0.5 * this.m_node) + shiftY;
                for (int iz = 0; iz <= this.m_maxNode[ix]; ++iz) {
                    double v = -9999999.0;
                    if (supplementalData == 2000) {
                        v = this.m_velocity[ix][iz];
                    } else if (this.m_sumHits[ix][iz] > 0.5f) {
                        if (supplementalData == 2001) {
                            v = this.m_sumWeight[ix][iz];
                        }
                        if (supplementalData == 2002) {
                            v = this.m_sumError[ix][iz];
                        }
                        if (supplementalData == 2003) {
                            v = this.m_sumHits[ix][iz];
                        }
                    }
                    if (colorWrapper.valueOK(v)) {
                        g2d.setColor(colorWrapper.colorUsingValue(v));
                        g2d.fillRect(x12, (int)z12, sizeX, sizeZ);
                    }
                    z12 += scaleY * this.m_node;
                }
            }
            this.m_velPlotDirty = false;
            g2d.setColor(Color.BLACK);
            for (Element e : this.m_shotHash.getValues()) {
                x1 = (int)(scaleX * e.X + shiftX);
                z1 = (int)(scaleY * e.Z + shiftY);
                g2d.drawLine(x1, z1 - 1, x1, z1 + 1);
                g2d.drawLine(x1 - 1, z1, x1 + 1, z1);
            }
            for (Element e : this.m_recHash.getValues()) {
                x1 = (int)(scaleX * e.X + shiftX);
                z1 = (int)(scaleY * e.Z + shiftY);
                g2d.drawRect(x1 - 1, z1 - 1, 3, 3);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public boolean Java2D_ImageContentsDirty(int supplementalData) {
        try {
            if (supplementalData >= 2000) {
                return this.m_velPlotDirty;
            }
            return false;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    @Override
    public int Java2D_MaximumPaintLevel(int supplementalData) {
        try {
            return 0;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return 0;
        }
    }

    @Override
    public void Java2D_Paint(Java2D_PaintParameter paintParameter, int supplementalData) {
        try {
            if (paintParameter.PaintLevel != 0) {
                return;
            }
            Java2D_ColorArrayWrapper colorWrapper = paintParameter.ColorArrayWrapper;
            Java2D_Transform transform = paintParameter.Transform;
            Graphics2D g2d = paintParameter.G2D;
            g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_0);
            if (supplementalData == 1000) {
                g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_4);
                g2d.setColor(Color.BLUE);
                double len = this.m_node * (double)(this.m_numX - 1);
                paintParameter.drawLine(this.m_originX, this.m_originY, this.m_originX + len * Math.cos(this.m_angle), this.m_originY + len * Math.sin(this.m_angle));
                return;
            }
            if (supplementalData >= 2000) {
                this.paintVelocity(paintParameter, supplementalData);
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_RangeWorld(Range_Double rangeX, Range_Double rangeY, int supplementalData) {
        try {
            if (supplementalData == 1000) {
                double len = this.m_node * (double)(this.m_numX - 1);
                rangeX.expandRange(this.m_originX);
                rangeX.expandRange(this.m_originX + len * Math.cos(this.m_angle));
                rangeY.expandRange(this.m_originY);
                rangeY.expandRange(this.m_originY + len * Math.sin(this.m_angle));
            }
            if (supplementalData >= 2000) {
                rangeX.expandRange(-1.5 * this.m_node);
                rangeX.expandRange((double)(this.m_numX + 3) * this.m_node);
                rangeY.expandRange(this.m_originZ - 1.5 * this.m_node);
                rangeY.expandRange(this.m_originZ + (double)(this.m_numZ + 3) * this.m_node);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_RangeColor(Range_Double rangeC, int supplementalData) {
        try {
            if (supplementalData >= 2000) {
                for (int x = 0; x < this.m_numX; ++x) {
                    for (int z = 0; z <= this.m_maxNode[x]; ++z) {
                        if (supplementalData == 2000) {
                            rangeC.expandRange(this.m_velocity[x][z]);
                            continue;
                        }
                        if (!(this.m_sumHits[x][z] > 0.5f)) continue;
                        if (supplementalData == 2001) {
                            rangeC.expandRange(this.m_sumWeight[x][z]);
                        }
                        if (supplementalData == 2002) {
                            rangeC.expandRange(this.m_sumError[x][z]);
                        }
                        if (supplementalData != 2003) continue;
                        rangeC.expandRange(this.m_sumHits[x][z]);
                    }
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_PaintDatum(Java2D_PaintParameter paintParameter) {
    }

    public class Element {
        public int ID = 0;
        public int Count = 0;
        public double Error = 0.0;
        public double AbsError = 0.0;
        public double X = 0.0;
        public double Z = 0.0;
    }
}

